"""

Revision ID: f089dfb7e3ba
Revises: 
Create Date: 2025-06-23 17:48:32.842030

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'f089dfb7e3ba'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('lecrapaud_experiments',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('path', sa.String(length=255), nullable=True),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('size', sa.Integer(), nullable=False),
    sa.Column('train_size', sa.Integer(), nullable=True),
    sa.Column('val_size', sa.Integer(), nullable=True),
    sa.Column('test_size', sa.Integer(), nullable=True),
    sa.Column('corr_threshold', sa.Float(), nullable=False),
    sa.Column('max_features', sa.Integer(), nullable=False),
    sa.Column('percentile', sa.Float(), nullable=False),
    sa.Column('number_of_groups', sa.Integer(), nullable=True),
    sa.Column('list_of_groups', sa.JSON(), nullable=True),
    sa.Column('start_date', sa.DateTime(), nullable=True),
    sa.Column('end_date', sa.DateTime(), nullable=True),
    sa.Column('train_start_date', sa.DateTime(), nullable=True),
    sa.Column('train_end_date', sa.DateTime(), nullable=True),
    sa.Column('val_start_date', sa.DateTime(), nullable=True),
    sa.Column('val_end_date', sa.DateTime(), nullable=True),
    sa.Column('test_start_date', sa.DateTime(), nullable=True),
    sa.Column('test_end_date', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', name='uq_experiments_composite')
    )
    op.create_index(op.f('ix_lecrapaud_experiments_id'), 'lecrapaud_experiments', ['id'], unique=False)
    op.create_table('lecrapaud_features',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_index(op.f('ix_lecrapaud_features_id'), 'lecrapaud_features', ['id'], unique=False)
    op.create_table('lecrapaud_models',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', 'type', name='uq_model_composite')
    )
    op.create_index(op.f('ix_lecrapaud_models_id'), 'lecrapaud_models', ['id'], unique=False)
    op.create_table('lecrapaud_targets',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', 'type', name='uq_target_composite')
    )
    op.create_index(op.f('ix_lecrapaud_targets_id'), 'lecrapaud_targets', ['id'], unique=False)
    op.create_table('lecrapaud_experiment_target_association',
    sa.Column('experiment_id', sa.BigInteger(), nullable=False),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_id'], ['lecrapaud_experiments.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['lecrapaud_targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('experiment_id', 'target_id')
    )
    op.create_table('lecrapaud_feature_selections',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('best_features_path', sa.String(length=255), nullable=True),
    sa.Column('experiment_id', sa.BigInteger(), nullable=False),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_id'], ['lecrapaud_experiments.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['lecrapaud_targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('experiment_id', 'target_id', name='uq_feature_selection_composite')
    )
    op.create_index(op.f('ix_lecrapaud_feature_selections_id'), 'lecrapaud_feature_selections', ['id'], unique=False)
    op.create_table('lecrapaud_model_selections',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('best_model_params', sa.JSON(), nullable=True),
    sa.Column('best_model_path', sa.String(length=255), nullable=True),
    sa.Column('best_model_id', sa.BigInteger(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.Column('experiment_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['best_model_id'], ['lecrapaud_models.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['experiment_id'], ['lecrapaud_experiments.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['lecrapaud_targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('target_id', 'experiment_id', name='uq_model_selection_composite')
    )
    op.create_index(op.f('ix_lecrapaud_model_selections_id'), 'lecrapaud_model_selections', ['id'], unique=False)
    op.create_table('lecrapaud_feature_selection_association',
    sa.Column('feature_selection_id', sa.BigInteger(), nullable=False),
    sa.Column('feature_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['feature_id'], ['lecrapaud_features.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['feature_selection_id'], ['lecrapaud_feature_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('feature_selection_id', 'feature_id')
    )
    op.create_table('lecrapaud_feature_selection_ranks',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('score', sa.Float(), nullable=True),
    sa.Column('pvalue', sa.Float(), nullable=True),
    sa.Column('support', sa.Integer(), nullable=True),
    sa.Column('rank', sa.Integer(), nullable=True),
    sa.Column('method', sa.String(length=50), nullable=True),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('feature_id', sa.BigInteger(), nullable=True),
    sa.Column('feature_selection_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['feature_id'], ['lecrapaud_features.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['feature_selection_id'], ['lecrapaud_feature_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('feature_id', 'feature_selection_id', 'method', name='uq_feature_selection_rank_composite')
    )
    op.create_index(op.f('ix_lecrapaud_feature_selection_ranks_id'), 'lecrapaud_feature_selection_ranks', ['id'], unique=False)
    op.create_table('lecrapaud_model_trainings',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('best_params', sa.JSON(), nullable=True),
    sa.Column('model_path', sa.String(length=255), nullable=True),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('model_id', sa.BigInteger(), nullable=False),
    sa.Column('model_selection_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['model_id'], ['lecrapaud_models.id'], ),
    sa.ForeignKeyConstraint(['model_selection_id'], ['lecrapaud_model_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('model_id', 'model_selection_id', name='uq_model_training_composite')
    )
    op.create_index(op.f('ix_lecrapaud_model_trainings_id'), 'lecrapaud_model_trainings', ['id'], unique=False)
    op.create_table('lecrapaud_scores',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('eval_data_std', sa.Float(), nullable=True),
    sa.Column('rmse', sa.Float(), nullable=True),
    sa.Column('rmse_std_ratio', sa.Float(), nullable=True),
    sa.Column('mae', sa.Float(), nullable=True),
    sa.Column('mape', sa.Float(), nullable=True),
    sa.Column('mam', sa.Float(), nullable=True),
    sa.Column('mad', sa.Float(), nullable=True),
    sa.Column('mae_mam_ratio', sa.Float(), nullable=True),
    sa.Column('mae_mad_ratio', sa.Float(), nullable=True),
    sa.Column('r2', sa.Float(), nullable=True),
    sa.Column('logloss', sa.Float(), nullable=True),
    sa.Column('accuracy', sa.Float(), nullable=True),
    sa.Column('precision', sa.Float(), nullable=True),
    sa.Column('recall', sa.Float(), nullable=True),
    sa.Column('f1', sa.Float(), nullable=True),
    sa.Column('roc_auc', sa.Float(), nullable=True),
    sa.Column('threshold', sa.Float(), nullable=True),
    sa.Column('precision_at_threshold', sa.Float(), nullable=True),
    sa.Column('recall_at_threshold', sa.Float(), nullable=True),
    sa.Column('model_training_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['model_training_id'], ['lecrapaud_model_trainings.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_lecrapaud_scores_id'), 'lecrapaud_scores', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_lecrapaud_scores_id'), table_name='lecrapaud_scores')
    op.drop_table('lecrapaud_scores')
    op.drop_index(op.f('ix_lecrapaud_model_trainings_id'), table_name='lecrapaud_model_trainings')
    op.drop_table('lecrapaud_model_trainings')
    op.drop_index(op.f('ix_lecrapaud_feature_selection_ranks_id'), table_name='lecrapaud_feature_selection_ranks')
    op.drop_table('lecrapaud_feature_selection_ranks')
    op.drop_table('lecrapaud_feature_selection_association')
    op.drop_index(op.f('ix_lecrapaud_model_selections_id'), table_name='lecrapaud_model_selections')
    op.drop_table('lecrapaud_model_selections')
    op.drop_index(op.f('ix_lecrapaud_feature_selections_id'), table_name='lecrapaud_feature_selections')
    op.drop_table('lecrapaud_feature_selections')
    op.drop_table('lecrapaud_experiment_target_association')
    op.drop_index(op.f('ix_lecrapaud_targets_id'), table_name='lecrapaud_targets')
    op.drop_table('lecrapaud_targets')
    op.drop_index(op.f('ix_lecrapaud_models_id'), table_name='lecrapaud_models')
    op.drop_table('lecrapaud_models')
    op.drop_index(op.f('ix_lecrapaud_features_id'), table_name='lecrapaud_features')
    op.drop_table('lecrapaud_features')
    op.drop_index(op.f('ix_lecrapaud_experiments_id'), table_name='lecrapaud_experiments')
    op.drop_table('lecrapaud_experiments')
    # ### end Alembic commands ###
