# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AsyncAudioUrlParameters(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url': 'str',
        'entities': 'AsyncEntitiesPayload',
        'enable_all_trackers': 'AsyncEnableAllTrackers',
        'detect_phrases': 'AsyncDetectPhrases',
        'confidence_threshold': 'AsyncConfidenceThreshold',
        'name': 'AsyncMeetingName',
        'trackers': 'AsyncTrackers'
    }

    attribute_map = {
        'url': 'url',
        'entities': 'entities',
        'enable_all_trackers': 'enableAllTrackers',
        'detect_phrases': 'detectPhrases',
        'confidence_threshold': 'confidenceThreshold',
        'name': 'name',
        'trackers': 'trackers'
    }

    def __init__(self, url=None, entities=None, enable_all_trackers=None, detect_phrases=None, confidence_threshold=None, name=None, trackers=None):  # noqa: E501
        """AsyncAudioUrlParameters - a model defined in Swagger"""  # noqa: E501
        self._url = None
        self._entities = None
        self._enable_all_trackers = None
        self._detect_phrases = None
        self._confidence_threshold = None
        self._name = None
        self._trackers = None
        self.discriminator = None
        if url is not None:
            self.url = url
        if entities is not None:
            self.entities = entities
        if enable_all_trackers is not None:
            self.enable_all_trackers = enable_all_trackers
        if detect_phrases is not None:
            self.detect_phrases = detect_phrases
        if confidence_threshold is not None:
            self.confidence_threshold = confidence_threshold
        if name is not None:
            self.name = name
        if trackers is not None:
            self.trackers = trackers

    @property
    def url(self):
        """Gets the url of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The url of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this AsyncAudioUrlParameters.


        :param url: The url of this AsyncAudioUrlParameters.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def entities(self):
        """Gets the entities of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The entities of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncEntitiesPayload
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """Sets the entities of this AsyncAudioUrlParameters.


        :param entities: The entities of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncEntitiesPayload
        """

        self._entities = entities

    @property
    def enable_all_trackers(self):
        """Gets the enable_all_trackers of this AsyncAudioUrlParameters.  # noqa: E501

        Messages Body for a Async Submit Text request.  # noqa: E501

        :return: The enable_all_trackers of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncEnableAllTrackers
        """
        return self._enable_all_trackers

    @enable_all_trackers.setter
    def enable_all_trackers(self, enable_all_trackers):
        """Sets the enable_all_trackers of this AsyncAudioUrlParameters.

        Messages Body for a Async Submit Text request.  # noqa: E501

        :param enable_all_trackers: The enable_all_trackers of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncEnableAllTrackers
        """

        self._enable_all_trackers = enable_all_trackers

    @property
    def detect_phrases(self):
        """Gets the detect_phrases of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The detect_phrases of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncDetectPhrases
        """
        return self._detect_phrases

    @detect_phrases.setter
    def detect_phrases(self, detect_phrases):
        """Sets the detect_phrases of this AsyncAudioUrlParameters.


        :param detect_phrases: The detect_phrases of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncDetectPhrases
        """

        self._detect_phrases = detect_phrases

    @property
    def confidence_threshold(self):
        """Gets the confidence_threshold of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The confidence_threshold of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncConfidenceThreshold
        """
        return self._confidence_threshold

    @confidence_threshold.setter
    def confidence_threshold(self, confidence_threshold):
        """Sets the confidence_threshold of this AsyncAudioUrlParameters.


        :param confidence_threshold: The confidence_threshold of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncConfidenceThreshold
        """

        self._confidence_threshold = confidence_threshold

    @property
    def name(self):
        """Gets the name of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The name of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncMeetingName
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AsyncAudioUrlParameters.


        :param name: The name of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncMeetingName
        """

        self._name = name

    @property
    def trackers(self):
        """Gets the trackers of this AsyncAudioUrlParameters.  # noqa: E501


        :return: The trackers of this AsyncAudioUrlParameters.  # noqa: E501
        :rtype: AsyncTrackers
        """
        return self._trackers

    @trackers.setter
    def trackers(self, trackers):
        """Sets the trackers of this AsyncAudioUrlParameters.


        :param trackers: The trackers of this AsyncAudioUrlParameters.  # noqa: E501
        :type: AsyncTrackers
        """

        self._trackers = trackers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AsyncAudioUrlParameters, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AsyncAudioUrlParameters):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
