from typing import Any, ClassVar, Dict, Iterable, Iterator, List, Mapping, Optional, Sequence, Type, Union

from django.core.exceptions import ValidationError as ValidationError
from django.forms.boundfield import BoundField
from django.forms.fields import Field
from django.forms.renderers import BaseRenderer
from django.forms.utils import ErrorDict, ErrorList, _DataT, _FilesT
from django.forms.widgets import Media, MediaDefiningClass
from django.utils.safestring import SafeString

class DeclarativeFieldsMetaclass(MediaDefiningClass): ...

class BaseForm:
    class Meta:
        fields: Sequence[str] = ...
    default_renderer: Optional[Union[BaseRenderer, Type[BaseRenderer]]] = ...
    field_order: Optional[Iterable[str]] = ...
    use_required_attribute: bool = ...
    is_bound: bool = ...
    data: _DataT = ...
    files: _FilesT = ...
    auto_id: Union[bool, str] = ...
    initial: Mapping[str, Any] = ...
    error_class: Type[ErrorList] = ...
    prefix: Optional[str] = ...
    label_suffix: str = ...
    empty_permitted: bool = ...
    fields: Dict[str, Field] = ...
    renderer: BaseRenderer = ...
    cleaned_data: Dict[str, Any] = ...
    def __init__(
        self,
        data: Optional[_DataT] = ...,
        files: Optional[_FilesT] = ...,
        auto_id: Union[bool, str] = ...,
        prefix: Optional[str] = ...,
        initial: Optional[Mapping[str, Any]] = ...,
        error_class: Type[ErrorList] = ...,
        label_suffix: Optional[str] = ...,
        empty_permitted: bool = ...,
        field_order: Optional[Iterable[str]] = ...,
        use_required_attribute: Optional[bool] = ...,
        renderer: Optional[BaseRenderer] = ...,
    ) -> None: ...
    def order_fields(self, field_order: Optional[Iterable[str]]) -> None: ...
    def __iter__(self) -> Iterator[BoundField]: ...
    def __getitem__(self, name: str) -> BoundField: ...
    @property
    def errors(self) -> ErrorDict: ...
    def is_valid(self) -> bool: ...
    def add_prefix(self, field_name: str) -> str: ...
    def add_initial_prefix(self, field_name: str) -> str: ...
    def as_table(self) -> SafeString: ...
    def as_ul(self) -> SafeString: ...
    def as_p(self) -> SafeString: ...
    def non_field_errors(self) -> ErrorList: ...
    def add_error(self, field: Optional[str], error: Union[ValidationError, str]) -> None: ...
    def has_error(self, field: Optional[str], code: Optional[str] = ...) -> bool: ...
    def full_clean(self) -> None: ...
    def clean(self) -> Optional[Dict[str, Any]]: ...
    def has_changed(self) -> bool: ...
    @property
    def changed_data(self) -> List[str]: ...
    @property
    def media(self) -> Media: ...
    def is_multipart(self) -> bool: ...
    def hidden_fields(self) -> List[BoundField]: ...
    def visible_fields(self) -> List[BoundField]: ...
    def get_initial_for_field(self, field: Field, field_name: str) -> Any: ...
    def _html_output(
        self,
        normal_row: str,
        error_row: str,
        row_ender: str,
        help_text_html: str,
        errors_on_separate_row: bool,
    ) -> SafeString: ...

class Form(BaseForm):
    base_fields: ClassVar[Dict[str, Field]]
    declared_fields: ClassVar[Dict[str, Field]]
