from typing import Any, List, Optional, Sequence, Set, Tuple, Type, Union

from django.db.backends.base.base import BaseDatabaseWrapper
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.backends.ddl_references import Statement
from django.db.models.base import Model
from django.db.models.expressions import BaseExpression, Combinable, Expression, Func
from django.db.models.query_utils import Q
from django.db.models.sql.compiler import SQLCompiler

class Index:
    model: Type[Model]
    suffix: str = ...
    max_name_length: int = ...
    fields: Sequence[str] = ...
    fields_orders: Sequence[Tuple[str, str]] = ...
    name: str = ...
    db_tablespace: Optional[str] = ...
    opclasses: Sequence[str] = ...
    condition: Optional[Q] = ...
    expressions: Sequence[Union[Union[BaseExpression, Combinable]]]
    include: Sequence[str]
    def __init__(
        self,
        *expressions: Union[BaseExpression, Combinable, str],
        fields: Sequence[str] = ...,
        name: Optional[str] = ...,
        db_tablespace: Optional[str] = ...,
        opclasses: Sequence[str] = ...,
        condition: Optional[Q] = ...,
        include: Optional[Sequence[str]] = ...,
    ) -> None: ...
    @property
    def contains_expressions(self) -> bool: ...
    def create_sql(
        self, model: Type[Model], schema_editor: BaseDatabaseSchemaEditor, using: str = ..., **kwargs: Any
    ) -> Statement: ...
    def remove_sql(self, model: Type[Model], schema_editor: BaseDatabaseSchemaEditor, **kwargs: Any) -> str: ...
    def deconstruct(self) -> Any: ...
    def clone(self) -> Index: ...
    def set_name_with_model(self, model: Type[Model]) -> None: ...

class IndexExpression(Func):
    template: str = ...
    wrapper_classes: Sequence[Expression] = ...
    def set_wrapper_classes(self, connection: Optional[Any] = ...) -> None: ...
    @classmethod
    def register_wrappers(cls, *wrapper_classes: Expression) -> None: ...
    def resolve_expression(
        self,
        query: Optional[Any] = ...,
        allow_joins: bool = ...,
        reuse: Optional[Set[str]] = ...,
        summarize: bool = ...,
        for_save: bool = ...,
    ) -> IndexExpression: ...
    def as_sqlite(self, compiler: SQLCompiler, connection: BaseDatabaseWrapper, **extra_context: Any) -> Any: ...
