from typing import Any, Dict, List, Sequence, Tuple, Type, Union

from django.db.backends.base.base import BaseDatabaseWrapper
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import ProjectState
from django.db.models import Model

class Operation:
    reversible: bool = ...
    reduces_to_sql: bool = ...
    atomic: bool = ...
    elidable: bool = ...
    serialization_expand_args: List[str] = ...
    _constructor_args: Tuple[Sequence[Any], Dict[str, Any]]
    def deconstruct(self) -> Tuple[str, Sequence[Any], Dict[str, Any]]: ...
    def state_forwards(self, app_label: str, state: ProjectState) -> None: ...
    def database_forwards(
        self, app_label: str, schema_editor: BaseDatabaseSchemaEditor, from_state: ProjectState, to_state: ProjectState
    ) -> None: ...
    def database_backwards(
        self, app_label: str, schema_editor: BaseDatabaseSchemaEditor, from_state: ProjectState, to_state: ProjectState
    ) -> None: ...
    def describe(self) -> str: ...
    def references_model(self, name: str, app_label: str) -> bool: ...
    def references_field(self, model_name: str, name: str, app_label: str) -> bool: ...
    def allow_migrate_model(self, connection_alias: Union[BaseDatabaseWrapper, str], model: Type[Model]) -> bool: ...
    def reduce(self, operation: Operation, app_label: str) -> Union[bool, List[Operation]]: ...
