from typing import Any, Awaitable, Callable, Optional, Union

from django.http.request import HttpRequest
from django.http.response import HttpResponse, HttpResponseBase
from django.urls.resolvers import ResolverMatch

class BaseHandler:
    def load_middleware(self, is_async: bool = ...) -> None: ...
    def adapt_method_mode(
        self,
        is_async: bool,
        method: Callable[[HttpRequest], Union[HttpResponseBase, Awaitable[HttpResponseBase]]],
        method_is_async: Optional[bool] = ...,
        debug: bool = False,
        name: Optional[str] = ...,
    ) -> Callable[[HttpRequest], Union[HttpResponseBase, Awaitable[HttpResponseBase]]]: ...
    def get_response(self, request: HttpRequest) -> HttpResponseBase: ...
    async def get_response_async(self, request: HttpRequest) -> HttpResponseBase: ...
    def resolve_request(self, request: HttpRequest) -> ResolverMatch: ...
    def check_response(self, response: HttpResponseBase, callback: Any, name: Optional[str] = ...) -> None: ...
    def make_view_atomic(self, view: Callable[..., HttpResponseBase]) -> Callable[..., HttpResponseBase]: ...
    def process_exception_by_middleware(self, exception: Exception, request: HttpRequest) -> HttpResponse: ...
