# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sortinghat',
 'sortinghat.bin',
 'sortinghat.cmd',
 'sortinghat.db',
 'sortinghat.matching',
 'sortinghat.misc',
 'sortinghat.parsing',
 'tests']

package_data = \
{'': ['*'], 'sortinghat': ['data/*', 'templates/*'], 'tests': ['data/*']}

install_requires = \
['PyMySQL>=0.7.0',
 'jinja2>=3.0.1,<4.0.0',
 'numpy<1.21.1',
 'pandas>=0.22,<=0.25.3',
 'python-dateutil>=2.6.0,<3.0.0',
 'pyyaml>=3.12',
 'requests>=2.9,<3.0',
 'sqlalchemy>=1.3.0,<1.4.0',
 'urllib3>=1.22,<2.0']

entry_points = \
{'console_scripts': ['eclipse2sh = sortinghat.misc.eclipse2sh:main',
                     'gitdm2sh = sortinghat.misc.gitdm2sh:main',
                     'grimoirelab2sh = sortinghat.misc.grimoirelab2sh:main',
                     'mailmap2sh = sortinghat.misc.mailmap2sh:main',
                     'mg2sh = sortinghat.bin.mg2sh:main',
                     'mozilla2sh = sortinghat.misc.mozilla2sh:main',
                     'sh2mg = sortinghat.bin.sh2mg:main',
                     'sortinghat = sortinghat.bin.sortinghat:main',
                     'stackalytics2sh = sortinghat.misc.stackalytics2sh:main']}

setup_kwargs = {
    'name': 'sortinghat',
    'version': '0.7.21rc5',
    'description': 'A tool to manage identities.',
    'long_description': '# Sorting Hat [![Build Status](https://github.com/chaoss/grimoirelab-sortinghat/workflows/tests/badge.svg)](https://github.com/chaoss/grimoirelab-sortinghat/actions?query=workflow:tests+branch:master+event:push) [![Coverage Status](https://img.shields.io/coveralls/chaoss/grimoirelab-sortinghat.svg)](https://coveralls.io/r/chaoss/grimoirelab-sortinghat?branch=master)\n\n## Description\n\nA tool to manage identities.\n\nSorting Hat maintains an SQL database of unique identities of communities members across (potentially) many different sources. Identities corresponding to the same real person can be merged in the same unique identity with a unique uuid. For each unique identity, a profile can be defined, with the name and other data shown for the corresponding person by default.\n\nIn addition, each unique identity can be related to one or more affiliations, for different time periods. This will usually correspond to different organizations in which the person was employed during those time periods.\n\nSorting Hat is a part of the [GrimoireLab toolset](https://grimoirelab.github.io), which provides Python modules and scripts to analyze data sources with information about software development, and allows the production of interactive dashboards to visualize that information.\n\nIn the context of GrimoireLab, Sorting Hat is usually run after data is retrieved with [Perceval](https://github.com/chaoss/grimoirelab-perceval), to store the identities obtained into its database, and later merge them into unique identities (and maybe affiliate them).\n\n## Source code and contributions\n\nAll the source code is available in the [Sorting Hat GitHub repository](https://github.com/chaoss/grimoirelab-sortinghat). Please, submit pull requests if you have proposals to change the source code, and open an issue if you want to report a bug, ask for a new feature, or just provide feedback.\n\n## Usage\n\n```\nusage: sortinghat [--help] [-c <file>] [-u <user>] [-p <password>]\n                  [--host <host>] [--port <port>] [-d <name>]\n                  command [<cmd_args>]\n\nThe most commonly used sortinghat commands are:\n\n    add          Add identities\n    affiliate    Affiliate identities\n    autogender   Auto complete gender data\n    autoprofile  Auto complete profiles\n    blacklist    List, add or delete entries from the blacklist\n    config       Get and set configuration parameters\n    countries    List information about countries\n    enroll       Enroll identities into organizations\n    export       Export data (i.e identities) from the registry\n    init         Create an empty registry\n    load         Import data (i.e identities, organizations) on the registry\n    merge        Merge unique identities\n    mv           Move an identity into a unique identity\n    log          List enrollment information available in the registry\n    orgs         List, add or delete organizations and domains\n    profile      Edit profile\n    rm           Remove identities from the registry\n    show         Show information about a unique identity\n    unify        Merge identities using a matching algorithm\n    withdraw     Remove identities from organizations\n\nGeneral options:\n  -h, --help            show this help message and exit\n  -c FILE, --config FILE\n                        set configuration file\n  -u USER, --user USER  database user name\n  -p PASSWORD, --password PASSWORD\n                        database user password\n  -d DATABASE, --database DATABASE\n                        name of the database where the registry will be stored\n  --host HOST           name of the host where the database server is running\n  --port PORT           port of the host where the database server is running\n\nRun \'sortinghat <command> --help\' to get information about a specific command.\n```\n\n## Installation\n\n### From pypi\n\nYou can install sortinghat as a package from the pypi repository:\n\n```\n$ pip install sortinghat\n```\n\n### Native\n\nYou can install sortinghat just by running setup.py script:\n\n```\n$ python setup.py install\n```\n\nThis will install it in the python default directories in your system.\n\nIf you don\'t install sortinghat with root privileges, or don\'t want to install it in the default directories, you can also use the source code directory, as cloned from the main git repo. It is enough to\nconfigure your `$PATH` and `$PYTHONPATH` so that sortinghat, and the Python modules it needs, are found.\n\nAdd to your `$PATH` the directory which contains the sortinghat executables:\n\n```\n$ export PATH=$PATH:sortinghatdir/bin\n```\n\nIn `$PYTHONPATH`, you need to include sortinghat as well. If sortinghatdir is the path where sortinghat is installed:\n\n```\n$ export PYTHONPATH=$PYTHONPATH:sortinghatdir\n```\n\nYou are ready to use sortinghat!\n\n### Docker\n\nYou can use our image from [DockerHub](https://hub.docker.com/r/grimoirelab/sortinghat/) (`grimoirelab/sortinghat`) and skip the `docker build` step.\nIf you prefer to build the image yourself execute:\n\n```sh\n$ docker build -t grimoirelab/sortinghat .\n```\n\nNext step would be to start a MySQL docker container for data storage:\n\n```sh\n$ docker run --name mysql \\\n             -e MYSQL_ROOT_PASSWORD=sortinghat \\\n             -d mysql\n```\n\nRun the sortinghat docker container in interactive mode:\n\n```sh\n$ docker run -i -t --rm \\\n             --link mysql:mysql \\\n             -e SORTINGHAT_DB_HOST=mysql \\\n             -e SORTINGHAT_DB_PASSWORD=sortinghat \\\n             -e SORTINGHAT_DB_DATABASE=sortinghat \\\n             grimoirelab/sortinghat \\\n             /bin/bash\n```\n\nNow you can initialize sortinghat with the database name `sortinghat`:\n\n```\n$ sortinghat init sortinghat\n```\n\nYou are ready to use sortinghat and explore the commands documented below.\nHave fun!\n\n## Configuration\n\nSet the database parameters via the `config` command:\n\n```\n  $ sortinghat config set db.host <mysql-host>\n  $ sortinghat config set db.user <user>\n  $ sortinghat config set db.password <password>\n  $ sortinghat config set db.database <name>\n  $ sortinghat config set db.port <port>\n```\n\nAlternatively you can set environment variables:\n\n```\n  $ export SORTINGHAT_DB_HOST=<mysql-host>\n  $ export SORTINGHAT_DB_USER=<user>\n  $ export SORTINGHAT_DB_PASSWORD=<password>\n  $ export SORTINGHAT_DB_DATABASE=<name>\n  $ export SORTINGHAT_DB_PORT=<port>\n```\n\nAfter this initialize a new database:\n\n```\n  $ sortinghat init <name>\n```\n\n## Compatibility between versions\n\nPython 2.7 is no longer supported. Any code using this version will\nnot work. Please update your code to 3.4 or newer versions.\n\nSortingHat databases previous to 0.7.0 are compatible but UTF-8 encoded 4-bytes\ncharacters will not be inserted in the database and will cause errors. For this\nreason, it is recommended to update its schema. The fastest way is to\ndump the data into a file, regenerate the database with `init` command\nand restore the data from the dump.\n\nSortingHat databases previous to 0.6.0 are no longer compatible.\nThe database schema changed in `profiles` table to add the fields `gender`\nand `gender_acc`.\n\nThe next MySQL statements should be run to update the schema\n\n```\nmysql> ALTER TABLE profiles ADD COLUMN gender VARCHAR(32) DEFAULT NULL\nmysql> ALTER TABLE profiles ADD COLUMN gender_acc INT(11) DEFAULT NULL\n```\n\nSortingHat databases previous to 0.5.0 are no longer compatible. The\ndatabase schema changed in `uidentites` and `identities` tables to add the\nfield `last_modified` to log when a record was updated.\n\nThe next MySQL statements should be run to update the schema\n\n```\nmysql> ALTER TABLE uidentities ADD COLUMN last_modified DATETIME(6) DEFAULT NULL\nmysql> ALTER TABLE identities ADD COLUMN last_modified DATETIME(6) DEFAULT NULL\n```\n\nSortingHat databases previous to 0.3.0 are no longer compatible. The\nseed used to generate identities UUIDs changed and for that reason, these\nids should be re-generated.\n\nThe next steps will restore the database generating new UUIDs for each identity\nbut keeping the data and relationships between them.\n\n1. Export data\n```\n$ sortinghat export --orgs orgs.json\n$ sortinghat export --identities identities.json\n```\n1. Remove the database and/or create a new one with `sortinghat init`\n1. Load data, this will regenerate the UUIDs\n```\n$ sortinghat load orgs.json\n$ sortinghat load identities.json\n```\n\n## Basic commands\n\n* Add some unique identities\n```\n  $ sortinghat add --name "John Smith" --email "jsmith@example.com" --username "jsmith" --source scm\n  New identity a9b403e150dd4af8953a52a4bb841051e4b705d9 to a9b403e150dd4af8953a52a4bb841051e4b705d9\n\n  $ sortinghat add --name "John Doe" --email "jdoe@example.com" --source scm\n  New identity 3de180633322e853861f9ee5f50a87e007b51058 added to 3de180633322e853861f9ee5f50a87e007b51058\n```\n\n* Set a profile\n```\n  $ sortinghat profile --name "John Smith" --email "jsmith@example.com" --country US a9b403e150dd4af8953a52a4bb841051e4b705d9\n  unique identity a9b403e150dd4af8953a52a4bb841051e4b705d9\n\n  Profile:\n      * Name: John Smith\n      * E-Mail: jsmith@example.com\n      * Bot: No\n      * Country: US - United States of America\n```\n\n* Add an identity to an existing unique identity\n```\n  $ sortinghat add --username "jsmith" --source mls --uuid a9b403e150dd4af8953a52a4bb841051e4b705d9\n  New identity 2612aad107cae121b45c1f46041650abc8e39421 added to a9b403e150dd4af8953a52a4bb841051e4b705d9\n```\n\n* Merge two identities\n```\n  $ sortinghat merge a7637bb1737bc2a83f3a3e25b9b441cba62d97c2 a9b403e150dd4af8953a52a4bb841051e4b705d9\n  Unique identity 3de180633322e853861f9ee5f50a87e007b51058 merged on a9b403e150dd4af8953a52a4bb841051e4b705d9\n```\n\n* Move an identity into a unique identity\n```\n  $ sortinghat mv 3de180633322e853861f9ee5f50a87e007b51058 3de180633322e853861f9ee5f50a87e007b51058\n  New unique identity 3de180633322e853861f9ee5f50a87e007b51058 created. Identity moved\n```\n\n* Remove a unique identity\n```\n  $ sortinghat rm 3de180633322e853861f9ee5f50a87e007b51058\n  Unique identity 3de180633322e853861f9ee5f50a87e007b51058 removed\n```\n\n* Show identities information\n```\n  $ sortinghat show\n  unique identity a9b403e150dd4af8953a52a4bb841051e4b705d9\n\n  Profile:\n      * Name: John Smith\n      * E-Mail: jsmith@example.com\n      * Bot: No\n      * Country: US - United States of America\n\n  Identities:\n    2612aad107cae121b45c1f46041650abc8e39421\t-\t-\tjsmith\tmls\n    a9b403e150dd4af8953a52a4bb841051e4b705d9\tJohn Smith\tjsmith@example.com\tjsmith\tscm\n\n  No enrollments\n```\n\n* Add some organizations\n```\n  $ sortinghat orgs -a Example\n  $ sortinghat orgs -a Bitergia\n  $ sortinghat orgs -a Individual\n```\n\n* Add some domains to the organizations\n```\n  $ sortinghat orgs -a Example example.com --top-domain\n  $ sortinghat orgs -a Example web.example.com\n  $ sortinghat orgs -a Bitergia bitergia.com --top-domain\n```\n\n* List organizations\n```\n  $ sortinghat orgs\n  Bitergia\tbitergia.com *\n  Example\texample.com *\n  Example\tweb.example.com\n  Individual\n```\n\n* Remove domains\n```\n  $ sortinghat orgs -d Example web.example.com\n```\n\n* Remove organizations\n```\n $ sortinghat orgs -d Bitergia\n```\n\n* Enroll\n```\n  $ sortinghat enroll --from 2014-06-01 --to 2015-09-01 a9b403e150dd4af8953a52a4bb841051e4b705d9 Example\n  $ sortinghat enroll --from 2015-09-01 a9b403e150dd4af8953a52a4bb841051e4b705d9 Individual\n```\n\n* Show enrollments information\n```\n  $ sortinghat show a9b403e150dd4af8953a52a4bb841051e4b705d9\n  unique identity a9b403e150dd4af8953a52a4bb841051e4b705d9\n\n  Profile:\n      * Name: John Smith\n      * E-Mail: jsmith@example.com\n      * Bot: No\n      * Country: US - United States of America\n\n  Identities:\n    2612aad107cae121b45c1f46041650abc8e39421\t-\t-\tjsmith\tmls\n    a9b403e150dd4af8953a52a4bb841051e4b705d9\tJohn Smith\tjsmith@example.com\tjsmith\tscm\n\n  Enrollments:\n    Example\t2014-06-01 00:00:00\t2015-09-01 00:00:00\n    Individual\t2015-09-01 00:00:00\t2100-01-01 00:00:00\n```\n\n* Withdraw\n```\n  $ sortinghat withdraw --from 2014-06-01 --to 2015-09-01 a9b403e150dd4af8953a52a4bb841051e4b705d9 Example\n```\n\n## Basic API calls\n\nSortinghat can be integrated on your Python scripts by leveraging on its API. Each API call requires as a parameter\nthe database in which the operations will be performed. A database object should thus be created by specifying\nthe `user`, `password`, `database` and optional `host` and `port`.\n```\nfrom sortinghat import api\nfrom sortinghat.db.database import Database\n\ndb = Database(\'root\', \'*****\', \'test_db\')\n```\n \n#### Key terms\n\n* `identity_id`: Identifier assigned to the identity.\n* `entity`:  Entity can be any term, word or value to blacklist.\n* `from_date`: Starting date which is a datetime objects. The method `str_to_datetime` can be used to convert the\n    string date and time parameter to datetime object. \n* `matcher`: Criteria used to match identities.\n* `source`: Source of the identities.\n* `term`: Term to match with an attribute(e.g organization, country name). \n* `to_date`: Ending date which is a datetime objects. The method `str_to_datetime` can be used to convert the\n    string date and time parameter to datetime object. \n* `uuid`: Unique identifier for the identity.\n \n#### Usage\n \n* Add a unique identity to the registry\n```\napi.add_unique_identity(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\')\n```\n\n* Add an identity to the registry\n ```\nsource = \'git\'\nemail = \'jsmith@example.com\'\nname = \'John Smith\'\nusername = \'jsmith\'\nuuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\n    \napi.add_identity(db=db, source=source, email=email, name=name, username=username, uuid=uuid)\n```\n\n* Add an organization to the registry\n```\napi.add_organization(db=db, organization=\'ExampleOrg\')\n```\n\n* Add a new domain to the given organization\n\n    To set the domain as the top domain pass `is_top_domain = True`. The domain for an organization can be updated by\n    passing `overwrite=True`. \n```\napi.add_domain(db=db, organization=\'ExampleOrg\', domain=\'example.com\', is_top_domain=True, overwrite=False)\n```\n\n* Enroll a unique identity to an organization\n```\nfrom sortinghat.utils import str_to_datetime\n    \nuuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\norganization = \'ExampleOrg\'\nfrom_date = str_to_datetime(\'2020-04-01\')\nto_date = str_to_datetime(\'2020-04-05\')\n    \napi.add_enrollment(db=db, uuid=uuid, organization=organization, from_date=from_date, to_date=to_date)\n```\n\n* Add entity to the matching blacklist\n```\napi.add_to_matching_blacklist(db=db, entity=\'example\')\n```\n\n* List the blacklisted entities available in the registry\n\n    The API returns a list of blacklisted entities sorted by their name.\n```\napi.blacklist(db=db, term=\'example\')\n```\n\n* List the countries available in the registry\n\n    The API returns a list of countries sorted by their country id.\n```\napi.countries(db=db, code=\'US\', term=\'United States of America\')\n```\n\n* Remove a unique identity from the registry\n```\napi.delete_unique_identity(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\')\n```\n\n* Remove an identity from the registry\n```\napi.delete_identity(db=db, identity_id=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\')\n```\n\n* Remove an organization from the registry\n```\napi.delete_organization(db=db, organization=\'ExampleOrg\')\n```\n\n* Remove the given organization domain from the registry\n```\napi.delete_domain(db=db, organization=\'ExampleOrg\', domain=\'example.com\')\n```\n\n* Withdraw a unique identity from an organization\n```\nfrom sortinghat.utils import str_to_datetime\n    \nuuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\norganization = \'ExampleOrg\'\nfrom_date = str_to_datetime(\'2020-04-01\')\nto_date = str_to_datetime(\'2020-04-05\')\n    \napi.delete_enrollment(db=db, uuid=uuid, organization=organization, from_date=from_date, to_date=to_date)\n```\n\n* Remove a blacklisted entity from the registry\n```\napi.delete_from_matching_blacklist(db=db, entity=\'example\')\n```\n\n* List the domains available in the registry\n\n    The API returns a list of domains.\n```\napi.domains(db=db, domain=\'example.com\')\n```\n\n* Edit unique identity profile\n\n    The allowed keywords are, `name`, `email`,`gender`, `gender_acc`, `is_bot` and `country_code`. Any other keyword will be\n    ignored.   \n```\nkwargs = {\n    \'name\': \'John Doe\',\n    \'email\': \'doe@example.com\',\n    \'gender\': \'Female\',\n    \'gender_acc\': 50,\n    \'is_bot\': False,\n    \'country_code\': \'IN\'\n}\napi.edit_profile(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\', **kwargs)\n```\n\n* List the enrollment information available in the registry\n\n    The API returns a list of enrollments sorted by uuid or by organization.\n```\nfrom sortinghat.utils import str_to_datetime\n    \nuuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\norganization = \'ExampleOrg\'\nfrom_date = str_to_datetime(\'2020-04-01\')\nto_date = str_to_datetime(\'2020-04-05\')\n    \napi.enrollments(db=db, uuid=uuid, organization=organization, from_date=from_date, to_date=to_date)\n```\n\n* Search for similar unique identities\n\n    The API requires a Matcher object to be passed a parameter. The object can be created using the\n    `create_identity_matcher` method.\n```\nfrom sortinghat.matcher import create_identity_matcher\n\nmatcher = create_identity_matcher()\n\napi.match_identities(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\', matcher=matcher)\n```\n\n* Merge one unique identity into another\n```\nfrom_uuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\nto_uuid = \'3de180633322e853861f9ee5f50a87e007b51058\'\n    \napi.merge_unique_identities(db=db, from_uuid=from_uuid, to_uuid=to_uuid)\n```\n\n* Merge overlapping enrollments\n```\napi.merge_enrollments(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\', organization=\'ExampleOrg\')\n```\n\n* Move an identity to a unique identity\n```\nfrom_id = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\nto_uuid = \'a9b403e150dd4af8953a52a4bb841051e4b705d9\'\n        \napi.move_identity(db=db, from_id=from_id, to_uuid=to_uuid )\n```\n\n* List the organizations available in the registry\n\n    The API returns a list of organizations sorted by their name.\n```\napi.registry(db=db, term=\'example\')\n```\n\n* Search for the uuids of identities modified on or after a given date\n\n    The API returns a list of uuids of identities modified.\n```\napi.search_last_modified_identities(db=db, after=\'2020-04-01\')\n```\n\n* Search for the uuids of unique identities modified on or after a given date\n\n    The API returns a list of uuids of unique identities modified.\n```\napi.search_last_modified_unique_identities(db=db, after=\'2020-04-01\')\n```\n\n* List unique identities profiles\n    \n    The API returns a list of profile entities. To return only the entities having no gender set `no_gender=True`.\n```\napi.search_profiles(db, no_gender=False)\n```\n\n* Search for unique identities\n\n    The API returns a list of unique identities. The term will be compared with name, email, username and source values\n    of each identity. When `source` is given, this search will be only performed on identities linked to this source.\n```\napi.search_unique_identities(db=db, term=\'example\', source=\'scm\')\n```\n\n* Search for unique identities using slicing\n\n    The API returns a list of unique identities starting from `offset` and limiting a maximum number of identities specified by\n    `limit`. The term will be compared with name, email, username and source values of each identity.\n```\napi.search_unique_identities_slice(db=db, term=\'example\', offset=4, limit=20)\n```\n\n* List the unique identities available in the registry\n\n    The function returns a list of unique identities.\n```\napi.unique_identities(db=db, uuid=\'a9b403e150dd4af8953a52a4bb841051e4b705d9\', source=\'scm\')\n```\n\n## Import / Export\n\n* Import data from a Sorting Hat JSON file\n```\n  $ sortinghat load sh.json\n  Loading blacklist...\n  Entry  added to the blacklist\n  1/1 blacklist entries loaded\n  Loading unique identities...\n  + 00000ba7f563234e5f239e912f2df1021695122e (old 00000ba7f563234e5f239e912f2df1021695122e) loaded\n  + 00003e37e7586be36c64ce4f9eafa89f11be2448 (old 00003e37e7586be36c64ce4f9eafa89f11be2448) loaded\n  ...\n  + fa84729382093928570aef849483948489238498 (old fa84729382093928570aef849483948489238498) loaded\n  100/100 unique identities loaded\n```\n\n* Export identities\n```\n  $ sortinghat export --identities sh_ids.json\n```\n\n* Export organizations\n```\n  $ sortinghat export --orgs sh_orgs.json\n```\n\n## Requirements\n\n* Python >= 3.4\n* MySQL >= 5.6 or MariaDB 10.0\n* SQLAlchemy >= 1.2\n* Jinja2 >= 2.7\n* python-dateutil >= 2.6\n* python-yaml >= 3.12\n* requests >= 2.9\n* urllib3 >= 1.22\n\nYou will also need a MySQL Python driver to connect with the database server. We recommend using one these packages:\n\n* PyMySQL\n\nOptionally, you can install Pandas library to speed up the matching process:\n\n* python-pandas >= 0.15\n\n## Running tests\n\nSortingHat comes with a comprehensive list of unit tests.\nTo run them, copy the file \'tests/tests.conf.sample\' to \'tests/tests.conf\'\nand edit it to suit your configuration:\n\n* `name`: Name of the database to use for testing\n* `host`, `port`: How to access the database server (MySQL, MariaDB)\n* `user`, `password`: Credentials for the database server\n* `create`: Whether the database for testing will be created (`True`)\n  or not (`False`, by default). If `True`, tests will fail if database\n  already exists. If `False`, tests will fail if database does not exist.\n\nYou can run the tests through `setup.py` (no need to install dependencies\n  or something else, `setup.py` will take care of that):\n\n```\n$ python3 setup.py test\n```\n\n## Troubleshooting\n\nOnce SortingHat has been installed, some errors may pop up when running the test suite due to the underlying MySQL\ndatabase configuration.\n\nMySQL command should be executed without superuser privilege (sudo):\n```\nmysql> GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nmysql> FLUSH PRIVILEGES;\n```\n\nMySQL strict mode should be disabled:\n```\nmysql> SET @@global.sql_mode= \'\';\n```\n\n## License\n\nLicensed under GNU General Public License (GPL), version 3 or later.\n',
    'author': 'GrimoireLab Developers',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chaoss.github.io/grimoirelab/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
