Oxrdflib
========

[![PyPI](https://img.shields.io/pypi/v/oxrdflib)](https://pypi.org/project/oxrdflib/)
![PyPI - Implementation](https://img.shields.io/pypi/implementation/oxrdflib)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/oxrdflib)
[![actions status](https://github.com/oxigraph/oxrdflib/workflows/build/badge.svg)](https://github.com/oxigraph/oxrdflib/actions)
[![Gitter](https://badges.gitter.im/oxigraph/community.svg)](https://gitter.im/oxigraph/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

Oxrdflib provides an [rdflib](https://rdflib.readthedocs.io/) store based on [pyoxigraph](https://oxigraph.org/pyoxigraph/).
This store is named `"Oxigraph"`.

This store can be used as drop-in replacement of the rdflib default one. It support context but not formulas.
Transaction support is not implemented yet.

SPARQL query evaluation is done by pyoxigraph instead of rdflib if the Oxigraph store is used.
SPARQL update evaluation is still done using rdflib because of [a limitation in rdflib context management](https://github.com/RDFLib/rdflib/issues/1396).

Oxrdflib is [available on Pypi](https://pypi.org/project/oxrdflib/) and installable with:
```bash
pip install oxrdflib
```

The oxrdflib store is automatically registered as an rdflib store plugin by setuptools.

*Warning:* Oxigraph is not stable yet and its storage format might change in the future.
To migrate to future version you might have to dump and load the store content.
However, Oxigraph should be in a good enough shape to power most of use cases if you are not afraid of down time and data loss.

## API

To create a rdflib graph using the Oxigraph store use
```python
rdflib.Graph(store="Oxigraph")
```
instead of the usual
```python
rdflib.Graph()
```

Similarly, to get a conjunctive graph, use
```python
rdflib.ConjunctiveGraph(store="Oxigraph")
```
instead of the usual
```python
rdflib.ConjunctiveGraph()
```
and to get a dataset, use

```python
rdflib.Dataset(store="Oxigraph")
```
instead of the usual
```python
rdflib.Dataset()
```

If you want to get the store data persisted on disk, use the `open` method on the `Graph` object (or `ConjunctiveGraph` or `Dataset`) with the directory where data should be persisted. For example:
```python
graph = rdflib.Graph(store="Oxigraph")
graph.open("test_dir")
```
The store is closed with the `close()` method or automatically when Python garbage collector collects the store object.

If the `open` method is not called Oxigraph will automatically use a ramdisk on Linux and a temporary file in the other operating systems.

To do anything else, use the usual rdflib python API.

## Migration guide

### From 0.2 to 0.3
* The 0.2 stores named `"OxSled"` and `"OxMemory"` have been merged into the `"Oxigraph"` store.
* The on-disk storage system provided by `"OxSled"` has been dropped and replaced by a new storage system based on [RocksDB](https://rocksdb.org/).
  To migrate you need to first dump your data in RDF using `oxrdflib` 0.2 and the `serialize` method, then upgrade to `oxrdflib` 0.3, and finally reload the data using the `parse` method.

## Development

To run the test do first `pip install -e` to register the stores in rdflib plugin registry.
Then, `cd tests && python -m unittest` should run the tests.

The code is automatically formatted using [black](https://github.com/psf/black). A [pre-commit](https://pre-commit.com/) configuration is provided.
Run `pip install pre-commit && pre-commit install` to install pre-commit as a git pre-commit hook in your clone.
