from pymink.cleaner import Cleaner
from pymink.ngram import word_ngrams, sentence_ngrams

# Dummy text
DTXT_1 = "This is a dummy text. It is used to test libraries and modules."
DTXT_2 = """Though the terms global warming and climate change are often used interchangeably, they have different meanings. Climate change describes long-term shifts in the Earth's weather patterns, which affect such factors as temperature, humidity, wind, cloud cover, and precipitation levels. Global warming specifically refers to an increase in the Earth's average surface temperatures caused by human activities, primarily the burning of fossil fuels.

Overwhelming scientific evidence supports the reality of both global warming and climate change. In 2021 the Intergovernmental Panel on Climate Change (IPCC) released its Sixth Assessment Report (AR6) revealing how human activity has induced rapid climate change. AR6 covers how specific regions experienced the effects of climate change, projecting how these changes will likely play out in the future and identifying what interventions could limit increased global temperatures. AR6 estimates a rise in the global surface temperature by 1.07°C (1.93°F) from the latter half the nineteenth century through the first two decades of the twenty-first century, primarily as a result of increasing greenhouse gas and particulate emissions that trap heat in the earth's atmosphere.

The IPCC emphasizes the key role of humans in the causes of global warming and climate change. The scientific model uses decades of research and peer-reviewed studies to provide evidence that global warming and climate change are being caused and accelerated by the release of carbon dioxide and other pollutants into the atmosphere during human agricultural and industrial processes and the continued extraction, production, and consumption of fossil fuels. They note that climate change and global warming have already led to increased numbers of and more severe storms, floods, droughts, and wildfires, which will only continue if humans continue to utilize fossil fuels and other processes that contribute to the greenhouse effect.

A vocal minority disagree with the scientific consensus that these climate trends are being driven by human activity. Opponents believe that severe changes in climate and weather patterns are the result of natural cycles that have repeated again and again over the course of Earth's history.

Concerns about the phenomena have inspired activism, laws, and international treaties while also sparking heated debate because of the political implications of trying to change the processes and practices scientists have linked to climate change. The debate over climate change influences social and economic policy, and many environmental and economic experts believe shifts in everything from food production to transportation to electricity production would be needed to curb or stop further climate change. Some opponents of such changes believe they are unnecessary, that they cause major job losses and decimate entire industries, or that it will be easier to adapt to future environmental changes than projected. Voters have demonstrated a growing willingness to cast ballots in favor of political candidates who share their views about how to deal with the issue, whether that means maintaining the status quo or implementing sweeping changes.

 

Main Ideas
Climate change refers to long-term shifts in the earth's weather patterns; global warming is the increase in the earth's average surface temperatures caused by human activities such as the burning of fossil fuels.
Causes of climate change related to human activity are referred to as anthropogenic; natural causes of climate change are called naturogenic.

Earth's atmosphere contains several gases that trap heat from the sun and prevent it from escaping into space. These gases are called greenhouse gases.

Global warming could have a long-term impact on ecosystems and wildlife habitats, negatively impacting Earth's biodiversity.

Economic and political issues play a role in how governments respond to global warming and climate change.

Global warming has been linked to more frequent heat waves. July 2021 was the earth's hottest month on record.

 

Causes of Climate Change
Earth's atmosphere contains several gases that trap heat from the sun and prevent it from escaping into space. This phenomenon is known as the greenhouse effect, and the gases are referred to as greenhouse gases. The main greenhouse gases that occur in nature are carbon dioxide, methane, and nitrous oxide. Without the greenhouse effect, Earth would be too cold to support life. Over time, the amount of greenhouse gases trapped in Earth's atmosphere has increased significantly, causing worldwide temperatures to rise.

Natural processes on Earth constantly create and destroy greenhouse gases. For example, the decay of plant and animal matter produces carbon dioxide, which plants then absorb during photosynthesis. This natural cycle stabilizes atmospheric levels of carbon dioxide. Shifts in the planet's crust and changes in ocean patterns impact weather, as do fluctuations in the sun's output of radiation. Volcanic activity also affects the climate because eruptions discharge greenhouse gases and other contaminants into the atmosphere. Climate change scientists at the National Aeronautics and Space Administration (NASA) and other federal and international agencies recognize that these natural factors continue to play a role in climate change, but they generally agree that the impact of these factors alone does not explain the substantial recent rise in Earth's temperature. Natural causes of climate change are referred to as naturogenic, while causes of climate change related to human activity are called anthropogenic.

Earth's vegetation releases and absorbs more than two hundred billion metric tons of carbon dioxide annually. Human activities, such as the burning of fossil fuels, add approximately seven billion more metric tons per year. Climate scientists believe the cumulative effect of this additional carbon dioxide has had a dramatic effect on the atmosphere. According to the National Oceanic and Atmospheric Administration (NOAA), the 20 percent increase in the average global concentration of carbon dioxide in the atmosphere that occurred between 1980 and 2020 accounted for over half of the total increase since the Industrial Revolution began around 1750. Deforestation has also played a role in this increase by eliminating forests that would otherwise have absorbed many tons of carbon dioxide.

Increased levels of other greenhouse gases such as nitrous oxide and methane have also resulted from human activity. Several agricultural and industrial processes, such as the use of certain fertilizers in farming, produce nitrous oxide on a mass scale. Methane emissions come from the production of fossil fuels as well as from landfills and livestock. Though much smaller quantities of these gases exist in Earth's atmosphere, some scientists believe they cause more harm than carbon dioxide. Methane, for example, is about twenty-one times as potent as carbon dioxide at trapping heat. Humans have also created and released greenhouse gases that do not occur in nature. These include hydrofluorocarbons (HFCs), perfluorocarbons (PFCs), and sulfur hexafluoride (SF6). These gases, released during such industrial processes as aluminum production and electrical transmission, trap thousands of times more heat in the atmosphere than carbon dioxide.

 

Climate Change Predictions
A broad consensus exists in the scientific community that the consequences of climate change may be devastating, though the exact nature of the changes is difficult to assess. No climate model formulated by scientists to chart climate patterns has had 100 percent accuracy in predicting changes. For instance, most climate models failed to predict a slowdown in rising temperatures starting in 1998 and ending in 2012. The slowdown was attributed to volcanic eruptions that blocked out the sun and cooled temperatures, low levels of solar activity, and naturally occurring variability. Similarly, some predictions have underestimated threats.

In its initial assessment of rising sea levels in 1990, the IPCC originally anticipated a sea level rise of 1.9 millimeters per year from that year onward. However, in its sixth report, released in 2021, the IPCC found that sea levels have risen at a rate of 3.7 millimeters per year between 2006 and 2018. The IPCC predicts that global warming will cause the global sea level to rise two to six meters by 2150. Sea level rise contributes to increased flooding and to the damage caused by extreme storms such as hurricanes in coastal cities.

Because of the difficulties in creating completely accurate climate change models, skeptics of global warming and climate change note that Earth has experienced cyclical changes in its climate patterns for eons. They also tend to believe that recent climatic shifts are not as severe as indicated and may not necessarily be a direct consequence of human activity. Climate scientists contend that such skepticism may stem from an unwillingness to face the scope of the threat posed to the planet by human activity. Additionally, fossil fuel companies and major agricultural and industrial companies that might be affected by changes recommended by climate scientists have contributed large amounts of money to organizations and politicians that promote climate change denial.

 

Effects of Global Warming
The potential future consequences of global warming remain an issue of great debate and uncertainty. However, most experts predict dramatic and serious problems for future generations. Warmer oceans could result in stronger and more frequent hurricanes. As temperatures climb, some regions could experience frequent heat waves along with devastating droughts and wildfires. A heat wave in 2021 led to record-breaking temperatures. NOAA reported that June was the hottest month on record in the United States and July was the hottest month recorded on Earth. During the US heat wave, temperatures in the Pacific Northwest reached triple digits and led to the deaths of more than two hundred people in the region.

Climate change has been linked to the severe, exceptional drought that has occurred over the last twenty years in parts or all of several western states including Arizona, California, Colorado, Idaho, Montana, Nevada, New Mexico, Oregon, Utah, and Washington. Some observers have labeled this phenomenon a "megadrought," and it has led to massive wildfires and water shortages. From 2018 to 2021, California and Oregon endured massive wildfires that burned millions of acres and led to the displacement of thousands of residents, widespread destruction of property, and the deaths of dozens of people. California had a record-breaking wildfire season in 2020, including the state's first gigafire—a blaze that burned more than one million acres of land. By the end of the year, wildfires burned more than four million acres throughout the state. Scientists have attributed the fires to high levels of extremely dry vegetation, desiccated by rising temperatures and low soil moisture, that created conditions enabling the fires to spread rapidly and burn with fierce intensity. A federal water shortage was declared for the Colorado River in August 2021, impacting states that rely on the river for water. Cuts to state water supplies, projected to heavily affect agriculture and residential consumers, took effect beginning in October in Arizona and Nevada. If the drought continued, future cuts were expected for other states in the river basin including California and in several Native American nations.

Many coastal areas around the world could also face severe flooding due to rising sea levels. Low-lying islands in the Pacific Ocean would eventually become uninhabitable. Since the beginning of the twentieth century, sea level has risen about eight inches worldwide. The hurricane season of 2017 proved to be the costliest hurricane season since 1900, with over $265 billion of property damage in the United States and the tragic loss of life in Florida, Texas, and Puerto Rico. The 2016, 2017, 2018, 2019, and 2020 seasons all brought powerful Category 5 hurricanes, indicating a possible trend toward increasing storm intensities. The year 2020 broke records with thirty named storms—the most to ever occur in a single hurricane season. By September 6, 2021, it was predicted that the 2021 season, which ends in November, would be nearly as active as 2020.

Global warming could also have a major impact on ecosystems and wildlife habitats. Some areas might become too dry or too wet to support agriculture. Long periods of drought could turn fertile lands into deserts with little vegetation. Plants and animals might not be able to survive the rapid changes caused by global warming and could become extinct. Over the long term, such changes would negatively impact Earth's biodiversity. Some ecosystems such as coral reefs and coastal mangrove swamps appear likely to disappear completely.

Human populations would also face serious problems. Loss of farmland, for example, would cause major disruptions in the food supply, bringing about famine in many areas. More frequent and intense heat waves could result in more heat-related deaths, and changes in air quality could also affect human health. Other experts warn of potential impacts on migration and geopolitical conflict as populations flee areas most impacted by climate change and rival countries go to war over dwindling resources.

 

U.S. Attitudes About Climate Change
The effects of human activities on global warming and climate change are acknowledged and accepted by the majority of people in the United States. According to annual polls conducted by Gallup since 2001, the public's beliefs in anthropogenic climate change had increased slightly by 2021. That year, 64 percent of Americans accepted that human activities cause climate change (up from 61 percent in 2001), 59 percent believed that the effects have begun (up from 54 percent), and 43 percent stated that that global warming will soon pose a serious threat and that they worry a great deal about it (up from 31 and 33 percent, respectively).

Researchers have observed a strong correlation between people's political affiliations and their acceptance of climate science and levels of concern about global warming. In 2021 about 82 percent of Democrats believed effects of global warming were already apparent and 88 percent believed they were caused by humans, while only 29 percent of Republicans agreed with the first statement and 32 with the second. The majority of independents believed both statements (59 and 65 percent, respectively).

 

International Response
Economic and political issues influence how governments choose to respond to climate change and global warming. To reduce global warming in years to come, nations may need to implement policies with the potential to inhibit their economies. Efforts to tighten restrictions on greenhouse emissions may reduce production capacity, foreign investment, and household purchasing power. They could also lead to higher prices on consumer goods. However, some economists believe that investments in clean energy and alternative agricultural and industrial practices could offset financial losses or higher prices on certain goods. For these reasons, governments have encountered great difficulty in agreeing on a global plan to deal with Earth's changing climate.

Wealthier countries produce far more greenhouse gases than poorer countries, thus contributing more to the process of global warming. At the same time, the negative effects of climate change impact developing countries to a greater degree than developed countries. Many people believe that industrialized nations should take on greater responsibility in reducing emissions of these gases. In many cases, leaders of developed nations have resisted this idea.

Since 1995 the United Nations (UN) has hosted annual conferences to discuss climate change as part of its Framework Convention on Climate Change (UNFCCC). In 1997 delegates gathered in Kyoto, Japan, to negotiate an international treaty known as the Kyoto Protocol. This treaty required industrialized countries to reduce their greenhouse gas emissions by a certain percentage over a five-year period. As of August 2021, 192 parties, composed of 191 countries and the European Union, had ratified the Kyoto Protocol. Notable exceptions from the list of signatories include the United States, which has never ratified the treaty, and Canada, which announced its withdrawal from the agreement in 2011.

In 2015 world leaders set new climate goals at the UNFCCC conference in Paris, France. The resultant Paris Agreement aimed to limit the rise in global temperatures to less than 2°C (approximately 3.6°F) above preindustrial levels and provide countries with the tools needed to counteract climate change. US president Barack Obama played a central role in brokering the Paris Agreement and pushed for greater environmental restrictions during his presidency. On November 4, 2016, the Paris Agreement went into effect with the commitment of the United States and seventy-three other parties.

In June 2017 President Donald Trump announced that the United States would withdraw from the Paris Agreement, sparking widespread controversy. Shortly after the president's announcement, a bipartisan coalition of governors, tribal leaders, mayors, and business leaders pledged their commitment to work toward the goals of the Paris Agreement by signing on to the We Are Still In declaration. The United States officially withdrew from the agreement in November 2020.

When President Joe Biden took office in January 2021, he reentered the country into the Paris Agreement on his first day. Biden vowed that his administration would prioritize climate policy, and he issued several executive orders that made sustainability and addressing climate change important considerations across all federal government agencies. In April 2021 he hosted a virtual climate summit attended by forty world leaders and pledged that, by 2030, the United States would reduce its carbon emissions to half of 2005 levels.

 

Critical Thinking Questions
According to climate experts, how could global warming impact human populations in the future? What do you believe should be done about it? Explain your answer.

Why do you think that there is a correlation between political ideology and belief in the anthropogenic causes of climate change?

Do you believe wealthy, industrialized nations should take on greater responsibility than developing nations in reducing emissions? Why or why not?

 

Climate Activism
In 2018 Swedish teenager Greta Thunberg (2003–) emerged as the face of a new youth-oriented movement seeking to prompt global leaders to take dramatic action to fight climate change. Thunberg started alone protesting political inaction on climate change outside of her country's parliament and, within a year, had become a global phenomenon, delivering powerful speeches attacking world leaders for their lack of urgency in addressing the root causes of climate change. Time magazine named Thunberg its "Person of the Year" for 2019. On Friday, September 20, 2019, thanks in large part to Thunberg's urging, four million people participated in a global climate strike. The event was the largest climate protest in history.

Climate experts have labeled the 2020s as the "decisive decade" for climate action. In April 2021 Christiana Figueres, the former executive secretary of the UNFCCC, wrote: "History will remember this decade as the climate turning point, the moment we finally woke up to the fact that despite (and because of) shocks like COVID-19, decarbonization—the reduction of carbon dioxide emissions—is now inevitable. … We've crossed a new threshold, there's no going back to a high-emissions trajectory.\""""
