# Generated by Django 3.2.7 on 2021-09-16 12:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.code_field
import isc_common.fields.description_field
import isc_common.fields.name_field
import isc_common.fields.related


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('isc_common', '0133_auto_20210916_1226'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Widgets_trees',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('id_widget', isc_common.fields.code_field.CodeField(blank=True, null=True, unique=True)),
                ('name', isc_common.fields.name_field.NameField(blank=True, null=True)),
                ('class_name', isc_common.fields.name_field.NameField(blank=True, null=True)),
                ('description', isc_common.fields.description_field.DescriptionField()),
                ('structure', isc_common.fields.code_field.JSONFieldIVC(default=dict)),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='permission.widgets_trees')),
            ],
            options={
                'verbose_name': 'Таблица сохранения деревьев виджетов объектов системы',
            },
        ),
        migrations.CreateModel(
            name='Usergroup_permission',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('permission', isc_common.fields.code_field.JSONFieldIVC(default=dict)),
                ('usergroup', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='isc_common.usergroup')),
                ('widget', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='permission.widgets_trees')),
            ],
            options={
                'verbose_name': 'Доступы для групп',
                'unique_together': {('usergroup', 'widget')},
            },
        ),
        migrations.CreateModel(
            name='User_permission',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('permission', isc_common.fields.code_field.JSONFieldIVC(default=dict)),
                ('user', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('widget', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='permission.widgets_trees')),
            ],
            options={
                'verbose_name': 'Доступы для пользователей',
                'unique_together': {('user', 'widget')},
            },
        ),
    ]
