"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTag = exports.toJson_CfnTagProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnTagProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnTagProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
        'Repository': obj.repository,
        'Tag': obj.tag,
        'Sha': obj.sha,
        'Force': obj.force,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnTagProps = toJson_CfnTagProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `GitHub::Git::Tag`
 *
 * @cloudformationResource GitHub::Git::Tag
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnTag extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Git::Tag`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTag.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnTagProps(props) });
        this.props = props;
    }
}
exports.CfnTag = CfnTag;
_a = JSII_RTTI_SYMBOL_1;
CfnTag[_a] = { fqn: "@cdk-cloudformation/github-git-tag.CfnTag", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnTag.CFN_RESOURCE_TYPE_NAME = "GitHub::Git::Tag";
//# sourceMappingURL=data:application/json;base64,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