# MongoDB Wrapper Class
###### Prereqs
Use this well and keep up to date

```bash
$ pip3 install pymongo
$ pip3 install dnspython
```
###### General
- Used to do heavy lifting for mongo operations
- Utilizes 'pymongo' library
    - pymongo does not automatically return lists for find functions: need to unwrap
    - makes finding/updating/deleting by id easy
    - 3 types of ID schemes
        - user defined -> Collection
        - Auto increment -> AutoIncrementCollection
        - ObjectId -> ObjectIdCollection
- Make sure you copy this directory in the described structure below to your python workspace
    - mongo/Collection.py
    - mongo/MongoDB.py
- This class uses auto-increment to generate the id

###### Initialization
Using URL
```python
from mongo.MongoDB import *
DATABASE ="UnitTestDB"
COLLECTIONS = {"TestCollection1": AUTO_INCREMENT, "TestCollection2": DEFAULT}
URL= "ENTER MONGODB URL HERE"
mongo = MongoDB(
    database=DATABASE, # the database name you want to use 
    collections=COLLECTIONS,  # collections you want to store in the db
    url=URL # mongodb or localhost url
    )
tc1 = mongo.collection["TestCollection1"]
tc2 = mongo.collection["TestCollection2"]
```
Using Host and Port
```python
from mongo.MongoDB import *
DATABASE = "UnitTestDB"
COLLECTIONS = {"TestCollection1": AUTO_INCREMENT, "TestCollection2": DEFAULT}
HOST = "localhost"
PORT = 27017

# b). set up mongodb connection by defining host and port
mongo = MongoDB(
    database=DATABASE, # the database name you want to use  
    collections=COLLECTIONS, # collections you want to store in the db
    host=HOST, # server host
    port=PORT # server port
    )

# define your collections
tc1 = mongo.collection["TestCollection1"]
tc2 = mongo.collection["TestCollection2"]
# you are all set with the initialization step
```

###### Functionality

- [Collection.py](Collection.py)
    - User must provide their own id for add()
    - they can also use add_by_id()
- [AutoIncrementCollection](AutoIncrementCollection.py)
    - Id is autogenerated with auto-incrementing numbers starting from 1
- [ObjectIdCollection](ObjectIdCollection.py)
    - Id is autogenerated with type ObjectId
    - need to unwrap _id to convert to dictionary
     
