#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['gidappdata',
 'gidappdata.cli',
 'gidappdata.data',
 'gidappdata.standard_appdata',
 'gidappdata.utility']

package_data = \
{'': ['*'],
 'gidappdata.data': ['serialized_skeletons/*',
                     'skeletons/*',
                     'skeletons/prebuilt_experimental/*',
                     'skeletons/prebuilt_special/*',
                     'skeletons/prebuilt_standard/*',
                     'skeletons/prebuilt_standard/basic/*',
                     'skeletons/prebuilt_standard/basic/data_pack/*',
                     'skeletons/prebuilt_standard/basic/data_pack/archive/*',
                     'skeletons/prebuilt_standard/basic/data_pack/config/*',
                     'skeletons/prebuilt_standard/basic/data_pack/database/*',
                     'skeletons/prebuilt_standard/basic/data_pack/fixed_data/*',
                     'skeletons/prebuilt_standard/basic/data_pack/fixed_data/sql_procedures/*',
                     'skeletons/prebuilt_standard/basic/data_pack/fixed_data/templates/*',
                     'skeletons/prebuilt_standard/basic/data_pack/image_files/*',
                     'skeletons/prebuilt_standard/basic/data_pack/image_files/icons/*',
                     'skeletons/prebuilt_standard/basic/data_pack/misc/*',
                     'skeletons/prebuilt_standard/basic/data_pack/plugins/*',
                     'skeletons/prebuilt_standard/basic/data_pack/save_data/*',
                     'skeletons/prebuilt_standard/basic/data_pack/temp/*']}

install_requires = \
['click>=7.1.2',
 'appdirs>=1.4.4',
 'gidconfig>=0.1.11',
 'gidlogger>=0.1.7',
 'python-dotenv>=0.15.0',
 'checksumdir']

entry_points = \
{'console_scripts': ['appdata_binit = '
                     'gidappdata.cli.pack_and_bin_and_py_data:cli_generate_user_data_binfile',
                     'appdata_provide = '
                     'gidappdata.cli.create_datapack_skeleton:cli']}

setup(name='gidappdata',
      version='0.1.9',
      description="GidAppData provides an Userdata deployment, with appdirs as backendend, but easy access to files saved there. Also provides an option to 'fake' deploy it while still developing",
      author='Giddius',
      author_email=None,
      url='https://github.com/Giddius/GidAppData',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      entry_points=entry_points,
     )
