# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from swaggerpetstore.api_helper import APIHelper


class Order(object):

    """Implementation of the 'Order' model.

    TODO: type model description here.

    Attributes:
        id (long|int): TODO: type description here.
        pet_id (long|int): TODO: type description here.
        quantity (int): TODO: type description here.
        ship_date (datetime): TODO: type description here.
        status (Status1Enum): Order Status
        complete (bool): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "pet_id": 'petId',
        "quantity": 'quantity',
        "ship_date": 'shipDate',
        "status": 'status',
        "complete": 'complete'
    }

    def __init__(self,
                 id=None,
                 pet_id=None,
                 quantity=None,
                 ship_date=None,
                 status=None,
                 complete=None):
        """Constructor for the Order class"""

        # Initialize members of the class
        self.id = id
        self.pet_id = pet_id
        self.quantity = quantity
        self.ship_date = APIHelper.RFC3339DateTime(ship_date) if ship_date else None
        self.status = status
        self.complete = complete

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get('id')
        pet_id = dictionary.get('petId')
        quantity = dictionary.get('quantity')
        ship_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("shipDate")).datetime if dictionary.get("shipDate") else None
        status = dictionary.get('status')
        complete = dictionary.get('complete')

        # Return an object of this model
        return cls(id,
                   pet_id,
                   quantity,
                   ship_date,
                   status,
                   complete)
