# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from swaggerpetstore.api_helper import APIHelper
from swaggerpetstore.configuration import Server
from swaggerpetstore.utilities.file_wrapper import FileWrapper
from swaggerpetstore.controllers.base_controller import BaseController
from swaggerpetstore.http.auth.o_auth_2 import OAuth2
from swaggerpetstore.models.api_response import ApiResponse
from swaggerpetstore.models.pet import Pet
from swaggerpetstore.exceptions.api_exception import APIException


class PetController(BaseController):

    """A Controller to access Endpoints in the swaggerpetstore API."""

    def __init__(self, config, call_back=None):
        super(PetController, self).__init__(config, call_back)

    def upload_file(self,
                    pet_id,
                    additional_metadata=None,
                    file=None):
        """Does a POST request to /pet/{petId}/uploadImage.

        uploads an image

        Args:
            pet_id (long|int): ID of pet to update
            additional_metadata (string, optional): Additional data to pass to
                server
            file (typing.BinaryIO, optional): file to upload

        Returns:
            ApiResponse: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/{petId}/uploadImage'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'petId': {'value': pet_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        if isinstance(file, FileWrapper):
            file_wrapper = file.file_stream
            file_content_type = file.content_type
        else:
            file_wrapper = file
            file_content_type = 'application/octet-stream'

        # Prepare files
        _files = {
            'file': (file_wrapper.name, file_wrapper, file_content_type)
        }

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare form parameters
        _form_parameters = {
            'additionalMetadata': additional_metadata
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=_form_parameters, files=_files)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, ApiResponse.from_dictionary)

        return decoded

    def add_pet(self,
                body):
        """Does a POST request to /pet.

        Add a new pet to the store

        Args:
            body (Pet): Pet object that needs to be added to the store

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 405:
            raise APIException('Invalid input', _response)
        self.validate_response(_response)

    def update_pet(self,
                   body):
        """Does a PUT request to /pet.

        Update an existing pet

        Args:
            body (Pet): Pet object that needs to be added to the store

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid ID supplied', _response)
        elif _response.status_code == 404:
            raise APIException('Pet not found', _response)
        elif _response.status_code == 405:
            raise APIException('Validation exception', _response)
        self.validate_response(_response)

    def find_pets_by_status(self,
                            status):
        """Does a GET request to /pet/findByStatus.

        Multiple status values can be provided with comma separated strings

        Args:
            status (list of Status2Enum): Status values that need to be
                considered for filter

        Returns:
            list of Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/findByStatus'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'status': status
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid status value', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Pet.from_dictionary)

        return decoded

    def find_pets_by_tags(self,
                          tags):
        """Does a GET request to /pet/findByTags.

        Multiple tags can be provided with comma separated strings. Use tag1,
        tag2, tag3 for testing.

        Args:
            tags (list of string): Tags to filter by

        Returns:
            list of Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/findByTags'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'tags': tags
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid tag value', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Pet.from_dictionary)

        return decoded

    def get_pet_by_id(self,
                      pet_id):
        """Does a GET request to /pet/{petId}.

        Returns a single pet

        Args:
            pet_id (long|int): ID of pet to return

        Returns:
            Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/{petId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'petId': {'value': pet_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid ID supplied', _response)
        elif _response.status_code == 404:
            raise APIException('Pet not found', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Pet.from_dictionary)

        return decoded

    def update_pet_with_form(self,
                             pet_id,
                             name=None,
                             status=None):
        """Does a POST request to /pet/{petId}.

        Updates a pet in the store with form data

        Args:
            pet_id (long|int): ID of pet that needs to be updated
            name (string, optional): Updated name of the pet
            status (string, optional): Updated status of the pet

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/{petId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'petId': {'value': pet_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare form parameters
        _form_parameters = {
            'name': name,
            'status': status
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, parameters=_form_parameters)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 405:
            raise APIException('Invalid input', _response)
        self.validate_response(_response)

    def delete_pet(self,
                   pet_id,
                   api_key=None):
        """Does a DELETE request to /pet/{petId}.

        Deletes a pet

        Args:
            pet_id (long|int): Pet id to delete
            api_key (string, optional): TODO: type description here.

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/pet/{petId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'petId': {'value': pet_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'api_key': api_key
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.check_auth(self.config)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid ID supplied', _response)
        elif _response.status_code == 404:
            raise APIException('Pet not found', _response)
        self.validate_response(_response)
