# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetAviatrixVpcTrackerResult',
    'AwaitableGetAviatrixVpcTrackerResult',
    'get_aviatrix_vpc_tracker',
    'get_aviatrix_vpc_tracker_output',
]

@pulumi.output_type
class GetAviatrixVpcTrackerResult:
    """
    A collection of values returned by getAviatrixVpcTracker.
    """
    def __init__(__self__, account_name=None, cidr=None, cloud_type=None, id=None, region=None, vpc_lists=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if cloud_type and not isinstance(cloud_type, int):
            raise TypeError("Expected argument 'cloud_type' to be a int")
        pulumi.set(__self__, "cloud_type", cloud_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc_lists and not isinstance(vpc_lists, list):
            raise TypeError("Expected argument 'vpc_lists' to be a list")
        pulumi.set(__self__, "vpc_lists", vpc_lists)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Aviatrix access account associated with the VPC.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        """
        Subnet CIDR.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[int]:
        """
        Cloud provider id hosting this VPC.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Subnet region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcLists")
    def vpc_lists(self) -> Sequence['outputs.GetAviatrixVpcTrackerVpcListResult']:
        """
        List of VPCs from the VPC tracker.
        """
        return pulumi.get(self, "vpc_lists")


class AwaitableGetAviatrixVpcTrackerResult(GetAviatrixVpcTrackerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAviatrixVpcTrackerResult(
            account_name=self.account_name,
            cidr=self.cidr,
            cloud_type=self.cloud_type,
            id=self.id,
            region=self.region,
            vpc_lists=self.vpc_lists)


def get_aviatrix_vpc_tracker(account_name: Optional[str] = None,
                             cidr: Optional[str] = None,
                             cloud_type: Optional[int] = None,
                             region: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAviatrixVpcTrackerResult:
    """
    Use this data source to get the list of VPC's for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aviatrix as aviatrix

    foo = aviatrix.get_aviatrix_vpc_tracker(account_name="bar",
        cidr="10.0.0.1/24",
        cloud_type=1,
        region="us-west-1")
    ```
    ## Notes

    * Please be aware this data source could take up to 20 minutes to refresh depending on the number of VPCs and cloud accounts.


    :param str account_name: Filters VPC list by access account name.
    :param str cidr: Filters VPC list by CIDR (AWS/Azure only).
    :param int cloud_type: Filters VPC list by cloud provider id. For example, cloud_type = 1 will give all AWS VPCs.
    :param str region: Filters VPC list by region (AWS/Azure only).
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['cidr'] = cidr
    __args__['cloudType'] = cloud_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aviatrix:index/getAviatrixVpcTracker:getAviatrixVpcTracker', __args__, opts=opts, typ=GetAviatrixVpcTrackerResult).value

    return AwaitableGetAviatrixVpcTrackerResult(
        account_name=__ret__.account_name,
        cidr=__ret__.cidr,
        cloud_type=__ret__.cloud_type,
        id=__ret__.id,
        region=__ret__.region,
        vpc_lists=__ret__.vpc_lists)


@_utilities.lift_output_func(get_aviatrix_vpc_tracker)
def get_aviatrix_vpc_tracker_output(account_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    cidr: Optional[pulumi.Input[Optional[str]]] = None,
                                    cloud_type: Optional[pulumi.Input[Optional[int]]] = None,
                                    region: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAviatrixVpcTrackerResult]:
    """
    Use this data source to get the list of VPC's for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aviatrix as aviatrix

    foo = aviatrix.get_aviatrix_vpc_tracker(account_name="bar",
        cidr="10.0.0.1/24",
        cloud_type=1,
        region="us-west-1")
    ```
    ## Notes

    * Please be aware this data source could take up to 20 minutes to refresh depending on the number of VPCs and cloud accounts.


    :param str account_name: Filters VPC list by access account name.
    :param str cidr: Filters VPC list by CIDR (AWS/Azure only).
    :param int cloud_type: Filters VPC list by cloud provider id. For example, cloud_type = 1 will give all AWS VPCs.
    :param str region: Filters VPC list by region (AWS/Azure only).
    """
    ...
