# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetAviatrixFirewallResult',
    'AwaitableGetAviatrixFirewallResult',
    'get_aviatrix_firewall',
    'get_aviatrix_firewall_output',
]

@pulumi.output_type
class GetAviatrixFirewallResult:
    """
    A collection of values returned by getAviatrixFirewall.
    """
    def __init__(__self__, base_log_enabled=None, base_policy=None, gw_name=None, id=None, policies=None):
        if base_log_enabled and not isinstance(base_log_enabled, bool):
            raise TypeError("Expected argument 'base_log_enabled' to be a bool")
        pulumi.set(__self__, "base_log_enabled", base_log_enabled)
        if base_policy and not isinstance(base_policy, str):
            raise TypeError("Expected argument 'base_policy' to be a str")
        pulumi.set(__self__, "base_policy", base_policy)
        if gw_name and not isinstance(gw_name, str):
            raise TypeError("Expected argument 'gw_name' to be a str")
        pulumi.set(__self__, "gw_name", gw_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="baseLogEnabled")
    def base_log_enabled(self) -> bool:
        """
        Indicates whether logging is enabled or not.
        """
        return pulumi.get(self, "base_log_enabled")

    @property
    @pulumi.getter(name="basePolicy")
    def base_policy(self) -> str:
        """
        The firewall's base policy.
        """
        return pulumi.get(self, "base_policy")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> str:
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAviatrixFirewallPolicyResult']:
        """
        List of policies associated with the firewall.
        """
        return pulumi.get(self, "policies")


class AwaitableGetAviatrixFirewallResult(GetAviatrixFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAviatrixFirewallResult(
            base_log_enabled=self.base_log_enabled,
            base_policy=self.base_policy,
            gw_name=self.gw_name,
            id=self.id,
            policies=self.policies)


def get_aviatrix_firewall(gw_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAviatrixFirewallResult:
    """
    Use this data source to get the Aviatrix stateful firewall for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aviatrix as aviatrix

    foo = aviatrix.get_aviatrix_firewall(gw_name="gw-abcd")
    ```


    :param str gw_name: Name of the gateway associated with the firewall.
    """
    __args__ = dict()
    __args__['gwName'] = gw_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aviatrix:index/getAviatrixFirewall:getAviatrixFirewall', __args__, opts=opts, typ=GetAviatrixFirewallResult).value

    return AwaitableGetAviatrixFirewallResult(
        base_log_enabled=__ret__.base_log_enabled,
        base_policy=__ret__.base_policy,
        gw_name=__ret__.gw_name,
        id=__ret__.id,
        policies=__ret__.policies)


@_utilities.lift_output_func(get_aviatrix_firewall)
def get_aviatrix_firewall_output(gw_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAviatrixFirewallResult]:
    """
    Use this data source to get the Aviatrix stateful firewall for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aviatrix as aviatrix

    foo = aviatrix.get_aviatrix_firewall(gw_name="gw-abcd")
    ```


    :param str gw_name: Name of the gateway associated with the firewall.
    """
    ...
