# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixVpnProfileArgs', 'AviatrixVpnProfile']

@pulumi.input_type
class AviatrixVpnProfileArgs:
    def __init__(__self__, *,
                 base_rule: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixVpnProfile resource.
        :param pulumi.Input[str] base_rule: Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        :param pulumi.Input[bool] manage_user_attachment: This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] name: Enter any name for the VPN profile.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]] policies: New security policy for the profile. Each policy has the following attributes:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        if base_rule is not None:
            pulumi.set(__self__, "base_rule", base_rule)
        if manage_user_attachment is not None:
            pulumi.set(__self__, "manage_user_attachment", manage_user_attachment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="baseRule")
    def base_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        """
        return pulumi.get(self, "base_rule")

    @base_rule.setter
    def base_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_rule", value)

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_user_attachment")

    @manage_user_attachment.setter
    def manage_user_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_user_attachment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enter any name for the VPN profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]]:
        """
        New security policy for the profile. Each policy has the following attributes:
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _AviatrixVpnProfileState:
    def __init__(__self__, *,
                 base_rule: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AviatrixVpnProfile resources.
        :param pulumi.Input[str] base_rule: Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        :param pulumi.Input[bool] manage_user_attachment: This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] name: Enter any name for the VPN profile.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]] policies: New security policy for the profile. Each policy has the following attributes:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        if base_rule is not None:
            pulumi.set(__self__, "base_rule", base_rule)
        if manage_user_attachment is not None:
            pulumi.set(__self__, "manage_user_attachment", manage_user_attachment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="baseRule")
    def base_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        """
        return pulumi.get(self, "base_rule")

    @base_rule.setter
    def base_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_rule", value)

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_user_attachment")

    @manage_user_attachment.setter
    def manage_user_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_user_attachment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enter any name for the VPN profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]]:
        """
        New security policy for the profile. Each policy has the following attributes:
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpnProfilePolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


class AviatrixVpnProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_rule: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpnProfilePolicyArgs']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The **aviatrix_vpn_profile** resource allows the creation and management of Aviatrix VPN user profiles.

        > **NOTE:** As of R2.15, management of user/profile attachment can be set using `manage_user_attachment`. This argument must be set to *true* in either **aviatrix_vpn_user** or **aviatrix_vpn_profile**. If attachment is managed in the **aviatrix_vpn_profile** (set to *true*), it must be set to *false* in the **aviatrix_vpn_user** resource and vice versa.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS VPN User Profile
        test_vpn_profile = aviatrix.AviatrixVpnProfile("testVpnProfile",
            base_rule="allow_all",
            policies=[
                aviatrix.AviatrixVpnProfilePolicyArgs(
                    action="deny",
                    port="443",
                    proto="tcp",
                    target="10.0.0.0/32",
                ),
                aviatrix.AviatrixVpnProfilePolicyArgs(
                    action="deny",
                    port="443",
                    proto="tcp",
                    target="10.0.0.1/32",
                ),
            ],
            users=[
                "user1",
                "user2",
            ])
        ```

        ## Import

        **vpn_profile** can be imported using the VPN profile's `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixVpnProfile:AviatrixVpnProfile test name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_rule: Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        :param pulumi.Input[bool] manage_user_attachment: This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] name: Enter any name for the VPN profile.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpnProfilePolicyArgs']]]] policies: New security policy for the profile. Each policy has the following attributes:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AviatrixVpnProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_vpn_profile** resource allows the creation and management of Aviatrix VPN user profiles.

        > **NOTE:** As of R2.15, management of user/profile attachment can be set using `manage_user_attachment`. This argument must be set to *true* in either **aviatrix_vpn_user** or **aviatrix_vpn_profile**. If attachment is managed in the **aviatrix_vpn_profile** (set to *true*), it must be set to *false* in the **aviatrix_vpn_user** resource and vice versa.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS VPN User Profile
        test_vpn_profile = aviatrix.AviatrixVpnProfile("testVpnProfile",
            base_rule="allow_all",
            policies=[
                aviatrix.AviatrixVpnProfilePolicyArgs(
                    action="deny",
                    port="443",
                    proto="tcp",
                    target="10.0.0.0/32",
                ),
                aviatrix.AviatrixVpnProfilePolicyArgs(
                    action="deny",
                    port="443",
                    proto="tcp",
                    target="10.0.0.1/32",
                ),
            ],
            users=[
                "user1",
                "user2",
            ])
        ```

        ## Import

        **vpn_profile** can be imported using the VPN profile's `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixVpnProfile:AviatrixVpnProfile test name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixVpnProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixVpnProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_rule: Optional[pulumi.Input[str]] = None,
                 manage_user_attachment: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpnProfilePolicyArgs']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixVpnProfileArgs.__new__(AviatrixVpnProfileArgs)

            __props__.__dict__["base_rule"] = base_rule
            __props__.__dict__["manage_user_attachment"] = manage_user_attachment
            __props__.__dict__["name"] = name
            __props__.__dict__["policies"] = policies
            __props__.__dict__["users"] = users
        super(AviatrixVpnProfile, __self__).__init__(
            'aviatrix:index/aviatrixVpnProfile:AviatrixVpnProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_rule: Optional[pulumi.Input[str]] = None,
            manage_user_attachment: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpnProfilePolicyArgs']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AviatrixVpnProfile':
        """
        Get an existing AviatrixVpnProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_rule: Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        :param pulumi.Input[bool] manage_user_attachment: This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] name: Enter any name for the VPN profile.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpnProfilePolicyArgs']]]] policies: New security policy for the profile. Each policy has the following attributes:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixVpnProfileState.__new__(_AviatrixVpnProfileState)

        __props__.__dict__["base_rule"] = base_rule
        __props__.__dict__["manage_user_attachment"] = manage_user_attachment
        __props__.__dict__["name"] = name
        __props__.__dict__["policies"] = policies
        __props__.__dict__["users"] = users
        return AviatrixVpnProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseRule")
    def base_rule(self) -> pulumi.Output[Optional[str]]:
        """
        Base policy rule of the profile to be added. Enter "allow_all" or "deny_all", based on whether you want a whitelist or blacklist.
        """
        return pulumi.get(self, "base_rule")

    @property
    @pulumi.getter(name="manageUserAttachment")
    def manage_user_attachment(self) -> pulumi.Output[Optional[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPN user attachments to the VPN profile using this resource. If this is set to false, attachment must be managed using the **aviatrix_vpn_user** resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_user_attachment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Enter any name for the VPN profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixVpnProfilePolicy']]]:
        """
        New security policy for the profile. Each policy has the following attributes:
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of VPN users to attach to this profile. This should be set to null if `manage_user_attachment` is set to false.
        """
        return pulumi.get(self, "users")

