# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSegmentationSecurityDomainAssociationArgs', 'AviatrixSegmentationSecurityDomainAssociation']

@pulumi.input_type
class AviatrixSegmentationSecurityDomainAssociationArgs:
    def __init__(__self__, *,
                 attachment_name: pulumi.Input[str],
                 security_domain_name: pulumi.Input[str],
                 transit_gateway_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixSegmentationSecurityDomainAssociation resource.
        :param pulumi.Input[str] attachment_name: Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        :param pulumi.Input[str] security_domain_name: Name of the Segmentation Security Domain.
        :param pulumi.Input[str] transit_gateway_name: Name of the Transit Gateway.
        """
        pulumi.set(__self__, "attachment_name", attachment_name)
        pulumi.set(__self__, "security_domain_name", security_domain_name)
        pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)

    @property
    @pulumi.getter(name="attachmentName")
    def attachment_name(self) -> pulumi.Input[str]:
        """
        Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        """
        return pulumi.get(self, "attachment_name")

    @attachment_name.setter
    def attachment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "attachment_name", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> pulumi.Input[str]:
        """
        Name of the Segmentation Security Domain.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name", value)


@pulumi.input_type
class _AviatrixSegmentationSecurityDomainAssociationState:
    def __init__(__self__, *,
                 attachment_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSegmentationSecurityDomainAssociation resources.
        :param pulumi.Input[str] attachment_name: Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        :param pulumi.Input[str] security_domain_name: Name of the Segmentation Security Domain.
        :param pulumi.Input[str] transit_gateway_name: Name of the Transit Gateway.
        """
        if attachment_name is not None:
            pulumi.set(__self__, "attachment_name", attachment_name)
        if security_domain_name is not None:
            pulumi.set(__self__, "security_domain_name", security_domain_name)
        if transit_gateway_name is not None:
            pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)

    @property
    @pulumi.getter(name="attachmentName")
    def attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        """
        return pulumi.get(self, "attachment_name")

    @attachment_name.setter
    def attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_name", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Segmentation Security Domain.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name", value)


class AviatrixSegmentationSecurityDomainAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_segmentation_security_domain_association** resource handles creation of [Transit Segmentation](https://docs.aviatrix.com/HowTos/transit_segmentation_faq.html) Security Domain and Transit Gateway Attachment Associations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Segmentation Security Domain Association
        test_segmentation_security_domain_association = aviatrix.AviatrixSegmentationSecurityDomainAssociation("testSegmentationSecurityDomainAssociation",
            attachment_name="attachment-name",
            security_domain_name="security-domain-name",
            transit_gateway_name="transit-gw-name")
        ```

        ## Import

        **aviatrix_segmentation_security_domain_association** can be imported using `transit_gateway_name`, `security_domain_name` and `attachment_name` separated by a `~` e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSegmentationSecurityDomainAssociation:AviatrixSegmentationSecurityDomainAssociation test transit_gateway_name~security_domain_name~attachment_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attachment_name: Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        :param pulumi.Input[str] security_domain_name: Name of the Segmentation Security Domain.
        :param pulumi.Input[str] transit_gateway_name: Name of the Transit Gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSegmentationSecurityDomainAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_segmentation_security_domain_association** resource handles creation of [Transit Segmentation](https://docs.aviatrix.com/HowTos/transit_segmentation_faq.html) Security Domain and Transit Gateway Attachment Associations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Segmentation Security Domain Association
        test_segmentation_security_domain_association = aviatrix.AviatrixSegmentationSecurityDomainAssociation("testSegmentationSecurityDomainAssociation",
            attachment_name="attachment-name",
            security_domain_name="security-domain-name",
            transit_gateway_name="transit-gw-name")
        ```

        ## Import

        **aviatrix_segmentation_security_domain_association** can be imported using `transit_gateway_name`, `security_domain_name` and `attachment_name` separated by a `~` e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSegmentationSecurityDomainAssociation:AviatrixSegmentationSecurityDomainAssociation test transit_gateway_name~security_domain_name~attachment_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixSegmentationSecurityDomainAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSegmentationSecurityDomainAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSegmentationSecurityDomainAssociationArgs.__new__(AviatrixSegmentationSecurityDomainAssociationArgs)

            if attachment_name is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_name'")
            __props__.__dict__["attachment_name"] = attachment_name
            if security_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'security_domain_name'")
            __props__.__dict__["security_domain_name"] = security_domain_name
            if transit_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name'")
            __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        super(AviatrixSegmentationSecurityDomainAssociation, __self__).__init__(
            'aviatrix:index/aviatrixSegmentationSecurityDomainAssociation:AviatrixSegmentationSecurityDomainAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_name: Optional[pulumi.Input[str]] = None,
            security_domain_name: Optional[pulumi.Input[str]] = None,
            transit_gateway_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixSegmentationSecurityDomainAssociation':
        """
        Get an existing AviatrixSegmentationSecurityDomainAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attachment_name: Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        :param pulumi.Input[str] security_domain_name: Name of the Segmentation Security Domain.
        :param pulumi.Input[str] transit_gateway_name: Name of the Transit Gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSegmentationSecurityDomainAssociationState.__new__(_AviatrixSegmentationSecurityDomainAssociationState)

        __props__.__dict__["attachment_name"] = attachment_name
        __props__.__dict__["security_domain_name"] = security_domain_name
        __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        return AviatrixSegmentationSecurityDomainAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentName")
    def attachment_name(self) -> pulumi.Output[str]:
        """
        Name of the transit gateway attachment, Spoke or Edge, to associate with the security domain.
        """
        return pulumi.get(self, "attachment_name")

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> pulumi.Output[str]:
        """
        Name of the Segmentation Security Domain.
        """
        return pulumi.get(self, "security_domain_name")

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_name")

