# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixPrivateModeMulticloudEndpointArgs', 'AviatrixPrivateModeMulticloudEndpoint']

@pulumi.input_type
class AviatrixPrivateModeMulticloudEndpointArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 controller_lb_vpc_id: pulumi.Input[str],
                 region: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixPrivateModeMulticloudEndpoint resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] controller_lb_vpc_id: ID of the VPC containing a Private Mode controller load balancer.
        :param pulumi.Input[str] region: Region of the VPC.
        :param pulumi.Input[str] vpc_id: ID of the VPC to create the endpoint in.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "controller_lb_vpc_id", controller_lb_vpc_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="controllerLbVpcId")
    def controller_lb_vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC containing a Private Mode controller load balancer.
        """
        return pulumi.get(self, "controller_lb_vpc_id")

    @controller_lb_vpc_id.setter
    def controller_lb_vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "controller_lb_vpc_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region of the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC to create the endpoint in.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _AviatrixPrivateModeMulticloudEndpointState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 controller_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 dns_entry: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixPrivateModeMulticloudEndpoint resources.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] controller_lb_vpc_id: ID of the VPC containing a Private Mode controller load balancer.
        :param pulumi.Input[str] dns_entry: DNS entry of the endpoint.
        :param pulumi.Input[str] region: Region of the VPC.
        :param pulumi.Input[str] vpc_id: ID of the VPC to create the endpoint in.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if controller_lb_vpc_id is not None:
            pulumi.set(__self__, "controller_lb_vpc_id", controller_lb_vpc_id)
        if dns_entry is not None:
            pulumi.set(__self__, "dns_entry", dns_entry)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="controllerLbVpcId")
    def controller_lb_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC containing a Private Mode controller load balancer.
        """
        return pulumi.get(self, "controller_lb_vpc_id")

    @controller_lb_vpc_id.setter
    def controller_lb_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_lb_vpc_id", value)

    @property
    @pulumi.getter(name="dnsEntry")
    def dns_entry(self) -> Optional[pulumi.Input[str]]:
        """
        DNS entry of the endpoint.
        """
        return pulumi.get(self, "dns_entry")

    @dns_entry.setter
    def dns_entry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_entry", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC to create the endpoint in.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixPrivateModeMulticloudEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 controller_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_private_mode_multicloud_endpoint** resource allows management of a Private Mode multicloud endpoint. This resource is available as of provider version R2.23+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Private Mode config
        test = aviatrix.AviatrixPrivateModeMulticloudEndpoint("test",
            account_name="devops",
            controller_lb_vpc_id="vpc-abcdefg",
            region="us-east-1",
            vpc_id="vpc-abcdef")
        ```

        ## Import

        **aviatrix_private_mode_multicloud_endpoint** can be imported using the `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPrivateModeMulticloudEndpoint:AviatrixPrivateModeMulticloudEndpoint test vpc-1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] controller_lb_vpc_id: ID of the VPC containing a Private Mode controller load balancer.
        :param pulumi.Input[str] region: Region of the VPC.
        :param pulumi.Input[str] vpc_id: ID of the VPC to create the endpoint in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixPrivateModeMulticloudEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_private_mode_multicloud_endpoint** resource allows management of a Private Mode multicloud endpoint. This resource is available as of provider version R2.23+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Private Mode config
        test = aviatrix.AviatrixPrivateModeMulticloudEndpoint("test",
            account_name="devops",
            controller_lb_vpc_id="vpc-abcdefg",
            region="us-east-1",
            vpc_id="vpc-abcdef")
        ```

        ## Import

        **aviatrix_private_mode_multicloud_endpoint** can be imported using the `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPrivateModeMulticloudEndpoint:AviatrixPrivateModeMulticloudEndpoint test vpc-1234567
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixPrivateModeMulticloudEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixPrivateModeMulticloudEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 controller_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixPrivateModeMulticloudEndpointArgs.__new__(AviatrixPrivateModeMulticloudEndpointArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if controller_lb_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'controller_lb_vpc_id'")
            __props__.__dict__["controller_lb_vpc_id"] = controller_lb_vpc_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["dns_entry"] = None
        super(AviatrixPrivateModeMulticloudEndpoint, __self__).__init__(
            'aviatrix:index/aviatrixPrivateModeMulticloudEndpoint:AviatrixPrivateModeMulticloudEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            controller_lb_vpc_id: Optional[pulumi.Input[str]] = None,
            dns_entry: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixPrivateModeMulticloudEndpoint':
        """
        Get an existing AviatrixPrivateModeMulticloudEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] controller_lb_vpc_id: ID of the VPC containing a Private Mode controller load balancer.
        :param pulumi.Input[str] dns_entry: DNS entry of the endpoint.
        :param pulumi.Input[str] region: Region of the VPC.
        :param pulumi.Input[str] vpc_id: ID of the VPC to create the endpoint in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixPrivateModeMulticloudEndpointState.__new__(_AviatrixPrivateModeMulticloudEndpointState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["controller_lb_vpc_id"] = controller_lb_vpc_id
        __props__.__dict__["dns_entry"] = dns_entry
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixPrivateModeMulticloudEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="controllerLbVpcId")
    def controller_lb_vpc_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC containing a Private Mode controller load balancer.
        """
        return pulumi.get(self, "controller_lb_vpc_id")

    @property
    @pulumi.getter(name="dnsEntry")
    def dns_entry(self) -> pulumi.Output[str]:
        """
        DNS entry of the endpoint.
        """
        return pulumi.get(self, "dns_entry")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region of the VPC.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC to create the endpoint in.
        """
        return pulumi.get(self, "vpc_id")

