# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixPrivateModeLbArgs', 'AviatrixPrivateModeLb']

@pulumi.input_type
class AviatrixPrivateModeLbArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 lb_type: pulumi.Input[str],
                 region: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 multicloud_access_vpc_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]] = None):
        """
        The set of arguments for constructing a AviatrixPrivateModeLb resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] lb_type: Type of load balancer to create. Must be one of controller or multicloud.
        :param pulumi.Input[str] region: Name of the region containing the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the proxy.
        :param pulumi.Input[str] multicloud_access_vpc_id: ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]] proxies: List of multicloud proxies. Only valid when `lb_type` is multicloud.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "lb_type", lb_type)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if multicloud_access_vpc_id is not None:
            pulumi.set(__self__, "multicloud_access_vpc_id", multicloud_access_vpc_id)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="lbType")
    def lb_type(self) -> pulumi.Input[str]:
        """
        Type of load balancer to create. Must be one of controller or multicloud.
        """
        return pulumi.get(self, "lb_type")

    @lb_type.setter
    def lb_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "lb_type", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Name of the region containing the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the proxy.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="multicloudAccessVpcId")
    def multicloud_access_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        """
        return pulumi.get(self, "multicloud_access_vpc_id")

    @multicloud_access_vpc_id.setter
    def multicloud_access_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multicloud_access_vpc_id", value)

    @property
    @pulumi.getter
    def proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]]:
        """
        List of multicloud proxies. Only valid when `lb_type` is multicloud.
        """
        return pulumi.get(self, "proxies")

    @proxies.setter
    def proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]]):
        pulumi.set(self, "proxies", value)


@pulumi.input_type
class _AviatrixPrivateModeLbState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 lb_type: Optional[pulumi.Input[str]] = None,
                 multicloud_access_vpc_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixPrivateModeLb resources.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] lb_type: Type of load balancer to create. Must be one of controller or multicloud.
        :param pulumi.Input[str] multicloud_access_vpc_id: ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]] proxies: List of multicloud proxies. Only valid when `lb_type` is multicloud.
        :param pulumi.Input[str] region: Name of the region containing the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the proxy.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if lb_type is not None:
            pulumi.set(__self__, "lb_type", lb_type)
        if multicloud_access_vpc_id is not None:
            pulumi.set(__self__, "multicloud_access_vpc_id", multicloud_access_vpc_id)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="lbType")
    def lb_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of load balancer to create. Must be one of controller or multicloud.
        """
        return pulumi.get(self, "lb_type")

    @lb_type.setter
    def lb_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_type", value)

    @property
    @pulumi.getter(name="multicloudAccessVpcId")
    def multicloud_access_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        """
        return pulumi.get(self, "multicloud_access_vpc_id")

    @multicloud_access_vpc_id.setter
    def multicloud_access_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multicloud_access_vpc_id", value)

    @property
    @pulumi.getter
    def proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]]:
        """
        List of multicloud proxies. Only valid when `lb_type` is multicloud.
        """
        return pulumi.get(self, "proxies")

    @proxies.setter
    def proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixPrivateModeLbProxyArgs']]]]):
        pulumi.set(self, "proxies", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the region containing the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID of the proxy.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixPrivateModeLb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 lb_type: Optional[pulumi.Input[str]] = None,
                 multicloud_access_vpc_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixPrivateModeLbProxyArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_private_mode_lb** resource allows management of a Private Mode load balancer. This resource is available as of provider version R2.23+.

        ## Import

        **aviatrix_private_mode_lb** can be imported using the `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPrivateModeLb:AviatrixPrivateModeLb test vpc-1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] lb_type: Type of load balancer to create. Must be one of controller or multicloud.
        :param pulumi.Input[str] multicloud_access_vpc_id: ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixPrivateModeLbProxyArgs']]]] proxies: List of multicloud proxies. Only valid when `lb_type` is multicloud.
        :param pulumi.Input[str] region: Name of the region containing the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the proxy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixPrivateModeLbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_private_mode_lb** resource allows management of a Private Mode load balancer. This resource is available as of provider version R2.23+.

        ## Import

        **aviatrix_private_mode_lb** can be imported using the `vpc_id`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPrivateModeLb:AviatrixPrivateModeLb test vpc-1234567
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixPrivateModeLbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixPrivateModeLbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 lb_type: Optional[pulumi.Input[str]] = None,
                 multicloud_access_vpc_id: Optional[pulumi.Input[str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixPrivateModeLbProxyArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixPrivateModeLbArgs.__new__(AviatrixPrivateModeLbArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if lb_type is None and not opts.urn:
                raise TypeError("Missing required property 'lb_type'")
            __props__.__dict__["lb_type"] = lb_type
            __props__.__dict__["multicloud_access_vpc_id"] = multicloud_access_vpc_id
            __props__.__dict__["proxies"] = proxies
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixPrivateModeLb, __self__).__init__(
            'aviatrix:index/aviatrixPrivateModeLb:AviatrixPrivateModeLb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            lb_type: Optional[pulumi.Input[str]] = None,
            multicloud_access_vpc_id: Optional[pulumi.Input[str]] = None,
            proxies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixPrivateModeLbProxyArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixPrivateModeLb':
        """
        Get an existing AviatrixPrivateModeLb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of the access account.
        :param pulumi.Input[str] lb_type: Type of load balancer to create. Must be one of controller or multicloud.
        :param pulumi.Input[str] multicloud_access_vpc_id: ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixPrivateModeLbProxyArgs']]]] proxies: List of multicloud proxies. Only valid when `lb_type` is multicloud.
        :param pulumi.Input[str] region: Name of the region containing the VPC.
        :param pulumi.Input[str] vpc_id: VPC ID of the proxy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixPrivateModeLbState.__new__(_AviatrixPrivateModeLbState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["lb_type"] = lb_type
        __props__.__dict__["multicloud_access_vpc_id"] = multicloud_access_vpc_id
        __props__.__dict__["proxies"] = proxies
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixPrivateModeLb(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Name of the access account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="lbType")
    def lb_type(self) -> pulumi.Output[str]:
        """
        Type of load balancer to create. Must be one of controller or multicloud.
        """
        return pulumi.get(self, "lb_type")

    @property
    @pulumi.getter(name="multicloudAccessVpcId")
    def multicloud_access_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the VPC with a multicloud endpoint. Required when `lb_type` is multicloud.
        """
        return pulumi.get(self, "multicloud_access_vpc_id")

    @property
    @pulumi.getter
    def proxies(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixPrivateModeLbProxy']]]:
        """
        List of multicloud proxies. Only valid when `lb_type` is multicloud.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Name of the region containing the VPC.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID of the proxy.
        """
        return pulumi.get(self, "vpc_id")

