# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixGatewaySnatArgs', 'AviatrixGatewaySnat']

@pulumi.input_type
class AviatrixGatewaySnatArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 snat_mode: Optional[pulumi.Input[str]] = None,
                 snat_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]] = None,
                 sync_to_ha: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixGatewaySnat resource.
        :param pulumi.Input[str] gw_name: Name of the Aviatrix gateway the custom SNAT will be configured for.
        :param pulumi.Input[str] snat_mode: NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]] snat_policies: Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        :param pulumi.Input[bool] sync_to_ha: Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        pulumi.set(__self__, "gw_name", gw_name)
        if snat_mode is not None:
            pulumi.set(__self__, "snat_mode", snat_mode)
        if snat_policies is not None:
            pulumi.set(__self__, "snat_policies", snat_policies)
        if sync_to_ha is not None:
            pulumi.set(__self__, "sync_to_ha", sync_to_ha)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the Aviatrix gateway the custom SNAT will be configured for.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="snatMode")
    def snat_mode(self) -> Optional[pulumi.Input[str]]:
        """
        NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        """
        return pulumi.get(self, "snat_mode")

    @snat_mode.setter
    def snat_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_mode", value)

    @property
    @pulumi.getter(name="snatPolicies")
    def snat_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]]:
        """
        Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        """
        return pulumi.get(self, "snat_policies")

    @snat_policies.setter
    def snat_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]]):
        pulumi.set(self, "snat_policies", value)

    @property
    @pulumi.getter(name="syncToHa")
    def sync_to_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "sync_to_ha")

    @sync_to_ha.setter
    def sync_to_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_to_ha", value)


@pulumi.input_type
class _AviatrixGatewaySnatState:
    def __init__(__self__, *,
                 connection_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatConnectionPolicyArgs']]]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 interface_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatInterfacePolicyArgs']]]] = None,
                 snat_mode: Optional[pulumi.Input[str]] = None,
                 snat_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]] = None,
                 sync_to_ha: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AviatrixGatewaySnat resources.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatConnectionPolicyArgs']]] connection_policies: Computed attribute to store the previous connection policy.
        :param pulumi.Input[str] gw_name: Name of the Aviatrix gateway the custom SNAT will be configured for.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatInterfacePolicyArgs']]] interface_policies: Computed attribute to store the previous interface policy.
        :param pulumi.Input[str] snat_mode: NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]] snat_policies: Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        :param pulumi.Input[bool] sync_to_ha: Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        if connection_policies is not None:
            pulumi.set(__self__, "connection_policies", connection_policies)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if interface_policies is not None:
            pulumi.set(__self__, "interface_policies", interface_policies)
        if snat_mode is not None:
            pulumi.set(__self__, "snat_mode", snat_mode)
        if snat_policies is not None:
            pulumi.set(__self__, "snat_policies", snat_policies)
        if sync_to_ha is not None:
            pulumi.set(__self__, "sync_to_ha", sync_to_ha)

    @property
    @pulumi.getter(name="connectionPolicies")
    def connection_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatConnectionPolicyArgs']]]]:
        """
        Computed attribute to store the previous connection policy.
        """
        return pulumi.get(self, "connection_policies")

    @connection_policies.setter
    def connection_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatConnectionPolicyArgs']]]]):
        pulumi.set(self, "connection_policies", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Aviatrix gateway the custom SNAT will be configured for.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="interfacePolicies")
    def interface_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatInterfacePolicyArgs']]]]:
        """
        Computed attribute to store the previous interface policy.
        """
        return pulumi.get(self, "interface_policies")

    @interface_policies.setter
    def interface_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatInterfacePolicyArgs']]]]):
        pulumi.set(self, "interface_policies", value)

    @property
    @pulumi.getter(name="snatMode")
    def snat_mode(self) -> Optional[pulumi.Input[str]]:
        """
        NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        """
        return pulumi.get(self, "snat_mode")

    @snat_mode.setter
    def snat_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_mode", value)

    @property
    @pulumi.getter(name="snatPolicies")
    def snat_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]]:
        """
        Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        """
        return pulumi.get(self, "snat_policies")

    @snat_policies.setter
    def snat_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixGatewaySnatSnatPolicyArgs']]]]):
        pulumi.set(self, "snat_policies", value)

    @property
    @pulumi.getter(name="syncToHa")
    def sync_to_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "sync_to_ha")

    @sync_to_ha.setter
    def sync_to_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_to_ha", value)


class AviatrixGatewaySnat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 snat_mode: Optional[pulumi.Input[str]] = None,
                 snat_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatSnatPolicyArgs']]]]] = None,
                 sync_to_ha: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Import

        **gateway_snat** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixGatewaySnat:AviatrixGatewaySnat test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Name of the Aviatrix gateway the custom SNAT will be configured for.
        :param pulumi.Input[str] snat_mode: NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatSnatPolicyArgs']]]] snat_policies: Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        :param pulumi.Input[bool] sync_to_ha: Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixGatewaySnatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        **gateway_snat** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixGatewaySnat:AviatrixGatewaySnat test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixGatewaySnatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixGatewaySnatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 snat_mode: Optional[pulumi.Input[str]] = None,
                 snat_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatSnatPolicyArgs']]]]] = None,
                 sync_to_ha: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixGatewaySnatArgs.__new__(AviatrixGatewaySnatArgs)

            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["snat_mode"] = snat_mode
            __props__.__dict__["snat_policies"] = snat_policies
            __props__.__dict__["sync_to_ha"] = sync_to_ha
            __props__.__dict__["connection_policies"] = None
            __props__.__dict__["interface_policies"] = None
        super(AviatrixGatewaySnat, __self__).__init__(
            'aviatrix:index/aviatrixGatewaySnat:AviatrixGatewaySnat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatConnectionPolicyArgs']]]]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            interface_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatInterfacePolicyArgs']]]]] = None,
            snat_mode: Optional[pulumi.Input[str]] = None,
            snat_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatSnatPolicyArgs']]]]] = None,
            sync_to_ha: Optional[pulumi.Input[bool]] = None) -> 'AviatrixGatewaySnat':
        """
        Get an existing AviatrixGatewaySnat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatConnectionPolicyArgs']]]] connection_policies: Computed attribute to store the previous connection policy.
        :param pulumi.Input[str] gw_name: Name of the Aviatrix gateway the custom SNAT will be configured for.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatInterfacePolicyArgs']]]] interface_policies: Computed attribute to store the previous interface policy.
        :param pulumi.Input[str] snat_mode: NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixGatewaySnatSnatPolicyArgs']]]] snat_policies: Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        :param pulumi.Input[bool] sync_to_ha: Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixGatewaySnatState.__new__(_AviatrixGatewaySnatState)

        __props__.__dict__["connection_policies"] = connection_policies
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["interface_policies"] = interface_policies
        __props__.__dict__["snat_mode"] = snat_mode
        __props__.__dict__["snat_policies"] = snat_policies
        __props__.__dict__["sync_to_ha"] = sync_to_ha
        return AviatrixGatewaySnat(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionPolicies")
    def connection_policies(self) -> pulumi.Output[Sequence['outputs.AviatrixGatewaySnatConnectionPolicy']]:
        """
        Computed attribute to store the previous connection policy.
        """
        return pulumi.get(self, "connection_policies")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the Aviatrix gateway the custom SNAT will be configured for.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="interfacePolicies")
    def interface_policies(self) -> pulumi.Output[Sequence['outputs.AviatrixGatewaySnatInterfacePolicy']]:
        """
        Computed attribute to store the previous interface policy.
        """
        return pulumi.get(self, "interface_policies")

    @property
    @pulumi.getter(name="snatMode")
    def snat_mode(self) -> pulumi.Output[Optional[str]]:
        """
        NAT mode. Valid values: "customized_snat". Default value: "customized_snat".
        """
        return pulumi.get(self, "snat_mode")

    @property
    @pulumi.getter(name="snatPolicies")
    def snat_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixGatewaySnatSnatPolicy']]]:
        """
        Policy rule applied for enabling source NAT (mode: "customized_snat"). Currently only supports AWS(1) and Azure(8).
        """
        return pulumi.get(self, "snat_policies")

    @property
    @pulumi.getter(name="syncToHa")
    def sync_to_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Sync the policies to the HA gateway. Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "sync_to_ha")

