# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixFirewallTagArgs', 'AviatrixFirewallTag']

@pulumi.input_type
class AviatrixFirewallTagArgs:
    def __init__(__self__, *,
                 firewall_tag: pulumi.Input[str],
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]] = None):
        """
        The set of arguments for constructing a AviatrixFirewallTag resource.
        :param pulumi.Input[str] firewall_tag: Name of the stateful firewall tag to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]] cidr_lists: Dynamic block representing a CIDR to filter, and a name to identify it:
        """
        pulumi.set(__self__, "firewall_tag", firewall_tag)
        if cidr_lists is not None:
            pulumi.set(__self__, "cidr_lists", cidr_lists)

    @property
    @pulumi.getter(name="firewallTag")
    def firewall_tag(self) -> pulumi.Input[str]:
        """
        Name of the stateful firewall tag to be created.
        """
        return pulumi.get(self, "firewall_tag")

    @firewall_tag.setter
    def firewall_tag(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_tag", value)

    @property
    @pulumi.getter(name="cidrLists")
    def cidr_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]]:
        """
        Dynamic block representing a CIDR to filter, and a name to identify it:
        """
        return pulumi.get(self, "cidr_lists")

    @cidr_lists.setter
    def cidr_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]]):
        pulumi.set(self, "cidr_lists", value)


@pulumi.input_type
class _AviatrixFirewallTagState:
    def __init__(__self__, *,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]] = None,
                 firewall_tag: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFirewallTag resources.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]] cidr_lists: Dynamic block representing a CIDR to filter, and a name to identify it:
        :param pulumi.Input[str] firewall_tag: Name of the stateful firewall tag to be created.
        """
        if cidr_lists is not None:
            pulumi.set(__self__, "cidr_lists", cidr_lists)
        if firewall_tag is not None:
            pulumi.set(__self__, "firewall_tag", firewall_tag)

    @property
    @pulumi.getter(name="cidrLists")
    def cidr_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]]:
        """
        Dynamic block representing a CIDR to filter, and a name to identify it:
        """
        return pulumi.get(self, "cidr_lists")

    @cidr_lists.setter
    def cidr_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirewallTagCidrListArgs']]]]):
        pulumi.set(self, "cidr_lists", value)

    @property
    @pulumi.getter(name="firewallTag")
    def firewall_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stateful firewall tag to be created.
        """
        return pulumi.get(self, "firewall_tag")

    @firewall_tag.setter
    def firewall_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_tag", value)


class AviatrixFirewallTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirewallTagCidrListArgs']]]]] = None,
                 firewall_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_firewall_tag** resource allows the creation and management of [Aviatrix Stateful Firewall tags](https://docs.aviatrix.com/HowTos/tag_firewall.html) for tag-based security for gateways.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Firewall Tag
        test_firewall_tag = aviatrix.AviatrixFirewallTag("testFirewallTag",
            cidr_lists=[
                aviatrix.AviatrixFirewallTagCidrListArgs(
                    cidr="10.1.0.0/24",
                    cidr_tag_name="a1",
                ),
                aviatrix.AviatrixFirewallTagCidrListArgs(
                    cidr="10.2.0.0/24",
                    cidr_tag_name="b1",
                ),
            ],
            firewall_tag="test-firewall-tag")
        ```

        ## Import

        **firewall_tag** can be imported using the `firewall_tag`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallTag:AviatrixFirewallTag test firewall_tag
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirewallTagCidrListArgs']]]] cidr_lists: Dynamic block representing a CIDR to filter, and a name to identify it:
        :param pulumi.Input[str] firewall_tag: Name of the stateful firewall tag to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFirewallTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_firewall_tag** resource allows the creation and management of [Aviatrix Stateful Firewall tags](https://docs.aviatrix.com/HowTos/tag_firewall.html) for tag-based security for gateways.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Firewall Tag
        test_firewall_tag = aviatrix.AviatrixFirewallTag("testFirewallTag",
            cidr_lists=[
                aviatrix.AviatrixFirewallTagCidrListArgs(
                    cidr="10.1.0.0/24",
                    cidr_tag_name="a1",
                ),
                aviatrix.AviatrixFirewallTagCidrListArgs(
                    cidr="10.2.0.0/24",
                    cidr_tag_name="b1",
                ),
            ],
            firewall_tag="test-firewall-tag")
        ```

        ## Import

        **firewall_tag** can be imported using the `firewall_tag`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallTag:AviatrixFirewallTag test firewall_tag
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixFirewallTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFirewallTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirewallTagCidrListArgs']]]]] = None,
                 firewall_tag: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFirewallTagArgs.__new__(AviatrixFirewallTagArgs)

            __props__.__dict__["cidr_lists"] = cidr_lists
            if firewall_tag is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_tag'")
            __props__.__dict__["firewall_tag"] = firewall_tag
        super(AviatrixFirewallTag, __self__).__init__(
            'aviatrix:index/aviatrixFirewallTag:AviatrixFirewallTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirewallTagCidrListArgs']]]]] = None,
            firewall_tag: Optional[pulumi.Input[str]] = None) -> 'AviatrixFirewallTag':
        """
        Get an existing AviatrixFirewallTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirewallTagCidrListArgs']]]] cidr_lists: Dynamic block representing a CIDR to filter, and a name to identify it:
        :param pulumi.Input[str] firewall_tag: Name of the stateful firewall tag to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFirewallTagState.__new__(_AviatrixFirewallTagState)

        __props__.__dict__["cidr_lists"] = cidr_lists
        __props__.__dict__["firewall_tag"] = firewall_tag
        return AviatrixFirewallTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cidrLists")
    def cidr_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixFirewallTagCidrList']]]:
        """
        Dynamic block representing a CIDR to filter, and a name to identify it:
        """
        return pulumi.get(self, "cidr_lists")

    @property
    @pulumi.getter(name="firewallTag")
    def firewall_tag(self) -> pulumi.Output[str]:
        """
        Name of the stateful firewall tag to be created.
        """
        return pulumi.get(self, "firewall_tag")

