# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixFirewallManagementAccessArgs', 'AviatrixFirewallManagementAccess']

@pulumi.input_type
class AviatrixFirewallManagementAccessArgs:
    def __init__(__self__, *,
                 management_access_resource_name: pulumi.Input[str],
                 transit_firenet_gateway_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixFirewallManagementAccess resource.
        :param pulumi.Input[str] management_access_resource_name: Name of the resource to enable Firewall Management Access.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        pulumi.set(__self__, "management_access_resource_name", management_access_resource_name)
        pulumi.set(__self__, "transit_firenet_gateway_name", transit_firenet_gateway_name)

    @property
    @pulumi.getter(name="managementAccessResourceName")
    def management_access_resource_name(self) -> pulumi.Input[str]:
        """
        Name of the resource to enable Firewall Management Access.
        """
        return pulumi.get(self, "management_access_resource_name")

    @management_access_resource_name.setter
    def management_access_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "management_access_resource_name", value)

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

    @transit_firenet_gateway_name.setter
    def transit_firenet_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_firenet_gateway_name", value)


@pulumi.input_type
class _AviatrixFirewallManagementAccessState:
    def __init__(__self__, *,
                 management_access_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFirewallManagementAccess resources.
        :param pulumi.Input[str] management_access_resource_name: Name of the resource to enable Firewall Management Access.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        if management_access_resource_name is not None:
            pulumi.set(__self__, "management_access_resource_name", management_access_resource_name)
        if transit_firenet_gateway_name is not None:
            pulumi.set(__self__, "transit_firenet_gateway_name", transit_firenet_gateway_name)

    @property
    @pulumi.getter(name="managementAccessResourceName")
    def management_access_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource to enable Firewall Management Access.
        """
        return pulumi.get(self, "management_access_resource_name")

    @management_access_resource_name.setter
    def management_access_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_access_resource_name", value)

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

    @transit_firenet_gateway_name.setter
    def transit_firenet_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_firenet_gateway_name", value)


class AviatrixFirewallManagementAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_access_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_firewall_management_access** resource allows the management of which resource to permit visibility into the Transit (FireNet) VPC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Firewall Management Access
        test_firewall_management_access = aviatrix.AviatrixFirewallManagementAccess("testFirewallManagementAccess",
            management_access_resource_name="SPOKE:spoke-gw",
            transit_firenet_gateway_name="transit-gw")
        ```

        ## Import

        **firewall_management_access** can be imported using the `transit_firenet_gateway_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallManagementAccess:AviatrixFirewallManagementAccess test transit_firenet_gateway_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] management_access_resource_name: Name of the resource to enable Firewall Management Access.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFirewallManagementAccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_firewall_management_access** resource allows the management of which resource to permit visibility into the Transit (FireNet) VPC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Firewall Management Access
        test_firewall_management_access = aviatrix.AviatrixFirewallManagementAccess("testFirewallManagementAccess",
            management_access_resource_name="SPOKE:spoke-gw",
            transit_firenet_gateway_name="transit-gw")
        ```

        ## Import

        **firewall_management_access** can be imported using the `transit_firenet_gateway_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallManagementAccess:AviatrixFirewallManagementAccess test transit_firenet_gateway_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixFirewallManagementAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFirewallManagementAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_access_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFirewallManagementAccessArgs.__new__(AviatrixFirewallManagementAccessArgs)

            if management_access_resource_name is None and not opts.urn:
                raise TypeError("Missing required property 'management_access_resource_name'")
            __props__.__dict__["management_access_resource_name"] = management_access_resource_name
            if transit_firenet_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_firenet_gateway_name'")
            __props__.__dict__["transit_firenet_gateway_name"] = transit_firenet_gateway_name
        super(AviatrixFirewallManagementAccess, __self__).__init__(
            'aviatrix:index/aviatrixFirewallManagementAccess:AviatrixFirewallManagementAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            management_access_resource_name: Optional[pulumi.Input[str]] = None,
            transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixFirewallManagementAccess':
        """
        Get an existing AviatrixFirewallManagementAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] management_access_resource_name: Name of the resource to enable Firewall Management Access.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFirewallManagementAccessState.__new__(_AviatrixFirewallManagementAccessState)

        __props__.__dict__["management_access_resource_name"] = management_access_resource_name
        __props__.__dict__["transit_firenet_gateway_name"] = transit_firenet_gateway_name
        return AviatrixFirewallManagementAccess(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managementAccessResourceName")
    def management_access_resource_name(self) -> pulumi.Output[str]:
        """
        Name of the resource to enable Firewall Management Access.
        """
        return pulumi.get(self, "management_access_resource_name")

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS(1) and Azure(8) providers.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

