# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixControllerPrivateOobArgs', 'AviatrixControllerPrivateOob']

@pulumi.input_type
class AviatrixControllerPrivateOobArgs:
    def __init__(__self__, *,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixControllerPrivateOob resource.
        :param pulumi.Input[bool] enable_private_oob: Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        if enable_private_oob is not None:
            pulumi.set(__self__, "enable_private_oob", enable_private_oob)

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_private_oob")

    @enable_private_oob.setter
    def enable_private_oob(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob", value)


@pulumi.input_type
class _AviatrixControllerPrivateOobState:
    def __init__(__self__, *,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AviatrixControllerPrivateOob resources.
        :param pulumi.Input[bool] enable_private_oob: Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        if enable_private_oob is not None:
            pulumi.set(__self__, "enable_private_oob", enable_private_oob)

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_private_oob")

    @enable_private_oob.setter
    def enable_private_oob(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob", value)


class AviatrixControllerPrivateOob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The **aviatrix_controller_private_oob** resource allows management of an Aviatrix Controller's private OOB configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Private OOB
        test_private_oob = aviatrix.AviatrixControllerPrivateOob("testPrivateOob", enable_private_oob=True)
        ```

        ## Import

        **controller_private_oob** can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixControllerPrivateOob:AviatrixControllerPrivateOob test 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_private_oob: Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AviatrixControllerPrivateOobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_controller_private_oob** resource allows management of an Aviatrix Controller's private OOB configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Private OOB
        test_private_oob = aviatrix.AviatrixControllerPrivateOob("testPrivateOob", enable_private_oob=True)
        ```

        ## Import

        **controller_private_oob** can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixControllerPrivateOob:AviatrixControllerPrivateOob test 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixControllerPrivateOobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixControllerPrivateOobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixControllerPrivateOobArgs.__new__(AviatrixControllerPrivateOobArgs)

            __props__.__dict__["enable_private_oob"] = enable_private_oob
        super(AviatrixControllerPrivateOob, __self__).__init__(
            'aviatrix:index/aviatrixControllerPrivateOob:AviatrixControllerPrivateOob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_private_oob: Optional[pulumi.Input[bool]] = None) -> 'AviatrixControllerPrivateOob':
        """
        Get an existing AviatrixControllerPrivateOob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_private_oob: Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixControllerPrivateOobState.__new__(_AviatrixControllerPrivateOobState)

        __props__.__dict__["enable_private_oob"] = enable_private_oob
        return AviatrixControllerPrivateOob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable Aviatrix controller private OOB. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_private_oob")

