from unittest import TestCase

from pollect.libs.sma.SmaEnergyMeter import SmaEnergyMeter, MeterProtocol


class TestSmaEnergyMeter(TestCase):
    def test_parse(self):
        protocol: MeterProtocol = None

        def data_received(data):
            nonlocal protocol
            protocol = data

        data = bytearray.fromhex(
            '534d4100000402a000000001024c001060690174b31b4487ab443f1b000104000000000000010800000000054637c87800020400000002ee000208000000000daa40771800030400000000000003080000000001320c4ff80004040000000dd20004080000000004ad7e831000090400000000000009080000000006e974f140000a040000000e21000a08000000000e0f577840000d0400000000cf000e04000000c33c0015040000000000001508000000000172de1160001604000000010a0016080000000004e4aa2ad80017040000000000001708000000000070f64058001804000000053500180800000000014da62018001d040000000000001d080000000001de7c5878001e04000000054f001e080000000005047190b8001f04000000032b002004000003888400210400000000c400290400000004da0029080000000001113f32b8002a040000000000002a080000000004fc67aab0002b040000000000002b08000000000062625c48002c040000000579002c080000000001c8de6ee800310400000007500031080000000001e1cd9af0003204000000000000320800000000052e224f8800330400000003cf0034040000038a080035040000000297003d040000000000003d08000000000368c50128003e0400000006be003e0800000000046fd92290003f040000000000003f080000000000678a6800004004000000032500400800000000019fd0a8b8004504000000000000450800000000041187a6f8004604000000077000460800000000049548d3e000470400000003910048040000038aa5004904000000038a900000000208055200000000')
        meter = SmaEnergyMeter('', 0)
        meter.meterProtocolReceived += data_received
        meter._parse(data, None)

        self.assertIsNotNone(protocol)
        self.assertEqual(59, len(protocol.obis_pairs))
        for item in protocol.obis_pairs:
            self.assertIsNotNone(item.unit, item.obis_id)
            self.assertIsNotNone(item.meta, item.obis_id)
