# -*- coding: utf-8 -*-
"""add targets

Revision ID: aa9c83a108be
Revises: 0001.outflow.management
Create Date: 2021-07-26 17:29:00.745043

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "aa9c83a108be"
down_revision = "0001.outflow.management"
branch_labels = None
depends_on = None


def upgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###
    if op.get_context().dialect.name == "postgresql":
        with op.get_context().autocommit_block():
            op.execute("ALTER TYPE stateenum ADD VALUE IF NOT EXISTS 'skipped'")

    op.create_table(
        "workflow",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manager_task_id", sa.Integer(), nullable=True),
        sa.Column("parent_workflow_id", sa.Integer(), nullable=True),
        sa.Column("run_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manager_task_id"],
            ["task.id"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_workflow_id"],
            ["workflow.id"],
        ),
        sa.ForeignKeyConstraint(
            ["run_id"],
            ["run.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.grant_permissions("workflow")

    op.add_column(
        "task",
        sa.Column("input_targets", sa.JSON(), nullable=False, server_default="{}"),
    )
    op.add_column(
        "task",
        sa.Column("output_targets", sa.JSON(), nullable=False, server_default="{}"),
    )
    with op.batch_alter_table("task") as batch_op:
        batch_op.add_column(
            sa.Column(
                "workflow_id", sa.Integer(), nullable=True, back_populates="tasks"
            ),
        )
        batch_op.create_foreign_key("task", "workflow", ["workflow_id"], ["id"])

    with op.get_context().autocommit_block():
        op.execute(
            "INSERT INTO configuration (id, config, settings, hash) VALUES (-1, '{}', '{}', '' );"
        )
        op.execute(
            "INSERT INTO run (id, uuid, state, configuration_id) VALUES (-1, '', 'skipped', -1);"
        )
        op.execute("INSERT INTO workflow (id, run_id) VALUES (-1, -1);")
        op.execute("UPDATE task SET workflow_id=-1 WHERE workflow_id IS NULL;")

    with op.batch_alter_table("task") as batch_op:
        batch_op.alter_column("workflow_id", nullable=False)
    # ### end Alembic commands ###


def downgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###
    naming_convention = {
        "fk": "fk_%(table_name)s_%(column_0_name)s_%(referred_table_name)s",
    }

    with op.batch_alter_table("task", naming_convention=naming_convention) as batch_op:
        # batch_op.drop_constraint("fk_task_workflow_id_workflow", type_="foreignkey")
        batch_op.drop_column("workflow_id")
        batch_op.drop_column("output_targets")
        batch_op.drop_column("input_targets")
    op.drop_table("workflow")

    with op.get_context().autocommit_block():
        op.execute("DELETE FROM run WHERE id=-1;")
        op.execute("DELETE FROM configuration WHERE id=-1;")
    # ### end Alembic commands ###
