# -*- coding: utf-8 -*-
"""Add column command to table run

Revision ID: 681dd4fd7a35
Revises: c07e04312313
Create Date: 2022-01-13 09:03:50.096722

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = "681dd4fd7a35"
down_revision = "c07e04312313"
branch_labels = None
depends_on = None


def upgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("outflow_run", sa.Column("command_name", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("outflow_run") as batch_op:
        batch_op.drop_column("command_name")
    # ### end Alembic commands ###
