# -*- coding: utf-8 -*-
"""Change config column type from JSON to JSONB if postgres

Revision ID: 094e0007ec5c
Revises: aa9c83a108be
Create Date: 2021-09-25 13:34:58.274562

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "094e0007ec5c"
down_revision = "aa9c83a108be"
branch_labels = None
depends_on = None


def upgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###

    if op.get_context().dialect.name == "postgresql":
        op.alter_column(
            "configuration",
            "config",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            type_=postgresql.JSONB(astext_type=sa.Text()),
            existing_nullable=False,
        )
        op.alter_column(
            "configuration",
            "settings",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            type_=postgresql.JSONB(astext_type=sa.Text()),
            existing_nullable=False,
        )
    # ### end Alembic commands ###


def downgrade():
    if op.get_context().dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###

    if op.get_context().dialect.name == "postgresql":
        op.alter_column(
            "configuration",
            "settings",
            existing_type=postgresql.JSONB(astext_type=sa.Text()),
            type_=postgresql.JSON(astext_type=sa.Text()),
            existing_nullable=False,
        )
        op.alter_column(
            "configuration",
            "config",
            existing_type=postgresql.JSONB(astext_type=sa.Text()),
            type_=postgresql.JSON(astext_type=sa.Text()),
            existing_nullable=False,
        )
    # ### end Alembic commands ###
