# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'c2a63bf288b75e44404c9e8c91497e6a'
g_compiler_version = '2.0'

class RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value', float(new_val))


class RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.value', float(new_val))


class RootCoreCore_cantileverProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property'
        self.selected_cantilever_spring_constant = RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(self._context)
        self.selected_cantilever_deflection_sensitivity = RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(self._context)


class RootCoreCore_cantilever(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever'
        self.property = RootCoreCore_cantileverProperty(self._context)

    def select_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.select_cantilever', *args)

    def selected_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.selected_cantilever', *args)

    def apply(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.apply', *args)


class RootCoreHv_amp_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hv_amp_control'


class RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Calibration_Error = 1
        Sensor_Signal_Failed = 2
        No_Error = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_spot_intensity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyScan_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.scan_mode'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.scan_mode.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.scan_mode.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_normal(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_normal'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.value', float(new_val))


class RootCoreLaser_align_drive_implPropertySensor_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Ok = 2
        Fail = 4
        Undefined = 0
        Low = 1
        High = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.sensor_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertySensor_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_focus_z_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_beam_shifter_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value', float(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_lateral(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_lateral'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.value', float(new_val))


class RootCoreLaser_align_drive_implProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property'
        self.deflection_lateral = RootCoreLaser_align_drive_implPropertyDeflection_lateral(self._context)
        self.motor_speed_max_beam_shifter = RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(self._context)
        self.motor_laser_clean_drive_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(self._context)
        self.motor_beam_shifter_position = RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(self._context)
        self.motor_laser_focus_z_position = RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(self._context)
        self.laser_readout_power = RootCoreLaser_align_drive_implPropertyLaser_readout_power(self._context)
        self.motor_speed_max_laser_focus = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(self._context)
        self.sensor_status = RootCoreLaser_align_drive_implPropertySensor_status(self._context)
        self.deflection_normal = RootCoreLaser_align_drive_implPropertyDeflection_normal(self._context)
        self.laser_clean_drive_enabled = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(self._context)
        self.scan_mode = RootCoreLaser_align_drive_implPropertyScan_mode(self._context)
        self.motor_speed_max_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(self._context)
        self.motor_speed_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(self._context)
        self.motor_laser_readout_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(self._context)
        self.motor_laser_readout_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(self._context)
        self.laser_clean_drive_power = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(self._context)
        self.laser_clean_drive_amplitude = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(self._context)
        self.motor_laser_photodetector_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(self._context)
        self.motor_laser_photodetector_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(self._context)
        self.laser_spot_intensity = RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(self._context)
        self.laser_readout_enabled = RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(self._context)
        self.motor_laser_clean_drive_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(self._context)
        self.deflection_offset_calibration_status = RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(self._context)


class RootCoreLaser_align_drive_implSignalAuto_align_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_search_step_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalCenter_detector_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.center_detector_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_pte_aligned'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect_extended', *args)


class RootCoreLaser_align_drive_implSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal'
        self.auto_align_pte_aligned = RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(self._context)
        self.procedure_info = RootCoreLaser_align_drive_implSignalProcedure_info(self._context)
        self.motor_move_finished = RootCoreLaser_align_drive_implSignalMotor_move_finished(self._context)
        self.center_detector_finished = RootCoreLaser_align_drive_implSignalCenter_detector_finished(self._context)
        self.motor_move_started = RootCoreLaser_align_drive_implSignalMotor_move_started(self._context)
        self.auto_align_search_step_finished = RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(self._context)
        self.auto_align_finished = RootCoreLaser_align_drive_implSignalAuto_align_finished(self._context)


class RootCoreLaser_align_drive_impl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl'
        self.signal = RootCoreLaser_align_drive_implSignal(self._context)
        self.property = RootCoreLaser_align_drive_implProperty(self._context)

    def abort_auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_auto_align', *args)

    def start_optimizing(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_optimizing', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.zero_position', *args)

    def stop_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_updating_detector_status', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_motors', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_move_to_optical_center', *args)

    def start_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_updating_detector_status', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_search_algorithm', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_moving_motors', *args)

    def center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.center_detector', *args)

    def auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.auto_align', *args)

    def abort_center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_center_detector', *args)

    def reference_motor(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.reference_motor', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.move_motors_by_step', *args)


class RootCoreOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.oscilloscope'


class RootCoreAcquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.acquisition'

    def erase_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.erase_lu_data_buffer', *args)

    def lu_data_buffer_channel_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_data', *args)

    def lu_data_buffer_channel_count(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_count', *args)

    def write_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.write_data', *args)

    def lu_data_buffer_timestamp(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_timestamp', *args)

    def reserve_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.reserve_lu_data_buffer', *args)

    def trim_sampler_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.trim_sampler_buffer', *args)

    def synchronize_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.synchronize_lu_data_buffer', *args)

    def lu_data_buffer_state(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_state', *args)


class RootCoreComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.comp_dc'


class RootCorePosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.position_control'


class RootCoreCore_monitoring(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_monitoring'


class RootCoreScan_head_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.scan_head_calibration'


class RootCoreImaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.imaging'


class RootCoreSignal_registration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_registration'


class RootCoreSignal_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_store'

    def get_signal_calibration_min_max(self, *args) -> Any:
        return self._context.call('root.core.signal_store.get_signal_calibration_min_max', *args)


class RootCoreSpectroscopySignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.signal'


class RootCoreSpectroscopyPropertyBackward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_Off = 0
        Z_On = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.repetition_count'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.repetition_count.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.repetition_count.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.repetition_count.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.value', float(new_val))


class RootCoreSpectroscopyPropertySpec_end_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Keep_Last_Z_Position = 0
        Z_Controller_Active = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.spec_end_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertySpec_end_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offset.value', float(new_val))


class RootCoreSpectroscopyPropertySample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.sample_mask'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.sample_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.sample_mask.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.sample_mask.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.sample_mask.value', int(new_val))


class RootCoreSpectroscopyPropertyXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.feedback_active'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.feedback_active.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.feedback_active.value', bool(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.value', float(new_val))


class RootCoreSpectroscopyPropertyModulation_relative_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_relative_value'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.modulation_relative_value.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.modulation_relative_value.value', bool(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.value', float(new_val))


class RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_Off = 0
        Z_On = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyStart_offste_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offste_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.value', int(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.value', float(new_val))


class RootCoreSpectroscopyPropertyModulation_output(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        External_Z = 2
        Tip_Voltage = 1
        Position_Z = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_output'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyModulation_output.ValueEnum(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.modulation_output.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.value', float(new_val))


class RootCoreSpectroscopyProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property'
        self.forward_move_speed = RootCoreSpectroscopyPropertyForward_move_speed(self._context)
        self.modulation_output = RootCoreSpectroscopyPropertyModulation_output(self._context)
        self.backward_move_speed = RootCoreSpectroscopyPropertyBackward_move_speed(self._context)
        self.forward_modulation_stop_mode = RootCoreSpectroscopyPropertyForward_modulation_stop_mode(self._context)
        self.backward_pause_datapoints = RootCoreSpectroscopyPropertyBackward_pause_datapoints(self._context)
        self.forward_modulation_mode = RootCoreSpectroscopyPropertyForward_modulation_mode(self._context)
        self.start_offste_move_speed = RootCoreSpectroscopyPropertyStart_offste_move_speed(self._context)
        self.backward_pause_mode = RootCoreSpectroscopyPropertyBackward_pause_mode(self._context)
        self.backward_datapoints = RootCoreSpectroscopyPropertyBackward_datapoints(self._context)
        self.auto_recalibrate_probe_interval = RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(self._context)
        self.forward_pause_time = RootCoreSpectroscopyPropertyForward_pause_time(self._context)
        self.backward_pause_sampling_rate = RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(self._context)
        self.modulation_relative_value = RootCoreSpectroscopyPropertyModulation_relative_value(self._context)
        self.forward_modulation_time = RootCoreSpectroscopyPropertyForward_modulation_time(self._context)
        self.backward_modulation_time = RootCoreSpectroscopyPropertyBackward_modulation_time(self._context)
        self.feedback_active = RootCoreSpectroscopyPropertyFeedback_active(self._context)
        self.forward_sampling_rate = RootCoreSpectroscopyPropertyForward_sampling_rate(self._context)
        self.backward_modulation_stop_value = RootCoreSpectroscopyPropertyBackward_modulation_stop_value(self._context)
        self.backward_modulation_stop_mode = RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(self._context)
        self.forward_datapoints = RootCoreSpectroscopyPropertyForward_datapoints(self._context)
        self.xy_move_speed = RootCoreSpectroscopyPropertyXy_move_speed(self._context)
        self.sample_mask = RootCoreSpectroscopyPropertySample_mask(self._context)
        self.start_offset = RootCoreSpectroscopyPropertyStart_offset(self._context)
        self.spec_end_mode = RootCoreSpectroscopyPropertySpec_end_mode(self._context)
        self.backward_modulation_range = RootCoreSpectroscopyPropertyBackward_modulation_range(self._context)
        self.backward_pause_time = RootCoreSpectroscopyPropertyBackward_pause_time(self._context)
        self.repetition_count = RootCoreSpectroscopyPropertyRepetition_count(self._context)
        self.forward_pause_sampling_rate = RootCoreSpectroscopyPropertyForward_pause_sampling_rate(self._context)
        self.forward_pause_mode = RootCoreSpectroscopyPropertyForward_pause_mode(self._context)
        self.forward_pause_datapoints = RootCoreSpectroscopyPropertyForward_pause_datapoints(self._context)
        self.forward_modulation_range = RootCoreSpectroscopyPropertyForward_modulation_range(self._context)
        self.backward_sampling_rate = RootCoreSpectroscopyPropertyBackward_sampling_rate(self._context)
        self.forward_modulation_stop_value = RootCoreSpectroscopyPropertyForward_modulation_stop_value(self._context)
        self.backward_modulation_mode = RootCoreSpectroscopyPropertyBackward_modulation_mode(self._context)


class RootCoreSpectroscopy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy'
        self.property = RootCoreSpectroscopyProperty(self._context)
        self.signal = RootCoreSpectroscopySignal(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.abort', *args)


class RootCoreThermal_tuneSignalNew_average(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_average'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_fit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_fit'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_frequency_list(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_frequency_list'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect_extended', *args)


class RootCoreThermal_tuneSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect_extended', *args)


class RootCoreThermal_tuneSignalEnded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect_extended', *args)


class RootCoreThermal_tuneSignalStarted(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect_extended', *args)


class RootCoreThermal_tuneSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect_extended', *args)


class RootCoreThermal_tuneSignalProgress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect_extended', *args)


class RootCoreThermal_tuneSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal'
        self.progress = RootCoreThermal_tuneSignalProgress(self._context)
        self.data_invalidated = RootCoreThermal_tuneSignalData_invalidated(self._context)
        self.started = RootCoreThermal_tuneSignalStarted(self._context)
        self.ended = RootCoreThermal_tuneSignalEnded(self._context)
        self.procedure_info = RootCoreThermal_tuneSignalProcedure_info(self._context)
        self.new_frequency_list = RootCoreThermal_tuneSignalNew_frequency_list(self._context)
        self.new_fit = RootCoreThermal_tuneSignalNew_fit(self._context)
        self.new_average = RootCoreThermal_tuneSignalNew_average(self._context)


class RootCoreThermal_tunePropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreThermal_tunePropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreThermal_tunePropertyMeasurement_environment.ValueEnum(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.thermal_tune.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.thermal_tune.property.measurement_environment.enum', list(new_val))


class RootCoreThermal_tunePropertyIterations(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.iterations'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.iterations.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.iterations.value', int(new_val))


class RootCoreThermal_tunePropertyResolution(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.resolution'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.resolution.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.resolution.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.resolution.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.resolution.value', float(new_val))


class RootCoreThermal_tunePropertyMax_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.max_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.max_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.max_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.max_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.max_frequency.value', float(new_val))


class RootCoreThermal_tunePropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.temperature.value', float(new_val))


class RootCoreThermal_tunePropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreThermal_tuneProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property'
        self.fit_frequency_upper_bound = RootCoreThermal_tunePropertyFit_frequency_upper_bound(self._context)
        self.temperature = RootCoreThermal_tunePropertyTemperature(self._context)
        self.max_frequency = RootCoreThermal_tunePropertyMax_frequency(self._context)
        self.resolution = RootCoreThermal_tunePropertyResolution(self._context)
        self.iterations = RootCoreThermal_tunePropertyIterations(self._context)
        self.measurement_environment = RootCoreThermal_tunePropertyMeasurement_environment(self._context)
        self.fit_frequency_lower_bound = RootCoreThermal_tunePropertyFit_frequency_lower_bound(self._context)


class RootCoreThermal_tune(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune'
        self.property = RootCoreThermal_tuneProperty(self._context)
        self.signal = RootCoreThermal_tuneSignal(self._context)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.abort', *args)

    def generate_frequency_list(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.generate_frequency_list', *args)

    def add_raw_data_to_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.add_raw_data_to_fft_average_buffer', *args)

    def create_fit_from_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.create_fit_from_fft_average_buffer', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.start', *args)

    def set_thermal_tune_parameters(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.set_thermal_tune_parameters', *args)

    def calculate_cantilever_calibration(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.calculate_cantilever_calibration', *args)


class RootCoreZ_controllerSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.signal'


class RootCoreZ_controllerPropertyFeedback(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        WaveMode_Amplitude_Reduction = 1
        Dynamic_Mode_Amplitude_Reduction = 2
        Deflection = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback.ValueEnum(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback.enum', list(new_val))


class RootCoreZ_controllerPropertyFeedback_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        invalid = 2
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback_polarity.ValueEnum(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback_polarity.enum', list(new_val))


class RootCoreZ_controllerPropertyActual_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_tip_position.value', float(new_val))


class RootCoreZ_controllerPropertyBase_work_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Drive_Z = 1
        Control_Z_by_Measurement_Mode = 2
        Control_Z_by_Z_Sensor = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.base_work_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyBase_work_mode.ValueEnum(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.base_work_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.base_work_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyActual_feedback_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_feedback_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_feedback_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_feedback_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_feedback_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_feedback_value.value', float(new_val))


class RootCoreZ_controllerPropertyI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyMin_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.min_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.min_z_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.min_z_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.min_z_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.min_z_value.value', float(new_val))


class RootCoreZ_controllerPropertySetpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.setpoint.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.setpoint.value', float(new_val))


class RootCoreZ_controllerPropertyIdle_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Retract_Tip = 1
        Enable_Z_Controller = 0
        Absolute_Z_Position = 3
        Keep_Last_Z_Position = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.idle_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyIdle_mode.ValueEnum(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.idle_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.idle_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyAbsolute_idle_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.absolute_idle_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.absolute_idle_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.absolute_idle_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.absolute_idle_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.absolute_idle_position.value', float(new_val))


class RootCoreZ_controllerPropertyD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.d_gain.value', int(new_val))


class RootCoreZ_controllerProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property'
        self.d_gain = RootCoreZ_controllerPropertyD_gain(self._context)
        self.absolute_idle_position = RootCoreZ_controllerPropertyAbsolute_idle_position(self._context)
        self.p_gain = RootCoreZ_controllerPropertyP_gain(self._context)
        self.idle_mode = RootCoreZ_controllerPropertyIdle_mode(self._context)
        self.setpoint = RootCoreZ_controllerPropertySetpoint(self._context)
        self.min_z_value = RootCoreZ_controllerPropertyMin_z_value(self._context)
        self.i_gain = RootCoreZ_controllerPropertyI_gain(self._context)
        self.actual_feedback_value = RootCoreZ_controllerPropertyActual_feedback_value(self._context)
        self.base_work_mode = RootCoreZ_controllerPropertyBase_work_mode(self._context)
        self.actual_tip_position = RootCoreZ_controllerPropertyActual_tip_position(self._context)
        self.feedback_polarity = RootCoreZ_controllerPropertyFeedback_polarity(self._context)
        self.feedback = RootCoreZ_controllerPropertyFeedback(self._context)


class RootCoreZ_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller'
        self.property = RootCoreZ_controllerProperty(self._context)
        self.signal = RootCoreZ_controllerSignal(self._context)

    def setpoint_upper_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_upper_limit', *args)

    def setpoint_limits_from_calibration(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_limits_from_calibration', *args)

    def tip_position_lower_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.tip_position_lower_limit', *args)

    def retract_tip(self, *args) -> Any:
        return self._context.call('root.core.z_controller.retract_tip', *args)


class RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        num_90_Hz = 3
        num_6_kHz = 9
        num_1500_Hz = 7
        num_3_kHz = 8
        num_750_Hz = 6
        num_23_kHz = 11
        num_360_Hz = 5
        num_500_kHz = 15
        num_230_kHz = 14
        num_45_kHz = 12
        num_180_Hz = 4
        num_100_kHz = 13
        num_12_kHz = 10

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.analyzer_demodulator_bandwidth'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth.ValueEnum(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum', list(new_val))


class RootCoreFrequency_sweepPropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.temperature.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.temperature.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_free_vibration_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertyNew_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.value', float(new_val))


class RootCoreFrequency_sweepPropertyNew_excitation_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_excitation_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.value', float(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.value', float(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_unit(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Volts_V_ = 1
        Meters_m_ = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_unit'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAmplitude_unit.ValueEnum(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.amplitude_unit.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value', float(new_val))


class RootCoreFrequency_sweepPropertySweep_data_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_data_points'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.sweep_data_points.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.sweep_data_points.value', int(new_val))


class RootCoreFrequency_sweepPropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyMeasurement_environment.ValueEnum(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.enum', list(new_val))


class RootCoreFrequency_sweepPropertyFrequency_selection_criteria(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Above_Peak = 1
        Below_Peak = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.frequency_selection_criteria'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyFrequency_selection_criteria.ValueEnum(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.enum', list(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.value', float(new_val))


class RootCoreFrequency_sweepProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property'
        self.fit_frequency_upper_bound = RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(self._context)
        self.frequency_selection_criteria = RootCoreFrequency_sweepPropertyFrequency_selection_criteria(self._context)
        self.measurement_environment = RootCoreFrequency_sweepPropertyMeasurement_environment(self._context)
        self.sweep_data_points = RootCoreFrequency_sweepPropertySweep_data_points(self._context)
        self.sweep_frequency_lower_bound = RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(self._context)
        self.amplitude_unit = RootCoreFrequency_sweepPropertyAmplitude_unit(self._context)
        self.sweep_excitation_amplitude = RootCoreFrequency_sweepPropertySweep_excitation_amplitude(self._context)
        self.amplitude_reduction = RootCoreFrequency_sweepPropertyAmplitude_reduction(self._context)
        self.new_excitation_frequency = RootCoreFrequency_sweepPropertyNew_excitation_frequency(self._context)
        self.new_spring_constant = RootCoreFrequency_sweepPropertyNew_spring_constant(self._context)
        self.sweep_frequency_upper_bound = RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(self._context)
        self.sweep_free_vibration_amplitude = RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(self._context)
        self.temperature = RootCoreFrequency_sweepPropertyTemperature(self._context)
        self.analyzer_demodulator_bandwidth = RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(self._context)
        self.fit_frequency_lower_bound = RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(self._context)


class RootCoreFrequency_sweepSignalSweep_ended(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect_extended', *args)


class RootCoreFrequency_sweepSignalNew_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalProcess_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.process_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalNew_fit_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_fit_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalSho_fit_failed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sho_fit_failed'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect_extended', *args)


class RootCoreFrequency_sweepSignalSweep_progress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect_extended', *args)


class RootCoreFrequency_sweepSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect_extended', *args)


class RootCoreFrequency_sweepSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal'
        self.data_invalidated = RootCoreFrequency_sweepSignalData_invalidated(self._context)
        self.sweep_progress = RootCoreFrequency_sweepSignalSweep_progress(self._context)
        self.sho_fit_failed = RootCoreFrequency_sweepSignalSho_fit_failed(self._context)
        self.new_fit_data = RootCoreFrequency_sweepSignalNew_fit_data(self._context)
        self.process_sweep_data = RootCoreFrequency_sweepSignalProcess_sweep_data(self._context)
        self.new_sweep_data = RootCoreFrequency_sweepSignalNew_sweep_data(self._context)
        self.sweep_ended = RootCoreFrequency_sweepSignalSweep_ended(self._context)


class RootCoreFrequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep'
        self.signal = RootCoreFrequency_sweepSignal(self._context)
        self.property = RootCoreFrequency_sweepProperty(self._context)

    def convert_and_emit_sweep_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.convert_and_emit_sweep_data', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.abort', *args)

    def set_sweep_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_sweep_parameters', *args)

    def do_sho_fit(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.do_sho_fit', *args)

    def calculate_spring_constant(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.calculate_spring_constant', *args)

    def invalidate_sweep_and_fit_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.invalidate_sweep_and_fit_data', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.start', *args)


class RootCoreOrtPropertyExcitation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.excitation_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.excitation_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.excitation_enabled.value', bool(new_val))


class RootCoreOrtPropertyBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_frequency.value', float(new_val))


class RootCoreOrtPropertyAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.average_periods'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.average_periods.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.average_periods.value', int(new_val))


class RootCoreOrtPropertyBaseline_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_value.value', float(new_val))


class RootCoreOrtPropertyBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_begin.value', float(new_val))


class RootCoreOrtPropertyFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.free_wave_delay.value', float(new_val))


class RootCoreOrtPropertyFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.feedback_amplitude_position.value', float(new_val))


class RootCoreOrtPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.amplitude_reduction.value', float(new_val))


class RootCoreOrtPropertyBaseline_controller_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_controller_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.baseline_controller_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.baseline_controller_enabled.value', bool(new_val))


class RootCoreOrtPropertyBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_end.value', float(new_val))


class RootCoreOrtPropertyAdhesion_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_position.value', float(new_val))


class RootCoreOrtPropertyInput_select(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fast_In_Deflection = 0
        Hi_Res_In_Deflection = 1
        Fast_In_User = 2
        Hi_Res_In_User1 = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.input_select'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.ort.property.input_select.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreOrtPropertyInput_select.ValueEnum(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.ort.property.input_select.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.ort.property.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.ort.property.input_select.enum', list(new_val))


class RootCoreOrtPropertySamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.samples_per_period.value', int(new_val))


class RootCoreOrtPropertyAdhesion_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.adhesion_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.adhesion_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_value.value', float(new_val))


class RootCoreOrtPropertyCantilever_samples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.cantilever_samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.cantilever_samples_per_period.value', int(new_val))


class RootCoreOrtPropertyBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_amplitude.value', float(new_val))


class RootCoreOrtProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property'
        self.baseline_amplitude = RootCoreOrtPropertyBaseline_amplitude(self._context)
        self.cantilever_samples_per_period = RootCoreOrtPropertyCantilever_samples_per_period(self._context)
        self.adhesion_value = RootCoreOrtPropertyAdhesion_value(self._context)
        self.samples_per_period = RootCoreOrtPropertySamples_per_period(self._context)
        self.input_select = RootCoreOrtPropertyInput_select(self._context)
        self.adhesion_position = RootCoreOrtPropertyAdhesion_position(self._context)
        self.baseline_window_end = RootCoreOrtPropertyBaseline_window_end(self._context)
        self.baseline_controller_enabled = RootCoreOrtPropertyBaseline_controller_enabled(self._context)
        self.amplitude_reduction = RootCoreOrtPropertyAmplitude_reduction(self._context)
        self.feedback_amplitude_position = RootCoreOrtPropertyFeedback_amplitude_position(self._context)
        self.free_wave_delay = RootCoreOrtPropertyFree_wave_delay(self._context)
        self.baseline_window_begin = RootCoreOrtPropertyBaseline_window_begin(self._context)
        self.baseline_value = RootCoreOrtPropertyBaseline_value(self._context)
        self.average_periods = RootCoreOrtPropertyAverage_periods(self._context)
        self.baseline_frequency = RootCoreOrtPropertyBaseline_frequency(self._context)
        self.excitation_enabled = RootCoreOrtPropertyExcitation_enabled(self._context)


class RootCoreOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort'
        self.property = RootCoreOrtProperty(self._context)

    def excitation_amplitude(self, *args) -> Any:
        return self._context.call('root.core.ort.excitation_amplitude', *args)

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_per_period', *args)

    def select_input(self, *args) -> Any:
        return self._context.call('root.core.ort.select_input', *args)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.core.ort.update_free_wave', *args)

    def apply_samples_values(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_values', *args)

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.core.ort.is_averaging', *args)


class RootCoreConverter_channel_correction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.converter_channel_correction'


class RootCoreDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.direct_motor_control'


class RootCoreCore_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_environment'


class RootCoreApproach_motors_driveSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect_extended', *args)


class RootCoreApproach_motors_driveSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect_extended', *args)


class RootCoreApproach_motors_driveSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal'
        self.motor_move_started = RootCoreApproach_motors_driveSignalMotor_move_started(self._context)
        self.motor_move_finished = RootCoreApproach_motors_driveSignalMotor_move_finished(self._context)


class RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_advance_retract'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_left_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_left_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_left_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_left_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_approach_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.value', float(new_val))


class RootCoreApproach_motors_drivePropertyRelative_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.relative_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_front_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_front_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_front_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_front_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.value', float(new_val))


class RootCoreApproach_motors_drivePropertyMotor_right_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_right_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_right_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_right_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.value', float(new_val))


class RootCoreApproach_motors_driveProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property'
        self.motor_right_position = RootCoreApproach_motors_drivePropertyMotor_right_position(self._context)
        self.motor_front_position = RootCoreApproach_motors_drivePropertyMotor_front_position(self._context)
        self.motor_speed = RootCoreApproach_motors_drivePropertyMotor_speed(self._context)
        self.relative_tip_position = RootCoreApproach_motors_drivePropertyRelative_tip_position(self._context)
        self.motor_speed_approach_motors = RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(self._context)
        self.motor_left_position = RootCoreApproach_motors_drivePropertyMotor_left_position(self._context)
        self.motor_speed_advance_retract = RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(self._context)


class RootCoreApproach_motors_drive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive'
        self.property = RootCoreApproach_motors_driveProperty(self._context)
        self.signal = RootCoreApproach_motors_driveSignal(self._context)

    def reference_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.reference_motors', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.stop_motors', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.zero_position', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.start_moving_motors', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.move_motors_by_step', *args)


class RootCoreApproachSignalApproach_or_withdraw_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal.approach_or_withdraw_done'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect_extended', *args)


class RootCoreApproachSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal'
        self.approach_or_withdraw_done = RootCoreApproachSignalApproach_or_withdraw_done(self._context)


class RootCoreApproachPropertyApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.approach_steps.value', int(new_val))


class RootCoreApproachPropertyWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.withdraw_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.withdraw_steps.value', int(new_val))


class RootCoreApproachPropertyStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_slope.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Position_Controlled = 0
        Not_Controlled = 1
        Tip_Position_Ignored = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyStep_by_step_mode.ValueEnum(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.step_by_step_mode.enum', list(new_val))


class RootCoreApproachPropertyStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_time.value', float(new_val))


class RootCoreApproachPropertyStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_period.value', float(new_val))


class RootCoreApproachPropertyApproach_result(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_result'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_result.value'))

    @value.setter
    def value(self, new_val:str):
        self._context.set('root.core.approach.property.approach_result.value', str(new_val))


class RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyApproach_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Continuous = 0
        Step_by_Step = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.approach_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyApproach_mode.ValueEnum(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.approach_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.approach_mode.enum', list(new_val))


class RootCoreApproachPropertyDeflection_offset_voltage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.deflection_offset_voltage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.deflection_offset_voltage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.deflection_offset_voltage.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.deflection_offset_voltage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.deflection_offset_voltage.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.value', int(new_val))


class RootCoreApproachPropertyMotor_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        External = 1
        Internal = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.motor_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.motor_source.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyMotor_source.ValueEnum(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.motor_source.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.motor_source.enum', list(new_val))


class RootCoreApproachPropertyApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_pos.value', float(new_val))


class RootCoreApproachPropertyApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_speed.value', float(new_val))


class RootCoreApproachProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property'
        self.approach_speed = RootCoreApproachPropertyApproach_speed(self._context)
        self.approach_pos = RootCoreApproachPropertyApproach_pos(self._context)
        self.motor_source = RootCoreApproachPropertyMotor_source(self._context)
        self.step_by_step_fine_step_size_percentage = RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(self._context)
        self.deflection_offset_voltage = RootCoreApproachPropertyDeflection_offset_voltage(self._context)
        self.approach_mode = RootCoreApproachPropertyApproach_mode(self._context)
        self.step_by_step_coarse_step_size_percentage = RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(self._context)
        self.approach_result = RootCoreApproachPropertyApproach_result(self._context)
        self.step_period = RootCoreApproachPropertyStep_period(self._context)
        self.step_by_step_time = RootCoreApproachPropertyStep_by_step_time(self._context)
        self.step_by_step_mode = RootCoreApproachPropertyStep_by_step_mode(self._context)
        self.step_by_step_slope = RootCoreApproachPropertyStep_by_step_slope(self._context)
        self.withdraw_steps = RootCoreApproachPropertyWithdraw_steps(self._context)
        self.approach_steps = RootCoreApproachPropertyApproach_steps(self._context)


class RootCoreApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach'
        self.property = RootCoreApproachProperty(self._context)
        self.signal = RootCoreApproachSignal(self._context)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.approach.abort', *args)

    def approach(self, *args) -> Any:
        return self._context.call('root.core.approach.approach', *args)

    def withdraw(self, *args) -> Any:
        return self._context.call('root.core.approach.withdraw', *args)


class RootCoreCore_options(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options'


class RootCoreSignal_analyzer1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_analyzer1'


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.signal_analyzer1 = RootCoreSignal_analyzer1(self._context)
        self.core_options = RootCoreCore_options(self._context)
        self.approach = RootCoreApproach(self._context)
        self.approach_motors_drive = RootCoreApproach_motors_drive(self._context)
        self.core_environment = RootCoreCore_environment(self._context)
        self.direct_motor_control = RootCoreDirect_motor_control(self._context)
        self.converter_channel_correction = RootCoreConverter_channel_correction(self._context)
        self.ort = RootCoreOrt(self._context)
        self.frequency_sweep = RootCoreFrequency_sweep(self._context)
        self.z_controller = RootCoreZ_controller(self._context)
        self.thermal_tune = RootCoreThermal_tune(self._context)
        self.spectroscopy = RootCoreSpectroscopy(self._context)
        self.signal_store = RootCoreSignal_store(self._context)
        self.signal_registration = RootCoreSignal_registration(self._context)
        self.imaging = RootCoreImaging(self._context)
        self.scan_head_calibration = RootCoreScan_head_calibration(self._context)
        self.core_monitoring = RootCoreCore_monitoring(self._context)
        self.position_control = RootCorePosition_control(self._context)
        self.comp_dc = RootCoreComp_dc(self._context)
        self.acquisition = RootCoreAcquisition(self._context)
        self.oscilloscope = RootCoreOscilloscope(self._context)
        self.laser_align_drive_impl = RootCoreLaser_align_drive_impl(self._context)
        self.hv_amp_control = RootCoreHv_amp_control(self._context)
        self.core_cantilever = RootCoreCore_cantilever(self._context)


class RootLuCantilever_propertiesInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.busy'


class RootLuCantilever_propertiesInstanceAttributeAlign_strategy(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        search_for_reflecting_edges = 1
        standard = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.align_strategy'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuCantilever_propertiesInstanceAttributeAlign_strategy.ValueEnum(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.enum', list(new_val))


class RootLuCantilever_propertiesInstanceAttributeWidth(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.width'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.width.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.width.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.width.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.width.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.width.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.width.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.width.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.width.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeQ_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.q_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.q_factor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.q_factor.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.q_factor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.q_factor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.q_factor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.q_factor.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.q_factor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.q_factor.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeSpring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.spring_constant.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.spring_constant.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.spring_constant.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.spring_constant.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.spring_constant.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.spring_constant.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeResonance_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.resonance_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.resonance_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.resonance_frequency.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.resonance_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.resonance_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.resonance_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.resonance_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.resonance_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.resonance_frequency.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.deflection_sensitivity.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeTip_half_angle(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_half_angle'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_half_angle.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_half_angle.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_half_angle.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_half_angle.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_half_angle.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_half_angle.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_half_angle.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_half_angle.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeShape(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        triangular = 1
        rectangular = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.shape'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuCantilever_propertiesInstanceAttributeShape.ValueEnum(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.enum', list(new_val))


class RootLuCantilever_propertiesInstanceAttributeLength(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.length'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.length.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.length.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.length.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.length.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.length.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.length.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.length.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.length.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttributeTip_radius(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_radius'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_radius.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_radius.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_radius.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_radius.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_radius.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_radius.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.cantilever_properties.instance.attribute.tip_radius.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.cantilever_properties.instance.attribute.tip_radius.value', float(new_val))


class RootLuCantilever_propertiesInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute'
        self.tip_radius = RootLuCantilever_propertiesInstanceAttributeTip_radius(self._context)
        self.length = RootLuCantilever_propertiesInstanceAttributeLength(self._context)
        self.shape = RootLuCantilever_propertiesInstanceAttributeShape(self._context)
        self.tip_half_angle = RootLuCantilever_propertiesInstanceAttributeTip_half_angle(self._context)
        self.deflection_sensitivity = RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(self._context)
        self.resonance_frequency = RootLuCantilever_propertiesInstanceAttributeResonance_frequency(self._context)
        self.spring_constant = RootLuCantilever_propertiesInstanceAttributeSpring_constant(self._context)
        self.q_factor = RootLuCantilever_propertiesInstanceAttributeQ_factor(self._context)
        self.width = RootLuCantilever_propertiesInstanceAttributeWidth(self._context)
        self.align_strategy = RootLuCantilever_propertiesInstanceAttributeAlign_strategy(self._context)


class RootLuCantilever_propertiesInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.trigger'


class RootLuCantilever_propertiesInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance'
        self.trigger = RootLuCantilever_propertiesInstanceTrigger(self._context)
        self.attribute = RootLuCantilever_propertiesInstanceAttribute(self._context)
        self.busy = RootLuCantilever_propertiesInstanceBusy(self._context)


class RootLuCantilever_properties(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties'
        self.instance = RootLuCantilever_propertiesInstance(self._context)


class RootLuPid_controllerPid_user2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.busy'


class RootLuPid_controllerPid_user2AttributeP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.p_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.p_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.p_gain.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeMedian_filter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.median_filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeMedian_filter_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum', list(new_val))


class RootLuPid_controllerPid_user2AttributeReached_err_lim(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_err_lim'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_err_lim.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeCompare_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.compare_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.compare_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.compare_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.compare_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.compare_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.compare_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.compare_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.compare_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.compare_mode.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeSet_point_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.set_point_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_gain.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum', list(new_val))


class RootLuPid_controllerPid_user2AttributeFeedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.feedback_mode.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeSelect_output(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.select_output'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.select_output.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.select_output.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.select_output.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.select_output.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.select_output.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.select_output.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.select_output.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.select_output.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.min_value.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeReached_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_max.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeSet_point_modulation_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum', list(new_val))


class RootLuPid_controllerPid_user2AttributePolarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.polarity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.polarity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.polarity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.polarity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.polarity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.polarity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.polarity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.polarity.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.d_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.d_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.d_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.d_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.d_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.d_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.d_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.d_gain.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum', list(new_val))


class RootLuPid_controllerPid_user2AttributeReached_min(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_min'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_min.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_min.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_min.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_min.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_min.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_min.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.reached_min.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.reached_min.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.i_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.i_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.i_gain.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeSlope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.slope.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeMax_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.max_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.max_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.max_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.max_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.max_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.max_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.max_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.max_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.max_value.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeInput_actual(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_actual'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeInput_actual.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum', list(new_val))


class RootLuPid_controllerPid_user2AttributeError_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.error_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.error_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.error_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.error_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.error_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.error_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.error_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.error_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.error_limit.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeOffset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user2.attribute.offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user2.attribute.offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.offset.value', float(new_val))


class RootLuPid_controllerPid_user2AttributeInput_set_point(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_set_point'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user2AttributeInput_set_point.ValueEnum(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum', list(new_val))


class RootLuPid_controllerPid_user2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute'
        self.input_set_point = RootLuPid_controllerPid_user2AttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_user2AttributeOffset(self._context)
        self.error_limit = RootLuPid_controllerPid_user2AttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_user2AttributeInput_actual(self._context)
        self.max_value = RootLuPid_controllerPid_user2AttributeMax_value(self._context)
        self.slope = RootLuPid_controllerPid_user2AttributeSlope(self._context)
        self.i_gain = RootLuPid_controllerPid_user2AttributeI_gain(self._context)
        self.reached_min = RootLuPid_controllerPid_user2AttributeReached_min(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enable(self._context)
        self.d_gain = RootLuPid_controllerPid_user2AttributeD_gain(self._context)
        self.polarity = RootLuPid_controllerPid_user2AttributePolarity(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_user2AttributeSet_point_modulation_enable(self._context)
        self.reached_max = RootLuPid_controllerPid_user2AttributeReached_max(self._context)
        self.min_value = RootLuPid_controllerPid_user2AttributeMin_value(self._context)
        self.select_output = RootLuPid_controllerPid_user2AttributeSelect_output(self._context)
        self.feedback_mode = RootLuPid_controllerPid_user2AttributeFeedback_mode(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enable(self._context)
        self.set_point_gain = RootLuPid_controllerPid_user2AttributeSet_point_gain(self._context)
        self.compare_mode = RootLuPid_controllerPid_user2AttributeCompare_mode(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_user2AttributeReached_err_lim(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_user2AttributeMedian_filter_enable(self._context)
        self.p_gain = RootLuPid_controllerPid_user2AttributeP_gain(self._context)


class RootLuPid_controllerPid_user2TriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_user2TriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger.calibrate_offset'


class RootLuPid_controllerPid_user2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger'
        self.calibrate_offset = RootLuPid_controllerPid_user2TriggerCalibrate_offset(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_user2TriggerDrive_to_zero_volt_position(self._context)

    def clear_pid_accu(self) -> None:
        return self._context.call('root.lu.pid_controller.pid_user2.trigger.clear_pid_accu')


class RootLuPid_controllerPid_user2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2'
        self.trigger = RootLuPid_controllerPid_user2Trigger(self._context)
        self.attribute = RootLuPid_controllerPid_user2Attribute(self._context)
        self.busy = RootLuPid_controllerPid_user2Busy(self._context)


class RootLuPid_controllerPid_wBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.busy'


class RootLuPid_controllerPid_wAttributeP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.p_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.p_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.p_gain.value', float(new_val))


class RootLuPid_controllerPid_wAttributeMedian_filter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.median_filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.median_filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.median_filter_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeMedian_filter_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.median_filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.median_filter_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum', list(new_val))


class RootLuPid_controllerPid_wAttributeReached_err_lim(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_err_lim'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_err_lim.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_err_lim.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_err_lim.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_err_lim.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_err_lim.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_err_lim.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_err_lim.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_err_lim.value', float(new_val))


class RootLuPid_controllerPid_wAttributeCompare_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.compare_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.compare_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.compare_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.compare_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.compare_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.compare_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.compare_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.compare_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.compare_mode.value', float(new_val))


class RootLuPid_controllerPid_wAttributeSet_point_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.set_point_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_gain.value', float(new_val))


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum', list(new_val))


class RootLuPid_controllerPid_wAttributeFeedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.feedback_mode.value', float(new_val))


class RootLuPid_controllerPid_wAttributeSelect_output(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.select_output'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.select_output.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.select_output.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.select_output.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.select_output.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.select_output.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.select_output.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.select_output.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.select_output.value', float(new_val))


class RootLuPid_controllerPid_wAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.min_value.value', float(new_val))


class RootLuPid_controllerPid_wAttributeReached_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_max.value', float(new_val))


class RootLuPid_controllerPid_wAttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeSet_point_modulation_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum', list(new_val))


class RootLuPid_controllerPid_wAttributePolarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.polarity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.polarity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.polarity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.polarity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.polarity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.polarity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.polarity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.polarity.value', float(new_val))


class RootLuPid_controllerPid_wAttributeD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.d_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.d_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.d_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.d_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.d_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.d_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.d_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.d_gain.value', float(new_val))


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum', list(new_val))


class RootLuPid_controllerPid_wAttributeReached_min(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_min'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_min.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_min.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_min.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_min.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_min.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_min.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.reached_min.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.reached_min.value', float(new_val))


class RootLuPid_controllerPid_wAttributeI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.i_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.i_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.i_gain.value', float(new_val))


class RootLuPid_controllerPid_wAttributeSlope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.slope.value', float(new_val))


class RootLuPid_controllerPid_wAttributeMax_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.max_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.max_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.max_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.max_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.max_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.max_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.max_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.max_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.max_value.value', float(new_val))


class RootLuPid_controllerPid_wAttributeInput_actual(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_actual'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeInput_actual.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum', list(new_val))


class RootLuPid_controllerPid_wAttributeError_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.error_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.error_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.error_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.error_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.error_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.error_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.error_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.error_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.error_limit.value', float(new_val))


class RootLuPid_controllerPid_wAttributeOffset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_w.attribute.offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_w.attribute.offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_w.attribute.offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_w.attribute.offset.value', float(new_val))


class RootLuPid_controllerPid_wAttributeInput_set_point(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_set_point'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_wAttributeInput_set_point.ValueEnum(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum', list(new_val))


class RootLuPid_controllerPid_wAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute'
        self.input_set_point = RootLuPid_controllerPid_wAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_wAttributeOffset(self._context)
        self.error_limit = RootLuPid_controllerPid_wAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_wAttributeInput_actual(self._context)
        self.max_value = RootLuPid_controllerPid_wAttributeMax_value(self._context)
        self.slope = RootLuPid_controllerPid_wAttributeSlope(self._context)
        self.i_gain = RootLuPid_controllerPid_wAttributeI_gain(self._context)
        self.reached_min = RootLuPid_controllerPid_wAttributeReached_min(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enable(self._context)
        self.d_gain = RootLuPid_controllerPid_wAttributeD_gain(self._context)
        self.polarity = RootLuPid_controllerPid_wAttributePolarity(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_wAttributeSet_point_modulation_enable(self._context)
        self.reached_max = RootLuPid_controllerPid_wAttributeReached_max(self._context)
        self.min_value = RootLuPid_controllerPid_wAttributeMin_value(self._context)
        self.select_output = RootLuPid_controllerPid_wAttributeSelect_output(self._context)
        self.feedback_mode = RootLuPid_controllerPid_wAttributeFeedback_mode(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enable(self._context)
        self.set_point_gain = RootLuPid_controllerPid_wAttributeSet_point_gain(self._context)
        self.compare_mode = RootLuPid_controllerPid_wAttributeCompare_mode(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_wAttributeReached_err_lim(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_wAttributeMedian_filter_enable(self._context)
        self.p_gain = RootLuPid_controllerPid_wAttributeP_gain(self._context)


class RootLuPid_controllerPid_wTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_wTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger.calibrate_offset'


class RootLuPid_controllerPid_wTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger'
        self.calibrate_offset = RootLuPid_controllerPid_wTriggerCalibrate_offset(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_wTriggerDrive_to_zero_volt_position(self._context)

    def clear_pid_accu(self) -> None:
        return self._context.call('root.lu.pid_controller.pid_w.trigger.clear_pid_accu')


class RootLuPid_controllerPid_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w'
        self.trigger = RootLuPid_controllerPid_wTrigger(self._context)
        self.attribute = RootLuPid_controllerPid_wAttribute(self._context)
        self.busy = RootLuPid_controllerPid_wBusy(self._context)


class RootLuPid_controllerPid_user1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.busy'


class RootLuPid_controllerPid_user1AttributeP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.p_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.p_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.p_gain.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeMedian_filter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.median_filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeMedian_filter_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum', list(new_val))


class RootLuPid_controllerPid_user1AttributeReached_err_lim(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_err_lim'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_err_lim.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeCompare_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.compare_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.compare_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.compare_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.compare_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.compare_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.compare_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.compare_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.compare_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.compare_mode.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeSet_point_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.set_point_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_gain.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum', list(new_val))


class RootLuPid_controllerPid_user1AttributeFeedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.feedback_mode.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeSelect_output(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.select_output'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.select_output.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.select_output.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.select_output.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.select_output.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.select_output.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.select_output.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.select_output.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.select_output.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.min_value.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeReached_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_max.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeSet_point_modulation_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum', list(new_val))


class RootLuPid_controllerPid_user1AttributePolarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.polarity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.polarity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.polarity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.polarity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.polarity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.polarity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.polarity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.polarity.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.d_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.d_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.d_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.d_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.d_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.d_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.d_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.d_gain.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum', list(new_val))


class RootLuPid_controllerPid_user1AttributeReached_min(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_min'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_min.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_min.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_min.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_min.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_min.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_min.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.reached_min.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.reached_min.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.i_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.i_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.i_gain.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeSlope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.slope.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeMax_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.max_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.max_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.max_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.max_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.max_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.max_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.max_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.max_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.max_value.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeInput_actual(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_actual'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeInput_actual.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum', list(new_val))


class RootLuPid_controllerPid_user1AttributeError_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.error_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.error_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.error_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.error_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.error_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.error_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.error_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.error_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.error_limit.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeOffset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_user1.attribute.offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_user1.attribute.offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.offset.value', float(new_val))


class RootLuPid_controllerPid_user1AttributeInput_set_point(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_set_point'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_user1AttributeInput_set_point.ValueEnum(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum', list(new_val))


class RootLuPid_controllerPid_user1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute'
        self.input_set_point = RootLuPid_controllerPid_user1AttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_user1AttributeOffset(self._context)
        self.error_limit = RootLuPid_controllerPid_user1AttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_user1AttributeInput_actual(self._context)
        self.max_value = RootLuPid_controllerPid_user1AttributeMax_value(self._context)
        self.slope = RootLuPid_controllerPid_user1AttributeSlope(self._context)
        self.i_gain = RootLuPid_controllerPid_user1AttributeI_gain(self._context)
        self.reached_min = RootLuPid_controllerPid_user1AttributeReached_min(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enable(self._context)
        self.d_gain = RootLuPid_controllerPid_user1AttributeD_gain(self._context)
        self.polarity = RootLuPid_controllerPid_user1AttributePolarity(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_user1AttributeSet_point_modulation_enable(self._context)
        self.reached_max = RootLuPid_controllerPid_user1AttributeReached_max(self._context)
        self.min_value = RootLuPid_controllerPid_user1AttributeMin_value(self._context)
        self.select_output = RootLuPid_controllerPid_user1AttributeSelect_output(self._context)
        self.feedback_mode = RootLuPid_controllerPid_user1AttributeFeedback_mode(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enable(self._context)
        self.set_point_gain = RootLuPid_controllerPid_user1AttributeSet_point_gain(self._context)
        self.compare_mode = RootLuPid_controllerPid_user1AttributeCompare_mode(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_user1AttributeReached_err_lim(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_user1AttributeMedian_filter_enable(self._context)
        self.p_gain = RootLuPid_controllerPid_user1AttributeP_gain(self._context)


class RootLuPid_controllerPid_user1TriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_user1TriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger.calibrate_offset'


class RootLuPid_controllerPid_user1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger'
        self.calibrate_offset = RootLuPid_controllerPid_user1TriggerCalibrate_offset(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_user1TriggerDrive_to_zero_volt_position(self._context)

    def clear_pid_accu(self) -> None:
        return self._context.call('root.lu.pid_controller.pid_user1.trigger.clear_pid_accu')


class RootLuPid_controllerPid_user1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1'
        self.trigger = RootLuPid_controllerPid_user1Trigger(self._context)
        self.attribute = RootLuPid_controllerPid_user1Attribute(self._context)
        self.busy = RootLuPid_controllerPid_user1Busy(self._context)


class RootLuPid_controllerPid_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.busy'


class RootLuPid_controllerPid_yAttributeP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.p_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.p_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.p_gain.value', float(new_val))


class RootLuPid_controllerPid_yAttributeMedian_filter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.median_filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.median_filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.median_filter_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeMedian_filter_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.median_filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.median_filter_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum', list(new_val))


class RootLuPid_controllerPid_yAttributeReached_err_lim(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_err_lim'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_err_lim.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_err_lim.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_err_lim.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_err_lim.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_err_lim.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_err_lim.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_err_lim.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_err_lim.value', float(new_val))


class RootLuPid_controllerPid_yAttributeCompare_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.compare_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.compare_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.compare_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.compare_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.compare_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.compare_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.compare_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.compare_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.compare_mode.value', float(new_val))


class RootLuPid_controllerPid_yAttributeSet_point_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.set_point_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_gain.value', float(new_val))


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum', list(new_val))


class RootLuPid_controllerPid_yAttributeFeedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.feedback_mode.value', float(new_val))


class RootLuPid_controllerPid_yAttributeSelect_output(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.select_output'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.select_output.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.select_output.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.select_output.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.select_output.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.select_output.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.select_output.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.select_output.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.select_output.value', float(new_val))


class RootLuPid_controllerPid_yAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.min_value.value', float(new_val))


class RootLuPid_controllerPid_yAttributeReached_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_max.value', float(new_val))


class RootLuPid_controllerPid_yAttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeSet_point_modulation_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum', list(new_val))


class RootLuPid_controllerPid_yAttributePolarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.polarity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.polarity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.polarity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.polarity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.polarity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.polarity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.polarity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.polarity.value', float(new_val))


class RootLuPid_controllerPid_yAttributeD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.d_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.d_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.d_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.d_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.d_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.d_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.d_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.d_gain.value', float(new_val))


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum', list(new_val))


class RootLuPid_controllerPid_yAttributeReached_min(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_min'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_min.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_min.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_min.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_min.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_min.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_min.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.reached_min.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.reached_min.value', float(new_val))


class RootLuPid_controllerPid_yAttributeI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.i_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.i_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.i_gain.value', float(new_val))


class RootLuPid_controllerPid_yAttributeSlope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.slope.value', float(new_val))


class RootLuPid_controllerPid_yAttributeMax_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.max_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.max_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.max_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.max_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.max_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.max_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.max_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.max_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.max_value.value', float(new_val))


class RootLuPid_controllerPid_yAttributeInput_actual(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_actual'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeInput_actual.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum', list(new_val))


class RootLuPid_controllerPid_yAttributeError_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.error_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.error_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.error_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.error_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.error_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.error_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.error_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.error_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.error_limit.value', float(new_val))


class RootLuPid_controllerPid_yAttributeOffset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_y.attribute.offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_y.attribute.offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_y.attribute.offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_y.attribute.offset.value', float(new_val))


class RootLuPid_controllerPid_yAttributeInput_set_point(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_set_point'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_yAttributeInput_set_point.ValueEnum(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum', list(new_val))


class RootLuPid_controllerPid_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute'
        self.input_set_point = RootLuPid_controllerPid_yAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_yAttributeOffset(self._context)
        self.error_limit = RootLuPid_controllerPid_yAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_yAttributeInput_actual(self._context)
        self.max_value = RootLuPid_controllerPid_yAttributeMax_value(self._context)
        self.slope = RootLuPid_controllerPid_yAttributeSlope(self._context)
        self.i_gain = RootLuPid_controllerPid_yAttributeI_gain(self._context)
        self.reached_min = RootLuPid_controllerPid_yAttributeReached_min(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enable(self._context)
        self.d_gain = RootLuPid_controllerPid_yAttributeD_gain(self._context)
        self.polarity = RootLuPid_controllerPid_yAttributePolarity(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_yAttributeSet_point_modulation_enable(self._context)
        self.reached_max = RootLuPid_controllerPid_yAttributeReached_max(self._context)
        self.min_value = RootLuPid_controllerPid_yAttributeMin_value(self._context)
        self.select_output = RootLuPid_controllerPid_yAttributeSelect_output(self._context)
        self.feedback_mode = RootLuPid_controllerPid_yAttributeFeedback_mode(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enable(self._context)
        self.set_point_gain = RootLuPid_controllerPid_yAttributeSet_point_gain(self._context)
        self.compare_mode = RootLuPid_controllerPid_yAttributeCompare_mode(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_yAttributeReached_err_lim(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_yAttributeMedian_filter_enable(self._context)
        self.p_gain = RootLuPid_controllerPid_yAttributeP_gain(self._context)


class RootLuPid_controllerPid_yTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_yTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger.calibrate_offset'


class RootLuPid_controllerPid_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger'
        self.calibrate_offset = RootLuPid_controllerPid_yTriggerCalibrate_offset(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_yTriggerDrive_to_zero_volt_position(self._context)

    def clear_pid_accu(self) -> None:
        return self._context.call('root.lu.pid_controller.pid_y.trigger.clear_pid_accu')


class RootLuPid_controllerPid_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y'
        self.trigger = RootLuPid_controllerPid_yTrigger(self._context)
        self.attribute = RootLuPid_controllerPid_yAttribute(self._context)
        self.busy = RootLuPid_controllerPid_yBusy(self._context)


class RootLuPid_controllerPid_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.busy'


class RootLuPid_controllerPid_xAttributeP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.p_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.p_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.p_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.p_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.p_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.p_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.p_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.p_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.p_gain.value', float(new_val))


class RootLuPid_controllerPid_xAttributeMedian_filter_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.median_filter_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.median_filter_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.median_filter_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeMedian_filter_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.median_filter_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.median_filter_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum', list(new_val))


class RootLuPid_controllerPid_xAttributeReached_err_lim(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_err_lim'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_err_lim.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_err_lim.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_err_lim.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_err_lim.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_err_lim.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_err_lim.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_err_lim.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_err_lim.value', float(new_val))


class RootLuPid_controllerPid_xAttributeCompare_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.compare_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.compare_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.compare_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.compare_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.compare_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.compare_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.compare_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.compare_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.compare_mode.value', float(new_val))


class RootLuPid_controllerPid_xAttributeSet_point_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.set_point_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_gain.value', float(new_val))


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum', list(new_val))


class RootLuPid_controllerPid_xAttributeFeedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.feedback_mode.value', float(new_val))


class RootLuPid_controllerPid_xAttributeSelect_output(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.select_output'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.select_output.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.select_output.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.select_output.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.select_output.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.select_output.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.select_output.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.select_output.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.select_output.value', float(new_val))


class RootLuPid_controllerPid_xAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.min_value.value', float(new_val))


class RootLuPid_controllerPid_xAttributeReached_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_max.value', float(new_val))


class RootLuPid_controllerPid_xAttributeSet_point_modulation_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeSet_point_modulation_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum', list(new_val))


class RootLuPid_controllerPid_xAttributePolarity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.polarity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.polarity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.polarity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.polarity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.polarity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.polarity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.polarity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.polarity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.polarity.value', float(new_val))


class RootLuPid_controllerPid_xAttributeD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.d_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.d_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.d_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.d_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.d_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.d_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.d_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.d_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.d_gain.value', float(new_val))


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enable.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum', list(new_val))


class RootLuPid_controllerPid_xAttributeReached_min(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_min'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_min.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_min.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_min.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_min.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_min.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_min.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.reached_min.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.reached_min.value', float(new_val))


class RootLuPid_controllerPid_xAttributeI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.i_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.i_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.i_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.i_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.i_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.i_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.i_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.i_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.i_gain.value', float(new_val))


class RootLuPid_controllerPid_xAttributeSlope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.slope.value', float(new_val))


class RootLuPid_controllerPid_xAttributeMax_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.max_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.max_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.max_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.max_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.max_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.max_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.max_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.max_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.max_value.value', float(new_val))


class RootLuPid_controllerPid_xAttributeInput_actual(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_actual'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeInput_actual.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum', list(new_val))


class RootLuPid_controllerPid_xAttributeError_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.error_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.error_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.error_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.error_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.error_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.error_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.error_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.error_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.error_limit.value', float(new_val))


class RootLuPid_controllerPid_xAttributeOffset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.pid_controller.pid_x.attribute.offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.pid_controller.pid_x.attribute.offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.pid_controller.pid_x.attribute.offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.pid_controller.pid_x.attribute.offset.value', float(new_val))


class RootLuPid_controllerPid_xAttributeInput_set_point(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 0
        ctrl_z_sum = 44
        in_position_x = 20
        analyzer1_phase = 9
        memory_gen_position_y = 26
        ramp_gen_plane_z = 38
        memory_gen_drive_y = 27
        memory_gen_drive_z = 29
        memory_gen_out8 = 31
        analyzer1_amplitude = 8
        ort_baseline_corrected = 57
        analyzer2_y = 55
        in_tip_current = 7
        in6 = 23
        ramp_gen_position_y = 34
        analyzer1_ctrl_delta_f = 11
        ort_amplitude_reduction = 16
        ctrl_y_out = 48
        in_user2 = 4
        ctrl_z_out = 46
        ort_baseline = 56
        ctrl_z_error = 42
        analyzer1_y = 53
        in_user3 = 5
        ctrl_x_out = 47
        memory_gen_drive_x = 25
        analyzer1_reference = 63
        ctrl_z_pid_command = 43
        analyzer2_ctrl_amplitude = 14
        in_user4 = 6
        in_position_y = 21
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 10
        in_user1 = 3
        static = 17
        in_detector_sum = 22
        ramp_gen_user4 = 37
        ctrl_user2_out = 51
        ramp_gen_tip_voltage = 35
        ramp_gen_test = 19
        fast_in_user = 62
        in_position_z = 2
        ramp_gen_alternate_z = 36
        gen_test_dynamic = 18
        ramp_gen_max_z = 40
        ramp_gen_ctrl_z = 39
        analyzer2_amplitude = 12
        analyzer1_x = 52
        memory_gen_position_x = 24
        in_lateral = 1
        ctrl_z_nominal = 45
        ramp_gen_approach = 32
        fast_in_deflection = 60
        ramp_gen_position_x = 33
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 58
        analyzer2_phase = 13
        ort_adhesion_position = 59
        memory_gen_position_z = 28
        ctrl_w_out = 49
        analyzer2_ctrl_delta_f = 15
        fast_in2 = 61
        memory_gen_out7 = 30
        ctrl_user1_out = 50
        ctrl_z_in = 41
        analyzer2_x = 54

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_set_point'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuPid_controllerPid_xAttributeInput_set_point.ValueEnum(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum', list(new_val))


class RootLuPid_controllerPid_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute'
        self.input_set_point = RootLuPid_controllerPid_xAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_xAttributeOffset(self._context)
        self.error_limit = RootLuPid_controllerPid_xAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_xAttributeInput_actual(self._context)
        self.max_value = RootLuPid_controllerPid_xAttributeMax_value(self._context)
        self.slope = RootLuPid_controllerPid_xAttributeSlope(self._context)
        self.i_gain = RootLuPid_controllerPid_xAttributeI_gain(self._context)
        self.reached_min = RootLuPid_controllerPid_xAttributeReached_min(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enable(self._context)
        self.d_gain = RootLuPid_controllerPid_xAttributeD_gain(self._context)
        self.polarity = RootLuPid_controllerPid_xAttributePolarity(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_xAttributeSet_point_modulation_enable(self._context)
        self.reached_max = RootLuPid_controllerPid_xAttributeReached_max(self._context)
        self.min_value = RootLuPid_controllerPid_xAttributeMin_value(self._context)
        self.select_output = RootLuPid_controllerPid_xAttributeSelect_output(self._context)
        self.feedback_mode = RootLuPid_controllerPid_xAttributeFeedback_mode(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enable(self._context)
        self.set_point_gain = RootLuPid_controllerPid_xAttributeSet_point_gain(self._context)
        self.compare_mode = RootLuPid_controllerPid_xAttributeCompare_mode(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_xAttributeReached_err_lim(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_xAttributeMedian_filter_enable(self._context)
        self.p_gain = RootLuPid_controllerPid_xAttributeP_gain(self._context)


class RootLuPid_controllerPid_xTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_xTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger.calibrate_offset'


class RootLuPid_controllerPid_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger'
        self.calibrate_offset = RootLuPid_controllerPid_xTriggerCalibrate_offset(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_xTriggerDrive_to_zero_volt_position(self._context)

    def clear_pid_accu(self) -> None:
        return self._context.call('root.lu.pid_controller.pid_x.trigger.clear_pid_accu')


class RootLuPid_controllerPid_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x'
        self.trigger = RootLuPid_controllerPid_xTrigger(self._context)
        self.attribute = RootLuPid_controllerPid_xAttribute(self._context)
        self.busy = RootLuPid_controllerPid_xBusy(self._context)


class RootLuPid_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller'
        self.pid_x = RootLuPid_controllerPid_x(self._context)
        self.pid_y = RootLuPid_controllerPid_y(self._context)
        self.pid_user1 = RootLuPid_controllerPid_user1(self._context)
        self.pid_w = RootLuPid_controllerPid_w(self._context)
        self.pid_user2 = RootLuPid_controllerPid_user2(self._context)


class RootLuMainboard_relaysInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.busy'


class RootLuMainboard_relaysInstanceAttributeSet_state_mask(wrap.CmdTreeProp):

    class ValueMask(enum.IntEnum):
        hires_in_user4 = 128
        fast_out_user = 256
        hi_res_in6 = 1024
        fast_in_user = 512
        hires_out_user4 = 8
        dummy0 = 2048
        none = 0
        hires_out_user3 = 4
        hires_out_user2 = 2
        hires_out_user1 = 1
        all = 4095
        hires_in_user3 = 64
        hires_in_user1 = 16
        hires_in_user2 = 32

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw', int(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum', list(new_val))


class RootLuMainboard_relaysInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute'
        self.set_state_mask = RootLuMainboard_relaysInstanceAttributeSet_state_mask(self._context)


class RootLuMainboard_relaysInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.trigger'


class RootLuMainboard_relaysInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance'
        self.trigger = RootLuMainboard_relaysInstanceTrigger(self._context)
        self.attribute = RootLuMainboard_relaysInstanceAttribute(self._context)
        self.busy = RootLuMainboard_relaysInstanceBusy(self._context)


class RootLuMainboard_relays(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays'
        self.instance = RootLuMainboard_relaysInstance(self._context)


class RootLuRamp_generatorTestBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.test.busy.is_moving'))


class RootLuRamp_generatorTestAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorTestAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorTestAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorTestAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorTestAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorTestAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.test.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorTestAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTestAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.test.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.test.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.test.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum', list(new_val))


class RootLuRamp_generatorTestAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute'
        self.status = RootLuRamp_generatorTestAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorTestAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorTestAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTestAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorTestAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorTestAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorTestAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorTestAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorTestAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorTestAttributeMoving_speed(self._context)


class RootLuRamp_generatorTestTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.test.trigger.abort')


class RootLuRamp_generatorTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test'
        self.trigger = RootLuRamp_generatorTestTrigger(self._context)
        self.attribute = RootLuRamp_generatorTestAttribute(self._context)
        self.busy = RootLuRamp_generatorTestBusy(self._context)


class RootLuRamp_generatorUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user2.busy.is_moving'))


class RootLuRamp_generatorUser2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorUser2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorUser2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorUser2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorUser2AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser2AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser2AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user2.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute'
        self.status = RootLuRamp_generatorUser2AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorUser2AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser2AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorUser2AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorUser2AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorUser2AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser2AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorUser2AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorUser2AttributeMoving_speed(self._context)


class RootLuRamp_generatorUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user2.trigger.abort')


class RootLuRamp_generatorUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2'
        self.trigger = RootLuRamp_generatorUser2Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser2Attribute(self._context)
        self.busy = RootLuRamp_generatorUser2Busy(self._context)


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user1.busy.is_moving'))


class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.abort')


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.busy = RootLuRamp_generatorUser1Busy(self._context)


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.ctrl_z.busy.is_moving'))


class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.abort')


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual0.busy.is_moving'))


class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.abort')


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_x.busy.is_moving'))


class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.abort')


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)


class RootLuRamp_generatorVirtual2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual2.busy.is_moving'))


class RootLuRamp_generatorVirtual2AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual2AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual2AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual2AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute'
        self.status = RootLuRamp_generatorVirtual2AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual2AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual2AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorVirtual2AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual2AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual2AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual2AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorVirtual2AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual2AttributeMoving_speed(self._context)


class RootLuRamp_generatorVirtual2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual2.trigger.abort')


class RootLuRamp_generatorVirtual2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2'
        self.trigger = RootLuRamp_generatorVirtual2Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual2Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual2Busy(self._context)


class RootLuRamp_generatorAlternate_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.alternate_z.busy.is_moving'))


class RootLuRamp_generatorAlternate_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorAlternate_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorAlternate_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute'
        self.status = RootLuRamp_generatorAlternate_zAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorAlternate_zAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorAlternate_zAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorAlternate_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorAlternate_zAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorAlternate_zAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorAlternate_zAttributeMoving_speed(self._context)


class RootLuRamp_generatorAlternate_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.alternate_z.trigger.abort')


class RootLuRamp_generatorAlternate_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z'
        self.trigger = RootLuRamp_generatorAlternate_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorAlternate_zAttribute(self._context)
        self.busy = RootLuRamp_generatorAlternate_zBusy(self._context)


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual1.busy.is_moving'))


class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute'
        self.status = RootLuRamp_generatorVirtual1AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual1AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual1AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorVirtual1AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual1AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual1AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual1AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorVirtual1AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual1AttributeMoving_speed(self._context)


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.abort')


class RootLuRamp_generatorVirtual1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1'
        self.trigger = RootLuRamp_generatorVirtual1Trigger(self._context)
        self.attribute = RootLuRamp_generatorVirtual1Attribute(self._context)
        self.busy = RootLuRamp_generatorVirtual1Busy(self._context)


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.approach.busy.is_moving'))


class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum', list(new_val))


class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.abort')


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.busy = RootLuRamp_generatorApproachBusy(self._context)


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user4.busy.is_moving'))


class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.abort')


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.busy = RootLuRamp_generatorUser4Busy(self._context)


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.tip_voltage.busy.is_moving'))


class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.abort')


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)


class RootLuRamp_generatorPlane_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.plane_z.busy.is_moving'))


class RootLuRamp_generatorPlane_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPlane_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPlane_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute'
        self.status = RootLuRamp_generatorPlane_zAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorPlane_zAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPlane_zAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorPlane_zAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorPlane_zAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorPlane_zAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPlane_zAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorPlane_zAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorPlane_zAttributeMoving_speed(self._context)


class RootLuRamp_generatorPlane_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.plane_z.trigger.abort')


class RootLuRamp_generatorPlane_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z'
        self.trigger = RootLuRamp_generatorPlane_zTrigger(self._context)
        self.attribute = RootLuRamp_generatorPlane_zAttribute(self._context)
        self.busy = RootLuRamp_generatorPlane_zBusy(self._context)


class RootLuRamp_generatorPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_y.busy.is_moving'))


class RootLuRamp_generatorPosition_yAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stopped_by_external_event = 4
        reached_lower_limit = 2
        reached_upper_limit = 3
        is_moving = 0
        reached_endposition = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_yAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_y.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute'
        self.status = RootLuRamp_generatorPosition_yAttributeStatus(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_yAttributeEnd_value_mode(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_yAttributeEnd_value_relative(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(self._context)
        self.current_value = RootLuRamp_generatorPosition_yAttributeCurrent_value(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_yAttributeMoving_mode(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_yAttributeLower_limit(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_yAttributeUpper_limit(self._context)
        self.moving_time = RootLuRamp_generatorPosition_yAttributeMoving_time(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_yAttributeMoving_speed(self._context)


class RootLuRamp_generatorPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_y.trigger.abort')


class RootLuRamp_generatorPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y'
        self.trigger = RootLuRamp_generatorPosition_yTrigger(self._context)
        self.attribute = RootLuRamp_generatorPosition_yAttribute(self._context)
        self.busy = RootLuRamp_generatorPosition_yBusy(self._context)


class RootLuRamp_generator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator'
        self.position_y = RootLuRamp_generatorPosition_y(self._context)
        self.plane_z = RootLuRamp_generatorPlane_z(self._context)
        self.tip_voltage = RootLuRamp_generatorTip_voltage(self._context)
        self.user4 = RootLuRamp_generatorUser4(self._context)
        self.approach = RootLuRamp_generatorApproach(self._context)
        self.virtual1 = RootLuRamp_generatorVirtual1(self._context)
        self.alternate_z = RootLuRamp_generatorAlternate_z(self._context)
        self.virtual2 = RootLuRamp_generatorVirtual2(self._context)
        self.position_x = RootLuRamp_generatorPosition_x(self._context)
        self.virtual0 = RootLuRamp_generatorVirtual0(self._context)
        self.ctrl_z = RootLuRamp_generatorCtrl_z(self._context)
        self.user1 = RootLuRamp_generatorUser1(self._context)
        self.user2 = RootLuRamp_generatorUser2(self._context)
        self.test = RootLuRamp_generatorTest(self._context)


class RootLuMacro_cmdInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.busy'


class RootLuMacro_cmdInstanceAttributeI2_c_address(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_address'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_address.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_address.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_address.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_address.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_address.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_address.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_address.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_address.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeMo_move_stop_feedback_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_feedback_mode.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeMo_move_stop_value(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_off = 0
        z_on = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_value'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuMacro_cmdInstanceAttributeMo_move_stop_value.ValueEnum(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_value.enum', list(new_val))


class RootLuMacro_cmdInstanceAttributePause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.pause_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.pause_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.pause_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.pause_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.pause_time.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeAbsolute_y_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_y_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_y_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_y_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_y_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_y_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_y_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_y_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_y_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_y_pos.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.xy_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.xy_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.xy_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.xy_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.xy_move_speed.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeTarget_output_channel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.target_output_channel'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_output_channel.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_output_channel.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_output_channel.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_output_channel.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.target_output_channel.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_output_channel.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_output_channel.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_output_channel.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeTarget_z_ctrl_output_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.target_z_ctrl_output_mode.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeAbsolute_pos_mo(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_pos_mo'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_pos_mo.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeI2_c_bus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        aux = 1
        digital_io = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_bus'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_bus.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_bus.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuMacro_cmdInstanceAttributeI2_c_bus.ValueEnum(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_bus.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_bus.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_bus.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_bus.enum', list(new_val))


class RootLuMacro_cmdInstanceAttributeUser_event_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.user_event_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.user_event_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.user_event_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.user_event_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.user_event_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.user_event_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.user_event_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.user_event_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.user_event_id.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeRelative_pos_mo(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.relative_pos_mo'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.relative_pos_mo.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.relative_pos_mo.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.relative_pos_mo.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.relative_pos_mo.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.relative_pos_mo.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.relative_pos_mo.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.relative_pos_mo.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.relative_pos_mo.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeMo_move_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_greater_than = 1
        is_less_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuMacro_cmdInstanceAttributeMo_move_stop_mode.ValueEnum(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_stop_mode.enum', list(new_val))


class RootLuMacro_cmdInstanceAttributeI2_c_register(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_register'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_register.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_register.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_register.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_register.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_register.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_register.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_register.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_register.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeAbsolute_x_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.absolute_x_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_x_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_x_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_x_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_x_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_x_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_x_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.absolute_x_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.absolute_x_pos.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeSystem_abort_event_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.system_abort_event_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.system_abort_event_mask.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeModulation_output(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        external_z = 3
        tip_voltage = 2
        position_z = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.modulation_output'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.macro_cmd.instance.attribute.modulation_output.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.macro_cmd.instance.attribute.modulation_output.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuMacro_cmdInstanceAttributeModulation_output.ValueEnum(self._context.get('root.lu.macro_cmd.instance.attribute.modulation_output.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.macro_cmd.instance.attribute.modulation_output.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.macro_cmd.instance.attribute.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.macro_cmd.instance.attribute.modulation_output.enum', list(new_val))


class RootLuMacro_cmdInstanceAttributeMo_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.mo_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.mo_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.mo_move_speed.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeEnable_daq_sync_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.enable_daq_sync_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq_sync_end.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeEnable_daq(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.enable_daq'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.enable_daq.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.enable_daq.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeActive_sampler_set(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.active_sampler_set'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.active_sampler_set.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.active_sampler_set.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.active_sampler_set.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.active_sampler_set.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.active_sampler_set.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.active_sampler_set.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.active_sampler_set.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.active_sampler_set.value', float(new_val))


class RootLuMacro_cmdInstanceAttributeI2_c_data(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute.i2_c_data'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_data.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_data.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_data.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_data.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_data.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_data.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.macro_cmd.instance.attribute.i2_c_data.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.macro_cmd.instance.attribute.i2_c_data.value', float(new_val))


class RootLuMacro_cmdInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.attribute'
        self.i2_c_data = RootLuMacro_cmdInstanceAttributeI2_c_data(self._context)
        self.active_sampler_set = RootLuMacro_cmdInstanceAttributeActive_sampler_set(self._context)
        self.enable_daq = RootLuMacro_cmdInstanceAttributeEnable_daq(self._context)
        self.enable_daq_sync_end = RootLuMacro_cmdInstanceAttributeEnable_daq_sync_end(self._context)
        self.mo_move_speed = RootLuMacro_cmdInstanceAttributeMo_move_speed(self._context)
        self.modulation_output = RootLuMacro_cmdInstanceAttributeModulation_output(self._context)
        self.system_abort_event_mask = RootLuMacro_cmdInstanceAttributeSystem_abort_event_mask(self._context)
        self.absolute_x_pos = RootLuMacro_cmdInstanceAttributeAbsolute_x_pos(self._context)
        self.i2_c_register = RootLuMacro_cmdInstanceAttributeI2_c_register(self._context)
        self.mo_move_stop_mode = RootLuMacro_cmdInstanceAttributeMo_move_stop_mode(self._context)
        self.relative_pos_mo = RootLuMacro_cmdInstanceAttributeRelative_pos_mo(self._context)
        self.user_event_id = RootLuMacro_cmdInstanceAttributeUser_event_id(self._context)
        self.i2_c_bus = RootLuMacro_cmdInstanceAttributeI2_c_bus(self._context)
        self.absolute_pos_mo = RootLuMacro_cmdInstanceAttributeAbsolute_pos_mo(self._context)
        self.target_z_ctrl_output_mode = RootLuMacro_cmdInstanceAttributeTarget_z_ctrl_output_mode(self._context)
        self.target_output_channel = RootLuMacro_cmdInstanceAttributeTarget_output_channel(self._context)
        self.xy_move_speed = RootLuMacro_cmdInstanceAttributeXy_move_speed(self._context)
        self.absolute_y_pos = RootLuMacro_cmdInstanceAttributeAbsolute_y_pos(self._context)
        self.pause_time = RootLuMacro_cmdInstanceAttributePause_time(self._context)
        self.mo_move_stop_value = RootLuMacro_cmdInstanceAttributeMo_move_stop_value(self._context)
        self.mo_move_stop_feedback_mode = RootLuMacro_cmdInstanceAttributeMo_move_stop_feedback_mode(self._context)
        self.i2_c_address = RootLuMacro_cmdInstanceAttributeI2_c_address(self._context)


class RootLuMacro_cmdInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance.trigger'

    def user_abort(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.user_abort')

    def make_pause(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.make_pause')

    def move_to_abs_mo_pos(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_abs_mo_pos')

    def move_to_stop_value_mo(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_stop_value_mo')

    def activate_z_feedback(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.activate_z_feedback')

    def user_event(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.user_event')

    def write_i2_c_data(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.write_i2_c_data')

    def stop_z_feedback(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.stop_z_feedback')

    def move_to_abs_xy_pos(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_abs_xy_pos')

    def auto_recalibrate_probe(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.auto_recalibrate_probe')

    def move_to_rel_mo_pos(self) -> None:
        return self._context.call('root.lu.macro_cmd.instance.trigger.move_to_rel_mo_pos')


class RootLuMacro_cmdInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd.instance'
        self.trigger = RootLuMacro_cmdInstanceTrigger(self._context)
        self.attribute = RootLuMacro_cmdInstanceAttribute(self._context)
        self.busy = RootLuMacro_cmdInstanceBusy(self._context)


class RootLuMacro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.macro_cmd'
        self.instance = RootLuMacro_cmdInstance(self._context)


class RootLuComp_dcInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.busy'


class RootLuComp_dcInstanceAttributeCoefficient_index(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.coefficient_index'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.coefficient_index.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.coefficient_index.value', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_x.value', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_z.value', float(new_val))


class RootLuComp_dcInstanceAttributeComp_dc_gain_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.comp_dc.instance.attribute.comp_dc_gain_y.value', float(new_val))


class RootLuComp_dcInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute'
        self.comp_dc_gain_y = RootLuComp_dcInstanceAttributeComp_dc_gain_y(self._context)
        self.comp_dc_gain_z = RootLuComp_dcInstanceAttributeComp_dc_gain_z(self._context)
        self.comp_dc_gain_x = RootLuComp_dcInstanceAttributeComp_dc_gain_x(self._context)
        self.coefficient_index = RootLuComp_dcInstanceAttributeCoefficient_index(self._context)


class RootLuComp_dcInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger'

    def start_comp_dc_calibration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.start_comp_dc_calibration')

    def apply_new_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.apply_new_configuration')

    def apply_new_nonlinear_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.apply_new_nonlinear_configuration')

    def user_abort(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.user_abort')

    def read_current_configuration(self) -> None:
        return self._context.call('root.lu.comp_dc.instance.trigger.read_current_configuration')


class RootLuComp_dcInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance'
        self.trigger = RootLuComp_dcInstanceTrigger(self._context)
        self.attribute = RootLuComp_dcInstanceAttribute(self._context)
        self.busy = RootLuComp_dcInstanceBusy(self._context)


class RootLuComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc'
        self.instance = RootLuComp_dcInstance(self._context)


class RootLuAnalog_hi_res_outPosition_wBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.busy'


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_wAttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_w.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_wAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outPosition_wAttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outPosition_wAttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outPosition_wAttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outPosition_wAttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outPosition_wAttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outPosition_wAttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outPosition_wAttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outPosition_wAttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outPosition_wAttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outPosition_wAttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outPosition_wAttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outPosition_wAttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outPosition_wAttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outPosition_wAttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outPosition_wAttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outPosition_wAttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outPosition_wAttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outPosition_wAttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outPosition_wTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w.trigger'


class RootLuAnalog_hi_res_outPosition_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_w'
        self.trigger = RootLuAnalog_hi_res_outPosition_wTrigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outPosition_wAttribute(self._context)
        self.busy = RootLuAnalog_hi_res_outPosition_wBusy(self._context)


class RootLuAnalog_hi_res_outUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.busy'


class RootLuAnalog_hi_res_outUser2AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser2AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser2AttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outUser2AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser2AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user2.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user2.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user2.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outUser2AttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outUser2AttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outUser2AttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outUser2AttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outUser2AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outUser2AttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outUser2AttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outUser2AttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outUser2AttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outUser2AttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outUser2AttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outUser2AttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outUser2AttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outUser2AttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outUser2AttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outUser2AttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outUser2AttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outUser2AttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2.trigger'


class RootLuAnalog_hi_res_outUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user2'
        self.trigger = RootLuAnalog_hi_res_outUser2Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outUser2Attribute(self._context)
        self.busy = RootLuAnalog_hi_res_outUser2Busy(self._context)


class RootLuAnalog_hi_res_outOut8Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.busy'


class RootLuAnalog_hi_res_outOut8AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outOut8AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut8AttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outOut8AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outOut8AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out8.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out8.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out8.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outOut8Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outOut8AttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outOut8AttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outOut8AttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outOut8AttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outOut8AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outOut8AttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outOut8AttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outOut8AttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outOut8AttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outOut8AttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outOut8AttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outOut8AttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outOut8AttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outOut8AttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outOut8AttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outOut8AttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outOut8AttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outOut8AttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outOut8Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8.trigger'


class RootLuAnalog_hi_res_outOut8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out8'
        self.trigger = RootLuAnalog_hi_res_outOut8Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outOut8Attribute(self._context)
        self.busy = RootLuAnalog_hi_res_outOut8Busy(self._context)


class RootLuAnalog_hi_res_outUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.busy'


class RootLuAnalog_hi_res_outUser1AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser1AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser1AttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outUser1AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser1AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user1.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user1.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user1.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outUser1AttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outUser1AttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outUser1AttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outUser1AttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outUser1AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outUser1AttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outUser1AttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outUser1AttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outUser1AttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outUser1AttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outUser1AttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outUser1AttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outUser1AttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outUser1AttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outUser1AttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outUser1AttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outUser1AttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outUser1AttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1.trigger'


class RootLuAnalog_hi_res_outUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user1'
        self.trigger = RootLuAnalog_hi_res_outUser1Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outUser1Attribute(self._context)
        self.busy = RootLuAnalog_hi_res_outUser1Busy(self._context)


class RootLuAnalog_hi_res_outPosition_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.busy'


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outPosition_zAttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.position_z.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outPosition_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outPosition_zAttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outPosition_zAttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outPosition_zAttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outPosition_zAttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outPosition_zAttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outPosition_zAttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outPosition_zAttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outPosition_zAttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outPosition_zAttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outPosition_zAttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outPosition_zAttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outPosition_zAttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outPosition_zAttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outPosition_zAttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outPosition_zAttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outPosition_zAttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outPosition_zAttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outPosition_zAttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outPosition_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z.trigger'


class RootLuAnalog_hi_res_outPosition_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_z'
        self.trigger = RootLuAnalog_hi_res_outPosition_zTrigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outPosition_zAttribute(self._context)
        self.busy = RootLuAnalog_hi_res_outPosition_zBusy(self._context)


class RootLuAnalog_hi_res_outUser3Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.busy'


class RootLuAnalog_hi_res_outUser3AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser3AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser3AttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outUser3AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser3AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user3.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user3.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user3.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outUser3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outUser3AttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outUser3AttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outUser3AttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outUser3AttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outUser3AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outUser3AttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outUser3AttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outUser3AttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outUser3AttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outUser3AttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outUser3AttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outUser3AttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outUser3AttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outUser3AttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outUser3AttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outUser3AttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outUser3AttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outUser3AttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outUser3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3.trigger'


class RootLuAnalog_hi_res_outUser3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user3'
        self.trigger = RootLuAnalog_hi_res_outUser3Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outUser3Attribute(self._context)
        self.busy = RootLuAnalog_hi_res_outUser3Busy(self._context)


class RootLuAnalog_hi_res_outOut7Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.busy'


class RootLuAnalog_hi_res_outOut7AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outOut7AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outOut7AttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outOut7AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outOut7AttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.out7.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.out7.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.out7.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outOut7Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outOut7AttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outOut7AttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outOut7AttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outOut7AttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outOut7AttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outOut7AttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outOut7AttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outOut7AttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outOut7AttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outOut7AttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outOut7AttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outOut7AttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outOut7AttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outOut7AttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outOut7AttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outOut7AttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outOut7AttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outOut7AttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outOut7Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7.trigger'


class RootLuAnalog_hi_res_outOut7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.out7'
        self.trigger = RootLuAnalog_hi_res_outOut7Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outOut7Attribute(self._context)
        self.busy = RootLuAnalog_hi_res_outOut7Busy(self._context)


class RootLuAnalog_hi_res_outApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.busy'


class RootLuAnalog_hi_res_outApproachAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outApproachAttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeGlitch_corr_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        enabled = 1
        disabled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeGlitch_corr_enabled.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.glitch_corr_enabled.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCalib_sig_source_dir(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        from_output_to_input = 0
        from_input_to_output = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeCalib_sig_source_dir.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_sig_source_dir.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeModulation(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        analyzer2_reference = 0
        ort_excitation = 2
        hi_res_signal = 3
        disabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.modulation'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outApproachAttributeModulation.ValueEnum(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.modulation.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.modulation.enum', list(new_val))


class RootLuAnalog_hi_res_outApproachAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.filter_coeff_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeOutput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.output_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.output_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.output_offset.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCalib_lo_word_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_gain.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCalib_lo_word_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.calib_lo_word_delay.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeStatic_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.static_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.static_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.static_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.static_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.static_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.static_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.static_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.static_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.static_value.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttributeCurrent_output_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute.current_output_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.current_output_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.current_output_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.current_output_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.current_output_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.approach.attribute.current_output_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.current_output_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.approach.attribute.current_output_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.approach.attribute.current_output_value.value', float(new_val))


class RootLuAnalog_hi_res_outApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.attribute'
        self.current_output_value = RootLuAnalog_hi_res_outApproachAttributeCurrent_output_value(self._context)
        self.static_value = RootLuAnalog_hi_res_outApproachAttributeStatic_value(self._context)
        self.calib_lo_word_delay = RootLuAnalog_hi_res_outApproachAttributeCalib_lo_word_delay(self._context)
        self.calib_lo_word_gain = RootLuAnalog_hi_res_outApproachAttributeCalib_lo_word_gain(self._context)
        self.output_offset = RootLuAnalog_hi_res_outApproachAttributeOutput_offset(self._context)
        self.calib_gain = RootLuAnalog_hi_res_outApproachAttributeCalib_gain(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_outApproachAttributeFilter_coeff_vec(self._context)
        self.modulation = RootLuAnalog_hi_res_outApproachAttributeModulation(self._context)
        self.calib_sig_source_dir = RootLuAnalog_hi_res_outApproachAttributeCalib_sig_source_dir(self._context)
        self.glitch_corr_enabled = RootLuAnalog_hi_res_outApproachAttributeGlitch_corr_enabled(self._context)
        self.filter_number = RootLuAnalog_hi_res_outApproachAttributeFilter_number(self._context)
        self.output_gain = RootLuAnalog_hi_res_outApproachAttributeOutput_gain(self._context)
        self.slew_rate = RootLuAnalog_hi_res_outApproachAttributeSlew_rate(self._context)
        self.calib_offset = RootLuAnalog_hi_res_outApproachAttributeCalib_offset(self._context)
        self.modulation_input = RootLuAnalog_hi_res_outApproachAttributeModulation_input(self._context)
        self.input = RootLuAnalog_hi_res_outApproachAttributeInput(self._context)
        self.glitch_corr_binary_vec = RootLuAnalog_hi_res_outApproachAttributeGlitch_corr_binary_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_outApproachAttributeCalib_polarity(self._context)


class RootLuAnalog_hi_res_outApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach.trigger'


class RootLuAnalog_hi_res_outApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.approach'
        self.trigger = RootLuAnalog_hi_res_outApproachTrigger(self._context)
        self.attribute = RootLuAnalog_hi_res_outApproachAttribute(self._context)
        self.busy = RootLuAnalog_hi_res_outApproachBusy(self._context)


class RootLuAnalog_hi_res_outUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.busy'


class RootLuAnalog_hi_res_outUser4AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser4AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_outUser4AttributeGlitch_corr_binary_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.max', float(new_val))

    @property
    def vector(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.vector'))

    @vector.setter
    def vector(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.vector', list(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.glitch_corr_binary_vec.unit', str(new_val))


class RootLuAnalog_hi_res_outUser4AttributeInput(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user4.attribute.input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser4AttributeInput.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user4.attribute.input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user4.attribute.input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser4AttributeModulation_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        in_deflection = 3
        ctrl_z_sum = 26
        in_position_x = 5
        analyzer1_phase = 36
        memory_gen_position_y = 53
        ramp_gen_plane_z = 20
        memory_gen_drive_y = 54
        memory_gen_drive_z = 56
        memory_gen_out8 = 58
        analyzer1_amplitude = 37
        ort_baseline_corrected = 47
        analyzer2_y = 45
        in_tip_current = 12
        in6 = 14
        ramp_gen_position_y = 17
        analyzer1_ctrl_delta_f = 34
        ort_amplitude_reduction = 48
        ctrl_y_out = 30
        in_user2 = 9
        ctrl_z_out = 28
        ort_baseline = 46
        ctrl_z_error = 24
        analyzer1_y = 39
        in_user3 = 10
        ctrl_x_out = 29
        memory_gen_drive_x = 52
        analyzer1_reference = 63
        ctrl_z_pid_command = 25
        analyzer2_ctrl_amplitude = 41
        in_user4 = 11
        in_position_y = 6
        ort_free_wave = 66
        analyzer1_ctrl_amplitude = 35
        in_user1 = 8
        static = 0
        in_detector_sum = 13
        ramp_gen_user4 = 59
        ctrl_user2_out = 33
        ramp_gen_tip_voltage = 18
        ramp_gen_test = 2
        fast_in_user = 62
        in_position_z = 7
        ramp_gen_alternate_z = 19
        gen_test_dynamic = 1
        ramp_gen_max_z = 22
        ramp_gen_ctrl_z = 21
        analyzer2_amplitude = 43
        analyzer1_x = 38
        memory_gen_position_x = 51
        in_lateral = 4
        ctrl_z_nominal = 27
        ramp_gen_approach = 15
        fast_in_deflection = 60
        ramp_gen_position_x = 16
        ort_excitation = 65
        analyzer2_reference = 64
        ort_adhesion_value = 49
        analyzer2_phase = 42
        ort_adhesion_position = 50
        memory_gen_position_z = 55
        ctrl_w_out = 31
        analyzer2_ctrl_delta_f = 40
        fast_in2 = 61
        memory_gen_out7 = 57
        ctrl_user1_out = 32
        ctrl_z_in = 23
        analyzer2_x = 44

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.modulation_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.user4.attribute.modulation_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.modulation_input.value_raw', int(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_outUser4AttributeModulation_input.ValueEnum(self._context.get('root.lu.analog_hi_res_out.user4.attribute.modulation_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.modulation_input.value_raw', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_out.user4.attribute.modulation_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.modulation_input.enum', list(new_val))


class RootLuAnalog_hi_res_outUser4AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_outUser4AttributeSlew_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.slew_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.slew_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.slew_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.slew_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.slew_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user4.attribute.slew_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.slew_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.slew_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.slew_rate.value', float(new_val))


class RootLuAnalog_hi_res_outUser4AttributeOutput_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.output_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.output_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.output_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.output_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.output_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user4.attribute.output_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.output_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.output_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.output_gain.value', float(new_val))


class RootLuAnalog_hi_res_outUser4AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.user4.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_out.user4.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_out.user4.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_out.user4.attribute.filter_number.value', float(new_v