# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'e4f686ead150a3611dcbc3fc9a3dfce4'
g_compiler_version = '2.0'

class RootSession(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.session'

    def select(self, *args) -> Any:
        return self._context.call('root.session.select', *args)

    def list(self, *args) -> Any:
        return self._context.call('root.session.list', *args)

    def select_main(self, *args) -> Any:
        return self._context.call('root.session.select_main', *args)

    @property
    def name(self) -> str:
        return str(self._context.get('root.session.name'))

    @name.setter
    def name(self, new_val:str):
        self._context.set('root.session.name', str(new_val))

    @property
    def current_connection(self) -> str:
        return str(self._context.get('root.session.current_connection'))

    @current_connection.setter
    def current_connection(self, new_val:str):
        self._context.set('root.session.current_connection', str(new_val))


class RootTestTabel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test.tabel'


class RootTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test'
        self.tabel = RootTestTabel(self._context)

    @property
    def str(self) -> str:
        return str(self._context.get('root.test.str'))

    @str.setter
    def str(self, new_val:str):
        self._context.set('root.test.str', str(new_val))

    @property
    def bool(self) -> bool:
        return bool(self._context.get('root.test.bool'))

    @bool.setter
    def bool(self, new_val:bool):
        self._context.set('root.test.bool', bool(new_val))

    @property
    def num_f(self) -> float:
        return float(self._context.get('root.test.num_f'))

    @num_f.setter
    def num_f(self, new_val:float):
        self._context.set('root.test.num_f', float(new_val))

    @property
    def num_i(self) -> int:
        return int(self._context.get('root.test.num_i'))

    @num_i.setter
    def num_i(self, new_val:int):
        self._context.set('root.test.num_i', int(new_val))

    def func(self, *args) -> Any:
        return self._context.call('root.test.func', *args)


class RootWorkflowManager(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow.manager'

    @property
    def session_name(self) -> str:
        return str(self._context.get('root.workflow.manager.session_name'))

    @session_name.setter
    def session_name(self, new_val:str):
        self._context.set('root.workflow.manager.session_name', str(new_val))


class RootWorkflowHardware_detection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow.hardware_detection'


class RootWorkflowCamera(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow.camera'


class RootWorkflowWorkflow_log_buffer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow.workflow_log_buffer'


class RootWorkflowCantilever_browser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow.cantilever_browser'


class RootWorkflow(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.workflow'
        self.cantilever_browser = RootWorkflowCantilever_browser(self._context)
        self.workflow_log_buffer = RootWorkflowWorkflow_log_buffer(self._context)
        self.camera = RootWorkflowCamera(self._context)
        self.hardware_detection = RootWorkflowHardware_detection(self._context)
        self.manager = RootWorkflowManager(self._context)


class RootCoreHw_modules(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hw_modules'


class RootCoreScript_server(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.script_server'


class RootCoreCamera(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.camera'


class RootCoreI2c(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.i2c'


class RootCoreStorage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.storage'

    def open_file(self, *args) -> Any:
        return self._context.call('root.core.storage.open_file', *args)

    def close_file(self, *args) -> Any:
        return self._context.call('root.core.storage.close_file', *args)

    def is_file_open(self, *args) -> Any:
        return self._context.call('root.core.storage.is_file_open', *args)


class RootCoreSpm_controller_discovery(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spm_controller_discovery'


class RootCoreVshi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.vshi'


class RootCoreCore_options_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options_store'


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.core_options_store = RootCoreCore_options_store(self._context)
        self.vshi = RootCoreVshi(self._context)
        self.spm_controller_discovery = RootCoreSpm_controller_discovery(self._context)
        self.storage = RootCoreStorage(self._context)
        self.i2c = RootCoreI2c(self._context)
        self.camera = RootCoreCamera(self._context)
        self.script_server = RootCoreScript_server(self._context)
        self.hw_modules = RootCoreHw_modules(self._context)


class RootLuAnalog_fast_inUserTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.trigger'


class RootLuAnalog_fast_inUserAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_polarity.enum'

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.calib_polarity.enum.positive', int(new_val))

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.calib_polarity.enum.negative', int(new_val))


class RootLuAnalog_fast_inUserAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_polarity'
        self.enum = RootLuAnalog_fast_inUserAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_fast_inUserAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_offset'


class RootLuAnalog_fast_inUserAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_fast_inUserAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.input_offset'


class RootLuAnalog_fast_inUserAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.input_gain'


class RootLuAnalog_fast_inUserAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id.enum.self', int(new_val))


class RootLuAnalog_fast_inUserAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_fast_inUserAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_fast_inUserAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.current_input_value'


class RootLuAnalog_fast_inUserAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute.calib_gain'


class RootLuAnalog_fast_inUserAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user.attribute'
        self.calib_gain = RootLuAnalog_fast_inUserAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_fast_inUserAttributeCurrent_input_value(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inUserAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_fast_inUserAttributeInput_gain(self._context)
        self.input_offset = RootLuAnalog_fast_inUserAttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inUserAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_fast_inUserAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_fast_inUserAttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inUser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.user'
        self.attribute = RootLuAnalog_fast_inUserAttribute(self._context)
        self.trigger = RootLuAnalog_fast_inUserTrigger(self._context)


class RootLuAnalog_fast_inDeflectionTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.trigger'


class RootLuAnalog_fast_inDeflectionAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_polarity.enum'

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.calib_polarity.enum.positive', int(new_val))

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.calib_polarity.enum.negative', int(new_val))


class RootLuAnalog_fast_inDeflectionAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_polarity'
        self.enum = RootLuAnalog_fast_inDeflectionAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_fast_inDeflectionAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_offset'


class RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_fast_inDeflectionAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.input_offset'


class RootLuAnalog_fast_inDeflectionAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.input_gain'


class RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id.enum.self', int(new_val))


class RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_fast_inDeflectionAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.current_input_value'


class RootLuAnalog_fast_inDeflectionAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute.calib_gain'


class RootLuAnalog_fast_inDeflectionAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection.attribute'
        self.calib_gain = RootLuAnalog_fast_inDeflectionAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_fast_inDeflectionAttributeCurrent_input_value(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_fast_inDeflectionAttributeInput_gain(self._context)
        self.input_offset = RootLuAnalog_fast_inDeflectionAttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inDeflectionAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_fast_inDeflectionAttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_fast_inDeflectionAttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inDeflection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.deflection'
        self.attribute = RootLuAnalog_fast_inDeflectionAttribute(self._context)
        self.trigger = RootLuAnalog_fast_inDeflectionTrigger(self._context)


class RootLuAnalog_fast_inCh2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.trigger'


class RootLuAnalog_fast_inCh2AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_polarity.enum'

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.calib_polarity.enum.positive', int(new_val))

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.calib_polarity.enum.negative', int(new_val))


class RootLuAnalog_fast_inCh2AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_polarity'
        self.enum = RootLuAnalog_fast_inCh2AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_fast_inCh2AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_offset'


class RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_fast_inCh2AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.input_offset'


class RootLuAnalog_fast_inCh2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.input_gain'


class RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id.enum.self', int(new_val))


class RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_fast_inCh2AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.current_input_value'


class RootLuAnalog_fast_inCh2AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute.calib_gain'


class RootLuAnalog_fast_inCh2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2.attribute'
        self.calib_gain = RootLuAnalog_fast_inCh2AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_fast_inCh2AttributeCurrent_input_value(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_fast_inCh2AttributeInput_gain(self._context)
        self.input_offset = RootLuAnalog_fast_inCh2AttributeInput_offset(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_fast_inCh2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_fast_inCh2AttributeCalib_offset(self._context)
        self.calib_polarity = RootLuAnalog_fast_inCh2AttributeCalib_polarity(self._context)


class RootLuAnalog_fast_inCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in.ch2'
        self.attribute = RootLuAnalog_fast_inCh2Attribute(self._context)
        self.trigger = RootLuAnalog_fast_inCh2Trigger(self._context)


class RootLuAnalog_fast_in(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_fast_in'
        self.ch2 = RootLuAnalog_fast_inCh2(self._context)
        self.deflection = RootLuAnalog_fast_inDeflection(self._context)
        self.user = RootLuAnalog_fast_inUser(self._context)


class RootLuDigi_user_ioInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.trigger'


class RootLuDigi_user_ioInstanceAttributeDigi_out2_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_enable.enum.disabled', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_enable'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_enableEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_event_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_approach_done', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.timer_dbg1_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event0_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_event_source.enum.comparator3_true', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_event_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_event_source'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_event_sourceEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_in2_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in2_level.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.low', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in2_level.enum.high', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_in2_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in2_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_in2_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_pulseEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum'

    @property
    def t0_5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t0_5_us'))

    @t0_5_us.setter
    def t0_5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t0_5_us', int(new_val))

    @property
    def t50_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t50_us'))

    @t50_us.setter
    def t50_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t50_us', int(new_val))

    @property
    def t500_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t500_us'))

    @t500_us.setter
    def t500_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t500_us', int(new_val))

    @property
    def t20_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t20_ms'))

    @t20_ms.setter
    def t20_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t20_ms', int(new_val))

    @property
    def t5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_us'))

    @t5_us.setter
    def t5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_us', int(new_val))

    @property
    def t5_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_ms'))

    @t5_ms.setter
    def t5_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_pulse.enum.t5_ms', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_pulse'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_pulseEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_pulseEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum'

    @property
    def t0_5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t0_5_us'))

    @t0_5_us.setter
    def t0_5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t0_5_us', int(new_val))

    @property
    def t50_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t50_us'))

    @t50_us.setter
    def t50_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t50_us', int(new_val))

    @property
    def t500_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t500_us'))

    @t500_us.setter
    def t500_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t500_us', int(new_val))

    @property
    def t20_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t20_ms'))

    @t20_ms.setter
    def t20_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t20_ms', int(new_val))

    @property
    def t5_us(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_us'))

    @t5_us.setter
    def t5_us(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_us', int(new_val))

    @property
    def t5_ms(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_ms'))

    @t5_ms.setter
    def t5_ms(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_pulse.enum.t5_ms', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_pulse'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_pulseEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_enable.enum.disabled', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_enable'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_enableEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_event_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_approach_done', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.timer_dbg1_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event0_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_event_source.enum.comparator3_true', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_event_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_event_source'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_event_sourceEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum'

    @property
    def static_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.static_level'))

    @static_level.setter
    def static_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.static_level', int(new_val))

    @property
    def event_rising_and_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_and_falling_edge_pulse'))

    @event_rising_and_falling_edge_pulse.setter
    def event_rising_and_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_and_falling_edge_pulse', int(new_val))

    @property
    def event_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_falling_edge_pulse'))

    @event_falling_edge_pulse.setter
    def event_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_falling_edge_pulse', int(new_val))

    @property
    def event_rising_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_edge_pulse'))

    @event_rising_edge_pulse.setter
    def event_rising_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_rising_edge_pulse', int(new_val))

    @property
    def event_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_level'))

    @event_level.setter
    def event_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_mode.enum.event_level', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_mode'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_modeEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_level.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.low', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_level.enum.high', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out1_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum'

    @property
    def static_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.static_level'))

    @static_level.setter
    def static_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.static_level', int(new_val))

    @property
    def event_rising_and_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_and_falling_edge_pulse'))

    @event_rising_and_falling_edge_pulse.setter
    def event_rising_and_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_and_falling_edge_pulse', int(new_val))

    @property
    def event_falling_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_falling_edge_pulse'))

    @event_falling_edge_pulse.setter
    def event_falling_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_falling_edge_pulse', int(new_val))

    @property
    def event_rising_edge_pulse(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_edge_pulse'))

    @event_rising_edge_pulse.setter
    def event_rising_edge_pulse(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_rising_edge_pulse', int(new_val))

    @property
    def event_level(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_level'))

    @event_level.setter
    def event_level(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out1_mode.enum.event_level', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out1_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out1_mode'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out1_modeEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_out2_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_level.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.low', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_out2_level.enum.high', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_out2_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_out2_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_out2_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttributeDigi_in1_levelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in1_level.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.low', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.digi_user_io.instance.attribute.digi_in1_level.enum.high', int(new_val))


class RootLuDigi_user_ioInstanceAttributeDigi_in1_level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute.digi_in1_level'
        self.enum = RootLuDigi_user_ioInstanceAttributeDigi_in1_levelEnum(self._context)


class RootLuDigi_user_ioInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance.attribute'
        self.digi_in1_level = RootLuDigi_user_ioInstanceAttributeDigi_in1_level(self._context)
        self.digi_out2_level = RootLuDigi_user_ioInstanceAttributeDigi_out2_level(self._context)
        self.digi_out1_mode = RootLuDigi_user_ioInstanceAttributeDigi_out1_mode(self._context)
        self.digi_out1_level = RootLuDigi_user_ioInstanceAttributeDigi_out1_level(self._context)
        self.digi_out2_mode = RootLuDigi_user_ioInstanceAttributeDigi_out2_mode(self._context)
        self.digi_out1_event_source = RootLuDigi_user_ioInstanceAttributeDigi_out1_event_source(self._context)
        self.digi_out1_enable = RootLuDigi_user_ioInstanceAttributeDigi_out1_enable(self._context)
        self.digi_out1_pulse = RootLuDigi_user_ioInstanceAttributeDigi_out1_pulse(self._context)
        self.digi_out2_pulse = RootLuDigi_user_ioInstanceAttributeDigi_out2_pulse(self._context)
        self.digi_in2_level = RootLuDigi_user_ioInstanceAttributeDigi_in2_level(self._context)
        self.digi_out2_event_source = RootLuDigi_user_ioInstanceAttributeDigi_out2_event_source(self._context)
        self.digi_out2_enable = RootLuDigi_user_ioInstanceAttributeDigi_out2_enable(self._context)


class RootLuDigi_user_ioInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io.instance'
        self.attribute = RootLuDigi_user_ioInstanceAttribute(self._context)
        self.trigger = RootLuDigi_user_ioInstanceTrigger(self._context)


class RootLuDigi_user_io(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.digi_user_io'
        self.instance = RootLuDigi_user_ioInstance(self._context)


class RootLuEvent_managerInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.busy.is_busy'


class RootLuEvent_managerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.busy'
        self.is_busy = RootLuEvent_managerInstanceBusyIs_busy(self._context)


class RootLuEvent_managerInstanceAttributeObject_queue_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_queue_size'


class RootLuEvent_managerInstanceAttributeStop_event_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_event_mask.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator2_true', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.all', float(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.none', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event0_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_dbg1_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeStop_event_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_event_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStop_event_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeStart_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.start_mask.enum'

    @property
    def ramp_gen_maxz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_maxz'))

    @ramp_gen_maxz.setter
    def ramp_gen_maxz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_maxz', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.all', int(new_val))

    @property
    def data_capture(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.data_capture'))

    @data_capture.setter
    def data_capture(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.data_capture', int(new_val))

    @property
    def ramp_gen_tipvoltage(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_tipvoltage'))

    @ramp_gen_tipvoltage.setter
    def ramp_gen_tipvoltage(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_tipvoltage', int(new_val))

    @property
    def ramp_gen_ctrlz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_ctrlz'))

    @ramp_gen_ctrlz.setter
    def ramp_gen_ctrlz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_ctrlz', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_approach', int(new_val))

    @property
    def unused(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.unused'))

    @unused.setter
    def unused(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.unused', int(new_val))

    @property
    def timer_dbg1(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.timer_dbg1'))

    @timer_dbg1.setter
    def timer_dbg1(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.timer_dbg1', int(new_val))

    @property
    def ramp_gen_positiony(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positiony'))

    @ramp_gen_positiony.setter
    def ramp_gen_positiony(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positiony', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_user4', int(new_val))

    @property
    def data_sampling(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.data_sampling'))

    @data_sampling.setter
    def data_sampling(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.data_sampling', int(new_val))

    @property
    def timer_proc0(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.timer_proc0'))

    @timer_proc0.setter
    def timer_proc0(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.timer_proc0', int(new_val))

    @property
    def ramp_gen_alternatez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_alternatez'))

    @ramp_gen_alternatez.setter
    def ramp_gen_alternatez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_alternatez', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_test', int(new_val))

    @property
    def ramp_gen_positionx(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positionx'))

    @ramp_gen_positionx.setter
    def ramp_gen_positionx(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positionx', int(new_val))

    @property
    def ramp_gen_planez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_planez'))

    @ramp_gen_planez.setter
    def ramp_gen_planez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_planez', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.none', int(new_val))

    @property
    def mem_sig_gen(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.mem_sig_gen'))

    @mem_sig_gen.setter
    def mem_sig_gen(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.mem_sig_gen', int(new_val))


class RootLuEvent_managerInstanceAttributeStart_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.start_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStart_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeAbort_event_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.abort_event_mask.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator2_true', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.all', float(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.none', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event0_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_dbg1_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeAbort_event_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.abort_event_mask'
        self.enum = RootLuEvent_managerInstanceAttributeAbort_event_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeStop_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_mask.enum'

    @property
    def ramp_gen_maxz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_maxz'))

    @ramp_gen_maxz.setter
    def ramp_gen_maxz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_maxz', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.all', int(new_val))

    @property
    def data_capture(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.data_capture'))

    @data_capture.setter
    def data_capture(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.data_capture', int(new_val))

    @property
    def ramp_gen_tipvoltage(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_tipvoltage'))

    @ramp_gen_tipvoltage.setter
    def ramp_gen_tipvoltage(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_tipvoltage', int(new_val))

    @property
    def ramp_gen_ctrlz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_ctrlz'))

    @ramp_gen_ctrlz.setter
    def ramp_gen_ctrlz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_ctrlz', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_approach', int(new_val))

    @property
    def unused(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.unused'))

    @unused.setter
    def unused(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.unused', int(new_val))

    @property
    def timer_dbg1(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_dbg1'))

    @timer_dbg1.setter
    def timer_dbg1(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_dbg1', int(new_val))

    @property
    def ramp_gen_positiony(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positiony'))

    @ramp_gen_positiony.setter
    def ramp_gen_positiony(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positiony', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_user4', int(new_val))

    @property
    def data_sampling(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.data_sampling'))

    @data_sampling.setter
    def data_sampling(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.data_sampling', int(new_val))

    @property
    def timer_proc0(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_proc0'))

    @timer_proc0.setter
    def timer_proc0(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_proc0', int(new_val))

    @property
    def ramp_gen_alternatez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_alternatez'))

    @ramp_gen_alternatez.setter
    def ramp_gen_alternatez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_alternatez', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_test', int(new_val))

    @property
    def ramp_gen_positionx(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positionx'))

    @ramp_gen_positionx.setter
    def ramp_gen_positionx(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positionx', int(new_val))

    @property
    def ramp_gen_planez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_planez'))

    @ramp_gen_planez.setter
    def ramp_gen_planez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_planez', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.none', int(new_val))

    @property
    def mem_sig_gen(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.mem_sig_gen'))

    @mem_sig_gen.setter
    def mem_sig_gen(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.mem_sig_gen', int(new_val))


class RootLuEvent_managerInstanceAttributeStop_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStop_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeEvent_vectorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator2_true', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.all', float(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.none', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event0_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.timer_dbg1_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector'
        self.enum = RootLuEvent_managerInstanceAttributeEvent_vectorEnum(self._context)


class RootLuEvent_managerInstanceAttributeAnd_mask0Enum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.and_mask0.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator2_true', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.all', float(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.none', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event0_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_dbg1_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeAnd_mask0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.and_mask0'
        self.enum = RootLuEvent_managerInstanceAttributeAnd_mask0Enum(self._context)


class RootLuEvent_managerInstanceAttributeObject_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_idle'


class RootLuEvent_managerInstanceAttributeEvent_vector_snapshotEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector_snapshot.enum'

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator2_true', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.all', float(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_capture_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_proc0_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_test_done', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event1_true', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.unused_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event0_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.and_mask0_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator1_true', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_sampling_done', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.none', int(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event0_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_dbg1_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_planez_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event1_true', int(new_val))

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event2_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector_snapshot'
        self.enum = RootLuEvent_managerInstanceAttributeEvent_vector_snapshotEnum(self._context)


class RootLuEvent_managerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute'
        self.event_vector_snapshot = RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(self._context)
        self.object_idle = RootLuEvent_managerInstanceAttributeObject_idle(self._context)
        self.and_mask0 = RootLuEvent_managerInstanceAttributeAnd_mask0(self._context)
        self.event_vector = RootLuEvent_managerInstanceAttributeEvent_vector(self._context)
        self.stop_mask = RootLuEvent_managerInstanceAttributeStop_mask(self._context)
        self.abort_event_mask = RootLuEvent_managerInstanceAttributeAbort_event_mask(self._context)
        self.start_mask = RootLuEvent_managerInstanceAttributeStart_mask(self._context)
        self.stop_event_mask = RootLuEvent_managerInstanceAttributeStop_event_mask(self._context)
        self.object_queue_size = RootLuEvent_managerInstanceAttributeObject_queue_size(self._context)


class RootLuEvent_managerInstanceTriggerSoft_event1_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event1_falling_edge'


class RootLuEvent_managerInstanceTriggerSoft_event2_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event2_falling_edge'


class RootLuEvent_managerInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.abort'


class RootLuEvent_managerInstanceTriggerSoft_event2_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event2_rising_edge'


class RootLuEvent_managerInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.stop'


class RootLuEvent_managerInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.user_abort'


class RootLuEvent_managerInstanceTriggerSoft_event0_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event0_falling_edge'


class RootLuEvent_managerInstanceTriggerSoft_event0_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event0_rising_edge'


class RootLuEvent_managerInstanceTriggerSoft_event1_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event1_rising_edge'


class RootLuEvent_managerInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.start'


class RootLuEvent_managerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger'
        self.start = RootLuEvent_managerInstanceTriggerStart(self._context)
        self.soft_event1_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event1_rising_edge(self._context)
        self.soft_event0_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event0_rising_edge(self._context)
        self.soft_event0_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event0_falling_edge(self._context)
        self.user_abort = RootLuEvent_managerInstanceTriggerUser_abort(self._context)
        self.stop = RootLuEvent_managerInstanceTriggerStop(self._context)
        self.soft_event2_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event2_rising_edge(self._context)
        self.abort = RootLuEvent_managerInstanceTriggerAbort(self._context)
        self.soft_event2_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event2_falling_edge(self._context)
        self.soft_event1_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event1_falling_edge(self._context)


class RootLuEvent_managerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance'
        self.trigger = RootLuEvent_managerInstanceTrigger(self._context)
        self.attribute = RootLuEvent_managerInstanceAttribute(self._context)
        self.busy = RootLuEvent_managerInstanceBusy(self._context)


class RootLuEvent_manager(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager'
        self.instance = RootLuEvent_managerInstance(self._context)


class RootLuOrtInstanceBusyIs_averaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy.is_averaging'


class RootLuOrtInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy'
        self.is_averaging = RootLuOrtInstanceBusyIs_averaging(self._context)


class RootLuOrtInstanceAttributeFeedback_amplitude_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.feedback_amplitude_position'


class RootLuOrtInstanceAttributeSamples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.samples_per_period'


class RootLuOrtInstanceAttributeBaseline_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_amplitude'


class RootLuOrtInstanceAttributeAmplitude_reduction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.amplitude_reduction'


class RootLuOrtInstanceAttributeBaseline_controller_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_controller_state'


class RootLuOrtInstanceAttributeFree_wave_delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_delay'


class RootLuOrtInstanceAttributeMin_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_position'


class RootLuOrtInstanceAttributeInput_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select.enum'

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.fast_in_user', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.fast_in_deflection', int(new_val))

    @property
    def hi_res_in_deflection(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_deflection'))

    @hi_res_in_deflection.setter
    def hi_res_in_deflection(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_deflection', int(new_val))

    @property
    def hi_res_in_user1(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_user1'))

    @hi_res_in_user1.setter
    def hi_res_in_user1(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum.hi_res_in_user1', int(new_val))


class RootLuOrtInstanceAttributeInput_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select'
        self.enum = RootLuOrtInstanceAttributeInput_selectEnum(self._context)


class RootLuOrtInstanceAttributeFree_wave_output_stateEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum.disabled', int(new_val))


class RootLuOrtInstanceAttributeFree_wave_output_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state'
        self.enum = RootLuOrtInstanceAttributeFree_wave_output_stateEnum(self._context)


class RootLuOrtInstanceAttributeAverage_periods(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.average_periods'


class RootLuOrtInstanceAttributeBaseline_window_begin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_begin'


class RootLuOrtInstanceAttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_value'


class RootLuOrtInstanceAttributeExcitation_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.excitation_amplitude'


class RootLuOrtInstanceAttributeBaseline_window_end(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_end'


class RootLuOrtInstanceAttributeCantilever_samples_per_periodEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum.disabled', int(new_val))


class RootLuOrtInstanceAttributeCantilever_samples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period'
        self.enum = RootLuOrtInstanceAttributeCantilever_samples_per_periodEnum(self._context)


class RootLuOrtInstanceAttributeBaseline_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_frequency'


class RootLuOrtInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute'
        self.baseline_frequency = RootLuOrtInstanceAttributeBaseline_frequency(self._context)
        self.cantilever_samples_per_period = RootLuOrtInstanceAttributeCantilever_samples_per_period(self._context)
        self.baseline_window_end = RootLuOrtInstanceAttributeBaseline_window_end(self._context)
        self.excitation_amplitude = RootLuOrtInstanceAttributeExcitation_amplitude(self._context)
        self.min_value = RootLuOrtInstanceAttributeMin_value(self._context)
        self.baseline_window_begin = RootLuOrtInstanceAttributeBaseline_window_begin(self._context)
        self.average_periods = RootLuOrtInstanceAttributeAverage_periods(self._context)
        self.free_wave_output_state = RootLuOrtInstanceAttributeFree_wave_output_state(self._context)
        self.input_select = RootLuOrtInstanceAttributeInput_select(self._context)
        self.min_position = RootLuOrtInstanceAttributeMin_position(self._context)
        self.free_wave_delay = RootLuOrtInstanceAttributeFree_wave_delay(self._context)
        self.baseline_controller_state = RootLuOrtInstanceAttributeBaseline_controller_state(self._context)
        self.amplitude_reduction = RootLuOrtInstanceAttributeAmplitude_reduction(self._context)
        self.baseline_amplitude = RootLuOrtInstanceAttributeBaseline_amplitude(self._context)
        self.samples_per_period = RootLuOrtInstanceAttributeSamples_per_period(self._context)
        self.feedback_amplitude_position = RootLuOrtInstanceAttributeFeedback_amplitude_position(self._context)


class RootLuOrtInstanceTriggerAverage_stop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.average_stop'


class RootLuOrtInstanceTriggerProcess_averaged_samples(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.process_averaged_samples'


class RootLuOrtInstanceTriggerAverage_start(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.average_start'


class RootLuOrtInstanceTriggerApply_samples_per_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.apply_samples_per_period'


class RootLuOrtInstanceTriggerApply_samples_values(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.apply_samples_values'


class RootLuOrtInstanceTriggerUpdate_free_wave(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger.update_free_wave'


class RootLuOrtInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger'
        self.update_free_wave = RootLuOrtInstanceTriggerUpdate_free_wave(self._context)
        self.apply_samples_values = RootLuOrtInstanceTriggerApply_samples_values(self._context)
        self.apply_samples_per_period = RootLuOrtInstanceTriggerApply_samples_per_period(self._context)
        self.average_start = RootLuOrtInstanceTriggerAverage_start(self._context)
        self.process_averaged_samples = RootLuOrtInstanceTriggerProcess_averaged_samples(self._context)
        self.average_stop = RootLuOrtInstanceTriggerAverage_stop(self._context)


class RootLuOrtInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance'
        self.trigger = RootLuOrtInstanceTrigger(self._context)
        self.attribute = RootLuOrtInstanceAttribute(self._context)
        self.busy = RootLuOrtInstanceBusy(self._context)


class RootLuOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort'
        self.instance = RootLuOrtInstance(self._context)


class RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_detector_auto_adjustment'


class RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration_with_retract'


class RootLuSensor_controlInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.user_abort'


class RootLuSensor_controlInstanceTriggerStart_sensor_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_sensor_calibration'


class RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_set_dynamic_amplitude'


class RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_deflection_offset_calibration'


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration'


class RootLuSensor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger'
        self.deflection_offset_calibration = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(self._context)
        self.start_deflection_offset_calibration = RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(self._context)
        self.start_set_dynamic_amplitude = RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(self._context)
        self.start_sensor_calibration = RootLuSensor_controlInstanceTriggerStart_sensor_calibration(self._context)
        self.user_abort = RootLuSensor_controlInstanceTriggerUser_abort(self._context)
        self.deflection_offset_calibration_with_retract = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(self._context)
        self.update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(self._context)
        self.start_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(self._context)
        self.start_detector_auto_adjustment = RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(self._context)


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum'

    @property
    def failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed'))

    @failed.setter
    def failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle', int(new_val))

    @property
    def running(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running'))

    @running.setter
    def running(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running', int(new_val))


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status'
        self.enum = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum'

    @property
    def fix_from_attr(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr'))

    @fix_from_attr.setter
    def fix_from_attr(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr', int(new_val))

    @property
    def auto_from_head_typ(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ'))

    @auto_from_head_typ.setter
    def auto_from_head_typ(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode.enum'

    @property
    def auto_calibrate_deflection(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection'))

    @auto_calibrate_deflection.setter
    def auto_calibrate_deflection(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection', int(new_val))

    @property
    def auto_calibrate_z_ctrl_input(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input'))

    @auto_calibrate_z_ctrl_input.setter
    def auto_calibrate_z_ctrl_input(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input', int(new_val))

    @property
    def no_auto_calibration(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration'))

    @no_auto_calibration.setter
    def no_auto_calibration(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum'

    @property
    def calibration_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error'))

    @calibration_error.setter
    def calibration_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error', int(new_val))

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error', int(new_val))

    @property
    def sensor_signal_failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed'))

    @sensor_signal_failed.setter
    def sensor_signal_failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed', int(new_val))


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status'
        self.enum = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain'


class RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceAttributeSensor_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.sensor_amplitude'


class RootLuSensor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute'
        self.sensor_amplitude = RootLuSensor_controlInstanceAttributeSensor_amplitude(self._context)
        self.enable10_hz_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(self._context)
        self.offset_calib_i_gain = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(self._context)
        self.detector_adjustment_duration_limit = RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(self._context)
        self.deflection_offset_calibration_status = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(self._context)
        self.offset_calib_mode = RootLuSensor_controlInstanceAttributeOffset_calib_mode(self._context)
        self.offset_calib_i_gain_mode = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(self._context)
        self.detector_adjustment_tolerance = RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(self._context)
        self.detector_auto_adjustment_status = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(self._context)


class RootLuSensor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance'
        self.attribute = RootLuSensor_controlInstanceAttribute(self._context)
        self.trigger = RootLuSensor_controlInstanceTrigger(self._context)


class RootLuSensor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control'
        self.instance = RootLuSensor_controlInstance(self._context)


class RootLuRescanInstanceAttributeLine_repetition_max_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max_count'


class RootLuRescanInstanceAttributeLine_repetition_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max'


class RootLuRescanInstanceAttributeEnable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.enable'


class RootLuRescanInstanceAttributeLine_repetition_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_count'


class RootLuRescanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute'
        self.line_repetition_count = RootLuRescanInstanceAttributeLine_repetition_count(self._context)
        self.enable = RootLuRescanInstanceAttributeEnable(self._context)
        self.line_repetition_max = RootLuRescanInstanceAttributeLine_repetition_max(self._context)
        self.line_repetition_max_count = RootLuRescanInstanceAttributeLine_repetition_max_count(self._context)


class RootLuRescanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance'
        self.attribute = RootLuRescanInstanceAttribute(self._context)


class RootLuRescan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan'
        self.instance = RootLuRescanInstance(self._context)


class RootLuOscilloscopeInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy.is_busy'


class RootLuOscilloscopeInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy'
        self.is_busy = RootLuOscilloscopeInstanceBusyIs_busy(self._context)


class RootLuOscilloscopeInstanceAttributeHi_res_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.hi_res_input_vec'


class RootLuOscilloscopeInstanceAttributeFast_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.fast_input_vec'


class RootLuOscilloscopeInstanceAttributeCapture_duration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_duration'


class RootLuOscilloscopeInstanceAttributeCapture_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_period'


class RootLuOscilloscopeInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute'
        self.capture_period = RootLuOscilloscopeInstanceAttributeCapture_period(self._context)
        self.capture_duration = RootLuOscilloscopeInstanceAttributeCapture_duration(self._context)
        self.fast_input_vec = RootLuOscilloscopeInstanceAttributeFast_input_vec(self._context)
        self.hi_res_input_vec = RootLuOscilloscopeInstanceAttributeHi_res_input_vec(self._context)


class RootLuOscilloscopeInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.stop'


class RootLuOscilloscopeInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.start'


class RootLuOscilloscopeInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.abort'


class RootLuOscilloscopeInstanceTriggerToggle_debug_logging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.toggle_debug_logging'


class RootLuOscilloscopeInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger'
        self.toggle_debug_logging = RootLuOscilloscopeInstanceTriggerToggle_debug_logging(self._context)
        self.abort = RootLuOscilloscopeInstanceTriggerAbort(self._context)
        self.start = RootLuOscilloscopeInstanceTriggerStart(self._context)
        self.stop = RootLuOscilloscopeInstanceTriggerStop(self._context)


class RootLuOscilloscopeInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance'
        self.trigger = RootLuOscilloscopeInstanceTrigger(self._context)
        self.attribute = RootLuOscilloscopeInstanceAttribute(self._context)
        self.busy = RootLuOscilloscopeInstanceBusy(self._context)


class RootLuOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope'
        self.instance = RootLuOscilloscopeInstance(self._context)


class RootLuComp_dcInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.user_abort'


class RootLuComp_dcInstanceTriggerApply_new_nonlinear_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.apply_new_nonlinear_configuration'


class RootLuComp_dcInstanceTriggerApply_new_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.apply_new_configuration'


class RootLuComp_dcInstanceTriggerStart_comp_dc_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.start_comp_dc_calibration'


class RootLuComp_dcInstanceTriggerRead_current_configuration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger.read_current_configuration'


class RootLuComp_dcInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.trigger'
        self.read_current_configuration = RootLuComp_dcInstanceTriggerRead_current_configuration(self._context)
        self.start_comp_dc_calibration = RootLuComp_dcInstanceTriggerStart_comp_dc_calibration(self._context)
        self.apply_new_configuration = RootLuComp_dcInstanceTriggerApply_new_configuration(self._context)
        self.apply_new_nonlinear_configuration = RootLuComp_dcInstanceTriggerApply_new_nonlinear_configuration(self._context)
        self.user_abort = RootLuComp_dcInstanceTriggerUser_abort(self._context)


class RootLuComp_dcInstanceAttributeComp_dc_gain_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_y'


class RootLuComp_dcInstanceAttributeComp_dc_gain_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_x'


class RootLuComp_dcInstanceAttributeComp_dc_gain_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.comp_dc_gain_z'


class RootLuComp_dcInstanceAttributeCoefficient_index(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute.coefficient_index'


class RootLuComp_dcInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance.attribute'
        self.coefficient_index = RootLuComp_dcInstanceAttributeCoefficient_index(self._context)
        self.comp_dc_gain_z = RootLuComp_dcInstanceAttributeComp_dc_gain_z(self._context)
        self.comp_dc_gain_x = RootLuComp_dcInstanceAttributeComp_dc_gain_x(self._context)
        self.comp_dc_gain_y = RootLuComp_dcInstanceAttributeComp_dc_gain_y(self._context)


class RootLuComp_dcInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc.instance'
        self.attribute = RootLuComp_dcInstanceAttribute(self._context)
        self.trigger = RootLuComp_dcInstanceTrigger(self._context)


class RootLuComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.comp_dc'
        self.instance = RootLuComp_dcInstance(self._context)


class RootLuSignal_analyzerInst2TriggerStart_phase_zero_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.start_phase_zero_calibration'


class RootLuSignal_analyzerInst2TriggerStart_switch_to_target_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst2TriggerSwitch_to_target_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst2TriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.user_abort'


class RootLuSignal_analyzerInst2TriggerKpfm_phase_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.kpfm_phase_calibration'


class RootLuSignal_analyzerInst2TriggerStart_kpfm_phase_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.start_kpfm_phase_calibration'


class RootLuSignal_analyzerInst2TriggerStart_update_current_free_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.start_update_current_free_amplitude'


class RootLuSignal_analyzerInst2TriggerStart_switch_to_target_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.start_switch_to_target_amplitude_ctrl_mode'


class RootLuSignal_analyzerInst2TriggerSwitch_to_target_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger.switch_to_target_amplitude_ctrl_mode'


class RootLuSignal_analyzerInst2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.trigger'
        self.switch_to_target_amplitude_ctrl_mode = RootLuSignal_analyzerInst2TriggerSwitch_to_target_amplitude_ctrl_mode(self._context)
        self.start_switch_to_target_amplitude_ctrl_mode = RootLuSignal_analyzerInst2TriggerStart_switch_to_target_amplitude_ctrl_mode(self._context)
        self.start_update_current_free_amplitude = RootLuSignal_analyzerInst2TriggerStart_update_current_free_amplitude(self._context)
        self.start_kpfm_phase_calibration = RootLuSignal_analyzerInst2TriggerStart_kpfm_phase_calibration(self._context)
        self.kpfm_phase_calibration = RootLuSignal_analyzerInst2TriggerKpfm_phase_calibration(self._context)
        self.user_abort = RootLuSignal_analyzerInst2TriggerUser_abort(self._context)
        self.switch_to_target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2TriggerSwitch_to_target_amplitude_ctrl_set_point(self._context)
        self.start_switch_to_target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2TriggerStart_switch_to_target_amplitude_ctrl_set_point(self._context)
        self.start_phase_zero_calibration = RootLuSignal_analyzerInst2TriggerStart_phase_zero_calibration(self._context)


class RootLuSignal_analyzerInst2AttributeCurrent_x_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x_binary'


class RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase_binary'


class RootLuSignal_analyzerInst2AttributeOperating_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.operating_mode.enum'

    @property
    def kpfm(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.kpfm'))

    @kpfm.setter
    def kpfm(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.kpfm', int(new_val))

    @property
    def pll(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.pll'))

    @pll.setter
    def pll(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.pll', int(new_val))

    @property
    def lock_in(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.lock_in'))

    @lock_in.setter
    def lock_in(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.operating_mode.enum.lock_in', int(new_val))


class RootLuSignal_analyzerInst2AttributeOperating_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.operating_mode'
        self.enum = RootLuSignal_analyzerInst2AttributeOperating_modeEnum(self._context)


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_i_gain'


class RootLuSignal_analyzerInst2AttributeCurrent_y_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y_binary'


class RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_amplitude'


class RootLuSignal_analyzerInst2AttributePll_unlocked(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.pll_unlocked'


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum'

    @property
    def free_vibration(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.free_vibration'))

    @free_vibration.setter
    def free_vibration(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.free_vibration', int(new_val))

    @property
    def const_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.const_amplitude'))

    @const_amplitude.setter
    def const_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.const_amplitude', int(new_val))

    @property
    def const_drive(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.const_drive'))

    @const_drive.setter
    def const_drive(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode.enum.const_drive', int(new_val))


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_mode'
        self.enum = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_modeEnum(self._context)


class RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.lock_in_calc_phase'


class RootLuSignal_analyzerInst2AttributeReference_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_frequency'


class RootLuSignal_analyzerInst2AttributeCurrent_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_x'


class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_amplitude'


class RootLuSignal_analyzerInst2AttributeAmplitude_modulationEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_modulation.enum.disabled', int(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_modulation'
        self.enum = RootLuSignal_analyzerInst2AttributeAmplitude_modulationEnum(self._context)


class RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst2AttributeCurrent_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_phase'


class RootLuSignal_analyzerInst2AttributeHarmonic_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum'

    @property
    def analyzer2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum.analyzer2'))

    @analyzer2.setter
    def analyzer2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum.analyzer2', int(new_val))

    @property
    def analyzer1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum.analyzer1'))

    @analyzer1.setter
    def analyzer1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.harmonic_source.enum.analyzer1', int(new_val))


class RootLuSignal_analyzerInst2AttributeHarmonic_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.harmonic_source'
        self.enum = RootLuSignal_analyzerInst2AttributeHarmonic_sourceEnum(self._context)


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_resultEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum'

    @property
    def amplitude_calibration_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum.amplitude_calibration_error'))

    @amplitude_calibration_error.setter
    def amplitude_calibration_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum.amplitude_calibration_error', int(new_val))

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result.enum.no_error', int(new_val))


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_set_point_calib_result'
        self.enum = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_resultEnum(self._context)


class RootLuSignal_analyzerInst2AttributeDisplay_df_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.display_df_range'


class RootLuSignal_analyzerInst2AttributeReference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude'


class RootLuSignal_analyzerInst2AttributeDemodulator_bwEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum'

    @property
    def bw_500_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_500_k_hz'))

    @bw_500_k_hz.setter
    def bw_500_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_500_k_hz', int(new_val))

    @property
    def bw_12_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_12_k_hz'))

    @bw_12_k_hz.setter
    def bw_12_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_12_k_hz', int(new_val))

    @property
    def bw_45_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_45_k_hz'))

    @bw_45_k_hz.setter
    def bw_45_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_45_k_hz', int(new_val))

    @property
    def bw_230_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_230_k_hz'))

    @bw_230_k_hz.setter
    def bw_230_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_230_k_hz', int(new_val))

    @property
    def bw_90_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_90_hz'))

    @bw_90_hz.setter
    def bw_90_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_90_hz', int(new_val))

    @property
    def bw_23_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_23_k_hz'))

    @bw_23_k_hz.setter
    def bw_23_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_23_k_hz', int(new_val))

    @property
    def bw_1500_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_1500_hz'))

    @bw_1500_hz.setter
    def bw_1500_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_1500_hz', int(new_val))

    @property
    def bw_23_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_23_hz'))

    @bw_23_hz.setter
    def bw_23_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_23_hz', int(new_val))

    @property
    def bw_180_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_180_hz'))

    @bw_180_hz.setter
    def bw_180_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_180_hz', int(new_val))

    @property
    def bw_6_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_6_k_hz'))

    @bw_6_k_hz.setter
    def bw_6_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_6_k_hz', int(new_val))

    @property
    def bw_3_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_3_k_hz'))

    @bw_3_k_hz.setter
    def bw_3_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_3_k_hz', int(new_val))

    @property
    def bw_360_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_360_hz'))

    @bw_360_hz.setter
    def bw_360_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_360_hz', int(new_val))

    @property
    def bw_750_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_750_hz'))

    @bw_750_hz.setter
    def bw_750_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_750_hz', int(new_val))

    @property
    def bw_100_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_100_k_hz'))

    @bw_100_k_hz.setter
    def bw_100_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_100_k_hz', int(new_val))

    @property
    def bw_45_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_45_hz'))

    @bw_45_hz.setter
    def bw_45_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.demodulator_bw.enum.bw_45_hz', int(new_val))


class RootLuSignal_analyzerInst2AttributeDemodulator_bw(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.demodulator_bw'
        self.enum = RootLuSignal_analyzerInst2AttributeDemodulator_bwEnum(self._context)


class RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_p_gain'


class RootLuSignal_analyzerInst2AttributeReference_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_source.enum'

    @property
    def harmonic3(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic3'))

    @harmonic3.setter
    def harmonic3(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic3', int(new_val))

    @property
    def own(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.own'))

    @own.setter
    def own(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.own', int(new_val))

    @property
    def harmonic2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic2'))

    @harmonic2.setter
    def harmonic2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic2', int(new_val))

    @property
    def harmonic1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic1'))

    @harmonic1.setter
    def harmonic1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.reference_source.enum.harmonic1', int(new_val))


class RootLuSignal_analyzerInst2AttributeReference_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_source'
        self.enum = RootLuSignal_analyzerInst2AttributeReference_sourceEnum(self._context)


class RootLuSignal_analyzerInst2AttributeReference_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_phase'


class RootLuSignal_analyzerInst2AttributeInputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def test_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.test_tip_voltage'))

    @test_tip_voltage.setter
    def test_tip_voltage(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.test_tip_voltage', int(new_val))

    @property
    def test_ref(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.test_ref'))

    @test_ref.setter
    def test_ref(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.test_ref', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.fast_in_deflection', int(new_val))

    @property
    def test_ana_gnd(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.test_ana_gnd'))

    @test_ana_gnd.setter
    def test_ana_gnd(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.test_ana_gnd', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.input.enum.ctrl_y_out', int(new_val))


class RootLuSignal_analyzerInst2AttributeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.input'
        self.enum = RootLuSignal_analyzerInst2AttributeInputEnum(self._context)


class RootLuSignal_analyzerInst2AttributePhase_lock_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_lock_range'


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.phase_ctrl_i_gain'


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude'


class RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.amplitude_ctrl_p_gain'


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum'

    @property
    def free_vibration(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.free_vibration'))

    @free_vibration.setter
    def free_vibration(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.free_vibration', int(new_val))

    @property
    def const_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.const_amplitude'))

    @const_amplitude.setter
    def const_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.const_amplitude', int(new_val))

    @property
    def const_drive(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.const_drive'))

    @const_drive.setter
    def const_drive(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode.enum.const_drive', int(new_val))


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_ctrl_mode'
        self.enum = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_modeEnum(self._context)


class RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_amplitude_binary'


class RootLuSignal_analyzerInst2AttributeEnable_dc_blockEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst2.attribute.enable_dc_block.enum.disabled', int(new_val))


class RootLuSignal_analyzerInst2AttributeEnable_dc_block(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.enable_dc_block'
        self.enum = RootLuSignal_analyzerInst2AttributeEnable_dc_blockEnum(self._context)


class RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reset_flag_pll_unlocked'


class RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_ctrl_delta_f'


class RootLuSignal_analyzerInst2AttributeDelay_comp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.delay_comp'


class RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.reference_amplitude_factor'


class RootLuSignal_analyzerInst2AttributeCurrent_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_y'


class RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute.current_reference_amplitude'


class RootLuSignal_analyzerInst2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2.attribute'
        self.current_reference_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_reference_amplitude(self._context)
        self.current_y = RootLuSignal_analyzerInst2AttributeCurrent_y(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst2AttributeReference_amplitude_factor(self._context)
        self.delay_comp = RootLuSignal_analyzerInst2AttributeDelay_comp(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_delta_f(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst2AttributeReset_flag_pll_unlocked(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst2AttributeEnable_dc_block(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_binary(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_p_gain(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_amplitude(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_i_gain(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst2AttributePhase_lock_range(self._context)
        self.input = RootLuSignal_analyzerInst2AttributeInput(self._context)
        self.reference_phase = RootLuSignal_analyzerInst2AttributeReference_phase(self._context)
        self.reference_source = RootLuSignal_analyzerInst2AttributeReference_source(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst2AttributePhase_ctrl_p_gain(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst2AttributeDemodulator_bw(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst2AttributeReference_amplitude(self._context)
        self.display_df_range = RootLuSignal_analyzerInst2AttributeDisplay_df_range(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst2AttributeHarmonic_source(self._context)
        self.current_phase = RootLuSignal_analyzerInst2AttributeCurrent_phase(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst2AttributeAmplitude_modulation(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst2AttributeCurrent_ctrl_amplitude(self._context)
        self.current_x = RootLuSignal_analyzerInst2AttributeCurrent_x(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst2AttributeReference_frequency(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst2AttributeLock_in_calc_phase(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst2AttributeTarget_amplitude_ctrl_mode(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst2AttributePll_unlocked(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst2AttributeLock_in_calc_amplitude(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst2AttributeCurrent_y_binary(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst2AttributeAmplitude_ctrl_i_gain(self._context)
        self.operating_mode = RootLuSignal_analyzerInst2AttributeOperating_mode(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst2AttributeCurrent_phase_binary(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst2AttributeCurrent_x_binary(self._context)


class RootLuSignal_analyzerInst2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst2'
        self.attribute = RootLuSignal_analyzerInst2Attribute(self._context)
        self.trigger = RootLuSignal_analyzerInst2Trigger(self._context)


class RootLuSignal_analyzerInst1TriggerStart_phase_zero_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.start_phase_zero_calibration'


class RootLuSignal_analyzerInst1TriggerStart_switch_to_target_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst1TriggerSwitch_to_target_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst1TriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.user_abort'


class RootLuSignal_analyzerInst1TriggerKpfm_phase_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.kpfm_phase_calibration'


class RootLuSignal_analyzerInst1TriggerStart_kpfm_phase_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.start_kpfm_phase_calibration'


class RootLuSignal_analyzerInst1TriggerStart_update_current_free_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.start_update_current_free_amplitude'


class RootLuSignal_analyzerInst1TriggerStart_switch_to_target_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.start_switch_to_target_amplitude_ctrl_mode'


class RootLuSignal_analyzerInst1TriggerSwitch_to_target_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger.switch_to_target_amplitude_ctrl_mode'


class RootLuSignal_analyzerInst1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.trigger'
        self.switch_to_target_amplitude_ctrl_mode = RootLuSignal_analyzerInst1TriggerSwitch_to_target_amplitude_ctrl_mode(self._context)
        self.start_switch_to_target_amplitude_ctrl_mode = RootLuSignal_analyzerInst1TriggerStart_switch_to_target_amplitude_ctrl_mode(self._context)
        self.start_update_current_free_amplitude = RootLuSignal_analyzerInst1TriggerStart_update_current_free_amplitude(self._context)
        self.start_kpfm_phase_calibration = RootLuSignal_analyzerInst1TriggerStart_kpfm_phase_calibration(self._context)
        self.kpfm_phase_calibration = RootLuSignal_analyzerInst1TriggerKpfm_phase_calibration(self._context)
        self.user_abort = RootLuSignal_analyzerInst1TriggerUser_abort(self._context)
        self.switch_to_target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1TriggerSwitch_to_target_amplitude_ctrl_set_point(self._context)
        self.start_switch_to_target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1TriggerStart_switch_to_target_amplitude_ctrl_set_point(self._context)
        self.start_phase_zero_calibration = RootLuSignal_analyzerInst1TriggerStart_phase_zero_calibration(self._context)


class RootLuSignal_analyzerInst1AttributeCurrent_x_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x_binary'


class RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase_binary'


class RootLuSignal_analyzerInst1AttributeOperating_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.operating_mode.enum'

    @property
    def kpfm(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.kpfm'))

    @kpfm.setter
    def kpfm(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.kpfm', int(new_val))

    @property
    def pll(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.pll'))

    @pll.setter
    def pll(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.pll', int(new_val))

    @property
    def lock_in(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.lock_in'))

    @lock_in.setter
    def lock_in(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.operating_mode.enum.lock_in', int(new_val))


class RootLuSignal_analyzerInst1AttributeOperating_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.operating_mode'
        self.enum = RootLuSignal_analyzerInst1AttributeOperating_modeEnum(self._context)


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_i_gain'


class RootLuSignal_analyzerInst1AttributeCurrent_y_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y_binary'


class RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_amplitude'


class RootLuSignal_analyzerInst1AttributePll_unlocked(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.pll_unlocked'


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum'

    @property
    def free_vibration(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.free_vibration'))

    @free_vibration.setter
    def free_vibration(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.free_vibration', int(new_val))

    @property
    def const_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.const_amplitude'))

    @const_amplitude.setter
    def const_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.const_amplitude', int(new_val))

    @property
    def const_drive(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.const_drive'))

    @const_drive.setter
    def const_drive(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode.enum.const_drive', int(new_val))


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_mode'
        self.enum = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_modeEnum(self._context)


class RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.lock_in_calc_phase'


class RootLuSignal_analyzerInst1AttributeReference_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_frequency'


class RootLuSignal_analyzerInst1AttributeCurrent_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_x'


class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_amplitude'


class RootLuSignal_analyzerInst1AttributeAmplitude_modulationEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_modulation.enum.disabled', int(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_modulation'
        self.enum = RootLuSignal_analyzerInst1AttributeAmplitude_modulationEnum(self._context)


class RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.target_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst1AttributeCurrent_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_phase'


class RootLuSignal_analyzerInst1AttributeHarmonic_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum'

    @property
    def analyzer2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum.analyzer2'))

    @analyzer2.setter
    def analyzer2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum.analyzer2', int(new_val))

    @property
    def analyzer1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum.analyzer1'))

    @analyzer1.setter
    def analyzer1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.harmonic_source.enum.analyzer1', int(new_val))


class RootLuSignal_analyzerInst1AttributeHarmonic_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.harmonic_source'
        self.enum = RootLuSignal_analyzerInst1AttributeHarmonic_sourceEnum(self._context)


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_resultEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum'

    @property
    def amplitude_calibration_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum.amplitude_calibration_error'))

    @amplitude_calibration_error.setter
    def amplitude_calibration_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum.amplitude_calibration_error', int(new_val))

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result.enum.no_error', int(new_val))


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_set_point_calib_result'
        self.enum = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_resultEnum(self._context)


class RootLuSignal_analyzerInst1AttributeDisplay_df_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.display_df_range'


class RootLuSignal_analyzerInst1AttributeReference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude'


class RootLuSignal_analyzerInst1AttributeDemodulator_bwEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum'

    @property
    def bw_500_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_500_k_hz'))

    @bw_500_k_hz.setter
    def bw_500_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_500_k_hz', int(new_val))

    @property
    def bw_12_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_12_k_hz'))

    @bw_12_k_hz.setter
    def bw_12_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_12_k_hz', int(new_val))

    @property
    def bw_45_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_45_k_hz'))

    @bw_45_k_hz.setter
    def bw_45_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_45_k_hz', int(new_val))

    @property
    def bw_230_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_230_k_hz'))

    @bw_230_k_hz.setter
    def bw_230_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_230_k_hz', int(new_val))

    @property
    def bw_90_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_90_hz'))

    @bw_90_hz.setter
    def bw_90_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_90_hz', int(new_val))

    @property
    def bw_23_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_23_k_hz'))

    @bw_23_k_hz.setter
    def bw_23_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_23_k_hz', int(new_val))

    @property
    def bw_1500_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_1500_hz'))

    @bw_1500_hz.setter
    def bw_1500_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_1500_hz', int(new_val))

    @property
    def bw_23_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_23_hz'))

    @bw_23_hz.setter
    def bw_23_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_23_hz', int(new_val))

    @property
    def bw_180_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_180_hz'))

    @bw_180_hz.setter
    def bw_180_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_180_hz', int(new_val))

    @property
    def bw_6_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_6_k_hz'))

    @bw_6_k_hz.setter
    def bw_6_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_6_k_hz', int(new_val))

    @property
    def bw_3_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_3_k_hz'))

    @bw_3_k_hz.setter
    def bw_3_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_3_k_hz', int(new_val))

    @property
    def bw_360_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_360_hz'))

    @bw_360_hz.setter
    def bw_360_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_360_hz', int(new_val))

    @property
    def bw_750_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_750_hz'))

    @bw_750_hz.setter
    def bw_750_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_750_hz', int(new_val))

    @property
    def bw_100_k_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_100_k_hz'))

    @bw_100_k_hz.setter
    def bw_100_k_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_100_k_hz', int(new_val))

    @property
    def bw_45_hz(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_45_hz'))

    @bw_45_hz.setter
    def bw_45_hz(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.demodulator_bw.enum.bw_45_hz', int(new_val))


class RootLuSignal_analyzerInst1AttributeDemodulator_bw(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.demodulator_bw'
        self.enum = RootLuSignal_analyzerInst1AttributeDemodulator_bwEnum(self._context)


class RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_p_gain'


class RootLuSignal_analyzerInst1AttributeReference_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_source.enum'

    @property
    def harmonic3(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic3'))

    @harmonic3.setter
    def harmonic3(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic3', int(new_val))

    @property
    def own(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.own'))

    @own.setter
    def own(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.own', int(new_val))

    @property
    def harmonic2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic2'))

    @harmonic2.setter
    def harmonic2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic2', int(new_val))

    @property
    def harmonic1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic1'))

    @harmonic1.setter
    def harmonic1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.reference_source.enum.harmonic1', int(new_val))


class RootLuSignal_analyzerInst1AttributeReference_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_source'
        self.enum = RootLuSignal_analyzerInst1AttributeReference_sourceEnum(self._context)


class RootLuSignal_analyzerInst1AttributeReference_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_phase'


class RootLuSignal_analyzerInst1AttributeInputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def test_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.test_tip_voltage'))

    @test_tip_voltage.setter
    def test_tip_voltage(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.test_tip_voltage', int(new_val))

    @property
    def test_ref(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.test_ref'))

    @test_ref.setter
    def test_ref(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.test_ref', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.fast_in_deflection', int(new_val))

    @property
    def test_ana_gnd(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.test_ana_gnd'))

    @test_ana_gnd.setter
    def test_ana_gnd(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.test_ana_gnd', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.input.enum.ctrl_y_out', int(new_val))


class RootLuSignal_analyzerInst1AttributeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.input'
        self.enum = RootLuSignal_analyzerInst1AttributeInputEnum(self._context)


class RootLuSignal_analyzerInst1AttributePhase_lock_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_lock_range'


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_set_point'


class RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.phase_ctrl_i_gain'


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude'


class RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.amplitude_ctrl_p_gain'


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum'

    @property
    def free_vibration(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.free_vibration'))

    @free_vibration.setter
    def free_vibration(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.free_vibration', int(new_val))

    @property
    def const_amplitude(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.const_amplitude'))

    @const_amplitude.setter
    def const_amplitude(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.const_amplitude', int(new_val))

    @property
    def const_drive(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.const_drive'))

    @const_drive.setter
    def const_drive(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode.enum.const_drive', int(new_val))


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_ctrl_mode'
        self.enum = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_modeEnum(self._context)


class RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_amplitude_binary'


class RootLuSignal_analyzerInst1AttributeEnable_dc_blockEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.signal_analyzer.inst1.attribute.enable_dc_block.enum.disabled', int(new_val))


class RootLuSignal_analyzerInst1AttributeEnable_dc_block(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.enable_dc_block'
        self.enum = RootLuSignal_analyzerInst1AttributeEnable_dc_blockEnum(self._context)


class RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reset_flag_pll_unlocked'


class RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_ctrl_delta_f'


class RootLuSignal_analyzerInst1AttributeDelay_comp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.delay_comp'


class RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.reference_amplitude_factor'


class RootLuSignal_analyzerInst1AttributeCurrent_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_y'


class RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute.current_reference_amplitude'


class RootLuSignal_analyzerInst1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1.attribute'
        self.current_reference_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_reference_amplitude(self._context)
        self.current_y = RootLuSignal_analyzerInst1AttributeCurrent_y(self._context)
        self.reference_amplitude_factor = RootLuSignal_analyzerInst1AttributeReference_amplitude_factor(self._context)
        self.delay_comp = RootLuSignal_analyzerInst1AttributeDelay_comp(self._context)
        self.current_ctrl_delta_f = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_delta_f(self._context)
        self.reset_flag_pll_unlocked = RootLuSignal_analyzerInst1AttributeReset_flag_pll_unlocked(self._context)
        self.enable_dc_block = RootLuSignal_analyzerInst1AttributeEnable_dc_block(self._context)
        self.current_amplitude_binary = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_binary(self._context)
        self.current_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_mode(self._context)
        self.amplitude_ctrl_p_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_p_gain(self._context)
        self.current_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_amplitude(self._context)
        self.phase_ctrl_i_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_i_gain(self._context)
        self.current_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeCurrent_amplitude_ctrl_set_point(self._context)
        self.phase_lock_range = RootLuSignal_analyzerInst1AttributePhase_lock_range(self._context)
        self.input = RootLuSignal_analyzerInst1AttributeInput(self._context)
        self.reference_phase = RootLuSignal_analyzerInst1AttributeReference_phase(self._context)
        self.reference_source = RootLuSignal_analyzerInst1AttributeReference_source(self._context)
        self.phase_ctrl_p_gain = RootLuSignal_analyzerInst1AttributePhase_ctrl_p_gain(self._context)
        self.demodulator_bw = RootLuSignal_analyzerInst1AttributeDemodulator_bw(self._context)
        self.reference_amplitude = RootLuSignal_analyzerInst1AttributeReference_amplitude(self._context)
        self.display_df_range = RootLuSignal_analyzerInst1AttributeDisplay_df_range(self._context)
        self.amplitude_ctrl_set_point_calib_result = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_set_point_calib_result(self._context)
        self.harmonic_source = RootLuSignal_analyzerInst1AttributeHarmonic_source(self._context)
        self.current_phase = RootLuSignal_analyzerInst1AttributeCurrent_phase(self._context)
        self.target_amplitude_ctrl_set_point = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_set_point(self._context)
        self.amplitude_modulation = RootLuSignal_analyzerInst1AttributeAmplitude_modulation(self._context)
        self.current_ctrl_amplitude = RootLuSignal_analyzerInst1AttributeCurrent_ctrl_amplitude(self._context)
        self.current_x = RootLuSignal_analyzerInst1AttributeCurrent_x(self._context)
        self.reference_frequency = RootLuSignal_analyzerInst1AttributeReference_frequency(self._context)
        self.lock_in_calc_phase = RootLuSignal_analyzerInst1AttributeLock_in_calc_phase(self._context)
        self.target_amplitude_ctrl_mode = RootLuSignal_analyzerInst1AttributeTarget_amplitude_ctrl_mode(self._context)
        self.pll_unlocked = RootLuSignal_analyzerInst1AttributePll_unlocked(self._context)
        self.lock_in_calc_amplitude = RootLuSignal_analyzerInst1AttributeLock_in_calc_amplitude(self._context)
        self.current_y_binary = RootLuSignal_analyzerInst1AttributeCurrent_y_binary(self._context)
        self.amplitude_ctrl_i_gain = RootLuSignal_analyzerInst1AttributeAmplitude_ctrl_i_gain(self._context)
        self.operating_mode = RootLuSignal_analyzerInst1AttributeOperating_mode(self._context)
        self.current_phase_binary = RootLuSignal_analyzerInst1AttributeCurrent_phase_binary(self._context)
        self.current_x_binary = RootLuSignal_analyzerInst1AttributeCurrent_x_binary(self._context)


class RootLuSignal_analyzerInst1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer.inst1'
        self.attribute = RootLuSignal_analyzerInst1Attribute(self._context)
        self.trigger = RootLuSignal_analyzerInst1Trigger(self._context)


class RootLuSignal_analyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.signal_analyzer'
        self.inst1 = RootLuSignal_analyzerInst1(self._context)
        self.inst2 = RootLuSignal_analyzerInst2(self._context)


class RootLuSpecInstanceTriggerResume_last_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.resume_last_point'


class RootLuSpecInstanceTriggerResume_next_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.resume_next_point'


class RootLuSpecInstanceTriggerPause(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.pause'


class RootLuSpecInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.start'


class RootLuSpecInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.user_abort'


class RootLuSpecInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger'
        self.user_abort = RootLuSpecInstanceTriggerUser_abort(self._context)
        self.start = RootLuSpecInstanceTriggerStart(self._context)
        self.pause = RootLuSpecInstanceTriggerPause(self._context)
        self.resume_next_point = RootLuSpecInstanceTriggerResume_next_point(self._context)
        self.resume_last_point = RootLuSpecInstanceTriggerResume_last_point(self._context)


class RootLuSpecInstanceAttributeBwd_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_datapoints'


class RootLuSpecInstanceAttributeBwd_mod_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_range'


class RootLuSpecInstanceAttributeFwd_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_move_speed'


class RootLuSpecInstanceAttributeFwd_pause_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_datapoints'


class RootLuSpecInstanceAttributeFwd_mod_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_range'


class RootLuSpecInstanceAttributePhase_fwd_mod_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_mod_rate'


class RootLuSpecInstanceAttributePoint_coords_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.point_coords_blob_vec'


class RootLuSpecInstanceAttributeRepetition_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_count'


class RootLuSpecInstanceAttributeRepetition_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode.enum'

    @property
    def list(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.repetition_mode.enum.list'))

    @list.setter
    def list(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.enum.list', int(new_val))

    @property
    def position(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.repetition_mode.enum.position'))

    @position.setter
    def position(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.enum.position', int(new_val))


class RootLuSpecInstanceAttributeRepetition_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode'
        self.enum = RootLuSpecInstanceAttributeRepetition_modeEnum(self._context)


class RootLuSpecInstanceAttributeSpec_end_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode.enum'

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.enum.keep_last_z_pos', int(new_val))


class RootLuSpecInstanceAttributeSpec_end_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode'
        self.enum = RootLuSpecInstanceAttributeSpec_end_modeEnum(self._context)


class RootLuSpecInstanceAttributeBwd_mod_stop_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum'

    @property
    def is_less_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_less_than'))

    @is_less_than.setter
    def is_less_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_less_than', int(new_val))

    @property
    def is_greater_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_greater_than'))

    @is_greater_than.setter
    def is_greater_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_greater_than', int(new_val))


class RootLuSpecInstanceAttributeBwd_mod_stop_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_mod_stop_modeEnum(self._context)


class RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_configuration_blob_vec'


class RootLuSpecInstanceAttributeFwd_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_datapoints'


class RootLuSpecInstanceAttributePhase_data_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_data_group_id'


class RootLuSpecInstanceAttributeFwd_mod_stop_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum'

    @property
    def is_less_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_less_than'))

    @is_less_than.setter
    def is_less_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_less_than', int(new_val))

    @property
    def is_greater_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_greater_than'))

    @is_greater_than.setter
    def is_greater_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_greater_than', int(new_val))


class RootLuSpecInstanceAttributeFwd_mod_stop_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_mod_stop_modeEnum(self._context)


class RootLuSpecInstanceAttributePhase_bwd_pause_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_pause_rate'


class RootLuSpecInstanceAttributeBwd_pause_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode.enum'

    @property
    def z_on(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_on'))

    @z_on.setter
    def z_on(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_on', int(new_val))

    @property
    def z_off(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_off'))

    @z_off.setter
    def z_off(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_off', int(new_val))


class RootLuSpecInstanceAttributeBwd_pause_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_pause_modeEnum(self._context)


class RootLuSpecInstanceAttributeBwd_mod_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode.enum'

    @property
    def stop_by_value(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.enum.stop_by_value'))

    @stop_by_value.setter
    def stop_by_value(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.enum.stop_by_value', int(new_val))

    @property
    def fixed_length(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.enum.fixed_length'))

    @fixed_length.setter
    def fixed_length(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.enum.fixed_length', int(new_val))


class RootLuSpecInstanceAttributeBwd_mod_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_mod_modeEnum(self._context)


class RootLuSpecInstanceAttributeStart_offset_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset_move_speed'


class RootLuSpecInstanceAttributeXy_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.xy_move_speed'


class RootLuSpecInstanceAttributeFwd_pause_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode.enum'

    @property
    def z_on(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_on'))

    @z_on.setter
    def z_on(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_on', int(new_val))

    @property
    def z_off(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_off'))

    @z_off.setter
    def z_off(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_off', int(new_val))


class RootLuSpecInstanceAttributeFwd_pause_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_pause_modeEnum(self._context)


class RootLuSpecInstanceAttributeMod_rel_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.mod_rel_value'


class RootLuSpecInstanceAttributePhase_fwd_pause_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_pause_rate'


class RootLuSpecInstanceAttributeFwd_mod_stop_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_value'


class RootLuSpecInstanceAttributeBwd_mod_stop_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_value'


class RootLuSpecInstanceAttributeFwd_mod_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode.enum'

    @property
    def stop_by_value(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.enum.stop_by_value'))

    @stop_by_value.setter
    def stop_by_value(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.enum.stop_by_value', int(new_val))

    @property
    def fixed_length(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.enum.fixed_length'))

    @fixed_length.setter
    def fixed_length(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.enum.fixed_length', int(new_val))


class RootLuSpecInstanceAttributeFwd_mod_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_mod_modeEnum(self._context)


class RootLuSpecInstanceAttributeFeedback_active(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.feedback_active'


class RootLuSpecInstanceAttributePhase_sample_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_sample_mask'


class RootLuSpecInstanceAttributeStart_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset'


class RootLuSpecInstanceAttributePhase_bwd_mod_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_mod_rate'


class RootLuSpecInstanceAttributeBwd_pause_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_datapoints'


class RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.auto_recalibrate_probe_interval'


class RootLuSpecInstanceAttributeModulation_outputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output.enum'

    @property
    def external_z(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.external_z'))

    @external_z.setter
    def external_z(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.external_z', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.position_z', int(new_val))

    @property
    def tip_voltage(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.tip_voltage'))

    @tip_voltage.setter
    def tip_voltage(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.tip_voltage', int(new_val))


class RootLuSpecInstanceAttributeModulation_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output'
        self.enum = RootLuSpecInstanceAttributeModulation_outputEnum(self._context)


class RootLuSpecInstanceAttributeBwd_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_move_speed'


class RootLuSpecInstanceAttributeCurrent_repetition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.current_repetition'


class RootLuSpecInstanceAttributeFwd_pause_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_time'


class RootLuSpecInstanceAttributeSpec_map_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_mode'


class RootLuSpecInstanceAttributeBwd_mod_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_time'


class RootLuSpecInstanceAttributeDeflection_force_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.deflection_force_offset'


class RootLuSpecInstanceAttributeFwd_mod_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_time'


class RootLuSpecInstanceAttributeBwd_pause_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_time'


class RootLuSpecInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute'
        self.bwd_pause_time = RootLuSpecInstanceAttributeBwd_pause_time(self._context)
        self.fwd_mod_time = RootLuSpecInstanceAttributeFwd_mod_time(self._context)
        self.deflection_force_offset = RootLuSpecInstanceAttributeDeflection_force_offset(self._context)
        self.bwd_mod_time = RootLuSpecInstanceAttributeBwd_mod_time(self._context)
        self.spec_map_mode = RootLuSpecInstanceAttributeSpec_map_mode(self._context)
        self.fwd_pause_time = RootLuSpecInstanceAttributeFwd_pause_time(self._context)
        self.current_repetition = RootLuSpecInstanceAttributeCurrent_repetition(self._context)
        self.bwd_move_speed = RootLuSpecInstanceAttributeBwd_move_speed(self._context)
        self.modulation_output = RootLuSpecInstanceAttributeModulation_output(self._context)
        self.auto_recalibrate_probe_interval = RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(self._context)
        self.bwd_pause_datapoints = RootLuSpecInstanceAttributeBwd_pause_datapoints(self._context)
        self.phase_bwd_mod_rate = RootLuSpecInstanceAttributePhase_bwd_mod_rate(self._context)
        self.start_offset = RootLuSpecInstanceAttributeStart_offset(self._context)
        self.phase_sample_mask = RootLuSpecInstanceAttributePhase_sample_mask(self._context)
        self.feedback_active = RootLuSpecInstanceAttributeFeedback_active(self._context)
        self.fwd_mod_mode = RootLuSpecInstanceAttributeFwd_mod_mode(self._context)
        self.bwd_mod_stop_value = RootLuSpecInstanceAttributeBwd_mod_stop_value(self._context)
        self.fwd_mod_stop_value = RootLuSpecInstanceAttributeFwd_mod_stop_value(self._context)
        self.phase_fwd_pause_rate = RootLuSpecInstanceAttributePhase_fwd_pause_rate(self._context)
        self.mod_rel_value = RootLuSpecInstanceAttributeMod_rel_value(self._context)
        self.fwd_pause_mode = RootLuSpecInstanceAttributeFwd_pause_mode(self._context)
        self.xy_move_speed = RootLuSpecInstanceAttributeXy_move_speed(self._context)
        self.start_offset_move_speed = RootLuSpecInstanceAttributeStart_offset_move_speed(self._context)
        self.bwd_mod_mode = RootLuSpecInstanceAttributeBwd_mod_mode(self._context)
        self.bwd_pause_mode = RootLuSpecInstanceAttributeBwd_pause_mode(self._context)
        self.phase_bwd_pause_rate = RootLuSpecInstanceAttributePhase_bwd_pause_rate(self._context)
        self.fwd_mod_stop_mode = RootLuSpecInstanceAttributeFwd_mod_stop_mode(self._context)
        self.phase_data_group_id = RootLuSpecInstanceAttributePhase_data_group_id(self._context)
        self.fwd_datapoints = RootLuSpecInstanceAttributeFwd_datapoints(self._context)
        self.spec_map_configuration_blob_vec = RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(self._context)
        self.bwd_mod_stop_mode = RootLuSpecInstanceAttributeBwd_mod_stop_mode(self._context)
        self.spec_end_mode = RootLuSpecInstanceAttributeSpec_end_mode(self._context)
        self.repetition_mode = RootLuSpecInstanceAttributeRepetition_mode(self._context)
        self.repetition_count = RootLuSpecInstanceAttributeRepetition_count(self._context)
        self.point_coords_blob_vec = RootLuSpecInstanceAttributePoint_coords_blob_vec(self._context)
        self.phase_fwd_mod_rate = RootLuSpecInstanceAttributePhase_fwd_mod_rate(self._context)
        self.fwd_mod_range = RootLuSpecInstanceAttributeFwd_mod_range(self._context)
        self.fwd_pause_datapoints = RootLuSpecInstanceAttributeFwd_pause_datapoints(self._context)
        self.fwd_move_speed = RootLuSpecInstanceAttributeFwd_move_speed(self._context)
        self.bwd_mod_range = RootLuSpecInstanceAttributeBwd_mod_range(self._context)
        self.bwd_datapoints = RootLuSpecInstanceAttributeBwd_datapoints(self._context)


class RootLuSpecInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance'
        self.attribute = RootLuSpecInstanceAttribute(self._context)
        self.trigger = RootLuSpecInstanceTrigger(self._context)


class RootLuSpec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec'
        self.instance = RootLuSpecInstance(self._context)


class RootLuData_acquisitionInstanceBusyIs_capturing(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy.is_capturing'


class RootLuData_acquisitionInstanceBusyIs_sampling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy.is_sampling'


class RootLuData_acquisitionInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy'
        self.is_sampling = RootLuData_acquisitionInstanceBusyIs_sampling(self._context)
        self.is_capturing = RootLuData_acquisitionInstanceBusyIs_capturing(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum'

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_user', int(new_val))

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in2', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.in_deflection', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum.ctrl_w_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum'

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_user', int(new_val))

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in2', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum.ctrl_w_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum'

    @property
    def low_pass_100_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_hz'))

    @low_pass_100_hz.setter
    def low_pass_100_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_hz', int(new_val))

    @property
    def low_pass_2_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_2_k_hz'))

    @low_pass_2_k_hz.setter
    def low_pass_2_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_2_k_hz', int(new_val))

    @property
    def filter_userdefined(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.filter_userdefined'))

    @filter_userdefined.setter
    def filter_userdefined(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.filter_userdefined', int(new_val))

    @property
    def low_pass_10_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_hz'))

    @low_pass_10_hz.setter
    def low_pass_10_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_hz', int(new_val))

    @property
    def low_pass_5_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_k_hz'))

    @low_pass_5_k_hz.setter
    def low_pass_5_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_k_hz', int(new_val))

    @property
    def low_pass_200_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_200_hz'))

    @low_pass_200_hz.setter
    def low_pass_200_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_200_hz', int(new_val))

    @property
    def low_pass_100_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_k_hz'))

    @low_pass_100_k_hz.setter
    def low_pass_100_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_100_k_hz', int(new_val))

    @property
    def low_pass_500_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_500_hz'))

    @low_pass_500_hz.setter
    def low_pass_500_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_500_hz', int(new_val))

    @property
    def low_pass_50_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_k_hz'))

    @low_pass_50_k_hz.setter
    def low_pass_50_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_k_hz', int(new_val))

    @property
    def low_pass_50_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_hz'))

    @low_pass_50_hz.setter
    def low_pass_50_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_50_hz', int(new_val))

    @property
    def low_pass_1_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_1_k_hz'))

    @low_pass_1_k_hz.setter
    def low_pass_1_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_1_k_hz', int(new_val))

    @property
    def low_pass_5_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_hz'))

    @low_pass_5_hz.setter
    def low_pass_5_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_5_hz', int(new_val))

    @property
    def low_pass_10_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_k_hz'))

    @low_pass_10_k_hz.setter
    def low_pass_10_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_10_k_hz', int(new_val))

    @property
    def low_pass_20_k_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_k_hz'))

    @low_pass_20_k_hz.setter
    def low_pass_20_k_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_k_hz', int(new_val))

    @property
    def low_pass_20_hz(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_hz'))

    @low_pass_20_hz.setter
    def low_pass_20_hz(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum.low_pass_20_hz', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_mode'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_filter_modeEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask'


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum'

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_user'))

    @in_user.setter
    def in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_user', int(new_val))

    @property
    def in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in2'))

    @in2.setter
    def in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in2', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.in_deflection', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum.ctrl_w_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_sampler_sets'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum'

    @property
    def window_rectangular(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_rectangular'))

    @window_rectangular.setter
    def window_rectangular(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_rectangular', int(new_val))

    @property
    def window_hamming(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_hamming'))

    @window_hamming.setter
    def window_hamming(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_hamming', int(new_val))

    @property
    def window_nuttall(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_nuttall'))

    @window_nuttall.setter
    def window_nuttall(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum.window_nuttall', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_type'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_filter_typeEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_channel_mask'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributePhase_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_count'


class RootLuData_acquisitionInstanceAttributePhase_sampler_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_group_id'


class RootLuData_acquisitionInstanceAttributeCapture_fast_sampling_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_datapoints'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributePhase_mode_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_mode_enabled'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_datapoints'


class RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec'


class RootLuData_acquisitionInstanceAttributeSampler_trigger_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum'

    @property
    def internal_timer(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.internal_timer'))

    @internal_timer.setter
    def internal_timer(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.internal_timer', int(new_val))

    @property
    def num_trigger_modes(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.num_trigger_modes'))

    @num_trigger_modes.setter
    def num_trigger_modes(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.num_trigger_modes', int(new_val))

    @property
    def external_trigger(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.external_trigger'))

    @external_trigger.setter
    def external_trigger(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum.external_trigger', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_trigger_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_trigger_mode'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_trigger_modeEnum(self._context)


class RootLuData_acquisitionInstanceAttributePhase_sampler_end_datapoint_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec'


class RootLuData_acquisitionInstanceAttributeCapture_fast_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_group_id'


class RootLuData_acquisitionInstanceAttributeActive_capture_set(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_capture_set'


class RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_capture_sets'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id'


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input'
        self.enum = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_inputEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_filter_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_size'


class RootLuData_acquisitionInstanceAttributeActive_sampler_set(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_sampler_set'


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum.ctrl_y_out', int(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec'
        self.enum = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vecEnum(self._context)


class RootLuData_acquisitionInstanceAttributeSampler_data_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_data_rate'


class RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode'


class RootLuData_acquisitionInstanceAttributeSampler_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_group_id'


class RootLuData_acquisitionInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute'
        self.sampler_group_id = RootLuData_acquisitionInstanceAttributeSampler_group_id(self._context)
        self.sampler_auto_set_filter_mode = RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(self._context)
        self.sampler_data_rate = RootLuData_acquisitionInstanceAttributeSampler_data_rate(self._context)
        self.sampler_hi_res_ch_input_vec = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(self._context)
        self.active_sampler_set = RootLuData_acquisitionInstanceAttributeActive_sampler_set(self._context)
        self.sampler_filter_size = RootLuData_acquisitionInstanceAttributeSampler_filter_size(self._context)
        self.capture_hi_res_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(self._context)
        self.capture_hi_res_group_id = RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(self._context)
        self.capture_fast_channel_mask = RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(self._context)
        self.sampler_hi_res_ch3_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input(self._context)
        self.capture_hi_res_datapoints = RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(self._context)
        self.sampler_hi_res_ch6_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(self._context)
        self.number_of_capture_sets = RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(self._context)
        self.active_capture_set = RootLuData_acquisitionInstanceAttributeActive_capture_set(self._context)
        self.capture_fast_group_id = RootLuData_acquisitionInstanceAttributeCapture_fast_group_id(self._context)
        self.phase_sampler_end_datapoint_vec = RootLuData_acquisitionInstanceAttributePhase_sampler_end_datapoint_vec(self._context)
        self.sampler_trigger_mode = RootLuData_acquisitionInstanceAttributeSampler_trigger_mode(self._context)
        self.phase_sampler_data_rate_vec = RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(self._context)
        self.sampler_datapoints = RootLuData_acquisitionInstanceAttributeSampler_datapoints(self._context)
        self.capture_hi_res_ch3_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(self._context)
        self.sampler_hi_res_ch5_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input(self._context)
        self.sampler_hi_res_ch4_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input(self._context)
        self.phase_mode_enabled = RootLuData_acquisitionInstanceAttributePhase_mode_enabled(self._context)
        self.sampler_hi_res_ch2_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(self._context)
        self.sampler_hi_res_ch0_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input(self._context)
        self.capture_fast_datapoints = RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(self._context)
        self.capture_hi_res_ch4_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input(self._context)
        self.capture_fast_sampling_rate = RootLuData_acquisitionInstanceAttributeCapture_fast_sampling_rate(self._context)
        self.phase_sampler_group_id = RootLuData_acquisitionInstanceAttributePhase_sampler_group_id(self._context)
        self.phase_count = RootLuData_acquisitionInstanceAttributePhase_count(self._context)
        self.capture_hi_res_ch5_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input(self._context)
        self.sampler_filter_cutoff = RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(self._context)
        self.capture_hi_res_ch6_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input(self._context)
        self.sampler_channel_mask = RootLuData_acquisitionInstanceAttributeSampler_channel_mask(self._context)
        self.sampler_filter_type = RootLuData_acquisitionInstanceAttributeSampler_filter_type(self._context)
        self.capture_hi_res_ch2_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(self._context)
        self.sampler_hi_res_ch7_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input(self._context)
        self.sampler_hi_res_ch1_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input(self._context)
        self.number_of_sampler_sets = RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(self._context)
        self.capture_hi_res_ch_input_vec = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(self._context)
        self.capture_fast_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(self._context)
        self.capture_hi_res_channel_mask = RootLuData_acquisitionInstanceAttributeCapture_hi_res_channel_mask(self._context)
        self.capture_hi_res_ch7_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(self._context)
        self.sampler_filter_mode = RootLuData_acquisitionInstanceAttributeSampler_filter_mode(self._context)
        self.capture_hi_res_ch1_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(self._context)
        self.capture_fast_ch_input_vec = RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(self._context)
        self.capture_fast_ch1_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(self._context)


class RootLuData_acquisitionInstanceTriggerSampler_prepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.sampler_prepare'


class RootLuData_acquisitionInstanceTriggerSampler_start(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.sampler_start'


class RootLuData_acquisitionInstanceTriggerSampler_trim_data_storage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.sampler_trim_data_storage'


class RootLuData_acquisitionInstanceTriggerSampler_start_data_simulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.sampler_start_data_simulation'


class RootLuData_acquisitionInstanceTriggerBackground_capture_start(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.background_capture_start'


class RootLuData_acquisitionInstanceTriggerCapture_trim_data_storage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.capture_trim_data_storage'


class RootLuData_acquisitionInstanceTriggerCapture_start(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.capture_start'


class RootLuData_acquisitionInstanceTriggerCapture_prepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.capture_prepare'


class RootLuData_acquisitionInstanceTriggerSampler_init_phase_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.sampler_init_phase_mode'


class RootLuData_acquisitionInstanceTriggerBackground_sampler_start(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.background_sampler_start'


class RootLuData_acquisitionInstanceTriggerAbort_all(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.abort_all'


class RootLuData_acquisitionInstanceTriggerCapture_start_data_simulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger.capture_start_data_simulation'


class RootLuData_acquisitionInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger'
        self.capture_start_data_simulation = RootLuData_acquisitionInstanceTriggerCapture_start_data_simulation(self._context)
        self.abort_all = RootLuData_acquisitionInstanceTriggerAbort_all(self._context)
        self.background_sampler_start = RootLuData_acquisitionInstanceTriggerBackground_sampler_start(self._context)
        self.sampler_init_phase_mode = RootLuData_acquisitionInstanceTriggerSampler_init_phase_mode(self._context)
        self.capture_prepare = RootLuData_acquisitionInstanceTriggerCapture_prepare(self._context)
        self.capture_start = RootLuData_acquisitionInstanceTriggerCapture_start(self._context)
        self.capture_trim_data_storage = RootLuData_acquisitionInstanceTriggerCapture_trim_data_storage(self._context)
        self.background_capture_start = RootLuData_acquisitionInstanceTriggerBackground_capture_start(self._context)
        self.sampler_start_data_simulation = RootLuData_acquisitionInstanceTriggerSampler_start_data_simulation(self._context)
        self.sampler_trim_data_storage = RootLuData_acquisitionInstanceTriggerSampler_trim_data_storage(self._context)
        self.sampler_start = RootLuData_acquisitionInstanceTriggerSampler_start(self._context)
        self.sampler_prepare = RootLuData_acquisitionInstanceTriggerSampler_prepare(self._context)


class RootLuData_acquisitionInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance'
        self.trigger = RootLuData_acquisitionInstanceTrigger(self._context)
        self.attribute = RootLuData_acquisitionInstanceAttribute(self._context)
        self.busy = RootLuData_acquisitionInstanceBusy(self._context)


class RootLuData_acquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition'
        self.instance = RootLuData_acquisitionInstance(self._context)


class RootLuSystem_infraInstanceTriggerDetect_scan_head_lever_change(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_scan_head_lever_change'


class RootLuSystem_infraInstanceTriggerSwitch_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.switch_clock_source'


class RootLuSystem_infraInstanceTriggerDetect_limit_switch_status_info_change(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_limit_switch_status_info_change'


class RootLuSystem_infraInstanceTriggerDetect_scan_head_arrival_removal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_scan_head_arrival_removal'


class RootLuSystem_infraInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger'
        self.detect_scan_head_arrival_removal = RootLuSystem_infraInstanceTriggerDetect_scan_head_arrival_removal(self._context)
        self.detect_limit_switch_status_info_change = RootLuSystem_infraInstanceTriggerDetect_limit_switch_status_info_change(self._context)
        self.switch_clock_source = RootLuSystem_infraInstanceTriggerSwitch_clock_source(self._context)
        self.detect_scan_head_lever_change = RootLuSystem_infraInstanceTriggerDetect_scan_head_lever_change(self._context)


class RootLuSystem_infraInstanceAttributeDepreciated_2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_2'


class RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status'


class RootLuSystem_infraInstanceAttributeExtra_in1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.extra_in1_input'


class RootLuSystem_infraInstanceAttributeHas_video_source_detection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_video_source_detection'


class RootLuSystem_infraInstanceAttributeLaser_power_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_current'


class RootLuSystem_infraInstanceAttributeCurrent_clock_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_clock_source.enum'

    @property
    def external(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_clock_source.enum.external'))

    @external.setter
    def external(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_clock_source.enum.external', int(new_val))

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_clock_source.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_clock_source.enum.internal', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_clock_source'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_clock_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeMain_in1_couplingEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_coupling.enum'

    @property
    def dc_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.dc_coupling'))

    @dc_coupling.setter
    def dc_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.dc_coupling', int(new_val))

    @property
    def ac_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.ac_coupling'))

    @ac_coupling.setter
    def ac_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.ac_coupling', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in1_coupling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_coupling'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in1_couplingEnum(self._context)


class RootLuSystem_infraInstanceAttributeDepreciated_0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_0'


class RootLuSystem_infraInstanceAttributeMain_in1_gainEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_gain.enum'

    @property
    def gain16(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain16'))

    @gain16.setter
    def gain16(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain16', int(new_val))

    @property
    def gain4(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain4'))

    @gain4.setter
    def gain4(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain4', int(new_val))

    @property
    def gain1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain1'))

    @gain1.setter
    def gain1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain1', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in1_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_gain'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in1_gainEnum(self._context)


class RootLuSystem_infraInstanceAttributeScan_head_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.scan_head_type'


class RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum'

    @property
    def ana_gnd(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.ana_gnd'))

    @ana_gnd.setter
    def ana_gnd(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.ana_gnd', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.in_user3', int(new_val))

    @property
    def tip_current(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.tip_current'))

    @tip_current.setter
    def tip_current(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.tip_current', int(new_val))


class RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input'
        self.enum = RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_inputEnum(self._context)


class RootLuSystem_infraInstanceAttributeSensor_value_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_value_normalized'


class RootLuSystem_infraInstanceAttributeSensor_light(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_light'


class RootLuSystem_infraInstanceAttributeTip_signal_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_signal_mode.enum'

    @property
    def external_feedthrough(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.external_feedthrough'))

    @external_feedthrough.setter
    def external_feedthrough(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.external_feedthrough', int(new_val))

    @property
    def current_sense_input(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.current_sense_input'))

    @current_sense_input.setter
    def current_sense_input(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.current_sense_input', int(new_val))

    @property
    def voltage_output(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.voltage_output'))

    @voltage_output.setter
    def voltage_output(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.voltage_output', int(new_val))


class RootLuSystem_infraInstanceAttributeTip_signal_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_signal_mode'
        self.enum = RootLuSystem_infraInstanceAttributeTip_signal_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeMain_in2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_input.enum'

    @property
    def tip_current(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.tip_current'))

    @tip_current.setter
    def tip_current(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.tip_current', int(new_val))

    @property
    def user1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user1'))

    @user1.setter
    def user1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user1', int(new_val))

    @property
    def deflection(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.deflection'))

    @deflection.setter
    def deflection(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.deflection', int(new_val))

    @property
    def user2(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user2'))

    @user2.setter
    def user2(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user2', int(new_val))

    @property
    def test_ref(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ref'))

    @test_ref.setter
    def test_ref(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ref', int(new_val))

    @property
    def user3(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user3'))

    @user3.setter
    def user3(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user3', int(new_val))

    @property
    def test_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_tip_voltage'))

    @test_tip_voltage.setter
    def test_tip_voltage(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_tip_voltage', int(new_val))

    @property
    def lateral(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.lateral'))

    @lateral.setter
    def lateral(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.lateral', int(new_val))

    @property
    def test_ana_gnd(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ana_gnd'))

    @test_ana_gnd.setter
    def test_ana_gnd(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ana_gnd', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_input'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_inputEnum(self._context)


class RootLuSystem_infraInstanceAttributeFast_out2_output_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum'

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.all', int(new_val))

    @property
    def tip_voltage_or_user_out_a(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.tip_voltage_or_user_out_a'))

    @tip_voltage_or_user_out_a.setter
    def tip_voltage_or_user_out_a(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.tip_voltage_or_user_out_a', int(new_val))

    @property
    def monitor2(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor2'))

    @monitor2.setter
    def monitor2(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor2', int(new_val))

    @property
    def user_out1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out1'))

    @user_out1.setter
    def user_out1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out1', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.none', int(new_val))

    @property
    def monitor1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor1'))

    @monitor1.setter
    def monitor1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor1', int(new_val))

    @property
    def user_out_b(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out_b'))

    @user_out_b.setter
    def user_out_b(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out_b', int(new_val))


class RootLuSystem_infraInstanceAttributeFast_out2_output_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.fast_out2_output_mask'
        self.enum = RootLuSystem_infraInstanceAttributeFast_out2_output_maskEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_mode.enum'

    @property
    def detector_intensity(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.detector_intensity'))

    @detector_intensity.setter
    def detector_intensity(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.detector_intensity', int(new_val))

    @property
    def laser_drive(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_drive'))

    @laser_drive.setter
    def laser_drive(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_drive', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.undefined', int(new_val))

    @property
    def laser_power(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_power'))

    @laser_power.setter
    def laser_power(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_power', int(new_val))


class RootLuSystem_infraInstanceAttributeAfm_sensor_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_mode'
        self.enum = RootLuSystem_infraInstanceAttributeAfm_sensor_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.low', int(new_val))

    @property
    def fail(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.fail'))

    @fail.setter
    def fail(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.fail', int(new_val))

    @property
    def ok(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.ok'))

    @ok.setter
    def ok(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.ok', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.undefined', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.high', int(new_val))


class RootLuSystem_infraInstanceAttributeAfm_sensor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status'
        self.enum = RootLuSystem_infraInstanceAttributeAfm_sensor_statusEnum(self._context)


class RootLuSystem_infraInstanceAttributeLaser_power_lock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_lock'


class RootLuSystem_infraInstanceAttributeApproach_motor_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status.enum'

    @property
    def dummy_0(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.dummy_0'))

    @dummy_0.setter
    def dummy_0(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.dummy_0', int(new_val))

    @property
    def error(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.error'))

    @error.setter
    def error(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.error', int(new_val))

    @property
    def min_in(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.min_in'))

    @min_in.setter
    def min_in(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.min_in', int(new_val))

    @property
    def in_range(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.in_range'))

    @in_range.setter
    def in_range(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.in_range', int(new_val))

    @property
    def max_out(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.max_out'))

    @max_out.setter
    def max_out(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.max_out', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.not_connected', int(new_val))


class RootLuSystem_infraInstanceAttributeApproach_motor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status'
        self.enum = RootLuSystem_infraInstanceAttributeApproach_motor_statusEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status_normalized'


class RootLuSystem_infraInstanceAttributeInterface_box_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.interface_box_type.enum'

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.unknown', int(new_val))

    @property
    def i100_afsem(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_afsem'))

    @i100_afsem.setter
    def i100_afsem(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_afsem', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.not_connected', int(new_val))

    @property
    def icxarac(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxarac'))

    @icxarac.setter
    def icxarac(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxarac', int(new_val))

    @property
    def icxcytomass(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxcytomass'))

    @icxcytomass.setter
    def icxcytomass(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxcytomass', int(new_val))

    @property
    def i100(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100'))

    @i100.setter
    def i100(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100', int(new_val))

    @property
    def icxflex(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxflex'))

    @icxflex.setter
    def icxflex(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxflex', int(new_val))

    @property
    def icxp6(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxp6'))

    @icxp6.setter
    def icxp6(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxp6', int(new_val))

    @property
    def i100_integrated(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_integrated'))

    @i100_integrated.setter
    def i100_integrated(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_integrated', int(new_val))


class RootLuSystem_infraInstanceAttributeInterface_box_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.interface_box_type'
        self.enum = RootLuSystem_infraInstanceAttributeInterface_box_typeEnum(self._context)


class RootLuSystem_infraInstanceAttributeController_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_type.enum'

    @property
    def cx(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.cx'))

    @cx.setter
    def cx(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.cx', int(new_val))

    @property
    def core_afm(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.core_afm'))

    @core_afm.setter
    def core_afm(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.core_afm', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.unknown', int(new_val))

    @property
    def c3000_i(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.c3000_i'))

    @c3000_i.setter
    def c3000_i(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.c3000_i', int(new_val))

    @property
    def c3000(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.c3000'))

    @c3000.setter
    def c3000(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.c3000', int(new_val))


class RootLuSystem_infraInstanceAttributeController_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_type'
        self.enum = RootLuSystem_infraInstanceAttributeController_typeEnum(self._context)


class RootLuSystem_infraInstanceAttributeFriction_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.friction_normalized'


class RootLuSystem_infraInstanceAttributeMain_in2_couplingEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_coupling.enum'

    @property
    def dc_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.dc_coupling'))

    @dc_coupling.setter
    def dc_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.dc_coupling', int(new_val))

    @property
    def ac_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.ac_coupling'))

    @ac_coupling.setter
    def ac_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.ac_coupling', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_coupling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_coupling'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_couplingEnum(self._context)


class RootLuSystem_infraInstanceAttributeController_temperature(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_temperature'


class RootLuSystem_infraInstanceAttributeDepreciated_1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_1'


class RootLuSystem_infraInstanceAttributeLaser_power_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_absolute'


class RootLuSystem_infraInstanceAttributeApproach_motor_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_mode.enum'

    @property
    def position_sensor(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.position_sensor'))

    @position_sensor.setter
    def position_sensor(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.position_sensor', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.undefined', int(new_val))

    @property
    def limit_switches(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.limit_switches'))

    @limit_switches.setter
    def limit_switches(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.limit_switches', int(new_val))


class RootLuSystem_infraInstanceAttributeApproach_motor_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_mode'
        self.enum = RootLuSystem_infraInstanceAttributeApproach_motor_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeControl_laser_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.control_laser_power'


class RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection'


class RootLuSystem_infraInstanceAttributeDeflection_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.deflection_offset'


class RootLuSystem_infraInstanceAttributeApproach_motor_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_position'


class RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status_normalized'


class RootLuSystem_infraInstanceAttributeCurrent_video_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_video_source.enum'

    @property
    def side_view(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.side_view'))

    @side_view.setter
    def side_view(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.side_view', int(new_val))

    @property
    def top_view(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.top_view'))

    @top_view.setter
    def top_view(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.top_view', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_video_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_video_source'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_video_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeMain_in2_gainEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_gain.enum'

    @property
    def gain16(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain16'))

    @gain16.setter
    def gain16(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain16', int(new_val))

    @property
    def gain4(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain4'))

    @gain4.setter
    def gain4(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain4', int(new_val))

    @property
    def gain1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain1'))

    @gain1.setter
    def gain1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain1', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_gain'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_gainEnum(self._context)


class RootLuSystem_infraInstanceAttributeTarget_clock_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.target_clock_source.enum'

    @property
    def external(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.target_clock_source.enum.external'))

    @external.setter
    def external(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.target_clock_source.enum.external', int(new_val))

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.target_clock_source.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.target_clock_source.enum.internal', int(new_val))


class RootLuSystem_infraInstanceAttributeTarget_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.target_clock_source'
        self.enum = RootLuSystem_infraInstanceAttributeTarget_clock_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_positionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum'

    @property
    def working_pos(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.working_pos'))

    @working_pos.setter
    def working_pos(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.working_pos', int(new_val))

    @property
    def open_pos(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.open_pos'))

    @open_pos.setter
    def open_pos(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.open_pos', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_scanhead_tilt_position'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_positionEnum(self._context)


class RootLuSystem_infraInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute'
        self.current_scanhead_tilt_position = RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(self._context)
        self.target_clock_source = RootLuSystem_infraInstanceAttributeTarget_clock_source(self._context)
        self.main_in2_gain = RootLuSystem_infraInstanceAttributeMain_in2_gain(self._context)
        self.current_video_source = RootLuSystem_infraInstanceAttributeCurrent_video_source(self._context)
        self.approach_motor_status_normalized = RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(self._context)
        self.approach_motor_position = RootLuSystem_infraInstanceAttributeApproach_motor_position(self._context)
        self.deflection_offset = RootLuSystem_infraInstanceAttributeDeflection_offset(self._context)
        self.has_scanhead_tilt_detection = RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(self._context)
        self.control_laser_power = RootLuSystem_infraInstanceAttributeControl_laser_power(self._context)
        self.approach_motor_mode = RootLuSystem_infraInstanceAttributeApproach_motor_mode(self._context)
        self.laser_power_absolute = RootLuSystem_infraInstanceAttributeLaser_power_absolute(self._context)
        self.depreciated_1 = RootLuSystem_infraInstanceAttributeDepreciated_1(self._context)
        self.controller_temperature = RootLuSystem_infraInstanceAttributeController_temperature(self._context)
        self.main_in2_coupling = RootLuSystem_infraInstanceAttributeMain_in2_coupling(self._context)
        self.friction_normalized = RootLuSystem_infraInstanceAttributeFriction_normalized(self._context)
        self.controller_type = RootLuSystem_infraInstanceAttributeController_type(self._context)
        self.interface_box_type = RootLuSystem_infraInstanceAttributeInterface_box_type(self._context)
        self.afm_sensor_status_normalized = RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(self._context)
        self.approach_motor_status = RootLuSystem_infraInstanceAttributeApproach_motor_status(self._context)
        self.laser_power_lock = RootLuSystem_infraInstanceAttributeLaser_power_lock(self._context)
        self.afm_sensor_status = RootLuSystem_infraInstanceAttributeAfm_sensor_status(self._context)
        self.afm_sensor_mode = RootLuSystem_infraInstanceAttributeAfm_sensor_mode(self._context)
        self.fast_out2_output_mask = RootLuSystem_infraInstanceAttributeFast_out2_output_mask(self._context)
        self.main_in2_input = RootLuSystem_infraInstanceAttributeMain_in2_input(self._context)
        self.tip_signal_mode = RootLuSystem_infraInstanceAttributeTip_signal_mode(self._context)
        self.sensor_light = RootLuSystem_infraInstanceAttributeSensor_light(self._context)
        self.sensor_value_normalized = RootLuSystem_infraInstanceAttributeSensor_value_normalized(self._context)
        self.tip_current_or_in_user3_input = RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(self._context)
        self.scan_head_type = RootLuSystem_infraInstanceAttributeScan_head_type(self._context)
        self.main_in1_gain = RootLuSystem_infraInstanceAttributeMain_in1_gain(self._context)
        self.depreciated_0 = RootLuSystem_infraInstanceAttributeDepreciated_0(self._context)
        self.main_in1_coupling = RootLuSystem_infraInstanceAttributeMain_in1_coupling(self._context)
        self.current_clock_source = RootLuSystem_infraInstanceAttributeCurrent_clock_source(self._context)
        self.laser_power_current = RootLuSystem_infraInstanceAttributeLaser_power_current(self._context)
        self.has_video_source_detection = RootLuSystem_infraInstanceAttributeHas_video_source_detection(self._context)
        self.extra_in1_input = RootLuSystem_infraInstanceAttributeExtra_in1_input(self._context)
        self.enable10_hz_update_sensor_status = RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(self._context)
        self.depreciated_2 = RootLuSystem_infraInstanceAttributeDepreciated_2(self._context)


class RootLuSystem_infraInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance'
        self.attribute = RootLuSystem_infraInstanceAttribute(self._context)
        self.trigger = RootLuSystem_infraInstanceTrigger(self._context)


class RootLuSystem_infra(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra'
        self.instance = RootLuSystem_infraInstance(self._context)


class RootLuTestInstanceTriggerForce_all_dac_to_zero(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.trigger.force_all_dac_to_zero'


class RootLuTestInstanceTriggerForce_all_dac_to_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.trigger.force_all_dac_to_min'


class RootLuTestInstanceTriggerForce_all_dac_to_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.trigger.force_all_dac_to_max'


class RootLuTestInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.trigger'
        self.force_all_dac_to_max = RootLuTestInstanceTriggerForce_all_dac_to_max(self._context)
        self.force_all_dac_to_min = RootLuTestInstanceTriggerForce_all_dac_to_min(self._context)
        self.force_all_dac_to_zero = RootLuTestInstanceTriggerForce_all_dac_to_zero(self._context)


class RootLuTestInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance.attribute'


class RootLuTestInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test.instance'
        self.attribute = RootLuTestInstanceAttribute(self._context)
        self.trigger = RootLuTestInstanceTrigger(self._context)


class RootLuTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.test'
        self.instance = RootLuTestInstance(self._context)


class RootLuSystemInstanceTriggerExit_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_idle'


class RootLuSystemInstanceTriggerOffset_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.offset_xyz'


class RootLuSystemInstanceTriggerExit_uncal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_uncal'


class RootLuSystemInstanceTriggerEntry_approach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_approach'


class RootLuSystemInstanceTriggerMotor_reference(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_reference'


class RootLuSystemInstanceTriggerMotor_reference_and_move_back(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_reference_and_move_back'


class RootLuSystemInstanceTriggerMotor_step(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_step'


class RootLuSystemInstanceTriggerExit_scan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_scan'


class RootLuSystemInstanceTriggerMotor_set_pos_zero(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_set_pos_zero'


class RootLuSystemInstanceTriggerMotor_stop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_stop'


class RootLuSystemInstanceTriggerExit_macro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_macro_cmd'


class RootLuSystemInstanceTriggerStart_system_startup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.start_system_startup'


class RootLuSystemInstanceTriggerEntry_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_idle'


class RootLuSystemInstanceTriggerEntry_litho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_litho'


class RootLuSystemInstanceTriggerMotor_move(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_move'


class RootLuSystemInstanceTriggerEntry_scan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_scan'


class RootLuSystemInstanceTriggerExit_spec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_spec'


class RootLuSystemInstanceTriggerEntry_uncal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_uncal'


class RootLuSystemInstanceTriggerEntry_spec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_spec'


class RootLuSystemInstanceTriggerExit_approach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_approach'


class RootLuSystemInstanceTriggerEntry_macro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_macro_cmd'


class RootLuSystemInstanceTriggerForce_motor_pos_update(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.force_motor_pos_update'


class RootLuSystemInstanceTriggerLevel_scanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.level_scanhead'


class RootLuSystemInstanceTriggerExit_litho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_litho'


class RootLuSystemInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger'
        self.exit_litho = RootLuSystemInstanceTriggerExit_litho(self._context)
        self.level_scanhead = RootLuSystemInstanceTriggerLevel_scanhead(self._context)
        self.force_motor_pos_update = RootLuSystemInstanceTriggerForce_motor_pos_update(self._context)
        self.entry_macro_cmd = RootLuSystemInstanceTriggerEntry_macro_cmd(self._context)
        self.exit_approach = RootLuSystemInstanceTriggerExit_approach(self._context)
        self.entry_spec = RootLuSystemInstanceTriggerEntry_spec(self._context)
        self.entry_uncal = RootLuSystemInstanceTriggerEntry_uncal(self._context)
        self.exit_spec = RootLuSystemInstanceTriggerExit_spec(self._context)
        self.entry_scan = RootLuSystemInstanceTriggerEntry_scan(self._context)
        self.motor_move = RootLuSystemInstanceTriggerMotor_move(self._context)
        self.entry_litho = RootLuSystemInstanceTriggerEntry_litho(self._context)
        self.entry_idle = RootLuSystemInstanceTriggerEntry_idle(self._context)
        self.start_system_startup = RootLuSystemInstanceTriggerStart_system_startup(self._context)
        self.exit_macro_cmd = RootLuSystemInstanceTriggerExit_macro_cmd(self._context)
        self.motor_stop = RootLuSystemInstanceTriggerMotor_stop(self._context)
        self.motor_set_pos_zero = RootLuSystemInstanceTriggerMotor_set_pos_zero(self._context)
        self.exit_scan = RootLuSystemInstanceTriggerExit_scan(self._context)
        self.motor_step = RootLuSystemInstanceTriggerMotor_step(self._context)
        self.motor_reference_and_move_back = RootLuSystemInstanceTriggerMotor_reference_and_move_back(self._context)
        self.motor_reference = RootLuSystemInstanceTriggerMotor_reference(self._context)
        self.entry_approach = RootLuSystemInstanceTriggerEntry_approach(self._context)
        self.exit_uncal = RootLuSystemInstanceTriggerExit_uncal(self._context)
        self.offset_xyz = RootLuSystemInstanceTriggerOffset_xyz(self._context)
        self.exit_idle = RootLuSystemInstanceTriggerExit_idle(self._context)


class RootLuSystemInstanceAttributeMotor_move_speed_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_speed_factor'


class RootLuSystemInstanceAttributeIdle_external_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z'


class RootLuSystemInstanceAttributeOperating_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.operating_mode.enum'

    @property
    def static_afm(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.static_afm'))

    @static_afm.setter
    def static_afm(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.static_afm', int(new_val))

    @property
    def fm_dynamic_afm(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.fm_dynamic_afm'))

    @fm_dynamic_afm.setter
    def fm_dynamic_afm(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.fm_dynamic_afm', int(new_val))

    @property
    def user_defined(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.user_defined'))

    @user_defined.setter
    def user_defined(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.user_defined', int(new_val))

    @property
    def resistivity_map(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.resistivity_map'))

    @resistivity_map.setter
    def resistivity_map(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.resistivity_map', int(new_val))

    @property
    def const_phase(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.const_phase'))

    @const_phase.setter
    def const_phase(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.const_phase', int(new_val))

    @property
    def force_modulation(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.force_modulation'))

    @force_modulation.setter
    def force_modulation(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.force_modulation', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.undefined', int(new_val))

    @property
    def stm(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.stm'))

    @stm.setter
    def stm(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.stm', int(new_val))

    @property
    def lateral_force(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.lateral_force'))

    @lateral_force.setter
    def lateral_force(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.lateral_force', int(new_val))

    @property
    def phase_contrast(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.phase_contrast'))

    @phase_contrast.setter
    def phase_contrast(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.phase_contrast', int(new_val))

    @property
    def dynamic_afm(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.enum.dynamic_afm'))

    @dynamic_afm.setter
    def dynamic_afm(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum.dynamic_afm', int(new_val))


class RootLuSystemInstanceAttributeOperating_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.operating_mode'
        self.enum = RootLuSystemInstanceAttributeOperating_modeEnum(self._context)


class RootLuSystemInstanceAttributeZ_axis_ctrl_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.z_axis_ctrl_mode.enum'

    @property
    def position_sensing(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_sensing'))

    @position_sensing.setter
    def position_sensing(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_sensing', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.undefined', int(new_val))

    @property
    def position_control(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_control'))

    @position_control.setter
    def position_control(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_control', int(new_val))

    @property
    def position_drive(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_drive'))

    @position_drive.setter
    def position_drive(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum.position_drive', int(new_val))


class RootLuSystemInstanceAttributeZ_axis_ctrl_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.z_axis_ctrl_mode'
        self.enum = RootLuSystemInstanceAttributeZ_axis_ctrl_modeEnum(self._context)


class RootLuSystemInstanceAttributeMeasurement_environmentEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.measurement_environment.enum'

    @property
    def vacuum(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.vacuum'))

    @vacuum.setter
    def vacuum(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.vacuum', int(new_val))

    @property
    def air(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.air'))

    @air.setter
    def air(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.air', int(new_val))

    @property
    def liquid(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.liquid'))

    @liquid.setter
    def liquid(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.liquid', int(new_val))


class RootLuSystemInstanceAttributeMeasurement_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.measurement_environment'
        self.enum = RootLuSystemInstanceAttributeMeasurement_environmentEnum(self._context)


class RootLuSystemInstanceAttributeMotor_selectionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_selection.enum'

    @property
    def motor_ptey(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_ptey'))

    @motor_ptey.setter
    def motor_ptey(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_ptey', int(new_val))

    @property
    def motor_beam_deflection_y(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_y'))

    @motor_beam_deflection_y.setter
    def motor_beam_deflection_y(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_y', int(new_val))

    @property
    def motor_photodiode_lateral(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_lateral'))

    @motor_photodiode_lateral.setter
    def motor_photodiode_lateral(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_lateral', int(new_val))

    @property
    def motor_c(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_c'))

    @motor_c.setter
    def motor_c(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_c', int(new_val))

    @property
    def motor_ptex(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_ptex'))

    @motor_ptex.setter
    def motor_ptex(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_ptex', int(new_val))

    @property
    def motor_b(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_b'))

    @motor_b.setter
    def motor_b(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_b', int(new_val))

    @property
    def motor_photodiode_normal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_normal'))

    @motor_photodiode_normal.setter
    def motor_photodiode_normal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_normal', int(new_val))

    @property
    def motor_lens_gimbal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_lens_gimbal'))

    @motor_lens_gimbal.setter
    def motor_lens_gimbal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_lens_gimbal', int(new_val))

    @property
    def motor_beam_deflection_x(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_x'))

    @motor_beam_deflection_x.setter
    def motor_beam_deflection_x(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_x', int(new_val))

    @property
    def motor_a(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_a'))

    @motor_a.setter
    def motor_a(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_a', int(new_val))

    @property
    def motor_approach(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_approach'))

    @motor_approach.setter
    def motor_approach(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_approach', int(new_val))

    @property
    def motor_focus(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_focus'))

    @motor_focus.setter
    def motor_focus(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_focus', int(new_val))


class RootLuSystemInstanceAttributeMotor_selection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_selection'
        self.enum = RootLuSystemInstanceAttributeMotor_selectionEnum(self._context)


class RootLuSystemInstanceAttributeIdle_position_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z'


class RootLuSystemInstanceAttributeHi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.hi_res_ch5_input'


class RootLuSystemInstanceAttributeOp_mode_kpfm_enabledEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.disabled', int(new_val))


class RootLuSystemInstanceAttributeOp_mode_kpfm_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.op_mode_kpfm_enabled'
        self.enum = RootLuSystemInstanceAttributeOp_mode_kpfm_enabledEnum(self._context)


class RootLuSystemInstanceAttributeSystem_stateEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.system_state.enum'

    @property
    def uncal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.uncal'))

    @uncal.setter
    def uncal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.uncal', int(new_val))

    @property
    def scan(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.scan'))

    @scan.setter
    def scan(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.scan', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.idle', int(new_val))

    @property
    def approach(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.approach'))

    @approach.setter
    def approach(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.approach', int(new_val))

    @property
    def spec(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.spec'))

    @spec.setter
    def spec(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.spec', int(new_val))

    @property
    def macro_cmd(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.macro_cmd'))

    @macro_cmd.setter
    def macro_cmd(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.macro_cmd', int(new_val))

    @property
    def litho(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.litho'))

    @litho.setter
    def litho(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.litho', int(new_val))

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.internal', int(new_val))


class RootLuSystemInstanceAttributeSystem_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.system_state'
        self.enum = RootLuSystemInstanceAttributeSystem_stateEnum(self._context)


class RootLuSystemInstanceAttributeMotor_step_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_step_size'


class RootLuSystemInstanceAttributeMotor_move_directionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_direction.enum'

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_move_direction.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.enum.positive', int(new_val))

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_move_direction.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.enum.negative', int(new_val))


class RootLuSystemInstanceAttributeMotor_move_direction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_direction'
        self.enum = RootLuSystemInstanceAttributeMotor_move_directionEnum(self._context)


class RootLuSystemInstanceAttributeIdle_external_z_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z_mode.enum'

    @property
    def retract_tip(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.retract_tip'))

    @retract_tip.setter
    def retract_tip(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.retract_tip', int(new_val))

    @property
    def absolute_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.absolute_z_pos'))

    @absolute_z_pos.setter
    def absolute_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.absolute_z_pos', int(new_val))

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.keep_last_z_pos', int(new_val))


class RootLuSystemInstanceAttributeIdle_external_z_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_external_z_modeEnum(self._context)


class RootLuSystemInstanceAttributeHi_res_ch4_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.hi_res_ch4_input'


class RootLuSystemInstanceAttributeIdle_position_z_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z_mode.enum'

    @property
    def retract_tip(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.retract_tip'))

    @retract_tip.setter
    def retract_tip(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.retract_tip', int(new_val))

    @property
    def absolute_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.absolute_z_pos'))

    @absolute_z_pos.setter
    def absolute_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.absolute_z_pos', int(new_val))

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.keep_last_z_pos', int(new_val))


class RootLuSystemInstanceAttributeIdle_position_z_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_position_z_modeEnum(self._context)


class RootLuSystemInstanceAttributeMemory_available(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.memory_available'


class RootLuSystemInstanceAttributeIdle_position_xy_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_xy_mode.enum'

    @property
    def keep_last_xy_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.enum.keep_last_xy_pos'))

    @keep_last_xy_pos.setter
    def keep_last_xy_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.enum.keep_last_xy_pos', int(new_val))

    @property
    def image_center(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.enum.image_center'))

    @image_center.setter
    def image_center(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.enum.image_center', int(new_val))


class RootLuSystemInstanceAttributeIdle_position_xy_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_xy_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_position_xy_modeEnum(self._context)


class RootLuSystemInstanceAttributeMemory_block_available(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.memory_block_available'


class RootLuSystemInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute'
        self.memory_block_available = RootLuSystemInstanceAttributeMemory_block_available(self._context)
        self.idle_position_xy_mode = RootLuSystemInstanceAttributeIdle_position_xy_mode(self._context)
        self.memory_available = RootLuSystemInstanceAttributeMemory_available(self._context)
        self.idle_position_z_mode = RootLuSystemInstanceAttributeIdle_position_z_mode(self._context)
        self.hi_res_ch4_input = RootLuSystemInstanceAttributeHi_res_ch4_input(self._context)
        self.idle_external_z_mode = RootLuSystemInstanceAttributeIdle_external_z_mode(self._context)
        self.motor_move_direction = RootLuSystemInstanceAttributeMotor_move_direction(self._context)
        self.motor_step_size = RootLuSystemInstanceAttributeMotor_step_size(self._context)
        self.system_state = RootLuSystemInstanceAttributeSystem_state(self._context)
        self.op_mode_kpfm_enabled = RootLuSystemInstanceAttributeOp_mode_kpfm_enabled(self._context)
        self.hi_res_ch5_input = RootLuSystemInstanceAttributeHi_res_ch5_input(self._context)
        self.idle_position_z = RootLuSystemInstanceAttributeIdle_position_z(self._context)
        self.motor_selection = RootLuSystemInstanceAttributeMotor_selection(self._context)
        self.measurement_environment = RootLuSystemInstanceAttributeMeasurement_environment(self._context)
        self.z_axis_ctrl_mode = RootLuSystemInstanceAttributeZ_axis_ctrl_mode(self._context)
        self.operating_mode = RootLuSystemInstanceAttributeOperating_mode(self._context)
        self.idle_external_z = RootLuSystemInstanceAttributeIdle_external_z(self._context)
        self.motor_move_speed_factor = RootLuSystemInstanceAttributeMotor_move_speed_factor(self._context)


class RootLuSystemInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance'
        self.attribute = RootLuSystemInstanceAttribute(self._context)
        self.trigger = RootLuSystemInstanceTrigger(self._context)


class RootLuSystem(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system'
        self.instance = RootLuSystemInstance(self._context)


class RootLuAnalog_hi_res_outPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.trigger'


class RootLuAnalog_hi_res_outPosition_yAttributeCurrent_output_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.current_output_value'


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_lo_word_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_lo_word_gain'


class RootLuAnalog_hi_res_outPosition_yAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_lo_word_delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_lo_word_delay'


class RootLuAnalog_hi_res_outPosition_yAttributeGlitch_corr_enabledEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled.enum'

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled.enum.disabled', int(new_val))


class RootLuAnalog_hi_res_outPosition_yAttributeGlitch_corr_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_enabled'
        self.enum = RootLuAnalog_hi_res_outPosition_yAttributeGlitch_corr_enabledEnum(self._context)


class RootLuAnalog_hi_res_outPosition_yAttributeInputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_user2_out', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_y', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_y', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in_user', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in2', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_reference', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in6', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_x', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_out', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_excitation', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_error', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_x', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_user4', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_y', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_sum', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.fast_in_deflection', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_max_z', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_test', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_z', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_position_x', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_amplitude', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_w_out', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_drive_y', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_out8', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.memory_gen_position_x', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.gen_test_dynamic', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ort_free_wave', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ramp_gen_position_y', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_position_x', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.static', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.in_detector_sum', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_x_out', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.analyzer2_reference', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.input.enum.ctrl_y_out', int(new_val))


class RootLuAnalog_hi_res_outPosition_yAttributeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.input'
        self.enum = RootLuAnalog_hi_res_outPosition_yAttributeInputEnum(self._context)


class RootLuAnalog_hi_res_outPosition_yAttributeStatic_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.static_value'


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_sig_source_dirEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir.enum'

    @property
    def from_input_to_output(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir.enum.from_input_to_output'))

    @from_input_to_output.setter
    def from_input_to_output(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir.enum.from_input_to_output', int(new_val))

    @property
    def from_output_to_input(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir.enum.from_output_to_input'))

    @from_output_to_input.setter
    def from_output_to_input(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir.enum.from_output_to_input', int(new_val))


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_sig_source_dir(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_sig_source_dir'
        self.enum = RootLuAnalog_hi_res_outPosition_yAttributeCalib_sig_source_dirEnum(self._context)


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_offset'


class RootLuAnalog_hi_res_outPosition_yAttributeOutput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.output_offset'


class RootLuAnalog_hi_res_outPosition_yAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.filter_number'


class RootLuAnalog_hi_res_outPosition_yAttributeSlew_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.slew_rate'


class RootLuAnalog_hi_res_outPosition_yAttributeOutput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.output_gain'


class RootLuAnalog_hi_res_outPosition_yAttributeGlitch_corr_binary_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.glitch_corr_binary_vec'


class RootLuAnalog_hi_res_outPosition_yAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.calib_gain'


class RootLuAnalog_hi_res_outPosition_yAttributeModulationEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.modulation.enum'

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.ort_excitation', int(new_val))

    @property
    def hi_res_signal(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.hi_res_signal'))

    @hi_res_signal.setter
    def hi_res_signal(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.hi_res_signal', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.enabled', int(new_val))

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.disabled', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation.enum.analyzer2_reference', int(new_val))


class RootLuAnalog_hi_res_outPosition_yAttributeModulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.modulation'
        self.enum = RootLuAnalog_hi_res_outPosition_yAttributeModulationEnum(self._context)


class RootLuAnalog_hi_res_outPosition_yAttributeModulation_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum'

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.memory_gen_position_z', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user2', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user3', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_user1', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_deflection', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_position_z', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.memory_gen_out7', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_adhesion_position', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.in_tip_current', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ctrl_z_in', int(new_val))

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_y', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_baseline', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.ort_adhesion_value', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_out.position_y.attribute.modulation_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_user2_out(s