"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustBoundaryType = exports.TrustBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class TrustBoundary extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.tags = props.tags;
        this.technicalAssetsInside = new Set();
        this.trustBoundariesNested = new Set();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
    }
    addTechnicalAssets(...assets) {
        assets.forEach((a) => {
            this.technicalAssetsInside.add(a.uuid);
        });
    }
    addTrustBoundary(boundary) {
        this.trustBoundariesNested.add(boundary.uuid);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                tags: Array.from(new Set(this.tags)),
                technical_assets_inside: Array.from(this.technicalAssetsInside),
                trust_boundaries_nested: Array.from(this.trustBoundariesNested),
            },
        };
    }
}
exports.TrustBoundary = TrustBoundary;
_a = JSII_RTTI_SYMBOL_1;
TrustBoundary[_a] = { fqn: "cdktg.TrustBoundary", version: "0.0.20" };
var TrustBoundaryType;
(function (TrustBoundaryType) {
    TrustBoundaryType["NETWORK_ON_PREM"] = "network-on-prem";
    TrustBoundaryType["NETWORK_DEDICATED_HOSTER"] = "network-dedicated-hoster";
    TrustBoundaryType["NETWORK_VIRTUAL_LAN"] = "network-virtual-lan";
    TrustBoundaryType["NETWORK_CLOUD_PROVIDER"] = "network-cloud-provider";
    TrustBoundaryType["NETWORK_CLOUD_SECURITY_GROUP"] = "network-cloud-security-group";
    TrustBoundaryType["NETWORK_POLICY_NAMESPACE_ISOLATION"] = "network-policy-namespace-isolation";
    TrustBoundaryType["EXECUTION_ENVIRONMENT"] = "execution-environment";
})(TrustBoundaryType = exports.TrustBoundaryType || (exports.TrustBoundaryType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJ1c3QtYm91bmRhcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdHJ1c3QtYm91bmRhcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxtQ0FBZ0M7QUFDaEMseUNBQXFEO0FBU3JELE1BQWEsYUFBYyxTQUFRLG1CQUFRO0lBT3pDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUV2QixJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxHQUFHLEVBQVUsQ0FBQztRQUMvQyxJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxHQUFHLEVBQVUsQ0FBQztRQUUvQyxJQUFJLElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ3JDLE1BQU0sS0FBSyxHQUFHLGFBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDN0IsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUM3QjtJQUNILENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxHQUFHLE1BQXdCO1FBQ25ELE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUNuQixJQUFJLENBQUMscUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN6QyxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxRQUF1QjtRQUM3QyxJQUFJLENBQUMscUJBQXFCLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQ7O09BRUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU87WUFDTCxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUU7Z0JBQ2QsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNiLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztnQkFDN0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNmLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDcEMsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7Z0JBQy9ELHVCQUF1QixFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDO2FBQ2hFO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBOUNILHNDQStDQzs7O0FBRUQsSUFBWSxpQkFRWDtBQVJELFdBQVksaUJBQWlCO0lBQzNCLHdEQUFtQyxDQUFBO0lBQ25DLDBFQUFxRCxDQUFBO0lBQ3JELGdFQUEyQyxDQUFBO0lBQzNDLHNFQUFpRCxDQUFBO0lBQ2pELGtGQUE2RCxDQUFBO0lBQzdELDhGQUF5RSxDQUFBO0lBQ3pFLG9FQUErQyxDQUFBO0FBQ2pELENBQUMsRUFSVyxpQkFBaUIsR0FBakIseUJBQWlCLEtBQWpCLHlCQUFpQixRQVE1QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBNb2RlbCB9IGZyb20gXCIuL21vZGVsXCI7XG5pbXBvcnQgeyBSZXNvdXJjZSwgUmVzb3VyY2VQcm9wcyB9IGZyb20gXCIuL3Jlc291cmNlXCI7XG5pbXBvcnQgKiBhcyBzcGVjIGZyb20gXCIuL3NwZWMvdGhyZWF0Z2lsZS5nZW5lcmF0ZWRcIjtcbmltcG9ydCB7IFRlY2huaWNhbEFzc2V0IH0gZnJvbSBcIi4vdGVjaG5pY2FsLWFzc2V0XCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVHJ1c3RCb3VuZGFyeVByb3BzIGV4dGVuZHMgUmVzb3VyY2VQcm9wcyB7XG4gIHJlYWRvbmx5IHR5cGU6IFRydXN0Qm91bmRhcnlUeXBlO1xuICByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG59XG5cbmV4cG9ydCBjbGFzcyBUcnVzdEJvdW5kYXJ5IGV4dGVuZHMgUmVzb3VyY2Uge1xuICBwdWJsaWMgcmVhZG9ubHkgdHlwZTogVHJ1c3RCb3VuZGFyeVR5cGU7XG4gIHB1YmxpYyByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG5cbiAgcHJpdmF0ZSB0ZWNobmljYWxBc3NldHNJbnNpZGU6IFNldDxzdHJpbmc+O1xuICBwcml2YXRlIHRydXN0Qm91bmRhcmllc05lc3RlZDogU2V0PHN0cmluZz47XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRydXN0Qm91bmRhcnlQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy50eXBlID0gcHJvcHMudHlwZTtcbiAgICB0aGlzLnRhZ3MgPSBwcm9wcy50YWdzO1xuXG4gICAgdGhpcy50ZWNobmljYWxBc3NldHNJbnNpZGUgPSBuZXcgU2V0PHN0cmluZz4oKTtcbiAgICB0aGlzLnRydXN0Qm91bmRhcmllc05lc3RlZCA9IG5ldyBTZXQ8c3RyaW5nPigpO1xuXG4gICAgaWYgKHRoaXMudGFncyAmJiB0aGlzLnRhZ3MubGVuZ3RoID4gMCkge1xuICAgICAgY29uc3QgbW9kZWwgPSBNb2RlbC5vZih0aGlzKTtcbiAgICAgIG1vZGVsLmFkZFRhZ3MoLi4udGhpcy50YWdzKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYWRkVGVjaG5pY2FsQXNzZXRzKC4uLmFzc2V0czogVGVjaG5pY2FsQXNzZXRbXSkge1xuICAgIGFzc2V0cy5mb3JFYWNoKChhKSA9PiB7XG4gICAgICB0aGlzLnRlY2huaWNhbEFzc2V0c0luc2lkZS5hZGQoYS51dWlkKTtcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBhZGRUcnVzdEJvdW5kYXJ5KGJvdW5kYXJ5OiBUcnVzdEJvdW5kYXJ5KSB7XG4gICAgdGhpcy50cnVzdEJvdW5kYXJpZXNOZXN0ZWQuYWRkKGJvdW5kYXJ5LnV1aWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF90b1RocmVhZ2lsZSgpOiBzcGVjLlRocmVhZ2lsZVtcInRydXN0X2JvdW5kYXJpZXNcIl0ge1xuICAgIHJldHVybiB7XG4gICAgICBbdGhpcy5ub2RlLmlkXToge1xuICAgICAgICBpZDogdGhpcy51dWlkLFxuICAgICAgICBkZXNjcmlwdGlvbjogdGhpcy5kZXNjcmlwdGlvbixcbiAgICAgICAgdHlwZTogdGhpcy50eXBlLFxuICAgICAgICB0YWdzOiBBcnJheS5mcm9tKG5ldyBTZXQodGhpcy50YWdzKSksXG4gICAgICAgIHRlY2huaWNhbF9hc3NldHNfaW5zaWRlOiBBcnJheS5mcm9tKHRoaXMudGVjaG5pY2FsQXNzZXRzSW5zaWRlKSxcbiAgICAgICAgdHJ1c3RfYm91bmRhcmllc19uZXN0ZWQ6IEFycmF5LmZyb20odGhpcy50cnVzdEJvdW5kYXJpZXNOZXN0ZWQpLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbmV4cG9ydCBlbnVtIFRydXN0Qm91bmRhcnlUeXBlIHtcbiAgTkVUV09SS19PTl9QUkVNID0gXCJuZXR3b3JrLW9uLXByZW1cIixcbiAgTkVUV09SS19ERURJQ0FURURfSE9TVEVSID0gXCJuZXR3b3JrLWRlZGljYXRlZC1ob3N0ZXJcIixcbiAgTkVUV09SS19WSVJUVUFMX0xBTiA9IFwibmV0d29yay12aXJ0dWFsLWxhblwiLFxuICBORVRXT1JLX0NMT1VEX1BST1ZJREVSID0gXCJuZXR3b3JrLWNsb3VkLXByb3ZpZGVyXCIsXG4gIE5FVFdPUktfQ0xPVURfU0VDVVJJVFlfR1JPVVAgPSBcIm5ldHdvcmstY2xvdWQtc2VjdXJpdHktZ3JvdXBcIixcbiAgTkVUV09SS19QT0xJQ1lfTkFNRVNQQUNFX0lTT0xBVElPTiA9IFwibmV0d29yay1wb2xpY3ktbmFtZXNwYWNlLWlzb2xhdGlvblwiLFxuICBFWEVDVVRJT05fRU5WSVJPTk1FTlQgPSBcImV4ZWN1dGlvbi1lbnZpcm9ubWVudFwiLFxufVxuIl19