"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yaml = void 0;
const fs = require("fs");
const YAML = require("yaml");
/**
 * YAML utilities.
 */
class Yaml {
    /**
     * Saves a set of objects as a multi-document YAML file.
     *
     * @param filePath The output path
     * @param docs The set of objects
     */
    static save(filePath, docs) {
        const data = `# Generated by cdk-threagile\n\n${this.stringify(...docs)}`;
        fs.writeFileSync(filePath, data, { encoding: "utf8" });
    }
    /**
     * Stringify a document (or multiple documents) into YAML
     *
     * Undefined values become null.
     * Undefiend documents will be ignored.
     *
     * @param docs A set of objects to convert to YAML
     * @returns a YAML string. Multiple docs are separated by `---`.
     */
    static stringify(...docs) {
        return docs
            .map((r) => r === undefined
            ? "\n"
            : YAML.stringify(r, { keepUndefined: true, lineWidth: 0 }))
            .join("---\n");
    }
}
exports.Yaml = Yaml;
//# sourceMappingURL=data:application/json;base64,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