"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorization = exports.Authentication = exports.Protocol = exports.Communication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class Communication {
    constructor(id, props) {
        this.id = id;
        this.caller = props.caller;
        this.target = props.target;
        this.description = props.description;
        this.protocol = props.protocol;
        this.authentication = props.authentication;
        this.authorization = props.authorization;
        this.vpn = props.vpn;
        this.ipFiltered = props.ipFiltered;
        this.readonly = props.readonly;
        this.usage = props.usage;
        this.dataAssetsSent = new Set();
        this.dataAssetsReceived = new Set();
    }
    sends(...assets) {
        assets.forEach((a) => {
            this.dataAssetsSent.add(a.uuid);
        });
    }
    receives(...assets) {
        assets.forEach((a) => {
            this.dataAssetsReceived.add(a.uuid);
        });
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                target: this.target.uuid,
                description: this.description,
                protocol: this.protocol,
                authentication: this.authentication,
                authorization: this.authorization,
                vpn: this.vpn,
                ipFiltered: this.ipFiltered,
                readonly: this.readonly,
                usage: this.usage,
                data_assets_sent: this.dataAssetsSent,
                data_assets_received: this.dataAssetsReceived,
            },
        };
    }
}
exports.Communication = Communication;
_a = JSII_RTTI_SYMBOL_1;
Communication[_a] = { fqn: "cdktg.Communication", version: "0.0.20" };
var Protocol;
(function (Protocol) {
    Protocol["UNKNOEN"] = "unknown-protocol";
    Protocol["HTTP"] = "http";
    Protocol["HTTPS"] = "https";
    Protocol["WS"] = "ws";
    Protocol["WSS"] = "wss";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL"] = "reverse-proxy-web-protocol";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED"] = "reverse-proxy-web-protocol-encrypted";
    Protocol["MQTT"] = "mqtt";
    Protocol["JDBC"] = "jdbc";
    Protocol["JDBC_ENCRYPTED"] = "jdbc-encrypted";
    Protocol["ODBC"] = "odbc";
    Protocol["ODBC_ENCRYPTED"] = "odbc-encrypted";
    Protocol["SQL_ACCESS_PROTOCOL"] = "sql-access-protocol";
    Protocol["SQL_ACCESS_PROTOCOL_ENCRYPTED"] = "sql-access-protocol-encrypted";
    Protocol["NOSQL_ACCESS_PROTOCOL"] = "nosql-access-protocol";
    Protocol["NOSQL_ACCESS_PROTOCOL_ENCRYPTED"] = "nosql-access-protocol-encrypted";
    Protocol["BINARY"] = "binary";
    Protocol["BINARY_ENCRYPTED"] = "binary-encrypted";
    Protocol["TEXT"] = "text";
    Protocol["TEXT_ENCRYPTED"] = "text-encrypted";
    Protocol["SSH"] = "ssh";
    Protocol["SSH_TUNNEL"] = "ssh-tunnel";
    Protocol["SMTP"] = "smtp";
    Protocol["SMTP_ENCRYPTED"] = "smtp-encrypted";
    Protocol["POP3"] = "pop3";
    Protocol["POP3_ENCRYPTED"] = "pop3-encrypted";
    Protocol["IMAP"] = "imap";
    Protocol["IMAP_ENCRYPTED"] = "imap-encrypted";
    Protocol["FTP"] = "ftp";
    Protocol["FTPS"] = "ftps";
    Protocol["SFTP"] = "sftp";
    Protocol["SCP"] = "scp";
    Protocol["LDAP"] = "ldap";
    Protocol["LDAPS"] = "ldaps";
    Protocol["JMS"] = "jms";
    Protocol["NFS"] = "nfs";
    Protocol["SMB"] = "smb";
    Protocol["SMB_ENCRYPTED"] = "smb-encrypted";
    Protocol["LOCAL_FILE_ACCESS"] = "local-file-access";
    Protocol["NRPE"] = "nrpe";
    Protocol["XMPP"] = "xmpp";
    Protocol["IIOP"] = "iiop";
    Protocol["IIOP_ENCRYPTED"] = "iiop-encrypted";
    Protocol["JRMP"] = "jrmp";
    Protocol["JRMP_ENCRYPTED"] = "jrmp-encrypted";
    Protocol["IN_PROCESS_LIBRARY_CALL"] = "in-process-library-call";
    Protocol["CONTAINER_SPAWNING"] = "container-spawning";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
var Authentication;
(function (Authentication) {
    Authentication["NONE"] = "none";
    Authentication["CREDENTIALS"] = "credentials";
    Authentication["SESSION_ID"] = "session-id";
    Authentication["TOKEN"] = "token";
    Authentication["CLIENT_CERTIFICATE"] = "client-certificate";
    Authentication["TWO_FACTOR"] = "two-factor";
    Authentication["EXTERNALIZED"] = "externalized";
})(Authentication = exports.Authentication || (exports.Authentication = {}));
var Authorization;
(function (Authorization) {
    Authorization["NONE"] = "none";
    Authorization["TECHNICAL_USER"] = "technical-user";
    Authorization["ENDUSER_IDENTITY_PROPAGATION"] = "enduser-identity-propagation";
})(Authorization = exports.Authorization || (exports.Authorization = {}));
//# sourceMappingURL=data:application/json;base64,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