"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * Threagile API
 * <b>Threagile API</b> for Agile Threat Modeling: visit <a href=\"https://threagile.io\">https://threagile.io</a> for more information.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaApi = exports.MetaApiFactory = exports.MetaApiFp = exports.MetaApiAxiosParamCreator = exports.DirectApi = exports.DirectApiFactory = exports.DirectApiFp = exports.DirectApiAxiosParamCreator = exports.AuthApi = exports.AuthApiFactory = exports.AuthApiFp = exports.AuthApiAxiosParamCreator = void 0;
const axios_1 = require("axios");
// URLSearchParams not necessarily used
// @ts-ignore
const url_1 = require("url");
const FormData = require("form-data");
// Some imports not used depending on template conditions
// @ts-ignore
const common_1 = require("./common");
// @ts-ignore
const base_1 = require("./base");
/**
 * AuthApi - axios parameter creator
 * @export
 */
exports.AuthApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * Delete an auth key
         * @summary Delete an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authKeysDelete: async (key, options = {}) => {
            // verify required parameter 'key' is not null or undefined
            common_1.assertParamExists('authKeysDelete', 'key', key);
            const localVarPath = `/auth/keys`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            if (key !== undefined && key !== null) {
                localVarHeaderParameter['key'] = String(key);
            }
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Create a new auth key
         * @summary Create a new auth key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authKeysPost: async (options = {}) => {
            const localVarPath = `/auth/keys`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete a token
         * @summary Delete a token
         * @param {string} token
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authTokensDelete: async (token, options = {}) => {
            // verify required parameter 'token' is not null or undefined
            common_1.assertParamExists('authTokensDelete', 'token', token);
            const localVarPath = `/auth/tokens`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            if (token !== undefined && token !== null) {
                localVarHeaderParameter['token'] = String(token);
            }
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Create a new (time limited) token from an auth key
         * @summary Create a new (time limited) token from an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authTokensPost: async (key, options = {}) => {
            // verify required parameter 'key' is not null or undefined
            common_1.assertParamExists('authTokensPost', 'key', key);
            const localVarPath = `/auth/tokens`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            if (key !== undefined && key !== null) {
                localVarHeaderParameter['key'] = String(key);
            }
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    };
};
/**
 * AuthApi - functional programming interface
 * @export
 */
exports.AuthApiFp = function (configuration) {
    const localVarAxiosParamCreator = exports.AuthApiAxiosParamCreator(configuration);
    return {
        /**
         * Delete an auth key
         * @summary Delete an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async authKeysDelete(key, options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.authKeysDelete(key, options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Create a new auth key
         * @summary Create a new auth key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async authKeysPost(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.authKeysPost(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Delete a token
         * @summary Delete a token
         * @param {string} token
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async authTokensDelete(token, options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.authTokensDelete(token, options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Create a new (time limited) token from an auth key
         * @summary Create a new (time limited) token from an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async authTokensPost(key, options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.authTokensPost(key, options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
    };
};
/**
 * AuthApi - factory interface
 * @export
 */
exports.AuthApiFactory = function (configuration, basePath, axios) {
    const localVarFp = exports.AuthApiFp(configuration);
    return {
        /**
         * Delete an auth key
         * @summary Delete an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authKeysDelete(key, options) {
            return localVarFp.authKeysDelete(key, options).then((request) => request(axios, basePath));
        },
        /**
         * Create a new auth key
         * @summary Create a new auth key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authKeysPost(options) {
            return localVarFp.authKeysPost(options).then((request) => request(axios, basePath));
        },
        /**
         * Delete a token
         * @summary Delete a token
         * @param {string} token
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authTokensDelete(token, options) {
            return localVarFp.authTokensDelete(token, options).then((request) => request(axios, basePath));
        },
        /**
         * Create a new (time limited) token from an auth key
         * @summary Create a new (time limited) token from an auth key
         * @param {string} key
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        authTokensPost(key, options) {
            return localVarFp.authTokensPost(key, options).then((request) => request(axios, basePath));
        },
    };
};
/**
 * AuthApi - object-oriented interface
 * @export
 * @class AuthApi
 * @extends {BaseAPI}
 */
class AuthApi extends base_1.BaseAPI {
    /**
     * Delete an auth key
     * @summary Delete an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authKeysDelete(key, options) {
        return exports.AuthApiFp(this.configuration).authKeysDelete(key, options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Create a new auth key
     * @summary Create a new auth key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authKeysPost(options) {
        return exports.AuthApiFp(this.configuration).authKeysPost(options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Delete a token
     * @summary Delete a token
     * @param {string} token
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authTokensDelete(token, options) {
        return exports.AuthApiFp(this.configuration).authTokensDelete(token, options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Create a new (time limited) token from an auth key
     * @summary Create a new (time limited) token from an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authTokensPost(key, options) {
        return exports.AuthApiFp(this.configuration).authTokensPost(key, options).then((request) => request(this.axios, this.basePath));
    }
}
exports.AuthApi = AuthApi;
/**
 * DirectApi - axios parameter creator
 * @export
 */
exports.DirectApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * Direct model analyze call
         * @summary Direct model analyze call
         * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directAnalyzePost: async (dpi, file, options = {}) => {
            const localVarPath = `/direct/analyze`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();
            if (dpi !== undefined) {
                localVarQueryParameter['dpi'] = dpi;
            }
            if (file !== undefined) {
                localVarFormParams.append('file', file);
            }
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            localVarRequestOptions.data = localVarFormParams;
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Direct model check call
         * @summary Direct model check call
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directCheckPost: async (file, options = {}) => {
            const localVarPath = `/direct/check`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();
            if (file !== undefined) {
                localVarFormParams.append('file', file);
            }
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            localVarRequestOptions.data = localVarFormParams;
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Stub model file (as a starting point)
         * @summary Stub model file
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directStubGet: async (options = {}) => {
            const localVarPath = `/direct/stub`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    };
};
/**
 * DirectApi - functional programming interface
 * @export
 */
exports.DirectApiFp = function (configuration) {
    const localVarAxiosParamCreator = exports.DirectApiAxiosParamCreator(configuration);
    return {
        /**
         * Direct model analyze call
         * @summary Direct model analyze call
         * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async directAnalyzePost(dpi, file, options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.directAnalyzePost(dpi, file, options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Direct model check call
         * @summary Direct model check call
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async directCheckPost(file, options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.directCheckPost(file, options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Stub model file (as a starting point)
         * @summary Stub model file
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async directStubGet(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.directStubGet(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
    };
};
/**
 * DirectApi - factory interface
 * @export
 */
exports.DirectApiFactory = function (configuration, basePath, axios) {
    const localVarFp = exports.DirectApiFp(configuration);
    return {
        /**
         * Direct model analyze call
         * @summary Direct model analyze call
         * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directAnalyzePost(dpi, file, options) {
            return localVarFp.directAnalyzePost(dpi, file, options).then((request) => request(axios, basePath));
        },
        /**
         * Direct model check call
         * @summary Direct model check call
         * @param {any} [file]
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directCheckPost(file, options) {
            return localVarFp.directCheckPost(file, options).then((request) => request(axios, basePath));
        },
        /**
         * Stub model file (as a starting point)
         * @summary Stub model file
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        directStubGet(options) {
            return localVarFp.directStubGet(options).then((request) => request(axios, basePath));
        },
    };
};
/**
 * DirectApi - object-oriented interface
 * @export
 * @class DirectApi
 * @extends {BaseAPI}
 */
class DirectApi extends base_1.BaseAPI {
    /**
     * Direct model analyze call
     * @summary Direct model analyze call
     * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directAnalyzePost(dpi, file, options) {
        return exports.DirectApiFp(this.configuration).directAnalyzePost(dpi, file, options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Direct model check call
     * @summary Direct model check call
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directCheckPost(file, options) {
        return exports.DirectApiFp(this.configuration).directCheckPost(file, options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Stub model file (as a starting point)
     * @summary Stub model file
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directStubGet(options) {
        return exports.DirectApiFp(this.configuration).directStubGet(options).then((request) => request(this.axios, this.basePath));
    }
}
exports.DirectApi = DirectApi;
/**
 * MetaApi - axios parameter creator
 * @export
 */
exports.MetaApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * Used as health check in docker container as well
         * @summary Simple health check ping
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaPingGet: async (options = {}) => {
            const localVarPath = `/meta/ping`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Model statistics
         * @summary Model statistics
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaStatsGet: async (options = {}) => {
            const localVarPath = `/meta/stats`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Listing of all enum type values
         * @summary Listing of all enum type values
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaTypesGet: async (options = {}) => {
            const localVarPath = `/meta/types`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Version number
         * @summary Version number
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaVersionGet: async (options = {}) => {
            const localVarPath = `/meta/version`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new url_1.URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options };
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            common_1.setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = { ...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers };
            return {
                url: common_1.toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    };
};
/**
 * MetaApi - functional programming interface
 * @export
 */
exports.MetaApiFp = function (configuration) {
    const localVarAxiosParamCreator = exports.MetaApiAxiosParamCreator(configuration);
    return {
        /**
         * Used as health check in docker container as well
         * @summary Simple health check ping
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async metaPingGet(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.metaPingGet(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Model statistics
         * @summary Model statistics
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async metaStatsGet(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.metaStatsGet(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Listing of all enum type values
         * @summary Listing of all enum type values
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async metaTypesGet(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.metaTypesGet(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
        /**
         * Version number
         * @summary Version number
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async metaVersionGet(options) {
            const localVarAxiosArgs = await localVarAxiosParamCreator.metaVersionGet(options);
            return common_1.createRequestFunction(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration);
        },
    };
};
/**
 * MetaApi - factory interface
 * @export
 */
exports.MetaApiFactory = function (configuration, basePath, axios) {
    const localVarFp = exports.MetaApiFp(configuration);
    return {
        /**
         * Used as health check in docker container as well
         * @summary Simple health check ping
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaPingGet(options) {
            return localVarFp.metaPingGet(options).then((request) => request(axios, basePath));
        },
        /**
         * Model statistics
         * @summary Model statistics
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaStatsGet(options) {
            return localVarFp.metaStatsGet(options).then((request) => request(axios, basePath));
        },
        /**
         * Listing of all enum type values
         * @summary Listing of all enum type values
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaTypesGet(options) {
            return localVarFp.metaTypesGet(options).then((request) => request(axios, basePath));
        },
        /**
         * Version number
         * @summary Version number
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        metaVersionGet(options) {
            return localVarFp.metaVersionGet(options).then((request) => request(axios, basePath));
        },
    };
};
/**
 * MetaApi - object-oriented interface
 * @export
 * @class MetaApi
 * @extends {BaseAPI}
 */
class MetaApi extends base_1.BaseAPI {
    /**
     * Used as health check in docker container as well
     * @summary Simple health check ping
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaPingGet(options) {
        return exports.MetaApiFp(this.configuration).metaPingGet(options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Model statistics
     * @summary Model statistics
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaStatsGet(options) {
        return exports.MetaApiFp(this.configuration).metaStatsGet(options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Listing of all enum type values
     * @summary Listing of all enum type values
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaTypesGet(options) {
        return exports.MetaApiFp(this.configuration).metaTypesGet(options).then((request) => request(this.axios, this.basePath));
    }
    /**
     * Version number
     * @summary Version number
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaVersionGet(options) {
        return exports.MetaApiFp(this.configuration).metaVersionGet(options).then((request) => request(this.axios, this.basePath));
    }
}
exports.MetaApi = MetaApi;
//# sourceMappingURL=data:application/json;base64,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