from .builds import Builds as Builds
from .exceptions import JenkinsError as JenkinsError, JenkinsNotFoundError as JenkinsNotFoundError
from .jobs import Jobs as Jobs
from .nodes import Nodes as Nodes
from .views import Views as Views
from aiohttp import ClientResponse as ClientResponse
from typing import Any, Optional, Tuple

JenkinsVersion: Any

class RetryClientSession:
    attempts: Any = ...
    interval: Any = ...
    statuses: Any = ...
    client: Any = ...
    def __init__(self, retry_options: dict, *args: Any, **kwargs: Any) -> None: ...
    async def request(self, *args: Any, **kwargs: Any) -> ClientResponse: ...
    async def close(self) -> None: ...

class Jenkins:
    host: Any = ...
    auth: Any = ...
    crumb: Any = ...
    retry: Any = ...
    nodes: Any = ...
    jobs: Any = ...
    builds: Any = ...
    views: Any = ...
    def __init__(self, host: str, login: Optional[str]=..., password: Optional[str]=..., *, retry: Optional[dict]=...) -> None: ...
    async def close(self) -> None: ...
    async def get_status(self) -> dict: ...
    async def get_version(self) -> JenkinsVersion: ...
    async def is_ready(self) -> bool: ...
    async def wait_until_ready(self, sleep_interval_sec: float=...) -> None: ...
    async def quiet_down(self) -> None: ...
    async def cancel_quiet_down(self) -> None: ...
    async def restart(self) -> None: ...
    async def safe_restart(self) -> None: ...
    async def generate_token(self, name: str) -> Tuple[str, str]: ...
    async def revoke_token(self, token_uuid: str) -> None: ...
    async def run_groovy_script(self, script: str) -> str: ...
