
# Remote Certificate Resource Provider

The Remote Certificate provider for Pulumi can be used to create a resources that contains the details of a remote certificate from any website.

This is especially useful when working with OIDC providers, which require a certificate thumbprint which can often require multiple manual steps to calculate.

## Installing

This package is available in many languages in standard packaging formats.

### Node.js (Java/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```
$ npm install @lbrlabs/pulumi-remotecertificate
```

or `yarn`:

```
$ yarn add @lbrlabs/pulumi-remotecertificate
```

### Python

To use from Python, install using `pip`:

```
$ pip install lbrlabs-pulumi-remotecertificate
```

### Go

To use from Go, use `go get` to grab the latest version of the library

```
$ go get github.com/lbrlabs/pulumi-remotecertificate/sdk/go/...
```

### .NET

To use from Dotnet, use `dotnet add package` to install into your project. You must specify the version if it is a pre-release version.


```
$ dotnet add package lbrlabs.PulumiPackage.Remotecertificate
```

## Reference

See the Pulumi registry for API docs:

https://www.pulumi.com/registry/packages/remotecertificate/api-docs/
