from django.utils.translation import ugettext_lazy as _

from rest_framework import status
from rest_framework.exceptions import APIException


class Conflict(APIException):
    status_code = status.HTTP_409_CONFLICT
    default_detail = _("A conflict occurred")
    default_code = 'conflict'


class Gone(APIException):
    status_code = status.HTTP_410_GONE
    default_detail = _("The resource is gone")
    default_code = 'gone'


class PreconditionFailed(APIException):
    status_code = status.HTTP_412_PRECONDITION_FAILED
    default_detail = _("Precondition failed")
    default_code = 'precondition_failed'
