import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface DocumentSplitterProps {
    /** Lambda function memory configuration (may need to increase for larger documents) */
    readonly lambdaMemoryMB?: number;
    /** Lambda function timeout (may need to increase for larger documents) */
    readonly lambdaTimeout?: number;
    /** Lambda log level */
    readonly lambdaLogLevel?: string;
    /** Bucketname to output data to */
    readonly s3OutputBucket: string;
    /** The prefix to use to output files to */
    readonly s3OutputPrefix: string;
}
/**
 * This construct takes in a manifest definition with just the s3Path:
 *
 * example s3Path:
 * {"s3Path": "s3://bucketname/prefix/image.png"}
 *
 *
 * then it generated single page versions of the multi-page file.
 * For PDF the output are single PDF files, for TIFF the output are single TIFF files.
 *
 * Example (Python)
 * ```python
  ```

 *
 */
export declare class DocumentSplitter extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    constructor(parent: Construct, id: string, props: DocumentSplitterProps);
}
