"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractConfiguration = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
//import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * CloudFormation Custom Resources importing default configuration values from default_config.csv
 * into DynamoDB table.
 * Used by the Configuration Construct to configure Textrat features.
 * The DynamoDB table can be configured to your requirements.
 * The configuration has to match the manifest format.
 * Essentially the Configuration construct looks up the classification
 * and if a match is found in the DynamoDB table, configures the context
 * manifest object to include the configuration.
 *
 */
class TextractConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.configurationInit = new lambda.DockerImageFunction(this, id, {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/cfn_custom_configurator_prefill/')),
            architecture: lambda.Architecture.X86_64,
            memorySize: 128,
            timeout: cdk.Duration.seconds(600),
            environment: {
                LOG_LEVEL: 'DEBUG',
                CONFIGURATION_TABLE: props.configuration_table,
            },
        });
        this.configurationInit.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: ['*'],
        }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.configurationInit,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.TextractConfiguration = TextractConfiguration;
//# sourceMappingURL=data:application/json;base64,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