# Generated by Django 3.1 on 2021-01-13 21:05

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0116_rearport_max_positions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('when', models.DateField(default=datetime.date.today)),
                ('description', models.TextField(blank=True, max_length=255, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('type', models.CharField(default='INSTALL', max_length=7)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ActivityReason',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=256)),
                ('type', models.CharField(default='INSTALL', max_length=7)),
            ],
        ),
        migrations.CreateModel(
            name='ActorCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=80)),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Category',
            },
        ),
        migrations.CreateModel(
            name='OldDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('rack', models.CharField(blank=True, max_length=100, null=True)),
                ('site', models.CharField(blank=True, max_length=100, null=True)),
                ('ipv4', models.CharField(blank=True, max_length=40, null=True)),
                ('ipv6', models.CharField(blank=True, max_length=70, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Actor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('cellphone', models.CharField(blank=True, max_length=20, null=True)),
                ('telephone', models.CharField(blank=True, max_length=20, null=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='conectividadeapp.actorcategory')),
            ],
            options={
                'verbose_name': 'Actor',
                'verbose_name_plural': 'Actors',
            },
        ),
        migrations.CreateModel(
            name='ActivityRemove',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('when', models.DateField(default=datetime.date.today)),
                ('description', models.TextField(blank=True, max_length=255, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('type', models.CharField(default='REMOVE', max_length=7)),
                ('actor', models.ManyToManyField(to='conectividadeapp.Actor')),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='dcim.device')),
                ('main_activity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.activity')),
                ('olddevice', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.olddevice')),
                ('reason', models.ForeignKey(limit_choices_to={'type': 'REMOVE'}, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.activityreason')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ActivityInstall',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('when', models.DateField(default=datetime.date.today)),
                ('description', models.TextField(blank=True, max_length=255, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('type', models.CharField(default='INSTALL', max_length=7)),
                ('actor', models.ManyToManyField(to='conectividadeapp.Actor')),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='dcim.device')),
                ('main_activity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.activity')),
                ('olddevice', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.olddevice')),
                ('reason', models.ForeignKey(limit_choices_to={'type': 'INSTALL'}, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.activityreason')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='activity',
            name='actor',
            field=models.ManyToManyField(to='conectividadeapp.Actor'),
        ),
        migrations.AddField(
            model_name='activity',
            name='device',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='dcim.device'),
        ),
        migrations.AddField(
            model_name='activity',
            name='olddevice',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.olddevice'),
        ),
        migrations.AddField(
            model_name='activity',
            name='reason',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='conectividadeapp.activityreason'),
        ),
    ]
