<div align="center"><img src="https://raw.githubusercontent.com/PlasmaPy/PlasmaPy-logo/main/exports/with-text-dark.png" width="600"/></div>

# PlasmaPy

[![PyPI version](https://img.shields.io/pypi/v/plasmapy?style=flat&logo=pypi)](https://pypi.org/project/plasmapy/)
[![Conda version](https://img.shields.io/conda/v/conda-forge/plasmapy?style=flat&logo=anaconda)](https://img.shields.io/conda/v/conda-forge/plasmapy)
[![PyPI version](https://img.shields.io/pypi/pyversions/plasmapy?style=flat&logo=python)](https://img.shields.io/pypi/pyversions/plasmapy?style=plastic)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](./LICENSE.md)
[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg)](https://docs.plasmapy.org/en/latest/CODE_OF_CONDUCT.html)

[![Matrix](https://img.shields.io/badge/Matrix-join%20chat-blueviolet?style=flat&logo=matrix)](https://app.element.io/#/room/#plasmapy:openastronomy.org)
[![Twitter](https://img.shields.io/badge/Twitter%20-follow-red?style=flat&logo=twitter)](https://twitter.com/plasmapy)
[![YouTube](https://img.shields.io/badge/YouTube%20-subscribe-red?style=flat&logo=youtube)](https://www.youtube.com/channel/UCSH6qzslhqIZKTAJmHPxIxw)

[![GitHub Actions — CI](https://github.com/PlasmaPy/PlasmaPy/workflows/CI/badge.svg)](https://github.com/PlasmaPy/PlasmaPy/actions?query=workflow%3ACI+branch%3Amain)
[![fortnightly tests](https://github.com/PlasmaPy/PlasmaPy/actions/workflows/fortnightly.yml/badge.svg?branch=main)](https://github.com/PlasmaPy/PlasmaPy/actions/workflows/fortnightly.yml)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/PlasmaPy/PlasmaPy/main.svg)](https://results.pre-commit.ci/latest/github/PlasmaPy/PlasmaPy/main)
[![codecov](https://codecov.io/gh/PlasmaPy/PlasmaPy/branch/main/graph/badge.svg)](https://codecov.io/gh/PlasmaPy/PlasmaPy)
[![Read the Docs Status](https://readthedocs.org/projects/plasmapy/badge/?version=latest&logo=twitter)](http://plasmapy.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/PlasmaPy/PlasmaPy/main?filepath=docs/notebooks)

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1436011.svg)](https://doi.org/10.5281/zenodo.1436011)
[![astropy](http://img.shields.io/badge/powered%20by-AstroPy-orange.svg?style=flat&logo=astropy)](http://www.astropy.org/)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Open Source Helpers](https://www.codetriage.com/plasmapy/plasmapy/badges/users.svg)](https://www.codetriage.com/plasmapy/plasmapy)

[Anaconda Navigator]: https://docs.anaconda.com/anaconda/navigator/index.html
[Astropy]: https://www.astropy.org
[3-clause BSD license]: ./LICENSE.md
[calendar]: https://calendar.google.com/calendar/embed?src=c_sqqq390s24jjfjp3q86pv41pi8%40group.calendar.google.com&ctz=America%2FNew_York
[citation instructions]: https://docs.plasmapy.org/en/latest/about/citation.html
[code of conduct]: http://docs.plasmapy.org/en/latest/CODE_OF_CONDUCT.html
[collaborative award]: https://doi.org/10.5281/zenodo.2633286
[command line]: https://tutorial.djangogirls.org/en/intro_to_command_line/
[community meetings]: https://www.plasmapy.org/meetings/weekly
[contributor guide]: https://docs.plasmapy.org/en/latest/development/index.html
[Cyberinfrastructure for Sustained Scientific Innovation]: https://beta.nsf.gov/funding/opportunities/cyberinfrastructure-sustained-scientific-innovation-cssi
[Department of Energy]: https://www.energy.gov
[emerging best practice for software citation]: https://doi.org/10.7717/peerj-cs.86
[GitHub discussions]: https://github.com/PlasmaPy/PlasmaPy/discussions
[Gitter]: https://gitter.im/PlasmaPy/Lobby
[good first issues]: https://github.com/PlasmaPy/PlasmaPy/issues?q=is%3Aissue+is%3Aopen+label%3A%22Good+first+contribution%22
[Google Summer of Code]: https://summerofcode.withgoogle.com
[hack week]: https://doi.org/10.1073/pnas.1717196115
[how to install plasmapy]: https://docs.plasmapy.org/en/stable/install.html
[installed Conda]: https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html
[download and install Python]: https://wiki.python.org/moin/BeginnersGuide/Download
[installing PlasmaPy]: https://docs.plasmapy.org/en/latest/install.html
[installing PlasmaPy from source]: http://docs.plasmapy.org/en/latest/install.html#building-and-installing-from-source-code
[Mailing list]: https://groups.google.com/forum/#!forum/plasmapy
[Matrix]: https://app.element.io/#/room/#plasmapy:openastronomy.org
[meetings]: https://www.plasmapy.org/meetings/weekly
[NASA]: https://www.nasa.gov/
[National Science Foundation]: https://nsf.gov
[office hours]: http://www.plasmapy.org/meetings/office_hours
[pip]: https://pypi.org/project/pip
[Plasma Hack Week]: https://hack.plasma.org
[PlasmaPy Community on Zenodo]: https://zenodo.org/communities/plasmapy
[PlasmaPy]: https://www.plasmapy.org
[PlasmaPy's online documentation]: https://docs.plasmapy.org
[protections against software patents]: ./PATENT.md
[Python]: https://www.python.org
[Smithsonian Institution]: https://www.si.edu
[submit a bug report]: https://github.com/PlasmaPy/PlasmaPy/issues/new?assignees=&labels=&template=Bug_report.md
[submit a feature request]: https://github.com/PlasmaPy/PlasmaPy/issues/new?assignees=&labels=&template=Feature_request.md
[Suggestion box]: https://docs.google.com/forms/d/e/1FAIpQLSdT3O5iHZrLJRuavFyzoR23PGy0Prfzx2SQOcwJGWtvHyT2lw/viewform?usp=sf_link
[team@plasmapy.org]: mailto:team@plasmapy.org
[this video]: https://youtu.be/E8RwQF5wcXM
[Zoom]: https://zoom.us/j/91633383503?pwd=QWNkdHpWeFhrYW1vQy91ODNTVG5Ndz09

[PlasmaPy] is an open source, community-developed [Python] 3.8+ package
for plasma science. PlasmaPy intends to be for plasma science what
[Astropy] is for astronomy — a collection of functionality commonly used
and shared between plasma scientists and researchers globally, running
within and leveraging the open source scientific Python ecosystem. The
goals of PlasmaPy are more thoroughly described in [this video]. Current
functionality is described in [PlasmaPy's online documentation], and
many of our recent presentations are available from the [PlasmaPy
Community on Zenodo].

Please [submit a feature request] if you have an idea for new
functionality. PlasmaPy is community-driven, and feature requests really
help guide the direction of software development. Please also [submit a
bug report] if you notice any bugs. Feedback really helps!

If you are interested in contributing, please check out our [contributor
guide] and [code of conduct]. There are also a number of [good first
issues] in our GitHub repository. New contributors are very welcome!

## Installation

PlasmaPy requires Python 3.8 or newer. If you do not have Python
installed already, here are the instructions to [download and install
Python].

To install `plasmapy` on macOS or Linux, open a terminal and run:
```Shell
python -m pip install plasmapy
```
On some systems, it might be necessary to specify the Python version
number, for example by using `python3` or `python3.10` instead of
`python`.

To install `plasmapy` on Windows, open a terminal and run
```Shell
py -3.10 -m pip install plasmapy
```
The `3.10` may be replaced by any version of Python that is supported by
PlasmaPy.

If you have [installed Conda], then you can also install PlasmaPy into
an activated Conda environment by running:
```Shell
conda install -c conda-forge plasmapy
```
PlasmaPy can also be installed using [Anaconda Navigator] so long as
`conda-forge` is added as a channel.

Check out our instructions on [installing PlasmaPy] for more details.

Please check out our documentation for more information on [how to
install PlasmaPy]. To contribute to the package or use the most recent
version, check out our instructions on [installing PlasmaPy from source].

## Events

PlasmaPy has several [meetings] that are on our [calendar]. Events are
usually held on PlasmaPy's [Zoom] room.

Last-minute cancellations are usually announced on the [Matrix]/[Gitter]
channel. The most up-to-date information about these meetings is on the
[meetings] page of PlasmaPy's website.

### Office hours

Our weekly informal [office hours] are an opportunity to chat with
active members of the PlasmaPy community about topics related to Python
and plasma science. If you'd like to learn more about PlasmaPy, our
office hours are one of the best places to start. As of April 2022,
our office hours are on Thursdays at 2 pm Eastern. Please feel free to
come by!

### Community meetings

PlasmaPy's weekly [community meetings] are a place to talk about
code development. If you have an idea for a new feature or would like to
make a code contribution, community meetings are a good place to go to.
As of April 2022, community meetings are on Tuesdays at 2 pm Eastern.

### Project meetings

PlasmaPy's weekly project meetings are a place to discuss education,
outreach, and project coordination. Topics might range from creating
educational notebooks to organizing community events. As of April 2022,
project meetings are held on Wednesdays at 3 pm Eastern.

### Working group meetings

PlasmaPy has started several working groups, including on diagnostics,
dispersion relations, and simulation. These working groups usually meet
fortnightly, and their meeting times can be found in PlasmaPy's event
[calendar]. If you would like to join a PlasmaPy working group or even
start a new one, please email us at [team@plasmapy.org]!

### Plasma Hack Week

A [hack week] is a mix of a hackathon and a summer school. Hack weeks
provide an opportunity to learn from each other and code together. The
inaugural [Plasma Hack Week] was held virtually in the summer of 2021,
and will hopefully be held annually. Please check out the [Plasma Hack
Week] website for more details, and email [team@plasmapy.org] if you
would like to become an organizer.

## Community

### Matrix chat

If you have any questions, the quickest way to get a response is to ask
on our [Matrix]/[Gitter] channel. Both of these are the same chat
channel; Gitter uses a bridge to link the two.

### GitHub discussions

We're trying out [GitHub discussions] as a place to suggest ideas,
bring up discussion topics, and ask questions.

### Mailing list

You can subscribe to PlasmaPy's low-volume [mailing list] to receive
PlasmaPy newsletters and other announcements.

### Suggestion box

We have a [suggestion box] if you would like to (optionally anonymously)
suggest a feature/topic for consideration. These suggestions might be
changed into GitHub issues for further discussion.

## Contact information

Please feel free to reach out to us at [team@plasmapy.org] or stop by
our [office hours] with any ideas, questions, and/or puns about
computational magnetohydrodynamics.

## License

PlasmaPy is permissively licensed under a [3-clause BSD license] with
added [protections against software patents].

## Citing PlasmaPy

An [emerging best practice for software citation] is to cite the
_specific version_ of each software package used in a research project
(instead of only citing a journal article, website, or GitHub
repository). The citation should include a persistent identifier that
uniquely identifies which version of the software was used. We therefore
ask that you cite the specific version of PlasmaPy used in your research
project. Releases of PlasmaPy are available from the [PlasmaPy community
on Zenodo], along with many other PlasmaPy resources. Please check our
documentation for more detailed [citation instructions].

## Acknowledgments

Early development on PlasmaPy was supported in part by the U.S.
[Department of Energy], the [Smithsonian Institution], [NASA], and
[Google Summer of Code]. Ongoing PlasmaPy development is being
supported through a [collaborative award] from the [Cyberinfrastructure
for Sustained Scientific Innovation] program of the U.S. [National
Science Foundation].
