# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['netscanner']

package_data = \
{'': ['*']}

install_requires = \
['mac-vendor-lookup>=0.1.12,<0.2.0']

setup_kwargs = {
    'name': 'netscanner',
    'version': '0.1.0',
    'description': 'A comprehensive network reconnaissance tool',
    'long_description': '# NETSCANNER\n\nThis project is the product of my final year undergraduate development project for my Bachelor of Science degree in Computer Networking and Cyber Security at London Metropolitan University.\n\nThis program will conduct a comprehensive scan of the local network and surrounding wireless networks using basic OS utilities, Nmap and airodump-ng.\n\n## Disclaimer\nThis program is designed to conduct a rigorous and comprehensive scan of your local network by actively engaging network hosts using common host discovery and port scanning techniques to produce an extensive overview of the local network. This program is also designed to produce an overview of surrounding wireless networks by capturing 802.11 frames in the vicinity of the host interface. \n\nThis program is a network reconnaissance tool and when executing the module you are wholly responsible and liable for any physical, mental or financial damage, complications and consequences of all operations that you execute using this utility. \n\nIt is strongly recommended that you execute this program on networks you are authorised to audit. Use at your own discretion and risk.\n\n## Demo\n![gif](https://user-images.githubusercontent.com/111141495/222961530-c4722153-e6e1-4b4b-a0af-5a69abc2875d.gif)\n\n\n## Screenshots\n*MAC Addresses have been obscured.\n\n### Running in the terminal\n![Screenshot 1](https://i.ibb.co/PDy14fL/Screenshot-from-2023-02-21-18-07-54-1.png)\n\n![Screenshot 2](https://i.ibb.co/DfKzcfH/Screenshot-from-2023-02-21-18-08-02-1.png)\n\n![Screenshot 3](https://i.ibb.co/Sm2X70F/Screenshot-from-2023-02-21-18-08-09-1.png)\n\n### Viewing the output file\n![Screenshot 4](https://i.ibb.co/Mp7HWJQ/Screenshot-from-2023-02-22-22-40-39-1.png)\n\n![Screenshot 5](https://i.ibb.co/Fg90thh/Screenshot-from-2023-02-22-22-40-56-1.png)\n\n![Screenshot 6](https://i.ibb.co/KDbbcSD/Screenshot-from-2023-02-22-22-41-15-1.png)\n\n![Screenshot 7](https://i.ibb.co/3y2SDwb/Screenshot-from-2023-02-22-22-41-29-1.png)\n\n## Usage\n```bash\n  python3 -m netscanner < -h | -nP | -w | -l | -hD >\n  < --wP <seconds> >\n  < --pP <seconds> >\n  < --pR <first port-last port> >\n```\n\n## Requirements\n* `python3`: NETSCANNER was designed to work with Python 3.10.\n* [`ifconfig`](https://linux.die.net/man/8/ifconfig): For gathering statistical data on local interfaces.\n* [`ethtool`](https://linux.die.net/man/8/ethtool): For gathering statistical data on local interfaces\n* [`iwconfig`](https://linux.die.net/man/8/iwconfig): For gathering statistical data on local wireless-capable interfaces.\n* [`airmon-ng`](https://www.aircrack-ng.org/doku.php?id=airmon-ng): For enabling monitor mode on capable interfaces.\n* [`airodump-ng`](https://www.aircrack-ng.org/doku.php?id=airodump-ng): For capturing 802.11 beacon frames.\n* [`Nmap`](https://nmap.org/): For conducting local network reconnaissance.\n\nA monitor-mode capable wireless interface is also required if you wish to use the wireless network discovery feature. See [here](http://www.aircrack-ng.org/doku.php?id=compatible_cards) for more information on this.\n\n## Execution\n### Using PyPI\nThe preferred method of running the program is installing the Python package from PyPI directly.\n\n```bash\n  pip install netscanner\n```\n\nThen running the program:\n\n```bash\n  python3 -m netscanner <mode specification> <options>\n```\n\n### Manually\nYou can also run the module itself by downloading the `__main__.py` module from this repository and running it.\n\n```bash\n  python3 __main__.py <mode specification> <options>\n```\n\n### Avoiding sudo\nThe program runs shell commands with sudo privileges in the background, which may require you to provide your sudo password frequently.\n\nTo avoid this, append this line to your `/etc/sudoers` file using `sudo visudo`\n\n```bash\n# NETSCANNER PACKAGE\n<USERNAME> ALL=(ALL) NOPASSWD: ALL\n```\n\nThis will allow you to run the module without being asked for your sudo password. This is wholly optional and it is recommended that you comment this line when done using the program. **Attempt to run the program initially before you do this.**\n\n## Modes and Options\n### Modes \n* Mode 1 \n    * This mode will execute all functions of the program. If no flags are specified this will be the mode of operation.\n* Mode 2 `(-nP)`\n    * This flag will execute Mode 2, NO PORT SCAN, which will execute the Host Discovery and 802.11 WLAN Discovery processes.\n* Mode 3 `(-w)`\n    * This flag will execute Mode 3, WIRELESS ONLY, which will execute the 802.11 WLAN Discovery process exclusively.\n* Mode 4 `(-l)`\n    * This flag will execute Mode 4, LOCAL SCAN ONLY, which will execute the Host Discovery and Port Scan processes.\n* Mode 5 `(-hD)`\n    * This flag will execute Mode 5, HOST DISCOVERY ONLY, which will execute the Host Discovery Process exclusively.\n\n### Options\n* Wireless Scan Period `(--wP <seconds>)`\n    * This option allows you to specify a scan period for the 802.11 WLAN Discovery process. The default is 60. This value is ignored if the mode of operation is not Mode 1, 2 or 3. Large values will result in longer scan times but greater verbosity.\n* Port Scan Period `(--pP <seconds>)`\n    * This option allows you to specify a scan period for the Port Scan process. The default is 60. This value is ignored if the mode of operation is not Mode 1 or 4. Large values will result in longer scan times but greater verbosity. \n* Port Range `(--pR <first port - last port>)`\n    * This option allows you to specify a port range for the Port Scan process. Thedefault is the 100 most common ports determined by Nmap (`-F`). Large values will result in longer scan times but greater verbosity. It is useful to combine this option with the `--pP` option to avoid scan timeouts when scanning large ranges. \n\n## Processes\nThis section provides a brief synopsis of each process used in the program. There are three processes that are used.\n\n### Host Discovery\nThis process gathers characteristics about the local network and hosts on the local network using ifconfig, iwconfig, ethtool. And the [ARP Request Ping](https://nmap.org/book/host-discovery-techniques.html#arp-scan) and [rDNS Query Flood](https://nmap.org/book/host-discovery-dns.html) in Nmap.\n\n### Port Scan\nBy default, this process uses Nmap to determine the state of the 100 most used TCP and UDP ports [`(-F)`](https://nmap.org/book/man-port-specification.html#idm45323729683296) on all active hosts on the local network using the [TCP Half-Open Scan](https://nmap.org/book/synscan.html) and the [UDP Scan](https://nmap.org/book/scan-methods-udp-scan.html), port scanning techniques. The ports that are scanned can be changed using the `--pR` flag in the command line, to indicate a port range. \n\nThis process also has a default timeout period of 60 seconds which can be changed using the `--pP` flag.\n\n### Remote WLAN Discovery\nThis process determines the characteristics of remote wireless networks in the vicinity of the host machine if a wireless interface is present, available and capable of 802.11 monitor mode, using the [802.11 packet capture](https://www.aircrack-ng.org/doku.php?id=wpa_capture) technique in airodump-ng.\n\nThe program will attempt to use [airmon-ng](https://www.aircrack-ng.org/doku.php?id=airmon-ng) to enable monitor mode on the interface. If this is is unsuccessful you will not see an error, the table for Remote WLAN data will simply be empty.\n\nThis process has a default timeout period of 60 seconds which can be changed using the `--wP` flag.\n\n## Supported Operating Systems\nThe program was designed to work with any UNIX-like operating system. It will not work on Windows.\n\nI have confirmed the following operating systems to support the program.\n\n* Ubuntu 22.10\n* Kali Linux 2022.4\n* BlackArch Slim 2021.09.01\n* ParrotOS Security 5.2 Electro Ara\n\n## Understanding the wireless data output\n### Access Points\n\n| Header | Description |\n| --- | --- |\n| `BSSID` | The MAC address of a detected access point. |\n| `SIGNAL` | The RSSI between the host machine and a detected access point. |\n| `CH` | The operating channel of a detected access point. |\n| `RATE `| The maximum speed in Mbps supported by a detected access point. |\n| `ENC` | The encryption algorithm in use by a detected access point. |\n| `CIPHER` | The cipher in use by a detected access point. |\n| `AUTH` | The authentication protocol in use by a detected access point. |\n| `VENDOR` | The vendor of the NIC of a detected access point. |\n\n### Stations\n\n| Header | Description |\n| --- | --- |\n| `STATION` | The MAC address of a detected station. |\n| `ASSOCIATED-BSSID` | The MAC address of the access point the station is connected to. |\n| `SIGNAL` | The RSSI between the host machine and a detected station. |\n| `VENDOR` | The vendor of the NIC of a detected station. |\n\nPlease view the airodump-ng documentation [here](https://www.aircrack-ng.org/doku.php?id=airodump-ng#usage_tips), for more detailed information about each header. Note: `PWR` and `MB` in airodump-ng correspond to `SIGNAL` and `RATE`.\n\n## FAQs\n#### The terminal output is unreadable, now what?\nSometimes the output may be format incorrectly due to the size of the terminal window or for unknown reasons. You can access all output files in the `home/<username>/Documents/NetScanner` directory which is created when you run the program initally.\n\nAll output files are in `.txt` format and are timestamped with the local date and time of the scan, and a tag indicating the mode of operation that was specified.\n\n#### Why is there no wireless data in the output?\nBe sure to check your host machine has a 802.11 NIC. Then [verify](http://www.aircrack-ng.org/doku.php?id=compatible_cards) that your interface supports monitor mode.\n\nThe program will attempt to enable monitor mode on the most active interface of your machine. This is determined by comparing the amount of data exchanged by all available interfaces excluding the loopback interface.\n\nIf the most active interface does not support 802.11, or monitor mode - you will not see any wireless output data. If you are running the program in a virtual machine, you are also unlikely to get any wireless output data.\n\n#### How long should the scan take?\nMode 1 will take at least two minutes to complete. Other modes will take less time. If you specify longer wireless scan, or port scan periods, and/or a large port range - the time period the scan will take will increase proportionately.\n\n#### What are hidden access points?\nThese are access points that belong to a wireless network that has been configured to use SSID cloaking. This disables the broadcast of the SSID.\n\n#### What are stations?\nStations are wireless endpoints.\n\n#### What are unassociated stations?\nThese are stations that are either not connected to, or are attempting to connect to, a detected wireless network.\n',
    'author': 'Adam Dawood',
    'author_email': 'ADD0242@MY.LONDONMET.AC.UK',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/add0242/NETSCANNER',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
}


setup(**setup_kwargs)
