# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from google.cloud.datastore_admin_v1.proto import (
    datastore_admin_pb2 as google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2,
)
from google.cloud.datastore_admin_v1.proto import (
    index_pb2 as google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_index__pb2,
)
from google.longrunning import (
    operations_pb2 as google_dot_longrunning_dot_operations__pb2,
)


class DatastoreAdminStub(object):
    """Google Cloud Datastore Admin API


    The Datastore Admin API provides several admin services for Cloud Datastore.

    -----------------------------------------------------------------------------
    ## Concepts

    Project, namespace, kind, and entity as defined in the Google Cloud Datastore
    API.

    Operation: An Operation represents work being performed in the background.

    EntityFilter: Allows specifying a subset of entities in a project. This is
    specified as a combination of kinds and namespaces (either or both of which
    may be all).

    -----------------------------------------------------------------------------
    ## Services

    # Export/Import

    The Export/Import service provides the ability to copy all or a subset of
    entities to/from Google Cloud Storage.

    Exported data may be imported into Cloud Datastore for any Google Cloud
    Platform project. It is not restricted to the export source project. It is
    possible to export from one project and then import into another.

    Exported data can also be loaded into Google BigQuery for analysis.

    Exports and imports are performed asynchronously. An Operation resource is
    created for each export/import. The state (including any errors encountered)
    of the export/import may be queried via the Operation resource.

    # Index

    The index service manages Cloud Datastore composite indexes.

    Index creation and deletion are performed asynchronously.
    An Operation resource is created for each such asynchronous operation.
    The state of the operation (including any errors encountered)
    may be queried via the Operation resource.

    # Operation

    The Operations collection provides a record of actions performed for the
    specified project (including any operations in progress). Operations are not
    created directly but through calls on other collections or resources.

    An operation that is not yet done may be cancelled. The request to cancel is
    asynchronous and the operation may continue to run for some time after the
    request to cancel is made.

    An operation that is done may be deleted so that it is no longer listed as
    part of the Operation collection.

    ListOperations returns all pending operations, but not completed operations.

    Operations are created by service DatastoreAdmin,
    but are accessed via service google.longrunning.Operations.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ExportEntities = channel.unary_unary(
            "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities",
            request_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ExportEntitiesRequest.SerializeToString,
            response_deserializer=google_dot_longrunning_dot_operations__pb2.Operation.FromString,
        )
        self.ImportEntities = channel.unary_unary(
            "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities",
            request_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ImportEntitiesRequest.SerializeToString,
            response_deserializer=google_dot_longrunning_dot_operations__pb2.Operation.FromString,
        )
        self.GetIndex = channel.unary_unary(
            "/google.datastore.admin.v1.DatastoreAdmin/GetIndex",
            request_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.GetIndexRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_index__pb2.Index.FromString,
        )
        self.ListIndexes = channel.unary_unary(
            "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes",
            request_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesResponse.FromString,
        )


class DatastoreAdminServicer(object):
    """Google Cloud Datastore Admin API


    The Datastore Admin API provides several admin services for Cloud Datastore.

    -----------------------------------------------------------------------------
    ## Concepts

    Project, namespace, kind, and entity as defined in the Google Cloud Datastore
    API.

    Operation: An Operation represents work being performed in the background.

    EntityFilter: Allows specifying a subset of entities in a project. This is
    specified as a combination of kinds and namespaces (either or both of which
    may be all).

    -----------------------------------------------------------------------------
    ## Services

    # Export/Import

    The Export/Import service provides the ability to copy all or a subset of
    entities to/from Google Cloud Storage.

    Exported data may be imported into Cloud Datastore for any Google Cloud
    Platform project. It is not restricted to the export source project. It is
    possible to export from one project and then import into another.

    Exported data can also be loaded into Google BigQuery for analysis.

    Exports and imports are performed asynchronously. An Operation resource is
    created for each export/import. The state (including any errors encountered)
    of the export/import may be queried via the Operation resource.

    # Index

    The index service manages Cloud Datastore composite indexes.

    Index creation and deletion are performed asynchronously.
    An Operation resource is created for each such asynchronous operation.
    The state of the operation (including any errors encountered)
    may be queried via the Operation resource.

    # Operation

    The Operations collection provides a record of actions performed for the
    specified project (including any operations in progress). Operations are not
    created directly but through calls on other collections or resources.

    An operation that is not yet done may be cancelled. The request to cancel is
    asynchronous and the operation may continue to run for some time after the
    request to cancel is made.

    An operation that is done may be deleted so that it is no longer listed as
    part of the Operation collection.

    ListOperations returns all pending operations, but not completed operations.

    Operations are created by service DatastoreAdmin,
    but are accessed via service google.longrunning.Operations.
    """

    def ExportEntities(self, request, context):
        """Exports a copy of all or a subset of entities from Google Cloud Datastore
        to another storage system, such as Google Cloud Storage. Recent updates to
        entities may not be reflected in the export. The export occurs in the
        background and its progress can be monitored and managed via the
        Operation resource that is created. The output of an export may only be
        used once the associated operation is done. If an export operation is
        cancelled before completion it may leave partial data behind in Google
        Cloud Storage.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ImportEntities(self, request, context):
        """Imports entities into Google Cloud Datastore. Existing entities with the
        same key are overwritten. The import occurs in the background and its
        progress can be monitored and managed via the Operation resource that is
        created. If an ImportEntities operation is cancelled, it is possible
        that a subset of the data has already been imported to Cloud Datastore.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetIndex(self, request, context):
        """Gets an index."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListIndexes(self, request, context):
        """Lists the indexes that match the specified filters.  Datastore uses an
        eventually consistent query to fetch the list of indexes and may
        occasionally return stale results.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_DatastoreAdminServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "ExportEntities": grpc.unary_unary_rpc_method_handler(
            servicer.ExportEntities,
            request_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ExportEntitiesRequest.FromString,
            response_serializer=google_dot_longrunning_dot_operations__pb2.Operation.SerializeToString,
        ),
        "ImportEntities": grpc.unary_unary_rpc_method_handler(
            servicer.ImportEntities,
            request_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ImportEntitiesRequest.FromString,
            response_serializer=google_dot_longrunning_dot_operations__pb2.Operation.SerializeToString,
        ),
        "GetIndex": grpc.unary_unary_rpc_method_handler(
            servicer.GetIndex,
            request_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.GetIndexRequest.FromString,
            response_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_index__pb2.Index.SerializeToString,
        ),
        "ListIndexes": grpc.unary_unary_rpc_method_handler(
            servicer.ListIndexes,
            request_deserializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesRequest.FromString,
            response_serializer=google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "google.datastore.admin.v1.DatastoreAdmin", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))


# This class is part of an EXPERIMENTAL API.
class DatastoreAdmin(object):
    """Google Cloud Datastore Admin API


    The Datastore Admin API provides several admin services for Cloud Datastore.

    -----------------------------------------------------------------------------
    ## Concepts

    Project, namespace, kind, and entity as defined in the Google Cloud Datastore
    API.

    Operation: An Operation represents work being performed in the background.

    EntityFilter: Allows specifying a subset of entities in a project. This is
    specified as a combination of kinds and namespaces (either or both of which
    may be all).

    -----------------------------------------------------------------------------
    ## Services

    # Export/Import

    The Export/Import service provides the ability to copy all or a subset of
    entities to/from Google Cloud Storage.

    Exported data may be imported into Cloud Datastore for any Google Cloud
    Platform project. It is not restricted to the export source project. It is
    possible to export from one project and then import into another.

    Exported data can also be loaded into Google BigQuery for analysis.

    Exports and imports are performed asynchronously. An Operation resource is
    created for each export/import. The state (including any errors encountered)
    of the export/import may be queried via the Operation resource.

    # Index

    The index service manages Cloud Datastore composite indexes.

    Index creation and deletion are performed asynchronously.
    An Operation resource is created for each such asynchronous operation.
    The state of the operation (including any errors encountered)
    may be queried via the Operation resource.

    # Operation

    The Operations collection provides a record of actions performed for the
    specified project (including any operations in progress). Operations are not
    created directly but through calls on other collections or resources.

    An operation that is not yet done may be cancelled. The request to cancel is
    asynchronous and the operation may continue to run for some time after the
    request to cancel is made.

    An operation that is done may be deleted so that it is no longer listed as
    part of the Operation collection.

    ListOperations returns all pending operations, but not completed operations.

    Operations are created by service DatastoreAdmin,
    but are accessed via service google.longrunning.Operations.
    """

    @staticmethod
    def ExportEntities(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities",
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ExportEntitiesRequest.SerializeToString,
            google_dot_longrunning_dot_operations__pb2.Operation.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ImportEntities(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities",
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ImportEntitiesRequest.SerializeToString,
            google_dot_longrunning_dot_operations__pb2.Operation.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetIndex(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.datastore.admin.v1.DatastoreAdmin/GetIndex",
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.GetIndexRequest.SerializeToString,
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_index__pb2.Index.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListIndexes(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes",
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesRequest.SerializeToString,
            google_dot_cloud_dot_datastore__admin__v1_dot_proto_dot_datastore__admin__pb2.ListIndexesResponse.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )
