from __future__ import annotations

from math import sqrt

from haversine import haversine

from mobio.sdks.dedupe import predicates
from mobio.sdks.dedupe.variables.base import FieldType


class LatLongType(FieldType):
    type = "LatLong"

    _predicate_functions = [predicates.latLongGridPredicate]

    @staticmethod
    def comparator(x: tuple[float, float], y: tuple[float, float]) -> float:
        return sqrt(haversine(x, y))
