# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class SwitchPacketIn(Base):
    """This object allows to configure the packet-in message parameters of the switch.
    The SwitchPacketIn class encapsulates a list of switchPacketIn resources that are managed by the user.
    A list of resources can be retrieved from the server using the SwitchPacketIn.find() method.
    The list can be managed by using the SwitchPacketIn.add() and SwitchPacketIn.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'switchPacketIn'

    def __init__(self, parent):
        super(SwitchPacketIn, self).__init__(parent)

    @property
    def PacketInHeaders(self):
        """
        Returns
        -------
        - obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.packetinheaders_d02a629ad9612b0e5ef79eb3afe666db.PacketInHeaders): An instance of the PacketInHeaders class

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.packetinheaders_d02a629ad9612b0e5ef79eb3afe666db import PacketInHeaders
        return PacketInHeaders(self)._select()

    @property
    def AuxiliaryId(self):
        """
        Returns
        -------
        - number: The identifier for auxiliary connections
        """
        return self._get_attribute('auxiliaryId')
    @AuxiliaryId.setter
    def AuxiliaryId(self, value):
        self._set_attribute('auxiliaryId', value)

    @property
    def ConsultFlowTable(self):
        """
        Returns
        -------
        - bool: If true, consults Flow Table before sending packet-in messages. If any flow present then do not send packet-in messages.
        """
        return self._get_attribute('consultFlowTable')
    @ConsultFlowTable.setter
    def ConsultFlowTable(self, value):
        self._set_attribute('consultFlowTable', value)

    @property
    def Enabled(self):
        """
        Returns
        -------
        - bool: If true, enables Packet-In Range for the switch.
        """
        return self._get_attribute('enabled')
    @Enabled.setter
    def Enabled(self, value):
        self._set_attribute('enabled', value)

    @property
    def InPort(self):
        """
        Returns
        -------
        - str: Specifies the number of ports on which the switch receives the new packet.
        """
        return self._get_attribute('inPort')
    @InPort.setter
    def InPort(self, value):
        self._set_attribute('inPort', value)

    @property
    def PacketIn(self):
        """
        Returns
        -------
        - str: Specifies the contents of the new packet that will be sent via the Packet-In message.
        """
        return self._get_attribute('packetIn')
    @PacketIn.setter
    def PacketIn(self, value):
        self._set_attribute('packetIn', value)

    @property
    def PacketInName(self):
        """
        Returns
        -------
        - str: Indicates the packet-in Range identifier name.
        """
        return self._get_attribute('packetInName')
    @PacketInName.setter
    def PacketInName(self, value):
        self._set_attribute('packetInName', value)

    @property
    def PhysicalInPort(self):
        """
        Returns
        -------
        - str: The physical In port value for this PacketIn range. It is the underlying physical port when packet is received on a logical port.
        """
        return self._get_attribute('physicalInPort')
    @PhysicalInPort.setter
    def PhysicalInPort(self, value):
        self._set_attribute('physicalInPort', value)

    @property
    def SendPacketIn(self):
        """
        Returns
        -------
        - bool: If true, packet-in messages will be sent to the controller using this Packet-In range definitions.
        """
        return self._get_attribute('sendPacketIn')
    @SendPacketIn.setter
    def SendPacketIn(self, value):
        self._set_attribute('sendPacketIn', value)

    def update(self, AuxiliaryId=None, ConsultFlowTable=None, Enabled=None, InPort=None, PacketIn=None, PacketInName=None, PhysicalInPort=None, SendPacketIn=None):
        """Updates switchPacketIn resource on the server.

        Args
        ----
        - AuxiliaryId (number): The identifier for auxiliary connections
        - ConsultFlowTable (bool): If true, consults Flow Table before sending packet-in messages. If any flow present then do not send packet-in messages.
        - Enabled (bool): If true, enables Packet-In Range for the switch.
        - InPort (str): Specifies the number of ports on which the switch receives the new packet.
        - PacketIn (str): Specifies the contents of the new packet that will be sent via the Packet-In message.
        - PacketInName (str): Indicates the packet-in Range identifier name.
        - PhysicalInPort (str): The physical In port value for this PacketIn range. It is the underlying physical port when packet is received on a logical port.
        - SendPacketIn (bool): If true, packet-in messages will be sent to the controller using this Packet-In range definitions.

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(locals())

    def add(self, AuxiliaryId=None, ConsultFlowTable=None, Enabled=None, InPort=None, PacketIn=None, PacketInName=None, PhysicalInPort=None, SendPacketIn=None):
        """Adds a new switchPacketIn resource on the server and adds it to the container.

        Args
        ----
        - AuxiliaryId (number): The identifier for auxiliary connections
        - ConsultFlowTable (bool): If true, consults Flow Table before sending packet-in messages. If any flow present then do not send packet-in messages.
        - Enabled (bool): If true, enables Packet-In Range for the switch.
        - InPort (str): Specifies the number of ports on which the switch receives the new packet.
        - PacketIn (str): Specifies the contents of the new packet that will be sent via the Packet-In message.
        - PacketInName (str): Indicates the packet-in Range identifier name.
        - PhysicalInPort (str): The physical In port value for this PacketIn range. It is the underlying physical port when packet is received on a logical port.
        - SendPacketIn (bool): If true, packet-in messages will be sent to the controller using this Packet-In range definitions.

        Returns
        -------
        - self: This instance with all currently retrieved switchPacketIn resources using find and the newly added switchPacketIn resources available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the contained switchPacketIn resources in this instance from the server.

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, AuxiliaryId=None, ConsultFlowTable=None, Enabled=None, InPort=None, PacketIn=None, PacketInName=None, PhysicalInPort=None, SendPacketIn=None):
        """Finds and retrieves switchPacketIn resources from the server.

        All named parameters are evaluated on the server using regex. The named parameters can be used to selectively retrieve switchPacketIn resources from the server.
        To retrieve an exact match ensure the parameter value starts with ^ and ends with $
        By default the find method takes no parameters and will retrieve all switchPacketIn resources from the server.

        Args
        ----
        - AuxiliaryId (number): The identifier for auxiliary connections
        - ConsultFlowTable (bool): If true, consults Flow Table before sending packet-in messages. If any flow present then do not send packet-in messages.
        - Enabled (bool): If true, enables Packet-In Range for the switch.
        - InPort (str): Specifies the number of ports on which the switch receives the new packet.
        - PacketIn (str): Specifies the contents of the new packet that will be sent via the Packet-In message.
        - PacketInName (str): Indicates the packet-in Range identifier name.
        - PhysicalInPort (str): The physical In port value for this PacketIn range. It is the underlying physical port when packet is received on a logical port.
        - SendPacketIn (bool): If true, packet-in messages will be sent to the controller using this Packet-In range definitions.

        Returns
        -------
        - self: This instance with matching switchPacketIn resources retrieved from the server available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of switchPacketIn data from the server.

        Args
        ----
        - href (str): An href to the instance to be retrieved

        Returns
        -------
        - self: This instance with the switchPacketIn resources from the server available through an iterator or index

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def SendSwitchPacketInOption(self, *args, **kwargs):
        """Executes the sendSwitchPacketInOption operation on the server.

        NOT DEFINED

        sendSwitchPacketInOption(Arg2=enum)bool
        ---------------------------------------
        - Arg2 (str(sendPause | sendStart | sendStop)): NOT DEFINED
        - Returns bool: NOT DEFINED

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('sendSwitchPacketInOption', payload=payload, response_object=None)
