# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class SpbOutsideLinks(Base):
    """The SPBM Outside Links.
    The SpbOutsideLinks class encapsulates a list of spbOutsideLinks resources that are managed by the user.
    A list of resources can be retrieved from the server using the SpbOutsideLinks.find() method.
    The list can be managed by using the SpbOutsideLinks.add() and SpbOutsideLinks.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'spbOutsideLinks'

    def __init__(self, parent):
        super(SpbOutsideLinks, self).__init__(parent)

    @property
    def ConnectionCol(self):
        """
        Returns
        -------
        - number: Signifies the connection between the columns.
        """
        return self._get_attribute('connectionCol')
    @ConnectionCol.setter
    def ConnectionCol(self, value):
        self._set_attribute('connectionCol', value)

    @property
    def ConnectionRow(self):
        """
        Returns
        -------
        - number: Signifies the connection between the rows.
        """
        return self._get_attribute('connectionRow')
    @ConnectionRow.setter
    def ConnectionRow(self, value):
        self._set_attribute('connectionRow', value)

    @property
    def LinkedRid(self):
        """
        Returns
        -------
        - str: Signifies the link between R identifier.
        """
        return self._get_attribute('linkedRid')
    @LinkedRid.setter
    def LinkedRid(self, value):
        self._set_attribute('linkedRid', value)

    def update(self, ConnectionCol=None, ConnectionRow=None, LinkedRid=None):
        """Updates spbOutsideLinks resource on the server.

        Args
        ----
        - ConnectionCol (number): Signifies the connection between the columns.
        - ConnectionRow (number): Signifies the connection between the rows.
        - LinkedRid (str): Signifies the link between R identifier.

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(locals())

    def add(self, ConnectionCol=None, ConnectionRow=None, LinkedRid=None):
        """Adds a new spbOutsideLinks resource on the server and adds it to the container.

        Args
        ----
        - ConnectionCol (number): Signifies the connection between the columns.
        - ConnectionRow (number): Signifies the connection between the rows.
        - LinkedRid (str): Signifies the link between R identifier.

        Returns
        -------
        - self: This instance with all currently retrieved spbOutsideLinks resources using find and the newly added spbOutsideLinks resources available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the contained spbOutsideLinks resources in this instance from the server.

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, ConnectionCol=None, ConnectionRow=None, LinkedRid=None):
        """Finds and retrieves spbOutsideLinks resources from the server.

        All named parameters are evaluated on the server using regex. The named parameters can be used to selectively retrieve spbOutsideLinks resources from the server.
        To retrieve an exact match ensure the parameter value starts with ^ and ends with $
        By default the find method takes no parameters and will retrieve all spbOutsideLinks resources from the server.

        Args
        ----
        - ConnectionCol (number): Signifies the connection between the columns.
        - ConnectionRow (number): Signifies the connection between the rows.
        - LinkedRid (str): Signifies the link between R identifier.

        Returns
        -------
        - self: This instance with matching spbOutsideLinks resources retrieved from the server available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of spbOutsideLinks data from the server.

        Args
        ----
        - href (str): An href to the instance to be retrieved

        Returns
        -------
        - self: This instance with the spbOutsideLinks resources from the server available through an iterator or index

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
