# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class LearnedFilter(Base):
    """Controls the types of LSAs that are learned by this interface.
    The LearnedFilter class encapsulates a required learnedFilter resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'learnedFilter'

    def __init__(self, parent):
        super(LearnedFilter, self).__init__(parent)

    @property
    def AdvRouterId(self):
        """
        Returns
        -------
        - str: Filter on the router ID of the router that is originating the LSA.
        """
        return self._get_attribute('advRouterId')
    @AdvRouterId.setter
    def AdvRouterId(self, value):
        self._set_attribute('advRouterId', value)

    @property
    def AreaSummaryLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of LSAs in the Summary Area.
        """
        return self._get_attribute('areaSummaryLsaCount')

    @property
    def EnableAdvRouterId(self):
        """
        Returns
        -------
        - bool: If true filter on the advertised router ID.
        """
        return self._get_attribute('enableAdvRouterId')
    @EnableAdvRouterId.setter
    def EnableAdvRouterId(self, value):
        self._set_attribute('enableAdvRouterId', value)

    @property
    def EnableFilter(self):
        """
        Returns
        -------
        - bool: Enables the use of the OSPF learned filter.
        """
        return self._get_attribute('enableFilter')
    @EnableFilter.setter
    def EnableFilter(self, value):
        self._set_attribute('enableFilter', value)

    @property
    def EnableLinkStateId(self):
        """
        Returns
        -------
        - bool: If true, filter on the Link State ID.
        """
        return self._get_attribute('enableLinkStateId')
    @EnableLinkStateId.setter
    def EnableLinkStateId(self, value):
        self._set_attribute('enableLinkStateId', value)

    @property
    def ExcludeAdvRouterId(self):
        """
        Returns
        -------
        - bool: If true, filter on no advertised router ID available.
        """
        return self._get_attribute('excludeAdvRouterId')
    @ExcludeAdvRouterId.setter
    def ExcludeAdvRouterId(self, value):
        self._set_attribute('excludeAdvRouterId', value)

    @property
    def ExcludeLinkStateId(self):
        """
        Returns
        -------
        - bool: If true, filter on no Link State ID available.
        """
        return self._get_attribute('excludeLinkStateId')
    @ExcludeLinkStateId.setter
    def ExcludeLinkStateId(self, value):
        self._set_attribute('excludeLinkStateId', value)

    @property
    def ExternalLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of External LSAs.
        """
        return self._get_attribute('externalLsaCount')

    @property
    def ExternalSummaryLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of External Summary LSAs.
        """
        return self._get_attribute('externalSummaryLsaCount')

    @property
    def IsComplete(self):
        """
        Returns
        -------
        - bool: If true, indicates the Filter operation has finished.
        """
        return self._get_attribute('isComplete')

    @property
    def LinkStateId(self):
        """
        Returns
        -------
        - str: Filter on the Link State ID.
        """
        return self._get_attribute('linkStateId')
    @LinkStateId.setter
    def LinkStateId(self, value):
        self._set_attribute('linkStateId', value)

    @property
    def NetworkLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of Network LSAs.
        """
        return self._get_attribute('networkLsaCount')

    @property
    def NssaLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of NSSA LSAs.
        """
        return self._get_attribute('nssaLsaCount')

    @property
    def OpaqueAreaScopeLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of Opaque Area LSAs.
        """
        return self._get_attribute('opaqueAreaScopeLsaCount')

    @property
    def OpaqueAsScopeLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of AS Scope LSAs.
        """
        return self._get_attribute('opaqueAsScopeLsaCount')

    @property
    def OpaqueLocalScopeLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of Local Scope LSAs.
        """
        return self._get_attribute('opaqueLocalScopeLsaCount')

    @property
    def RouterLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the number of Router LSAs.
        """
        return self._get_attribute('routerLsaCount')

    @property
    def ShowExternalAsLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on the LSAs from routers with External routes.
        """
        return self._get_attribute('showExternalAsLsa')
    @ShowExternalAsLsa.setter
    def ShowExternalAsLsa(self, value):
        self._set_attribute('showExternalAsLsa', value)

    @property
    def ShowNetworkLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Network routes.
        """
        return self._get_attribute('showNetworkLsa')
    @ShowNetworkLsa.setter
    def ShowNetworkLsa(self, value):
        self._set_attribute('showNetworkLsa', value)

    @property
    def ShowNssaLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with NSSA routes.
        """
        return self._get_attribute('showNssaLsa')
    @ShowNssaLsa.setter
    def ShowNssaLsa(self, value):
        self._set_attribute('showNssaLsa', value)

    @property
    def ShowOpaqueAreaLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Opaque Area routes.
        """
        return self._get_attribute('showOpaqueAreaLsa')
    @ShowOpaqueAreaLsa.setter
    def ShowOpaqueAreaLsa(self, value):
        self._set_attribute('showOpaqueAreaLsa', value)

    @property
    def ShowOpaqueDomainLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Opaque Domain routes.
        """
        return self._get_attribute('showOpaqueDomainLsa')
    @ShowOpaqueDomainLsa.setter
    def ShowOpaqueDomainLsa(self, value):
        self._set_attribute('showOpaqueDomainLsa', value)

    @property
    def ShowOpaqueLocalLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Opaque Local routes.
        """
        return self._get_attribute('showOpaqueLocalLsa')
    @ShowOpaqueLocalLsa.setter
    def ShowOpaqueLocalLsa(self, value):
        self._set_attribute('showOpaqueLocalLsa', value)

    @property
    def ShowRouterLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with BR or DBR routes.
        """
        return self._get_attribute('showRouterLsa')
    @ShowRouterLsa.setter
    def ShowRouterLsa(self, value):
        self._set_attribute('showRouterLsa', value)

    @property
    def ShowSummaryAsLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Summary AS routes.
        """
        return self._get_attribute('showSummaryAsLsa')
    @ShowSummaryAsLsa.setter
    def ShowSummaryAsLsa(self, value):
        self._set_attribute('showSummaryAsLsa', value)

    @property
    def ShowSummaryIpLsa(self):
        """
        Returns
        -------
        - bool: If true, filter on LSAs from router with Summary IP routes.
        """
        return self._get_attribute('showSummaryIpLsa')
    @ShowSummaryIpLsa.setter
    def ShowSummaryIpLsa(self, value):
        self._set_attribute('showSummaryIpLsa', value)

    @property
    def TotalLsaCount(self):
        """
        Returns
        -------
        - number: Filter on the total number of LSAs.
        """
        return self._get_attribute('totalLsaCount')

    def update(self, AdvRouterId=None, EnableAdvRouterId=None, EnableFilter=None, EnableLinkStateId=None, ExcludeAdvRouterId=None, ExcludeLinkStateId=None, LinkStateId=None, ShowExternalAsLsa=None, ShowNetworkLsa=None, ShowNssaLsa=None, ShowOpaqueAreaLsa=None, ShowOpaqueDomainLsa=None, ShowOpaqueLocalLsa=None, ShowRouterLsa=None, ShowSummaryAsLsa=None, ShowSummaryIpLsa=None):
        """Updates learnedFilter resource on the server.

        Args
        ----
        - AdvRouterId (str): Filter on the router ID of the router that is originating the LSA.
        - EnableAdvRouterId (bool): If true filter on the advertised router ID.
        - EnableFilter (bool): Enables the use of the OSPF learned filter.
        - EnableLinkStateId (bool): If true, filter on the Link State ID.
        - ExcludeAdvRouterId (bool): If true, filter on no advertised router ID available.
        - ExcludeLinkStateId (bool): If true, filter on no Link State ID available.
        - LinkStateId (str): Filter on the Link State ID.
        - ShowExternalAsLsa (bool): If true, filter on the LSAs from routers with External routes.
        - ShowNetworkLsa (bool): If true, filter on LSAs from router with Network routes.
        - ShowNssaLsa (bool): If true, filter on LSAs from router with NSSA routes.
        - ShowOpaqueAreaLsa (bool): If true, filter on LSAs from router with Opaque Area routes.
        - ShowOpaqueDomainLsa (bool): If true, filter on LSAs from router with Opaque Domain routes.
        - ShowOpaqueLocalLsa (bool): If true, filter on LSAs from router with Opaque Local routes.
        - ShowRouterLsa (bool): If true, filter on LSAs from router with BR or DBR routes.
        - ShowSummaryAsLsa (bool): If true, filter on LSAs from router with Summary AS routes.
        - ShowSummaryIpLsa (bool): If true, filter on LSAs from router with Summary IP routes.

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(locals())
