# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class Field(Base):
    """This object specifies the field properties of the protocol template.
    The Field class encapsulates a list of field resources that are managed by the system.
    A list of resources can be retrieved from the server using the Field.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'field'

    def __init__(self, parent):
        super(Field, self).__init__(parent)

    @property
    def __id__(self):
        """DEPRECATED 
        Returns
        -------
        - str: An alphanumeric string that defines the internal field ID.
        """
        return self._get_attribute('__id__')

    @property
    def DisplayName(self):
        """
        Returns
        -------
        - str: It is used to get the name of the particular field as available in the protocol template.
        """
        return self._get_attribute('displayName')

    @property
    def FieldTypeId(self):
        """
        Returns
        -------
        - str: 
        """
        return self._get_attribute('fieldTypeId')

    @property
    def Length(self):
        """
        Returns
        -------
        - number: It is used to get the length of the field in bits.
        """
        return self._get_attribute('length')

    @property
    def Trackable(self):
        """
        Returns
        -------
        - bool: The trackable fields.
        """
        return self._get_attribute('trackable')

    def find(self, __id__=None, DisplayName=None, FieldTypeId=None, Length=None, Trackable=None):
        """Finds and retrieves field resources from the server.

        All named parameters are evaluated on the server using regex. The named parameters can be used to selectively retrieve field resources from the server.
        To retrieve an exact match ensure the parameter value starts with ^ and ends with $
        By default the find method takes no parameters and will retrieve all field resources from the server.

        Args
        ----
        - __id__ (str): An alphanumeric string that defines the internal field ID.
        - DisplayName (str): It is used to get the name of the particular field as available in the protocol template.
        - FieldTypeId (str): 
        - Length (number): It is used to get the length of the field in bits.
        - Trackable (bool): The trackable fields.

        Returns
        -------
        - self: This instance with matching field resources retrieved from the server available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of field data from the server.

        Args
        ----
        - href (str): An href to the instance to be retrieved

        Returns
        -------
        - self: This instance with the field resources from the server available through an iterator or index

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
