"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDeletionPolicy = void 0;
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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